/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net.message;

import java.io.IOException;
import marauroa.common.game.DetailLevel;
import marauroa.common.game.RPObject;
import marauroa.common.net.Channel;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.message.Message;

public class MessageS2CCreateCharacterACK
extends Message {
    private String character;
    private RPObject template;

    public MessageS2CCreateCharacterACK() {
        super(Message.MessageType.S2C_CREATECHARACTER_ACK, null);
    }

    public MessageS2CCreateCharacterACK(Channel channel, String string, RPObject rPObject) {
        super(Message.MessageType.S2C_CREATECHARACTER_ACK, channel);
        this.character = string;
        this.template = rPObject;
    }

    public String getCharacter() {
        return this.character;
    }

    public RPObject getTemplate() {
        return this.template;
    }

    public String toString() {
        return "Message (S2C CreateCharacter ACK) from (" + this.getAddress() + ") CONTENTS: ()";
    }

    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        super.writeObject(outputSerializer);
        outputSerializer.write(this.character);
        outputSerializer.write(this.template);
    }

    public void readObject(InputSerializer inputSerializer) throws IOException {
        super.readObject(inputSerializer);
        this.character = inputSerializer.readString();
        this.template = (RPObject)inputSerializer.readObject(new RPObject());
        if (this.type != Message.MessageType.S2C_CREATECHARACTER_ACK) {
            throw new IOException();
        }
    }

    public void writeToJson(StringBuilder stringBuilder) {
        super.writeToJson(stringBuilder);
        stringBuilder.append(",");
        OutputSerializer.writeJson(stringBuilder, "charname", this.character);
        stringBuilder.append(",\"template\":{");
        this.template.writeToJson(stringBuilder, DetailLevel.PRIVATE);
        stringBuilder.append("}");
    }
}

