/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import marauroa.common.net.Channel;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.message.Message;
import marauroa.common.net.message.TransferContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageS2CTransfer
extends Message {
    private List<TransferContent> contents;

    public MessageS2CTransfer() {
        super(Message.MessageType.S2C_TRANSFER, null);
    }

    public MessageS2CTransfer(Channel channel) {
        super(Message.MessageType.S2C_TRANSFER, channel);
        this.contents = new LinkedList<TransferContent>();
    }

    public MessageS2CTransfer(Channel channel, TransferContent transferContent) {
        super(Message.MessageType.S2C_TRANSFER, channel);
        this.contents = new LinkedList<TransferContent>();
        this.contents.add(transferContent);
    }

    public void addContent(TransferContent transferContent) {
        this.contents.add(transferContent);
    }

    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    public List<TransferContent> getContents() {
        return new LinkedList<TransferContent>(this.contents);
    }

    @Override
    public boolean requiresPerception() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Message (S2C Transfer) from (" + this.getAddress() + ") CONTENTS: (");
        for (TransferContent transferContent : this.contents) {
            stringBuilder.append("[");
            stringBuilder.append(transferContent.name);
            stringBuilder.append(":");
            stringBuilder.append(transferContent.timestamp);
            stringBuilder.append("]");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        super.writeObject(outputSerializer);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
        OutputSerializer outputSerializer2 = new OutputSerializer(deflaterOutputStream);
        outputSerializer2.setProtocolVersion(outputSerializer.getProtocolVersion());
        int n = this.contents.size();
        outputSerializer2.write(n);
        for (TransferContent transferContent : this.contents) {
            transferContent.writeFULL(outputSerializer2);
        }
        deflaterOutputStream.close();
        outputSerializer.write(byteArrayOutputStream.toByteArray());
    }

    @Override
    public void writeToJson(StringBuilder stringBuilder) {
        super.writeToJson(stringBuilder);
        stringBuilder.append(",\"contents\":[");
        boolean bl = true;
        for (TransferContent transferContent : this.contents) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(",");
            }
            transferContent.writeFullToJson(stringBuilder);
        }
        stringBuilder.append("]");
    }

    @Override
    public void readObject(InputSerializer inputSerializer) throws IOException {
        super.readObject(inputSerializer);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(inputSerializer.readByteArray());
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream, new Inflater());
        InputSerializer inputSerializer2 = new InputSerializer(inflaterInputStream);
        inputSerializer2.setProtocolVersion(this.protocolVersion);
        int n = inputSerializer2.readInt();
        this.contents = new LinkedList<TransferContent>();
        for (int i = 0; i < n; ++i) {
            TransferContent transferContent = new TransferContent();
            transferContent.readFULL(inputSerializer2);
            this.contents.add(transferContent);
        }
        if (this.type != Message.MessageType.S2C_TRANSFER) {
            throw new IOException();
        }
    }
}

