/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net.message;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import marauroa.common.net.Channel;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.message.Message;
import org.apache.log4j.Logger;

public class MessageS2CUpdate
extends Message {
    private static Logger logger = Logger.getLogger(MessageS2CUpdate.class);
    private byte[] update;

    public MessageS2CUpdate() {
        super(Message.MessageType.S2C_UPDATE, null);
    }

    public MessageS2CUpdate(Channel channel, byte[] byArray) {
        super(Message.MessageType.S2C_UPDATE, channel);
        this.update = (byte[])byArray.clone();
    }

    public byte[] getUpdate() {
        if (this.update == null) {
            return this.update;
        }
        return (byte[])this.update.clone();
    }

    public String toString() {
        return "Message (S2C Update)";
    }

    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        super.writeObject(outputSerializer);
        outputSerializer.write(this.update);
    }

    public void writeToJson(StringBuilder stringBuilder) {
        super.writeToJson(stringBuilder);
        stringBuilder.append(",\"update\":");
        try {
            OutputSerializer.writeJson(stringBuilder, new String(this.update, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error((Object)unsupportedEncodingException, (Throwable)unsupportedEncodingException);
        }
    }

    public void readObject(InputSerializer inputSerializer) throws IOException {
        super.readObject(inputSerializer);
        this.update = inputSerializer.readByteArray();
        if (this.type != Message.MessageType.S2C_UPDATE) {
            throw new IOException();
        }
    }
}

