/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net.message;

import java.io.IOException;
import javax.xml.bind.DatatypeConverter;
import marauroa.common.Utility;
import marauroa.common.crypto.Hash;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;

public class TransferContent {
    public String name;
    public int timestamp;
    public byte[] data;
    public boolean cacheable;
    public boolean ack;
    private byte[] hash;

    public TransferContent() {
        this.ack = false;
        this.cacheable = false;
        this.data = null;
        this.name = null;
        this.timestamp = 0;
    }

    public byte[] getHash() {
        if (this.hash == null) {
            this.hash = Hash.hash(this.data);
        }
        return this.hash;
    }

    public byte[] getTransmittedHash() {
        return this.hash;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TransferContent: [name=\"");
        stringBuilder.append(this.name);
        stringBuilder.append("\" timestamp=\"");
        stringBuilder.append(this.timestamp);
        stringBuilder.append("\"]");
        return stringBuilder.toString();
    }

    public TransferContent(String string, int n, byte[] byArray) {
        this.name = string;
        this.timestamp = n;
        this.data = Utility.copy(byArray);
        this.cacheable = true;
        this.ack = false;
    }

    public void writeREQ(OutputSerializer outputSerializer) throws IOException {
        outputSerializer.write(this.name);
        outputSerializer.write(this.timestamp);
        if (outputSerializer.getProtocolVersion() >= 34) {
            outputSerializer.write(this.getHash());
        }
        outputSerializer.write((byte)(this.cacheable ? 1 : 0));
    }

    public void writeREQToJson(StringBuilder stringBuilder) {
        stringBuilder.append("{\"name\":");
        OutputSerializer.writeJson(stringBuilder, this.name);
        stringBuilder.append(",\"timestamp\":");
        OutputSerializer.writeJson(stringBuilder, Integer.toString(this.timestamp));
        stringBuilder.append(",\"hash\":");
        OutputSerializer.writeJson(stringBuilder, Hash.toHexString(this.getHash()));
        stringBuilder.append(",\"cachable\":");
        stringBuilder.append(this.cacheable ? "true" : "false");
        stringBuilder.append("}");
    }

    public void readREQ(InputSerializer inputSerializer) throws IOException {
        this.name = inputSerializer.readString();
        this.timestamp = inputSerializer.readInt();
        if (inputSerializer.getProtocolVersion() >= 34) {
            this.hash = inputSerializer.readByteArray();
        }
        this.cacheable = inputSerializer.readByte() == 1;
    }

    public void writeACK(OutputSerializer outputSerializer) throws IOException {
        outputSerializer.write(this.name);
        outputSerializer.write((byte)(this.ack ? 1 : 0));
    }

    public void writeACKToJson(StringBuilder stringBuilder) {
        OutputSerializer.writeJson(stringBuilder, this.name, this.ack ? "true" : "false");
    }

    public void readACK(InputSerializer inputSerializer) throws IOException {
        this.name = inputSerializer.readString();
        this.ack = inputSerializer.readByte() == 1;
    }

    public void readACKFromMap(String string, Object object) {
        this.name = string;
        if (object instanceof String) {
            this.ack = Boolean.parseBoolean((String)object);
        } else if (object instanceof Boolean) {
            this.ack = (Boolean)object;
        }
    }

    public void writeFULL(OutputSerializer outputSerializer) throws IOException {
        outputSerializer.write(this.name);
        outputSerializer.write(this.data);
        outputSerializer.write(this.timestamp);
        if (outputSerializer.getProtocolVersion() >= 34) {
            outputSerializer.write(this.getHash());
        }
        outputSerializer.write((byte)(this.cacheable ? 1 : 0));
    }

    public void writeFullToJson(StringBuilder stringBuilder) {
        stringBuilder.append("{\"name\":");
        OutputSerializer.writeJson(stringBuilder, this.name);
        stringBuilder.append(",\"timestamp\":");
        OutputSerializer.writeJson(stringBuilder, Integer.toString(this.timestamp));
        stringBuilder.append(",\"hash\":");
        OutputSerializer.writeJson(stringBuilder, Hash.toHexString(this.getHash()));
        stringBuilder.append(",\"cachable\":");
        stringBuilder.append(this.cacheable ? "true" : "false");
        stringBuilder.append(",\"data\":\"");
        stringBuilder.append(DatatypeConverter.printBase64Binary((byte[])this.data));
        stringBuilder.append("\"}");
    }

    public void readFULL(InputSerializer inputSerializer) throws IOException {
        this.name = inputSerializer.readString();
        this.data = inputSerializer.readByteArray();
        this.timestamp = inputSerializer.readInt();
        if (inputSerializer.getProtocolVersion() >= 34) {
            this.hash = inputSerializer.readByteArray();
        }
        this.cacheable = inputSerializer.readByte() == 1;
    }
}

