/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.db;

import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import java.util.StringTokenizer;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.server.db.StringChecker;
import marauroa.server.db.adapter.DatabaseAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBTransaction {
    private static final String RE_INT = "^-?[0-9 ]*$";
    private static final String RE_INT_LIST = "^-?[0-9, ]*$";
    private static Logger logger = Log4J.getLogger(DBTransaction.class);
    private DatabaseAdapter databaseAdapter = null;
    private Thread thread;

    protected DBTransaction(DatabaseAdapter databaseAdapter) {
        this.databaseAdapter = databaseAdapter;
    }

    protected void setThread(Thread thread) {
        this.thread = thread;
    }

    private void ensureCorrectThread(boolean bl) {
        if (this.thread == null) {
            if (!bl) {
                logger.error("Accessing DBTransaction " + this + " that is supposed to be available", new Throwable());
            }
        } else if (this.thread != Thread.currentThread()) {
            logger.error("Transaction " + this + " is bound to thread " + this.thread.getName() + " is used in thread " + Thread.currentThread(), new Throwable());
            for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
                logger.error(entry.getKey() + ": " + Arrays.asList((Object[])entry.getValue()));
            }
        }
    }

    protected void commit() throws SQLException {
        this.ensureCorrectThread(false);
        this.databaseAdapter.commit();
    }

    protected void rollback() throws SQLException {
        this.ensureCorrectThread(false);
        this.databaseAdapter.rollback();
    }

    protected void close() {
        this.ensureCorrectThread(true);
        try {
            this.databaseAdapter.close();
        }
        catch (SQLException sQLException) {
            logger.warn(sQLException, sQLException);
        }
    }

    public String subst(String string, Map<String, ?> map) throws SQLException {
        if (map == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "([]'", true);
        String string2 = "";
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string2.equals("[")) {
                Object obj = map.get(string4);
                string4 = obj != null ? obj.toString() : "";
                if (string3.equals("(")) {
                    if (!string4.matches(RE_INT_LIST)) {
                        throw new SQLException("Illegal argument: \"" + string4 + "\" is not an integer list");
                    }
                } else if (string3.equals("'")) {
                    if (string4.length() > 0) {
                        string4 = StringChecker.escapeSQLString(string4);
                    }
                } else if (!string4.matches(RE_INT)) {
                    throw new SQLException("Illegal argument: \"" + string4 + "\" is not an integer.");
                }
            }
            string3 = string2;
            string2 = string4.trim();
            if (string4.equals("[") || string4.equals("]")) {
                string4 = "";
            }
            stringBuilder.append(string4);
        }
        return stringBuilder.toString();
    }

    public int execute(String string, Map<String, Object> map) throws SQLException {
        this.ensureCorrectThread(false);
        String string2 = this.subst(string, map);
        return this.databaseAdapter.execute(string2);
    }

    public int execute(String string, Map<String, Object> map, InputStream ... inputStreamArray) throws SQLException, IOException {
        this.ensureCorrectThread(false);
        String string2 = this.subst(string, map);
        return this.databaseAdapter.execute(string2, inputStreamArray);
    }

    public ResultSet query(String string, Map<String, Object> map) throws SQLException {
        this.ensureCorrectThread(false);
        String string2 = this.subst(string, map);
        return this.databaseAdapter.query(string2);
    }

    public int querySingleCellInt(String string, Map<String, Object> map) throws SQLException {
        this.ensureCorrectThread(false);
        String string2 = this.subst(string, map);
        return this.databaseAdapter.querySingleCellInt(string2);
    }

    public int getLastInsertId(String string, String string2) throws SQLException {
        this.ensureCorrectThread(false);
        return this.databaseAdapter.getLastInsertId(string, string2);
    }

    public PreparedStatement prepareStatement(String string, Map<String, Object> map) throws SQLException {
        this.ensureCorrectThread(false);
        String string2 = this.subst(string, map);
        return this.databaseAdapter.prepareStatement(string2);
    }

    public boolean doesTableExist(String string) throws SQLException {
        this.ensureCorrectThread(false);
        return this.databaseAdapter.doesTableExist(string);
    }

    public boolean doesColumnExist(String string, String string2) throws SQLException {
        this.ensureCorrectThread(false);
        return this.databaseAdapter.doesColumnExist(string, string2);
    }

    public int getColumnLength(String string, String string2) throws SQLException {
        this.ensureCorrectThread(false);
        return this.databaseAdapter.getColumnLength(string, string2);
    }

    public boolean verifyConnection() {
        return this.databaseAdapter.verifyConnection();
    }
}

