/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import marauroa.common.Configuration;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.server.db.command.DBCommandQueue;
import marauroa.server.game.StatisticsMBean;
import marauroa.server.game.dbcommand.LogStatisticsCommand;

public class Statistics
implements StatisticsMBean {
    public static final int DATABASE_STATISTICS_LAPSUS = 60000;
    static final Logger logger = Log4J.getLogger(Statistics.class);
    private final Variables now;
    private final Variables sinceStart;
    private final long startTime = System.currentTimeMillis();
    private static Statistics stats;

    private Statistics() {
        this.now = new Variables();
        this.sinceStart = new Variables();
        this.init();
    }

    private void init() {
        this.set("Players online", 0);
        this.add("Players login", 0);
        this.add("Players logout", 0);
        this.add("Players timeout", 0);
        this.add("Players logged", 0);
        this.add("Ips online", 0);
        this.add("Bytes send", 0);
        this.add("Bytes recv", 0);
    }

    public static Statistics getStatistics() {
        if (stats == null) {
            stats = new Statistics();
        }
        return stats;
    }

    public void set(String string, int n) {
        this.now.put(string, n);
        this.sinceStart.put(string, n);
    }

    public void add(String string, int n) {
        this.now.add(string, n);
        this.sinceStart.add(string, n);
    }

    public long get(String string) {
        return this.sinceStart == null ? -1L : this.sinceStart.get(string);
    }

    public void print() {
        try {
            Configuration configuration = Configuration.getConfiguration();
            String string = configuration.get("statistics_filename");
            if (string == null) {
                return;
            }
            long l = System.currentTimeMillis();
            this.addStatisticsEventRow();
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
            double d = (double)(l - this.startTime) / 1000.0;
            printWriter.println("<?xml version=\"1.0\" encoding=\"" + System.getProperty("file.encoding") + "\"?>");
            printWriter.println("<statistics time=\"" + l / 1000L + "\">");
            printWriter.println("  <uptime value=\"" + d + "\"/>");
            long l2 = Runtime.getRuntime().totalMemory() / 1024L;
            long l3 = l2 - Runtime.getRuntime().freeMemory() / 1024L;
            printWriter.println("  <memory total=\"" + l2 + "\" used=\"" + l3 + "\"/>");
            logger.info("Total/Used memory: " + l2 + "/" + l3);
            this.sinceStart.print(printWriter, d);
            printWriter.println("</statistics>");
            printWriter.close();
        }
        catch (Exception exception) {
            logger.warn("error while printing statistics to file configured in parameter \"statistics_filename\". ", exception);
        }
    }

    private void addStatisticsEventRow() {
        DBCommandQueue.get().enqueue(new LogStatisticsCommand(this.now));
        this.now.clear();
        this.init();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Variables
    implements Iterable<String>,
    Cloneable {
        private Map<String, Long> content = Collections.synchronizedMap(new HashMap());

        public void clear() {
            this.content.clear();
        }

        public void put(String string, long l) {
            this.content.put(string, l);
        }

        public void add(String string, long l) {
            Long l2 = this.content.get(string);
            if (l2 == null) {
                this.put(string, l);
            } else {
                this.content.put(string, l2 + l);
            }
        }

        public long get(String string) {
            return this.content.get(string);
        }

        @Override
        public Iterator<String> iterator() {
            return this.content.keySet().iterator();
        }

        public void add(Variables variables) {
            for (String string : variables) {
                this.add(string, variables.get(string));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void print(PrintWriter printWriter, double d) {
            Map<String, Long> map = this.content;
            synchronized (map) {
                for (String string : this.content.keySet()) {
                    printWriter.println("<attrib name=\"" + Variables.escapeXML(string) + "\" value=\"" + this.content.get(string) + "\" />");
                }
            }
        }

        private static String escapeXML(String string) {
            return string.replace("&", "&amp;").replace("\"", "&quot;").replace("<", "&lt;").replace(">", "&gt;");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object clone() {
            try {
                Variables variables = (Variables)super.clone();
                Map<String, Long> map = this.content;
                synchronized (map) {
                    variables.content = Collections.synchronizedMap(new HashMap<String, Long>(this.content));
                }
                return variables;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                logger.error(cloneNotSupportedException, cloneNotSupportedException);
                return null;
            }
        }
    }
}

