/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.messagehandler;

import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.crypto.RSAKey;
import marauroa.common.net.message.Message;
import marauroa.server.game.Statistics;
import marauroa.server.game.container.ClientState;
import marauroa.server.game.container.PlayerEntry;
import marauroa.server.game.container.PlayerEntryContainer;
import marauroa.server.game.rp.RPServerManager;
import marauroa.server.net.INetworkServerManager;

abstract class MessageHandler {
    private static final Logger logger = Log4J.getLogger(MessageHandler.class);
    protected INetworkServerManager netMan;
    protected RPServerManager rpMan;
    protected PlayerEntryContainer playerContainer;
    protected Statistics stats;
    protected RSAKey key;

    MessageHandler() {
    }

    protected boolean isValidEvent(Message message, PlayerEntry playerEntry, ClientState ... clientStateArray) {
        if (playerEntry == null) {
            logger.warn("Client(" + message.getAddress() + ") has not logged in, but sent message: " + message.toString());
            return false;
        }
        boolean bl = false;
        for (ClientState clientState : clientStateArray) {
            if (playerEntry.state != clientState) continue;
            bl = true;
        }
        if (!bl) {
            StringBuilder stringBuilder = new StringBuilder();
            for (ClientState clientState : clientStateArray) {
                stringBuilder.append((Object)clientState).append(" ");
            }
            logger.warn("Client(" + message.getAddress() + ") is not in the required state (" + stringBuilder.toString() + ")");
            return false;
        }
        if (playerEntry.channel != message.getChannel()) {
            logger.warn("Client(" + message.getAddress() + ") has not correct IP<->clientid relation");
            return false;
        }
        return true;
    }

    public abstract void process(Message var1);

    public void init(INetworkServerManager iNetworkServerManager, RPServerManager rPServerManager, PlayerEntryContainer playerEntryContainer, Statistics statistics, RSAKey rSAKey) {
        this.netMan = iNetworkServerManager;
        this.rpMan = rPServerManager;
        this.playerContainer = playerEntryContainer;
        this.stats = statistics;
        this.key = rSAKey;
    }
}

