/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.util.ArrayList;
import mikera.tyrant.BaseObject;
import mikera.tyrant.Being;
import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.RPG;
import mikera.tyrant.Thing;
import mikera.tyrant.Tile;
import mikera.tyrant.Weapon;

public class Combat {
    public static final boolean DEBUG = false;
    private static Thing unarmedWeapon = null;
    private static Thing baseWeapon = null;
    private static Thing kickingWeapon;

    public static int calcAttackSpeed(Thing thing) {
        int n = thing.getStat("AttackSpeed");
        int n2 = thing.getStat("Ferocity");
        if (n2 > 0) {
            n += RPG.min(100, thing.getStat("SK")) * n2 / 4;
        }
        return n;
    }

    public static int attack(Thing thing, Thing thing2) {
        if (thing2 == null) {
            return 0;
        }
        int n = 0;
        if (thing.getStat("IsPanicked") > 0 && RPG.test(thing.getStat("IsPanicked"), thing.getStat("WP"))) {
            if (thing.isVisible(Game.hero())) {
                Game.message(thing.getTheName() + " freeze" + (thing.isHero() ? "" : "s") + " in terror");
            }
            return 0;
        }
        int n2 = thing2.getStat("FearFactor");
        if (n2 > 0 && Being.feelsFear(thing) && thing.getStat("WP") * (1 + thing.getStat("Bravery")) < RPG.r(thing2.getStat("WP") * n2)) {
            thing.visibleMessage(thing.getTheName() + " " + thing.verb("freeze") + " in terror and " + thing.is() + " unable to attack!");
            thing.incStat("APS", -60);
            return 0;
        }
        int n3 = thing.getStat("AttackSpeed");
        if (n3 <= 0) {
            thing.set("APS", -1);
            Game.warn(thing.getName(Game.hero()) + " is too slow to attack!");
            return 0;
        }
        Thing thing3 = thing.getWielded(1);
        if (thing3 != null && thing3.getFlag("IsWeapon")) {
            n += Combat.attackWith(thing, thing2, thing3);
            thing3 = thing.getWielded(2);
            if (thing3 != null && thing3.getFlag("IsWeapon") && !thing2.isDead()) {
                n += Combat.attackWith(thing, thing2, thing3);
            }
        } else {
            thing3 = Combat.unarmedWeapon(thing);
            n += Combat.attackWith(thing, thing2, thing3);
        }
        return n;
    }

    public static Thing unarmedWeapon(Thing thing) {
        Thing thing2 = (Thing)thing.get("UnarmedWeapon");
        if (thing2 != null) {
            return thing2;
        }
        if (unarmedWeapon == null) {
            unarmedWeapon = Lib.create("unarmed attack");
            baseWeapon = Lib.create("base attack");
        }
        if (thing.getStat("Unarmed Combat") <= 0) {
            return unarmedWeapon;
        }
        return baseWeapon;
    }

    public static Thing kickingWeapon(Thing thing) {
        Thing thing2;
        if (kickingWeapon == null) {
            kickingWeapon = Lib.create("kick attack");
        }
        if ((thing2 = thing.getWielded(8)) == null) {
            thing2 = kickingWeapon;
        }
        return thing2;
    }

    public static int attackCost(Thing thing, Thing thing2) {
        double d = thing2.getStat("AttackCost");
        d += (double)thing.getStat("AttackCost");
        if (thing2.getFlag("IsUnarmedWeapon")) {
            d /= 1.0 + 0.1 * (double)thing.getStat("Unarmed Combat");
        }
        return (int)(100.0 * d / (double)Combat.calcAttackSpeed(thing));
    }

    public static int attackWith(Thing thing, Thing thing2, Thing thing3) {
        if (thing2 == null) {
            return 0;
        }
        int n = 0;
        Map map = thing2.getMap();
        if (Weapon.attack(thing3, thing, thing2) > 0) {
            n = Weapon.hit(thing3, thing, thing2);
        }
        thing.incStat("APS", -Combat.attackCost(thing, thing3));
        if (map != null && thing.isHero()) {
            map.areaNotify(thing.x, thing.y, 8, 5, thing2.getStat("Side"), thing);
        }
        return n;
    }

    public static void die(Thing thing) {
        Object object;
        if (thing.getFlag("IsImmortal")) {
            thing.set("HPS", 1);
            return;
        }
        Map map = thing.getMap();
        int n = thing.getMapX();
        int n2 = thing.getMapY();
        if (thing.getFlag("IsItem") || thing.getFlag("IsOwned")) {
            if (thing.place instanceof Thing && ((Thing)thing.place).isHero()) {
                Game.message("Your " + thing.getFullName(Game.hero()) + " " + thing.is() + " destroyed!");
            }
            if (map != null && Game.actor.isHero() && thing.getFlag("IsOwned")) {
                map.areaNotify(n, n2, 6, 6, 1, Game.actor);
            }
        }
        thing.remove();
        if (map != null) {
            if (thing != Game.hero()) {
                object = thing.getFlaggedContents("IsItem");
                if (object != null) {
                    boolean bl = "impact".equals(thing.getString("KillingDamageType"));
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        map.addThing((Thing)object[i], n, n2);
                        if (!bl) continue;
                        ((Thing)object[i]).displace();
                    }
                }
            } else {
                thing.set("Killer", Game.actor);
            }
            if ((object = thing.getString("DeathDecoration")) != null) {
                map.addThing((String)object, n, n2);
            }
        }
        if (thing.handles("OnDeath")) {
            object = new Event("Death");
            ((BaseObject)object).set("DeathMap", map);
            ((BaseObject)object).set("DeathX", n);
            ((BaseObject)object).set("DeathY", n2);
            thing.handle((Event)object);
        }
        Game.registerDeath(thing);
        thing.remove();
        thing.set("APS", -1000);
        thing.set("HPS", RPG.min(0, thing.getStat("HPS")));
    }

    private static void kickEffect(Thing thing, Thing thing2) {
        Thing thing3 = Combat.kickingWeapon(thing);
        Game.instance().pushMessages();
        Combat.attackWith(thing, thing2, thing3);
        ArrayList arrayList = Game.instance().popMessages();
        if (thing2.isDead()) {
            String string = thing2.getFlag("IsLiving") ? "killed" : "destroyed";
            thing.message(thing2.getTheName() + " is " + string + " by your kick");
        }
        Game.message(arrayList);
    }

    public static void kick(Thing thing, int n, int n2) {
        thing.incStat("APS", -100);
        Map map = thing.getMap();
        Thing thing2 = map.getObjects(thing.x + n, thing.y + n2);
        while (thing2 != null) {
            if (thing2.isBlocking()) {
                Combat.kickEffect(thing, thing2);
                return;
            }
            thing2 = thing2.next;
        }
        if (map.isTileBlocked(thing.x + n, thing.y + n2)) {
            Tile.kick(thing, map, thing.x + n, thing.y + n2);
            return;
        }
        thing2 = map.getObjects(thing.x + n, thing.y + n2);
        while (thing2 != null) {
            if ((thing2.getFlag("IsItem") || thing2.getFlag("IsScenery")) && !thing2.getFlag("IsDecoration")) {
                Combat.kickEffect(thing, thing2);
                return;
            }
            thing2 = thing2.next;
        }
        Tile.kick(thing, map, thing.x + n, thing.y + n2);
    }
}

