/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.AI;
import mikera.tyrant.Chest;
import mikera.tyrant.Coin;
import mikera.tyrant.Door;
import mikera.tyrant.Fire;
import mikera.tyrant.Food;
import mikera.tyrant.Game;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Maze;
import mikera.tyrant.Point;
import mikera.tyrant.Portal;
import mikera.tyrant.RPG;
import mikera.tyrant.RuneTrap;
import mikera.tyrant.Secret;
import mikera.tyrant.SpellBook;
import mikera.tyrant.Thing;
import mikera.tyrant.Town;
import mikera.tyrant.Trap;

class Dungeon {
    private static String[] dungeonThemeNames = new String[]{"standard", "caves", "goblins", "stone", "labyrinthe", "sewer", "mines", "dungeon", "deep halls"};
    private static String[] deepThemeNames = new String[]{"hell", "fire", "ice", "metal"};

    Dungeon() {
    }

    public static Map createDungeon(int n, int n2, int n3) {
        Map map = new Map(n, n2);
        map.set("Description", "Dungeon");
        if (n3 >= 6) {
            map.set("MonsterType", RPG.pick(new String[]{"IsMonster", "IsMonster", "IsBeast", "IsGoblinoid", "IsBandit", "IsInsect", "IsUndead", "IsMonster", "IsDemonic"}));
        }
        Dungeon.makeDungeon(map, n3);
        map.addEntrance("stairs up");
        if (n3 < 50) {
            Point point = map.findFreeSquare();
            map.setExit(Portal.create("stairs down", map, point.x, point.y));
        }
        return map;
    }

    public static Map createDarkTowerLevel(int n) {
        Map map = new Map(50, 50);
        map.set("Description", "Dark Tower");
        map.set("ComplexName", "dark tower");
        map.set("DungeonLevel", n);
        map.set("NoNeutrals", 1);
        map.setTheme("metal");
        Dungeon.makeDungeon(map, 18 + n);
        map.set("WanderingRate", 1000);
        Point point = map.findFreeSquare();
        Thing thing = Portal.create("stairs down", "dark tower", n - 1);
        map.addThing(thing, point.x, point.y);
        map.setEntrance(thing);
        Point point2 = map.findFreeSquare();
        Thing thing2 = Portal.create("stairs up", "dark tower", n + 1);
        map.addThing(thing2, point2.x, point2.y);
        map.setExit(thing2);
        return map;
    }

    public static Map createDungeon(int n, int n2, String string, int n3) {
        Map map = new Map(n, n2);
        map.setTheme(string);
        Dungeon.makeDungeon(map, n3);
        return map;
    }

    public static String selectTheme(int n) {
        String[] stringArray = dungeonThemeNames;
        if (n >= 18 && RPG.d(4) == 1) {
            stringArray = deepThemeNames;
        }
        String string = RPG.pick(stringArray);
        return string;
    }

    public static void makeDungeon(Map map, int n) {
        if (map.get("Theme") == null) {
            map.setTheme(Dungeon.selectTheme(n));
        }
        int n2 = map.width;
        int n3 = map.height;
        map.set("Level", n);
        Dungeon.makeDungeon(map, 0, 0, n2 - 1, n3 - 1);
        map.replaceTiles(0, map.wall());
        for (int i = 0; i < n2 * n3 / 400; ++i) {
            Point point = map.findFreeSquare();
            Dungeon.addBaddie(map, point.x, point.y);
        }
    }

    public static Point findEdge(Map map, int n, int n2, int n3, int n4) {
        while (map.getTile(n, n2) != 0) {
            n += n3;
            n2 += n4;
        }
        if (map.isBlocked(n - n3, n2 - n4)) {
            return null;
        }
        return new Point(n, n2);
    }

    public static void addTrap(Map map, int n, int n2) {
        map.addThing(Trap.createTrap(map.getLevel()), n, n2);
    }

    private static void makeDungeon(Map map, int n, int n2, int n3, int n4) {
        String string;
        map.fillArea(n, n2, n3, n4, map.wall());
        map.fillArea(n + 1, n2 + 1, n3 - 1, n4 - 1, 0);
        map.fillArea((n + n3) / 2 - RPG.d(3), (n2 + n4) / 2 - RPG.d(3), (n + n3) / 2 + RPG.d(3), (n2 + n4) / 2 + RPG.d(3), map.floor());
        double d = map.getDouble("DungeonDensity");
        if (d == 0.0) {
            d = 0.1;
            Game.warn("No DungeonDensity!");
        }
        if ((string = map.getString("DungeonDNA")) == null) {
            string = "tttkrrroozhs";
            Game.warn("No DungeonDNA!");
        }
        int n5 = 0;
        while ((double)n5 < (double)(map.width * map.height) * d) {
            Point point = Point.randomDirection4();
            int n6 = point.x;
            int n7 = point.y;
            Point point2 = map.findEdgeSquare(n6, n7, 0);
            if (point2 != null) {
                point2.x += n6;
                point2.y += n7;
                Dungeon.extendDungeon(map, point2.x, point2.y, n6, n7, string);
            }
            ++n5;
        }
    }

    public static boolean extendDungeon(Map map, int n, int n2, int n3, int n4, String string) {
        char c = RPG.pick(string);
        switch (c) {
            case 'c': {
                return Dungeon.makeCorridor(map, n, n2, n3, n4);
            }
            case 'o': {
                return Dungeon.makeOvalRoom(map, n, n2, n3, n4);
            }
            case 'z': {
                return Dungeon.makeMaze(map, n, n2, n3, n4);
            }
            case 'r': {
                return Dungeon.makeRoom(map, n, n2, n3, n4);
            }
            case 't': {
                return Dungeon.makeCorridorToRoom(map, n, n2, n3, n4);
            }
            case 'h': {
                return Dungeon.makeChamber(map, n, n2, n3, n4);
            }
            case 'n': {
                return Dungeon.makeTunnel(map, n, n2, n3, n4);
            }
            case 's': {
                return Dungeon.makeSquare(map, n, n2, n3, n4);
            }
            case 'k': {
                return Dungeon.makeLinkingCorridor(map, n, n2, n3, n4);
            }
        }
        Game.warn("Dungeon extention '" + c + "' not recognised!");
        return false;
    }

    public static void makeDoor(Map map, int n, int n2) {
        switch (RPG.d(50)) {
            case 1: {
                map.setTile(n, n2, map.wall());
                Thing thing = Lib.create("secret door");
                thing.set("SecretDoorType", "[IsMonster]");
                map.addThing(thing, n, n2);
                break;
            }
            case 2: {
                map.setTile(n, n2, map.wall());
                map.addThing(Lib.create("secret door"), n, n2);
                break;
            }
            case 3: {
                map.setTile(n, n2, map.floor());
                map.addThing(Lib.create("portcullis"), n, n2);
                break;
            }
            default: {
                map.setTile(n, n2, map.floor());
                map.addThing(Lib.createType("IsDoor", map.getLevel()), n, n2);
            }
        }
    }

    private static boolean makeMaze(Map map, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8 = RPG.d(7) + 1;
        int n9 = n + n3 + (n3 - 1) * n8;
        if (!map.isBlank(n9, n7 = n2 + n4 + (n4 - 1) * n8, n6 = n + n3 + (n3 + 1) * n8, n5 = n2 + n4 + (n4 + 1) * n8)) {
            return false;
        }
        Maze.buildInnerMaze(map, n9, n7, n6, n5);
        Dungeon.makeDoor(map, n, n2);
        map.setTile(n + n3, n2 + n4, map.floor());
        map.setTile(n + n4, n2 - n3, map.wall());
        map.setTile(n - n4, n2 + n3, map.wall());
        return true;
    }

    private static boolean makeCorridorToRoom(Map map, int n, int n2, int n3, int n4) {
        int n5 = RPG.d(2, 10);
        if (!map.isBlank(n - n4, n2 - n3, n + n5 * n3 + n4, n2 + n5 * n4 + n3)) {
            return false;
        }
        if (!Dungeon.makeRoom(map, n + n5 * n3, n2 + n5 * n4, n3, n4)) {
            return false;
        }
        map.fillArea(n, n2, n + n5 * n3, n2 + n5 * n4, map.floor());
        Dungeon.makeDoor(map, n, n2);
        map.setTile(n + n4, n2 - n3, map.wall());
        map.setTile(n - n4, n2 + n3, map.wall());
        int n6 = RPG.rspread(1, n5 - 1);
        Dungeon.makeRoom(map, n + n6 * n3, n2 + n6 * n4, n4, -n3);
        int n7 = RPG.rspread(1, n5 - 1);
        Dungeon.makeRoom(map, n + n7 * n3, n2 + n7 * n4, -n4, n3);
        return true;
    }

    private static boolean makeRoom(Map map, int n, int n2, int n3, int n4) {
        int n5 = n - RPG.d(RPG.abs(n3 - 1), 5);
        int n6 = n2 - RPG.d(RPG.abs(n4 - 1), 5);
        int n7 = n + RPG.d(RPG.abs(n3 + 1), 5);
        int n8 = n2 + RPG.d(RPG.abs(n4 + 1), 5);
        if (n7 - n5 < 3 || n8 - n6 < 3 || !map.isBlank(n5, n6, n7, n8)) {
            return false;
        }
        map.fillArea(n5 + 1, n6 + 1, n7 - 1, n8 - 1, map.floor());
        map.setTile(n, n2, map.floor());
        map.addThing(Door.create(map.getLevel()), n, n2);
        if (RPG.d(2) == 1) {
            int n9 = map.wall();
            if (RPG.d(30) == 1) {
                n9 = RPG.pick(new int[]{6, 14, 8});
            }
            map.completeArea(n5, n6, n7, n8, n9);
            Dungeon.addEndingRoomFeatures(map, n5 + 1, n6 + 1, n7 - 1, n8 - 1);
        } else {
            map.completeArea(n3 == 0 ? n5 : n, n4 == 0 ? n6 : n2, n3 == 0 ? n7 : n, n4 == 0 ? n8 : n2, map.wall());
            Dungeon.addRoomFeatures(map, n5 + 1, n6 + 1, n7 - 1, n8 - 1);
        }
        return true;
    }

    private static void addEndingRoomFeatures(Map map, int n, int n2, int n3, int n4) {
        switch (RPG.d(50)) {
            case 1: {
                if (map.getFlag("NoNeutrals")) break;
                Dungeon.makeShop(map, n, n2, n3, n4);
                break;
            }
            case 2: {
                map.addThing(Portal.create("dungeon"), n, n2, n3, n4);
                break;
            }
            default: {
                Dungeon.addInternalRoomFeatures(map, n, n2, n3, n4);
            }
        }
    }

    private static void addRoomFeatures(Map map, int n, int n2, int n3, int n4) {
        int n5 = n3 - n + 1;
        int n6 = n4 - n2 + 1;
        switch (RPG.d(50)) {
            case 10: 
            case 11: {
                if (n5 <= 5 || n6 <= 5) break;
                map.fillArea(n + 1, n2 + 1, n3 - 1, n4 - 1, map.wall());
                map.fillArea(n + 2, n2 + 2, n3 - 2, n4 - 2, map.floor());
                Dungeon.addRoomFeatures(map, n + 2, n2 + 2, n3 - 2, n4 - 2);
                switch (RPG.d(4)) {
                    case 1: {
                        Dungeon.makeDoor(map, n + 1, n2 + 1 + RPG.d(n6 - 4));
                        break;
                    }
                    case 2: {
                        Dungeon.makeDoor(map, n3 - 1, n2 + 1 + RPG.d(n6 - 4));
                        break;
                    }
                    case 3: {
                        Dungeon.makeDoor(map, n + 1 + RPG.d(n5 - 4), n2 + 1);
                        break;
                    }
                    case 4: {
                        Dungeon.makeDoor(map, n + 1 + RPG.d(n5 - 4), n4 - 1);
                    }
                }
                break;
            }
            default: {
                Dungeon.addInternalRoomFeatures(map, n, n2, n3, n4);
            }
        }
    }

    private static void addInternalRoomFeatures(Map map, int n, int n2, int n3, int n4) {
        int n5 = n3 - n + 1;
        int n6 = n4 - n2 + 1;
        switch (RPG.d(50)) {
            case 1: 
            case 2: {
                if (n5 * n6 >= 66) break;
                for (int i = n; i <= n3; ++i) {
                    for (int j = n2; j <= n4; ++j) {
                        if (RPG.d(5) != 1) continue;
                        Dungeon.addGuard(map, i, j);
                    }
                }
                break;
            }
            case 3: 
            case 4: {
                int n7;
                if (n5 < 5 || n6 < 5) break;
                if (n5 % 2 == 1) {
                    for (n7 = 1; n7 < n5; n7 += 2) {
                        map.setTile(n + n7, n2 + 1, map.wall());
                        map.setTile(n + n7, n4 - 1, map.wall());
                    }
                }
                if (n6 % 2 != 1) break;
                for (n7 = 1; n7 < n6; n7 += 2) {
                    map.setTile(n + 1, n2 + n7, map.wall());
                    map.setTile(n3 - 1, n2 + n7, map.wall());
                }
                break;
            }
            case 5: 
            case 6: {
                for (int i = n; i <= n3; ++i) {
                    for (int j = n2; j <= n4; ++j) {
                        if (RPG.d(5) != 1) continue;
                        map.addThing(Lib.create("plant"), i, j);
                    }
                }
                break;
            }
            case 7: 
            case 8: {
                map.addThing(Lib.createItem(0), n + RPG.r(n5), n2 + RPG.r(n6));
                break;
            }
            case 9: {
                map.fillArea(n + 1, n2 + 1, n3 - 1, n4 - 1, 0);
                break;
            }
            case 12: {
                for (int i = n; i <= n3; ++i) {
                    for (int j = n2; j <= n4; ++j) {
                        if (RPG.d(4) != 1) continue;
                        map.addThing(RuneTrap.create(), i, j);
                    }
                }
                break;
            }
            case 13: {
                map.addThing(Lib.createItem(map.getLevel()), n + RPG.r(n5), n2 + RPG.r(n6));
                map.addThing(Trap.createTrap(map.getLevel()), n + RPG.r(n5), n2 + RPG.r(n6));
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                int n8;
                if (n5 <= 3 || !map.isBlank(n8 = n + RPG.d(n5 - 2), n2 - 1) || !map.isBlank(n8, n4 + 1)) break;
                map.fillArea(n8, n2, n8, n4, map.wall());
                int n9 = n2 + RPG.r(n6);
                map.addThing(Lib.create("secret passage"), n8, n9);
                Dungeon.addGuard(map, n8 + 1, n9);
                Dungeon.addGuard(map, n8 - 1, n9);
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                int n10;
                if (n6 <= 3 || !map.isBlank(n - 1, n10 = n2 + RPG.d(n6 - 2), n - 1, n10) || !map.isBlank(n3 + 1, n10, n3 + 1, n10)) break;
                map.fillArea(n, n10, n3, n10, map.wall());
                int n11 = n + RPG.r(n5);
                map.addThing(Lib.create("secret passage"), n11, n10);
                Dungeon.addGuard(map, n11, n10 + 1);
                Dungeon.addGuard(map, n11, n10 - 1);
                break;
            }
            case 20: {
                map.addThing(Lib.createType("IsMonster", map.getLevel() + 2), n + RPG.r(n5), n2 + RPG.r(n6));
                map.addThing(SpellBook.create(map.getLevel()), n + RPG.r(n5), n2 + RPG.r(n6));
                break;
            }
            case 21: {
                map.fillArea(n + 1, n2 + 1, n3 - 1, n4 - 1, 28);
                break;
            }
            case 22: 
            case 23: {
                map.addThing(Food.createFood(map.getLevel()), n, n2, n3, n4);
                break;
            }
            case 24: {
                for (int i = n; i <= n3; ++i) {
                    for (int j = n2; j <= n4; ++j) {
                        if (RPG.d(4) != 1) continue;
                        map.addThing(Trap.create(), i, j);
                    }
                }
                break;
            }
        }
    }

    public static void makeShop(Map map, int n, int n2, int n3, int n4) {
        Thing thing = Lib.create("shopkeeper");
        String string = RPG.pick(new String[]{"IsStoreItem", "IsStoreItem", "IsStoreItem", "IsScroll", "IsPotion", "IsMagicItem", "IsWeapon", "IsArmour", "IsShopFood", "IsFood"});
        for (int i = n; i <= n3; ++i) {
            for (int j = n2; j <= n4; ++j) {
                map.addThing(Town.stockingPoint(thing, string, map.getLevel()), i, j);
            }
        }
        AI.setGuard(thing, map, n, n2, n3, n4);
        thing.set("IsNeutral", 1);
        map.addThing(thing, (n + n3) / 2, (n2 + n4) / 2);
    }

    public static void addBeasties(Map map, int n, int n2) {
        Thing thing = Lib.createCreature(map.getLevel());
        map.addThing(Lib.create(thing.getString("Name")), n, n2);
    }

    private static void addGuard(Map map, int n, int n2) {
        if (map.isClear(n, n2)) {
            Thing thing = Lib.createMonster(map.getLevel());
            map.addThing(thing, n, n2);
        }
    }

    protected static void addWandering(Map map) {
        Point point = map.findFreeSquare();
        int n = point.x;
        int n2 = point.y;
        if (!map.isVisible(n, n2)) {
            Thing thing = Dungeon.createFoe(map);
            map.addThing(thing, n, n2);
        }
    }

    public static Thing createFoe(Map map) {
        String string = map.getString("MonsterType");
        if (string == null) {
            string = "IsHostile";
        }
        String[] stringArray = string.split(",");
        String string2 = stringArray[RPG.r(stringArray.length)];
        int n = map.getLevel();
        return Lib.createType(string2, n);
    }

    private static void addBaddie(Map map, int n, int n2) {
        int n3 = map.getLevel();
        if (map.isClear(n, n2)) {
            Thing thing = Dungeon.createFoe(map);
            if (RPG.d(10) == 1) {
                thing.addThing(Lib.createItem(n3));
            }
            map.addThing(thing, n, n2);
        }
    }

    public static boolean makeOvalRoom(Map map, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = RPG.d(2, 3);
        int n10 = n + (n3 - 1) * n9;
        if (!map.isBlank(n10, n8 = n2 + (n4 - 1) * (n7 = RPG.d(2, 3)), n6 = n + (n3 + 1) * n9, n5 = n2 + (n4 + 1) * n7)) {
            return false;
        }
        int n11 = (n10 + n6) / 2;
        int n12 = (n8 + n5) / 2;
        for (int i = n10; i <= n10 + n9 * 2; ++i) {
            for (int j = n8; j < n8 + n7 * 2; ++j) {
                if ((i - n11) * (i - n11) * 100 / (n9 * n9) + (j - n12) * (j - n12) * 100 / (n7 * n7) >= 100) continue;
                map.setTile(i, j, map.floor());
            }
        }
        map.fillArea(n11, n12, n, n2, map.floor());
        return true;
    }

    public static boolean makeChamber(Map map, int n, int n2, int n3, int n4) {
        int n5 = n + (n3 - 1) * 2;
        int n6 = n2 + (n4 - 1) * 2;
        int n7 = n + (n3 + 1) * 2;
        int n8 = n2 + (n4 + 1) * 2;
        int n9 = n5 + 2;
        int n10 = n6 + 2;
        if (!map.isBlank(n5, n6, n7, n8)) {
            return false;
        }
        map.fillArea(++n5, ++n6, --n7, --n8, map.floor());
        map.setTile(n, n2, map.floor());
        Dungeon.makeDoor(map, n, n2);
        boolean bl = false;
        boolean bl2 = false;
        switch (RPG.d(4)) {
            case 1: 
            case 2: {
                bl = Dungeon.makeRoom(map, n9 + 2 * n3, n10 + 2 * n4, n3, n4) || bl;
                break;
            }
            case 3: {
                boolean bl3 = bl = Dungeon.makeChamber(map, n9 + 2 * n3, n10 + 2 * n4, n3, n4) || bl;
            }
        }
        if (bl && RPG.d(3) == 1) {
            bl2 = true;
        } else {
            if (RPG.d(3) == 1) {
                boolean bl4 = bl = Dungeon.makeChamber(map, n9 + 2 * n4, n10 + 2 * n3, n4, n3) || bl;
            }
            if (RPG.d(3) == 1) {
                boolean bl5 = bl = Dungeon.makeChamber(map, n9 - 2 * n4, n10 - 2 * n3, -n4, -n3) || bl;
            }
        }
        if (bl) {
            if (bl2) {
                switch (RPG.d(12)) {
                    case 1: {
                        map.fillArea(n9 - 1, n10 - 1, n9 + 1, n10 + 1, map.wall());
                        map.fillArea(n9 - n3, n10 - n4, n9 + n3, n10 + n4, map.floor());
                        break;
                    }
                    case 2: {
                        String string = RPG.pick(new String[]{"menhir", "gravestone", "bone", "stone bench"});
                        map.addThing(string, n9 + n4, n10 - n3);
                        map.addThing(string, n9 - n4, n10 + n3);
                    }
                }
            } else {
                switch (RPG.d(8)) {
                    case 1: {
                        map.addThing(Trap.create(), n9 - n3, n10 - n4);
                        map.addThing(Chest.create(map.getLevel()), n9, n10);
                        break;
                    }
                    case 2: {
                        map.setTile(n9, n10, map.wall());
                        map.addThing(Secret.hide(Lib.createItem(map.getLevel())), n9 - 1, n10 - 1, n9 + 1, n10 + 1);
                        break;
                    }
                    case 3: {
                        map.addThing("menhir", n9, n10);
                        break;
                    }
                    case 4: {
                        map.addThing("fountain", n9, n10);
                    }
                }
            }
        } else {
            switch (RPG.d(30)) {
                case 1: {
                    map.addThing(Trap.create(), n9, n10);
                    map.addThing(Chest.create(map.getLevel()), n9 + n3, n10 + n4);
                    break;
                }
                case 2: {
                    map.addThing(RuneTrap.create(), n9, n10);
                    map.addThing(RuneTrap.create(), n9 + n4, n10 - n3);
                    map.addThing(RuneTrap.create(), n9 - n4, n10 + n3);
                    map.addThing(Chest.create(map.getLevel()), n9 + n3, n10 + n4);
                    break;
                }
                case 3: {
                    map.addThing(Lib.createType("IsMagicItem", map.getLevel()), n9 - n3, n10 - n4);
                    map.addThing(Chest.create(map.getLevel()), n9, n10);
                    break;
                }
                case 4: {
                    map.setTile(n9, n10, 17);
                    break;
                }
                case 5: {
                    map.setTile(n9, n10, map.wall());
                    map.addThing(Secret.hide(Lib.createItem(map.getLevel())), n9 - 1, n10 - 1, n9 + 1, n10 + 1);
                    break;
                }
                case 6: {
                    map.addThing("[IsGravestone]", n9 + n3, n10 + n4);
                    if (RPG.d(3) == 1) {
                        Thing thing = Lib.createType("IsIntelligent", map.getLevel() + 6);
                        if (!map.getFlag("NoNeutrals")) {
                            AI.setNeutral(thing);
                        }
                        map.addThing(thing, n9, n10);
                    }
                    if (RPG.d(3) != 1) break;
                    map.addThing("[IsGravestone]", n9 + n3 - n4, n10 + n4 + n3);
                    map.addThing("[IsGravestone]", n9 + n3 + n4, n10 + n4 - n3);
                    break;
                }
                case 7: {
                    Thing thing = Lib.createType("IsIntelligent", map.getLevel());
                    AI.setGuard(thing, map, n5, n6, n7, n8);
                    map.addThing(thing, n9, n10);
                    if (!map.getFlag("NoNeutrals")) {
                        AI.setNeutral(thing);
                    }
                    map.addThing(Lib.createItem(map.getLevel()), n5, n6, n7, n8).set("IsOwned", 1);
                    map.addThing(Lib.createItem(map.getLevel()), n5, n6, n7, n8).set("IsOwned", 1);
                    if (RPG.d(2) != 1) break;
                    map.addThing(Lib.createItem(map.getLevel()), n5, n6, n7, n8).set("IsShopOwned", 1);
                    map.addThing(Lib.createItem(map.getLevel()), n5, n6, n7, n8).set("IsShopOwned", 1);
                    break;
                }
                case 8: {
                    map.addThing("pit trap", n9 - n3, n10 - n4);
                    break;
                }
                case 9: {
                    Thing thing = Lib.createType("IsMonster", map.getLevel());
                    int n11 = n5;
                    while (n <= n7) {
                        int n12 = n6;
                        while (n2 <= n8) {
                            map.addThing(thing.cloneType(), n11, n12);
                            ++n2;
                        }
                        ++n;
                    }
                    break;
                }
                case 10: {
                    int n13 = n5;
                    while (n <= n7) {
                        int n14 = n6;
                        while (n2 <= n8) {
                            Thing thing = Lib.createType("IsMonster", map.getLevel() + 3);
                            map.addThing(thing, n13, n14);
                            map.addThing(Coin.createLevelMoney(map.getLevel()));
                            ++n2;
                        }
                        ++n;
                    }
                    break;
                }
                case 11: {
                    int n15 = n5;
                    while (n <= n7) {
                        int n16 = n6;
                        while (n2 <= n8) {
                            Thing thing = Lib.createType("IsFood", map.getLevel());
                            map.addThing(thing, n15, n16);
                            ++n2;
                        }
                        ++n;
                    }
                    break;
                }
                case 12: {
                    map.addThing("[IsAltar]", n9 + n3, n10 + n4);
                    break;
                }
                case 13: {
                    map.addThing("fountain", n9 + n3, n10 + n4);
                    break;
                }
                default: {
                    Dungeon.addInternalRoomFeatures(map, n5, n6, n7, n8);
                }
            }
        }
        map.completeArea(n5 - 1, n6 - 1, n7 + 1, n8 + 1, map.wall());
        return true;
    }

    public static boolean makeSquare(Map map, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        block29: {
            int n9;
            int n10;
            block28: {
                n8 = n + (n3 - 1) * 3;
                n7 = n2 + (n4 - 1) * 3;
                n6 = n + (n3 + 1) * 3;
                n5 = n2 + (n4 + 1) * 3;
                n10 = n8 + 3;
                n9 = n7 + 3;
                if (!map.isBlank(n8, n7, n6, n5)) {
                    return false;
                }
                map.fillArea(n8 + 1, n7 + 1, n6 - 1, n5 - 1, map.floor());
                map.setTile(n, n2, map.floor());
                Dungeon.makeDoor(map, n, n2);
                boolean bl = false;
                switch (RPG.d(4)) {
                    case 1: 
                    case 2: {
                        bl = Dungeon.makeRoom(map, n10 + 3 * n3, n9 + 3 * n4, n3, n4) || bl;
                        break;
                    }
                    case 3: {
                        boolean bl2 = bl = Dungeon.makeChamber(map, n10 + 3 * n3, n9 + 3 * n4, n3, n4) || bl;
                    }
                }
                if (RPG.d(2) == 1) {
                    if (RPG.d(2) == 1) {
                        bl = Dungeon.makeChamber(map, n10 + 3 * n4, n9 + 3 * n3, n4, n3) || bl;
                    } else {
                        boolean bl3 = bl = Dungeon.makeRoom(map, n10 + 3 * n4, n9 + 3 * n3, n4, n3) || bl;
                    }
                }
                if (RPG.d(2) == 1) {
                    if (RPG.d(2) == 1) {
                        bl = Dungeon.makeChamber(map, n10 - 3 * n4, n9 - 3 * n3, -n4, -n3) || bl;
                    } else {
                        boolean bl4 = bl = Dungeon.makeRoom(map, n10 - 3 * n4, n9 - 3 * n3, -n4, -n3) || bl;
                    }
                }
                if (!bl) break block28;
                switch (RPG.d(8)) {
                    case 1: {
                        map.addThing(Chest.create(map.getLevel()), n10, n9);
                        map.addThing(Trap.create(), n10 + n3, n9 + n4);
                        break;
                    }
                    case 2: {
                        Dungeon.addBeasties(map, n10, n9);
                        break;
                    }
                    case 3: {
                        map.addThing(Fire.create(5), n10 + 1, n9 + 1);
                        map.addThing(Fire.create(5), n10 - 1, n9 + 1);
                        map.addThing(Fire.create(5), n10 + 1, n9 - 1);
                        map.addThing(Fire.create(5), n10 - 1, n9 - 1);
                        break;
                    }
                    case 4: 
                    case 5: {
                        map.fillArea(n8 + 1, n7 + 1, n6 - 1, n5 - 1, map.wall());
                        if (!map.isBlank(n10 - 3, n9)) {
                            map.fillArea(n10, n9, n10 - 3, n9, map.floor());
                        }
                        if (!map.isBlank(n10 + 3, n9)) {
                            map.fillArea(n10, n9, n10 + 3, n9, map.floor());
                        }
                        if (!map.isBlank(n10, n9 - 3)) {
                            map.fillArea(n10, n9, n10, n9 - 3, map.floor());
                        }
                        if (!map.isBlank(n10, n9 + 3)) {
                            map.fillArea(n10, n9, n10, n9 + 3, map.floor());
                            break;
                        }
                        break block29;
                    }
                    default: {
                        Dungeon.addInternalRoomFeatures(map, n8 + 1, n7 + 1, n6 - 1, n5 - 1);
                        break;
                    }
                }
                break block29;
            }
            switch (RPG.d(8)) {
                case 1: {
                    map.addThing(Lib.createCreature(map.getLevel() + 3), n10, n9);
                    map.addThing(Chest.create(map.getLevel() + 3), n10 + n3, n9 + n4);
                    break;
                }
                case 2: {
                    if (map.getFlag("NoNeutrals")) break;
                    Dungeon.makeShop(map, n10 - 2, n9 - 2, n10 + 2, n9 + 2);
                    break;
                }
                case 3: {
                    map.addThing(Fire.create(5), n10 + n3, n9 + n4);
                    Thing thing = Lib.createType("IsIntelligent", map.getLevel() + 2);
                    if (!map.getFlag("NoNeutrals")) {
                        AI.setNeutral(thing);
                    }
                    map.addThing(thing, n10, n9);
                    AI.setGuard(thing, map, n10 - 2, n9 - 2, n10 + 2, n9 + 2);
                    Thing thing2 = Lib.createType("IsIntelligent", map.getLevel() + 2);
                    if (!map.getFlag("NoNeutrals")) {
                        AI.setNeutral(thing2);
                    }
                    map.addThing(thing2, n10 - n3, n9 - n4);
                    AI.setGuard(thing2, map, n10 - 2, n9 - 2, n10 + 2, n9 + 2);
                }
            }
        }
        map.completeArea(n8, n7, n6, n5, map.wall());
        return true;
    }

    public static boolean makeTunnel(Map map, int n, int n2, int n3, int n4) {
        if (map.getTile(n, n2) == 0 && map.isValid(n, n2)) {
            int n5 = n3;
            int n6 = n4;
            map.setTile(n, n2, map.floor());
            if (RPG.d(3) == 1) {
                n5 = -n4;
                n6 = n3;
            }
            if (RPG.d(4) == 1) {
                n5 = n4;
                n6 = -n3;
            }
            Dungeon.makeTunnel(map, n + n5, n2 + n6, n5, n6);
            return true;
        }
        return false;
    }

    public static boolean makeLinkingCorridor(Map map, int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n2;
        for (int i = RPG.d(4, 10); i > 0; --i) {
            if (map.isBlank(n5 += n3, n6 += n4)) continue;
            if (!map.isBlocked(n5, n6)) break;
            return false;
        }
        if (!map.isBlank(n5, n6)) {
            map.fillArea(n, n2, n5 - n3, n6 - n4, map.floor());
            return true;
        }
        return false;
    }

    public static boolean makeCorridor(Map map, int n, int n2, int n3, int n4) {
        int n5 = RPG.d(2, 8);
        if (!map.isBlank(n, n2, n + n3 * n5, n2 + n4 * n5)) {
            return false;
        }
        for (int i = 0; i < n5; ++i) {
            map.setTile(n + i * n3, n2 + i * n4, map.floor());
        }
        if (n5 > 4 && RPG.d(2) == 1 && map.completeTile(n + n4, n2 + n3, map.wall()) & map.completeTile(n - n4, n2 - n3, map.wall())) {
            Dungeon.makeDoor(map, n, n2);
        }
        if (n5 > 3) {
            Dungeon.makeRoom(map, n + n3 * n5, n2 + n4 * n5, n3, n4);
        }
        if (RPG.d(100) == 1) {
            Dungeon.addTrap(map, n + RPG.r(n5) * n3, n2 + RPG.r(n5) * n4);
        }
        return true;
    }
}

