/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Monster;
import mikera.tyrant.Script;
import mikera.tyrant.Thing;

public class EndGame {
    public static Map getFinalMap() {
        Map map = new Map(21, 41);
        map.setTheme("metal");
        map.set("Level", 30);
        map.set("Description", "The Tyrant's Throne Room");
        map.set("EnterMessage", "\"Prepare to DIE, puny mortal!!\"");
        map.fillArea(0, 0, 20, 40, map.wall());
        map.fillArea(1, 1, 19, 19, 33);
        map.fillOval(5, 7, 15, 13, map.floor());
        map.fillArea(9, 10, 11, 39, map.floor());
        map.addThing(Lib.create("The Tyrant"), 10, 10);
        map.fillArea(1, 21, 19, 39, map.floor());
        for (int i = 22; i <= 39; i += 2) {
            map.addThing("demon vortex", 7, i);
            map.addThing("demon vortex", 13, i);
        }
        map.addEntrance("stairs down");
        return map;
    }

    public static void init() {
        Thing thing = Lib.extendNamed("The Tyrant", "human");
        Monster.stats(thing, 300, 200, 250, 300, 100, 300, 100, 150);
        thing.set("ARM", 400);
        Monster.strengthen(thing, 0.6);
        thing.set("IsHostile", 1);
        thing.set("MoveSpeed", 200);
        thing.set("AttackSpeed", 200);
        thing.set("Image", 503);
        thing.set("Unarmed Combat", 2);
        thing.set("Attack", 3);
        thing.set("Defence", 4);
        thing.set("Spellcasting", 4);
        thing.set("True Magic", 5);
        thing.set("Magic Resistance", 4);
        thing.set("Bravery", 5);
        thing.set("RES:fire", 1000);
        thing.set("IsDisplaceable", 0);
        thing.set("DefaultThings", "The Tyrant's Mace,The Tyrant's Armour,[IsSpell],[IsSpell],[IsSpell],[IsSpell],[IsSpell],[IsSpell]");
        thing.set("LevelMin", 30);
        thing.set("Luck", 100);
        thing.set("ASCII", "T");
        thing.addHandler("OnDeath", new Script(){
            private static final long serialVersionUID = 1L;

            public boolean handle(Thing thing, Event event) {
                Game.over = true;
                return false;
            }
        });
        Lib.add(thing);
        thing = Lib.extendNamed("Bel-Gorimoth", "master voidling");
        Monster.stats(thing, 2000, 2000, 2000, 3000, 1500, 3000, 1000, 3000);
        thing.set("Armour", 2000);
        thing.set("Unarmed Combat", 5);
        thing.set("Attack", 5);
        thing.set("Defence", 5);
        thing.set("Spellcasting", 20);
        thing.set("Focus", 10);
        thing.set("True Magic", 5);
        thing.set("Magic Resistance", 6);
        thing.set("Bravery", 10);
        thing.set("Luck", 200);
        thing.set("Speed", 200);
        thing.set("AttackSpeed", 300);
        thing.set("MoveSpeed", 300);
        thing.set("UnarmedWeapon", Lib.create("disintegrate attack"));
        Lib.add(thing);
    }
}

