/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.awt.event.KeyEvent;
import mikera.tyrant.Action;
import mikera.tyrant.ActionMapping;
import mikera.tyrant.Game;
import mikera.tyrant.Map;
import mikera.tyrant.Movement;
import mikera.tyrant.Point;
import mikera.tyrant.Thing;

public class GameHandler {
    private ActionMapping actionMapping = new ActionMapping();

    public GameHandler() {
        this.actionMapping.addDefaultMappings();
    }

    public void doDirection(Thing thing, Action action, boolean bl) {
        Map map = thing.getMap();
        Point point = GameHandler.convertActionToDirection(action);
        if (map.getTile(thing.x + point.x, thing.y + point.y) != 0) {
            boolean bl2;
            if (bl) {
                if (!(thing.getStat("DirectionX") == point.x && thing.getStat("DirectionY") == point.y && thing.isRunning() || thing.getStat("RunDirectionX") != Integer.MIN_VALUE)) {
                    map.clearPath();
                }
                thing.isRunning(true);
            }
            if (!(bl2 = Movement.tryMove(thing, map, thing.x + point.x, thing.y + point.y))) {
                thing.isRunning(false);
            }
        } else if (map.canExit()) {
            thing.isRunning(false);
            Game.message("Exit area? (y/n)");
            int n = Game.getOption("yn123456789");
            Game.messagepanel.clear();
            if (thing.x == 0 && "147".indexOf(n) >= 0) {
                n = 121;
            }
            if (thing.y == 0 && "789".indexOf(n) >= 0) {
                n = 121;
            }
            if (thing.x == map.width - 1 && "369".indexOf(n) >= 0) {
                n = 121;
            }
            if (thing.y == map.width - 1 && "123".indexOf(n) >= 0) {
                n = 121;
            }
            if (n == 121) {
                map.exitMap(thing.x, thing.y);
            }
        } else if (map.getFlag("IsWorldMap") && bl) {
            boolean bl3 = thing.x == 0 && point.x == -1 || thing.x == map.getWidth() - 1 && point.x == 1 || thing.y == 0 && point.y == -1 || thing.y == map.getHeight() - 1 && point.y == 1;
            thing.isRunning(!bl3);
        }
    }

    public void calculateVision(Thing thing) {
        thing.calculateVision();
    }

    public Action actionFor(KeyEvent keyEvent) {
        return this.actionMapping.actionFor(keyEvent);
    }

    public Point convertKeyToDirection(char c) {
        Action action = this.actionMapping.convertKeyToAction(c);
        return GameHandler.convertActionToDirection(action);
    }

    public static Point convertActionToDirection(Action action) {
        Point point = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
        if (action == Action.MOVE_N) {
            point.x = 0;
            point.y = -1;
        }
        if (action == Action.MOVE_S) {
            point.x = 0;
            point.y = 1;
        }
        if (action == Action.MOVE_W) {
            point.x = -1;
            point.y = 0;
        }
        if (action == Action.MOVE_E) {
            point.x = 1;
            point.y = 0;
        }
        if (action == Action.MOVE_NW) {
            point.x = -1;
            point.y = -1;
        }
        if (action == Action.MOVE_NE) {
            point.x = 1;
            point.y = -1;
        }
        if (action == Action.MOVE_SW) {
            point.x = -1;
            point.y = 1;
        }
        if (action == Action.MOVE_SE) {
            point.x = 1;
            point.y = 1;
        }
        if (action == Action.MOVE_NOWHERE) {
            point.x = 0;
            point.y = 0;
        }
        return point.x == Integer.MIN_VALUE ? null : point;
    }

    public void setActionMapping(ActionMapping actionMapping) {
        this.actionMapping = actionMapping;
    }
}

