/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.io.Serializable;
import mikera.tyrant.AI;
import mikera.tyrant.Fire;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Monster;
import mikera.tyrant.Name;
import mikera.tyrant.Point;
import mikera.tyrant.Portal;
import mikera.tyrant.RPG;
import mikera.tyrant.Thing;

public class GoblinVillage {
    public static Map makeGoblinVillage() {
        int n;
        Serializable serializable;
        int n2;
        int n3;
        int n4 = 61;
        int n5 = 61;
        Map map = new Map(n4, n5);
        map.setTheme("goblins");
        map.set("IsHostile", 0);
        map.set("Description", "Goblin Village");
        map.set("EnterMessage", "You hear the sound of goblin drums...");
        map.set("Level", 3);
        Thing thing = Portal.create("invisible portal");
        map.addThing(thing, 30, 0);
        map.setEntrance(thing);
        map.makeRandomPath(n4 / 2, 0, n4 / 2, n5 / 2, 0, 0, n4 - 1, n5 - 1, map.floor(), false);
        Point[] pointArray = new Point[RPG.d(2, 10)];
        pointArray[0] = new Point(n4 / 2, n5 / 2);
        int n6 = 1;
        for (n3 = 1; n3 < pointArray.length; ++n3) {
            for (n2 = 0; n2 < 20; ++n2) {
                pointArray[n3] = serializable = new Point(6 + RPG.r(n4 - 12), 6 + RPG.r(n5 - 12));
                n = 1;
                for (int i = 0; i < n3; ++i) {
                    if (pointArray[i] == null || pointArray[i].hvDistance((Point)serializable) >= 9) continue;
                    n = 0;
                    break;
                }
                if (n != 0) break;
                pointArray[n3] = null;
            }
            if (pointArray[n3] == null) continue;
            ++n6;
        }
        if (n6 < pointArray.length) {
            Point[] pointArray2 = new Point[n6];
            n6 = 0;
            for (n2 = 0; n2 < pointArray.length; ++n2) {
                if (pointArray[n2] == null) continue;
                pointArray2[n6++] = pointArray[n2];
            }
            pointArray = pointArray2;
        }
        for (n3 = 1; n3 < pointArray.length; ++n3) {
            n2 = RPG.r(n3);
            map.makeRandomPath(pointArray[n3].x, pointArray[n3].y, pointArray[n2].x, pointArray[n2].y, 0, 0, n4 - 1, n5 - 1, map.floor(), false);
        }
        GoblinVillage.makeChiefHut(map, pointArray[0].x, pointArray[0].y);
        for (n3 = 1; n3 < pointArray.length; ++n3) {
            GoblinVillage.makeRandomFeature(map, pointArray[n3].x, pointArray[n3].y);
        }
        for (n3 = 0; n3 < 30; ++n3) {
            map.addThing(Lib.createType("IsGoblinoid", RPG.d(10)));
        }
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                serializable = map.getMobile(n3, n2);
                if (serializable != null) {
                    AI.setNeutral((Thing)serializable);
                }
                n = RPG.distSquared(n3, n2, n4 / 2, n5 / 2);
                if (!map.isBlank(n3, n2) || RPG.d(2500) >= n) continue;
                map.addThing(Lib.create("withered tree"), n3, n2);
            }
        }
        map.completeArea(0, 0, n4 - 1, n5 - 1, 27);
        return map;
    }

    public static void makeChiefHut(Map map, int n, int n2) {
        map.fillOval(n - 6, n2 - 6, n + 6, n2 + 6, map.floor());
        map.fillArea(n - 4, n2 - 2, n + 4, n2 + 2, map.wall());
        map.fillArea(n - 3, n2 - 3, n + 3, n2 + 3, map.wall());
        map.fillArea(n - 3, n2 - 1, n + 3, n2 + 1, map.floor());
        map.fillArea(n - 2, n2 - 2, n + 2, n2 + 2, map.floor());
        map.fillArea(n, n2 - 4, n, n2, map.floor());
        Thing thing = Lib.create("goblin war-boss");
        AI.name(thing, Name.createGoblinName() + " the goblin war-boss");
        map.addThing(thing, n, n2);
        AI.setGuard(thing, map, n, n2 + 2, n, n2 + 2);
        thing.addThing(Lib.createArtifact(20));
        for (int i = RPG.d(2, 4); i > 0; --i) {
            Thing thing2 = Lib.create(RPG.pick(new String[]{"goblin chieftain", "goblin shaman", "goblin hero"}));
            AI.name(thing2, Name.createGoblinName() + " " + thing2.getTheName());
            map.addThing(thing2, n - 3, n2 - 2, n + 3, n2 + 2);
            AI.setGuard(thing2, map, thing2.x, thing2.y);
        }
    }

    public static void makeRandomFeature(Map map, int n, int n2) {
        switch (RPG.d(10)) {
            case 1: {
                map.fillOval(n - 4, n2 - 4, n + 4, n2 + 4, map.floor());
                for (int i = -2; i <= 2; ++i) {
                    for (int j = -2; j <= 2; ++j) {
                        if (i == 2 || i == -2 || j == 2 || j == -2) {
                            map.addThing("barricade", n + i, n2 + j);
                            continue;
                        }
                        if (RPG.d(2) == 1) {
                            map.addThing("goblin archer", n + i, n2 + j);
                            continue;
                        }
                        map.addThing("[IsStoreItem]", n + i, n2 + j);
                    }
                }
                return;
            }
            case 2: {
                map.fillOval(n - 3, n2 - 3, n + 3, n2 + 3, map.floor());
                for (int i = -2; i <= 2; ++i) {
                    for (int j = -2; j <= 2; ++j) {
                        Thing thing = Lib.createType("IsGoblinoid", RPG.d(15));
                        map.addThing(thing, n + i, n2 + j);
                        AI.setGuard(thing, map, n + i, n2 + j);
                    }
                }
                return;
            }
            case 3: {
                map.fillArea(n - 2, n2 - 2, n + 2, n2 + 2, map.floor());
                for (int i = -2; i <= 2; ++i) {
                    for (int j = -2; j <= 2; ++j) {
                        if (RPG.d(3) != 1) continue;
                        Thing thing = Lib.create("tent");
                        map.addThing(thing, n + i, n2 + j);
                    }
                }
                return;
            }
            case 4: {
                map.fillOval(n - 2, n2 - 2, n + 2, n2 + 2, map.floor());
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        if (i == 0 && j == 0) {
                            map.addThing(Fire.create(10), n, n2);
                            continue;
                        }
                        if (RPG.d(2) != 1) continue;
                        Thing thing = Lib.createType("IsGoblinoid", RPG.d(10));
                        map.addThing(thing, n + i, n2 + j);
                        AI.setGuard(thing, map, n + i, n2 + j);
                    }
                }
                return;
            }
        }
        map.fillOval(n - 2, n2 - 2, n + 2, n2 + 2, map.floor());
        Thing thing = Lib.createType("IsGoblinoid", 10 + RPG.d(10));
        map.addThing(thing, n, n2);
        AI.setGuard(thing, map, n, n2, n, n2);
    }

    public static void init() {
        Thing thing = Lib.extend("goblin tribesman", "goblin");
        thing.set("Frequency", 0);
        AI.setNeutral(thing);
        thing.set("LevelMin", 7);
        Lib.add(thing);
        thing = Lib.extend("goblin guard", "goblin tribesman");
        Monster.strengthen(thing, 3.0);
        thing.set("Image", 243);
        thing.set("LevelMin", 15);
        Lib.add(thing);
    }
}

