/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.AI;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Maze;
import mikera.tyrant.Portal;
import mikera.tyrant.RPG;
import mikera.tyrant.Secret;
import mikera.tyrant.Thing;
import mikera.tyrant.Trap;

public class Pit {
    public int type;

    public static Map create(int n) {
        int n2 = 9 + RPG.d(n);
        Map map = new Map(n2, n2);
        map.set("Level", n);
        Pit.build(map, 0, n);
        map.set("Description", "A Dark Pit");
        return map;
    }

    public static Map createArtifactVault(String string, int n) {
        Map map = new Map(21, 21);
        map.setTheme(RPG.pick(new String[]{"standard", "caves", "labyrinthe", "sewer"}));
        Maze.buildMaze(map, 0, 0, map.width - 1, map.height - 1);
        map.setEntrance(Portal.create("stairs up"));
        map.addThing(map.getEntrance());
        map.set("Level", n);
        map.set("MonsterType", string);
        map.set("WanderingType", string);
        map.set("WanderingRate", 300);
        map.set("Description", "Dark Vault");
        map.set("EnterMessage", "You feel a surge of excitement!");
        Thing thing = Lib.createArtifact(n);
        Thing thing2 = Lib.createType(string, n + 6);
        AI.name(thing2, "The Boss");
        thing2.addThing(thing);
        map.addThing(thing2);
        for (int i = 0; i < map.width; ++i) {
            for (int j = 0; j < map.height; ++j) {
                if (!map.isClear(i, j)) continue;
                map.addThing(Lib.createType(string, n), i, j);
            }
        }
        return map;
    }

    public static void build(Map map, int n, int n2) {
        int n3 = map.width;
        int n4 = map.height;
        if (n == 0) {
            n = RPG.d(8);
        }
        switch (n) {
            case 1: {
                map.setTheme(RPG.pick(new String[]{"standard", "caves", "labyrinthe", "sewer"}));
                Pit.buildPitComplex(map, 0, 0, map.width - 1, map.height - 1);
                map.addEntrance("ladder up");
                map.addThing(Lib.create("secret item"));
                map.addThing(Lib.createCreature(n2));
                break;
            }
            case 2: {
                map.setTheme(RPG.pick(new String[]{"standard", "caves", "labyrinthe", "sewer"}));
                map.fillArea(0, 0, map.width - 1, map.height - 1, map.floor());
                map.fillBorder(0, 0, map.width - 1, map.height - 1, map.wall());
                map.addEntrance("stairs up");
                map.addThing(Lib.createCreature(n2));
                if (RPG.d(3) == 1) {
                    map.addThing(Lib.createCreature(n2 + 1));
                }
                if (RPG.d(3) == 1) {
                    map.addThing(Lib.create("secret item"));
                }
                if (RPG.d(3) != 1) break;
                map.addThing(Trap.create(n2));
                break;
            }
            case 3: {
                map.setTheme(RPG.pick(new String[]{"standard", "caves", "labyrinthe", "sewer"}));
                Pit.buildPitComplex(map, 0, 0, map.width - 1, map.height - 1);
                map.setEntrance(Portal.create("ladder up"));
                map.addThing(Secret.hide(map.getEntrance()));
                map.addThing(Trap.create(n2));
                map.addThing(Trap.create(n2));
                map.addThing(Trap.create(n2));
                map.addThing(Trap.create(n2));
                map.addThing(Trap.create(n2));
                map.addThing(Trap.create(n2));
                if (RPG.d(3) != 1) break;
                map.addThing(Lib.createCreature(n2 + 1));
                break;
            }
            case 4: {
                map.setTheme(RPG.pick(new String[]{"standard", "caves", "labyrinthe", "sewer"}));
                Pit.buildPitComplex(map, 0, 0, map.width - 1, map.height - 1);
                Thing thing = Lib.createMonster(n2 - 3);
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n4; ++j) {
                        if (RPG.d(3) != 1 || map.isBlocked(i, j)) continue;
                        map.addThing(Lib.create(thing.getString("Name")), i, j);
                    }
                }
                map.addEntrance("stairs up");
                break;
            }
            case 5: {
                map.setTheme(RPG.pick(new String[]{"standard", "caves", "labyrinthe", "sewer"}));
                Maze.buildMaze(map, 0, 0, map.width - 1, map.height - 1);
                map.addEntrance("stairs up");
                break;
            }
            case 6: {
                map.setTheme(RPG.pick(new String[]{"standard", "caves", "labyrinthe", "sewer"}));
                Maze.buildMaze(map, 0, 0, map.width - 1, map.height - 1);
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n4; ++j) {
                        if (RPG.d(3) != 1 || map.isBlocked(i, j)) continue;
                        map.addThing(Lib.createType("IsMonster", map.getLevel() - 1), i, j);
                    }
                }
                map.addEntrance("stairs up");
                break;
            }
            case 7: {
                map.setTheme(RPG.pick(new String[]{"standard", "caves", "labyrinthe", "sewer"}));
                Pit.buildPitComplex(map, 0, 0, n3 - 1, n4 - 1);
                for (int i = 1; i <= n2; ++i) {
                    map.addThing(Lib.createType("IsUndead", n2));
                    map.addThing(Lib.createType("IsGravestone", n2));
                }
                map.addEntrance("stairs up");
                break;
            }
            default: {
                map.setTheme(RPG.pick(new String[]{"standard", "caves", "labyrinthe", "sewer"}));
                Pit.buildPitComplex(map, 0, 0, map.width - 1, map.height - 1);
                map.addThing(Lib.createType("IsMonster", n2));
                map.addThing(Lib.createItem(n2));
                map.addEntrance("stairs up");
            }
        }
    }

    public static void buildPitComplex(Map map, int n, int n2, int n3, int n4) {
        map.fillArea(n, n2, n3, n4, map.floor());
        for (int i = n; i <= n3; i += 8) {
            for (int j = n2; j <= n4; j += 8) {
                map.setTile(i, j, map.wall());
            }
        }
        map.fractalize(n, n2, n3, n4, 4);
        map.fillBorder(n, n2, n3, n4, map.wall());
    }
}

