/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.util.ArrayList;
import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.Item;
import mikera.tyrant.Lib;
import mikera.tyrant.RPG;
import mikera.tyrant.Script;
import mikera.tyrant.Skill;
import mikera.tyrant.Spell;
import mikera.tyrant.Text;
import mikera.tyrant.Thing;

public class SpellBook {
    private static final String[] titles = new String[]{"worn tome", "tattered tome", "dull tome", "slim book", "greyish tome", "leather-bound tome", "weighty tome"};

    public static Thing create(int n) {
        return Lib.createType("IsSpellBook", n);
    }

    public static Thing create() {
        return SpellBook.create(Lib.currentLevel());
    }

    public static Thing create(String string, int n) {
        for (int i = 0; i < 30; ++i) {
            Thing thing = Lib.createType("IsSpellBook", n);
            if (!thing.getString("Order").equals(string)) continue;
            return thing;
        }
        return Lib.createType("IsSpellBook", n);
    }

    public static String getOrder(Thing thing) {
        Thing thing2 = Lib.create(thing.getString("BookSpell"));
        return thing2.getString("Order");
    }

    public static void init() {
        Thing thing = Lib.extend("base book", "base item");
        thing.set("Frequency", 50);
        thing.set("IsReadable", 1);
        thing.set("IsBook", 1);
        thing.set("RES:water", 0);
        thing.set("ItemWeight", 1500);
        thing.set("ASCII", "+");
        Lib.add(thing);
        thing = Lib.extend("base spellbook", "base book");
        thing.set("IsSpellBook", 1);
        thing.set("OnRead", new ReadSpellbookScript());
        thing.set("IsMagicItem", 1);
        thing.set("Image", 285);
        thing.set("HPS", 12);
        thing.set("ValueBase", 1000);
        thing.set("ItemWeight", 2000);
        thing.set("Frequency", 60);
        Lib.add(thing);
        SpellBook.initSpellBooks();
        SpellBook.initManuals();
        SpellBook.initRecipeBooks();
    }

    private static void addManual(String string) {
        Thing thing = Lib.extend(string + " manual", "base manual");
        thing.set("UName", "heavy manual");
        thing.set("OnRead", new ReadManualScript());
        thing.set("SkillName", string);
        thing.set("LevelMin", RPG.d(30));
        thing.set("Image", 284);
        thing.set("Frequency", 20);
        Lib.add(thing);
    }

    private static void initManuals() {
        Thing thing = Lib.extend("base manual", "base book");
        thing.set("ValueBase", 4000);
        thing.set("ItemWeight", 3500);
        thing.set("IsManual", 1);
        Lib.add(thing);
        String[] stringArray = Skill.fullList();
        for (int i = 0; i < stringArray.length; ++i) {
            SpellBook.addManual(stringArray[i]);
        }
    }

    private static void initRecipeBooks() {
        Thing thing = Lib.extend("base recipe book", "base book");
        thing.set("ValueBase", 1000);
        thing.set("UName", "strange recipe book");
        thing.set("ItemWeight", 3500);
        thing.set("Image", 285);
        thing.set("Frequency", 30);
        thing.set("IsRecipeBook", 1);
        thing.set("OnRead", new ReadRecipeBookScript());
        Lib.add(thing);
        String[] stringArray = new String[]{"Herb Lore", "Alchemy", "Black Magic"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            for (int j = 1; j <= 16; ++j) {
                thing = Lib.extend(string + " " + Text.roman(j) + " recipe book", "base recipe book");
                thing.set("LevelMin", j * 3);
                thing.set("Order", string);
                Lib.add(thing);
            }
        }
    }

    private static void initSpellBooks() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < titles.length; ++i) {
            arrayList.add(titles[i]);
        }
        ArrayList arrayList2 = Spell.getSpellNames();
        if (arrayList2.size() == 0) {
            throw new Error("SpellBook: Spells not yet generated");
        }
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)arrayList2.get(i);
            String string2 = (String)arrayList.get(RPG.r(arrayList.size()));
            Thing thing = Spell.create(string);
            Thing thing2 = Lib.extend("xxx", "base spellbook");
            thing2.set("Name", "spellbook of " + string);
            thing2.set("Image", SpellBook.spellBookImage(thing));
            thing2.set("NamePlural", "spellbooks of " + string);
            thing2.set("UName", string2);
            thing2.set("BookSpell", string);
            thing2.set("Order", thing.getString("Order"));
            thing2.set("DeathDecoration", string);
            thing2.set("LevelMin", thing.getLevel());
            thing2.multiplyStat("Frequency", (double)thing.getStat("Frequency") / 100.0);
            thing2.set("LevelMax", thing.getLevel() + 20);
            Lib.add(thing2);
        }
    }

    private static int spellBookImage(Thing thing) {
        String string = thing.getString("Order");
        if (string.equals("Holy Magic")) {
            return 287;
        }
        if (string.equals("Black Magic")) {
            return 286;
        }
        if (string.equals("True Magic")) {
            return 285;
        }
        throw new Error("Spell book order not identified [" + string + "]");
    }

    private static class ReadManualScript
    extends Script {
        private static final long serialVersionUID = 3256723983117464881L;

        private ReadManualScript() {
        }

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = event.getThing("Reader");
            String string = thing.getString("SkillName");
            if (!thing.getFlag("IsManual")) {
                System.out.println("Not a manual!");
                return false;
            }
            if (!thing2.isHero()) {
                return false;
            }
            thing2.incStat("APS", -2000 / thing2.getStat("Literacy"));
            if (!Item.isIdentified(thing)) {
                Item.identify(thing);
                thing2.message("Do you want to try to learn from " + thing.getTheName() + "? (y/n)");
                if (Game.getOption("yn") == 'n') {
                    return false;
                }
            }
            if (thing2.getBaseStat("SkillPoints") >= 2) {
                if (!thing.getFlag("IsBlessed") && (thing.getFlag("IsCursed") || RPG.d(4) == 1)) {
                    thing2.message("It doesn't seem that the manual is very well written");
                    thing2.incStat("SkillPoints", -1);
                }
                if (RPG.test(thing2.getStat("IN"), 10, thing2, null)) {
                    if (!RPG.test(thing2.getStat("IN"), 100, thing2, null)) {
                        thing2.incStat("SkillPoints", -1);
                        thing2.message("You find the manual very tough going");
                    }
                    if (thing2.getBaseStat("SkillPoints") >= 1) {
                        Game.message("You teach yourself about " + string);
                        Skill.add(thing2, string, 1);
                        thing2.incStat("SkillPoints", -1);
                    } else {
                        thing2.message("You get yourself confused.... you don't manage to learn anything");
                    }
                } else {
                    thing2.message("You don't manage to make sense of " + thing.getTheName());
                }
            } else {
                thing2.message("This manual seems too hard to master right now");
            }
            return false;
        }
    }

    private static class ReadRecipeBookScript
    extends Script {
        private static final long serialVersionUID = 3616728296604514359L;

        private ReadRecipeBookScript() {
        }

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = event.getThing("Reader");
            if (!thing.getFlag("IsRecipeBook")) {
                System.out.println(thing.name() + " is not a recipe book!");
                return false;
            }
            if (!thing2.isHero()) {
                return false;
            }
            String string = thing.getString("Order");
            if (thing2.getStat(string) > 0) {
                thing2.message("You discover no recipes of particular interest");
            } else {
                thing2.message("You need to learn " + string + " in order to undertand these recipes");
            }
            return false;
        }
    }

    private static class ReadSpellbookScript
    extends Script {
        private static final long serialVersionUID = 6685634600657516648L;

        private ReadSpellbookScript() {
        }

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = event.getThing("Reader");
            if (!thing.getFlag("IsSpellBook")) {
                System.out.println("Not a spell book!");
                return false;
            }
            if (!thing2.isHero()) {
                return false;
            }
            String string = thing.getString("BookSpell");
            if (Spell.canLearn(thing2, string)) {
                Spell.learn(thing2, string);
                Item.identify(thing);
                thing.remove(1);
            } else {
                Game.message("You are unable to understand this spellbook without knowledge of " + Spell.getOrder(string));
            }
            return false;
        }
    }
}

