/*
 * Decompiled with CFR 0.152.
 */
package jchessboard;

import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import jchessboard.JChessBoard;
import jchessboard.VisualBoard;

public class BoardEditor
extends JFrame {
    private JChessBoard jcb = null;
    private VisualBoard visualBoard = null;
    private Container contentPane;

    public static String getVersion() {
        return "$Id: BoardEditor.java,v 1.5 2004/12/24 23:56:43 cdivossen Exp $";
    }

    public void exit() {
        this.jcb.newGame(this.visualBoard.virtualBoard);
        this.dispose();
    }

    public BoardEditor(JChessBoard jChessBoard) {
        super("JChessBoard - Editor");
        this.jcb = jChessBoard;
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("Editor");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Setup");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((BoardEditor)BoardEditor.this).visualBoard.virtualBoard.init();
                BoardEditor.this.visualBoard.redraw();
            }
        });
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Clear");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((BoardEditor)BoardEditor.this).visualBoard.virtualBoard.clear();
                BoardEditor.this.visualBoard.redraw();
            }
        });
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Close & Save");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BoardEditor.this.exit();
            }
        });
        jMenu.add(jMenuItem3);
        this.contentPane = this.getContentPane();
        this.contentPane.setLayout(new GridLayout(1, 1));
        this.visualBoard = new VisualBoard(this.jcb, true);
        this.contentPane.add(this.visualBoard);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BoardEditor.this.exit();
            }
        });
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
    }
}

