/*
 * Decompiled with CFR 0.152.
 */
package jchessboard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Keymap;
import javax.swing.text.Position;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import jchessboard.AI;
import jchessboard.BoardConnector;
import jchessboard.ChessClock;
import jchessboard.ConnectionIndicator;
import jchessboard.ConnectionListener;
import jchessboard.History;
import jchessboard.JChessBoard;
import jchessboard.Move;
import jchessboard.PGN;
import jchessboard.VirtualBoard;
import jchessboard.VisualBoard;

class Chat
extends JPanel {
    private DefaultListModel visibleList;
    private JList chatJList;
    private JViewport chatViewport;
    private JScrollPane scrollPane;
    private JChessBoard jcb;
    private JTextField textfield;
    private JScrollBar scrollBar;
    private JTextPane textPane;
    private Component view;
    private DefaultStyledDocument document;
    private Position endPosition;
    private int replaceOffset = -1;
    private List inputHistory = new Vector();
    private int inputHistoryIndex = 0;

    public static String getVersion() {
        return "$Id: Chat.java,v 1.35 2004/12/26 23:12:13 cdivossen Exp $";
    }

    public void showMessage(String string) {
        this.showMessagePart(string + "\n");
    }

    public void showMessagePart(String string) {
        this.showMessagePart(string, "regular", false);
    }

    public void showMessage(String string, String string2) {
        if (string.length() > 0) {
            string = string + "\n";
        }
        this.showMessagePart(string, string2, false);
    }

    public void showReplaceableMessage(String string) {
        this.showReplaceableMessage(string, "PGNComment");
    }

    public void showReplaceableMessage(String string, String string2) {
        if (string.length() > 0) {
            string = string + "\n";
        }
        this.showMessagePart(string, string2, true);
    }

    public void showMessagePart(String string, String string2, boolean bl) {
        final String string3 = string;
        final String string4 = string2;
        final boolean bl2 = bl;
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    DefaultStyledDocument defaultStyledDocument = Chat.this.document;
                    synchronized (defaultStyledDocument) {
                        if (Chat.this.replaceOffset != -1) {
                            Chat.this.document.remove(Chat.this.replaceOffset, Chat.this.endPosition.getOffset() - Chat.this.replaceOffset - 1);
                        }
                        if (bl2) {
                            Chat.this.replaceOffset = Chat.this.endPosition.getOffset() - 1;
                        } else {
                            Chat.this.replaceOffset = -1;
                        }
                        Chat.this.document.insertString(Chat.this.endPosition.getOffset() - 1, string3, Chat.this.textPane.getStyle(string4));
                    }
                    Chat.this.textPane.setCaretPosition(Chat.this.document.getLength());
                }
                catch (BadLocationException badLocationException) {
                    System.out.println(badLocationException);
                }
                Chat.this.scrollBar.setValue(Integer.MAX_VALUE);
            }
        });
    }

    public void showActionMessagePart(String string, String string2) {
        final Style style = this.textPane.getStyle("action");
        final String string3 = string;
        style.addAttribute("action", string2);
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DefaultStyledDocument defaultStyledDocument = Chat.this.document;
                synchronized (defaultStyledDocument) {
                    try {
                        Chat.this.document.insertString(Chat.this.endPosition.getOffset() - 1, string3, style);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void parseInput(String string) {
        if (string.equals("")) {
            return;
        }
        this.inputHistory.add(new String(string));
        this.inputHistoryIndex = this.inputHistory.size();
        if (string.startsWith("/")) {
            int n = string.indexOf(32);
            String string2 = null;
            string2 = n > 0 ? string.substring(1, n) : string.substring(1, string.length());
            String string3 = null;
            if (n > 0 && string.length() > n + 1) {
                string3 = string.substring(n + 1, string.length());
            }
            if (string2.equals("set")) {
                if (string3 == null) {
                    this.showMessage("Missing argument");
                } else {
                    this.jcb.settings.parseLine(string3);
                }
            } else if (string2.equals("getfen")) {
                String string4 = this.jcb.getCurrentVirtualBoard().getFEN();
                this.showMessage("FEN: " + string4);
            } else if (string2.equals("fen")) {
                if (string3 == null) {
                    this.showMessage("Missing argument");
                    return;
                }
                VirtualBoard virtualBoard = new VirtualBoard();
                boolean bl = virtualBoard.initFromFEN(string3);
                if (bl) {
                    this.showMessage("Initialization from FEN OK.");
                    if (this.jcb.isConnected()) {
                        this.jcb.protocol.sendMessage("init_from_fen", string3);
                    }
                    this.jcb.newGame(virtualBoard);
                } else {
                    this.showMessage("Initialization from FEN failed.");
                }
                this.showMessage("FEN was: " + string3);
            } else if (string2.equals("exit")) {
                this.jcb.exit();
            } else if (string2.equals("name")) {
                if (string3 == null) {
                    this.showMessage("Missing argument");
                    return;
                }
                this.jcb.settings.userName = string3;
                this.jcb.showMessage("Set name to \"" + string3 + "\".");
                this.jcb.updateSTR();
                if (this.jcb.isConnected()) {
                    this.jcb.protocol.sendPlayerName(string3);
                }
            } else if (string2.equals("undo")) {
                this.jcb.undoMove();
            } else if (string2.equals("perf")) {
                if (this.jcb.ai != null) {
                    this.jcb.ai.perfTest();
                }
            } else if (string2.equals("m")) {
                try {
                    VirtualBoard virtualBoard = this.jcb.getCurrentVirtualBoard().clonedBoard();
                    virtualBoard.makeMove(string3);
                    Move move = virtualBoard.getLastMove();
                    this.jcb.makeUsersMove(move);
                }
                catch (VirtualBoard.ImpossibleMoveException impossibleMoveException) {
                    this.showMessage("Impossible move: " + string3);
                }
            } else if (string2.equals("nag")) {
                if (string3 == null) {
                    this.showMessage("Missing argument");
                    return;
                }
                try {
                    int n2 = Integer.parseInt(string3);
                    if (n2 < 0 || n2 >= PGN.NAGStrings.length) {
                        throw new NumberFormatException();
                    }
                    this.jcb.history.addNAG(n2);
                    this.jcb.update();
                }
                catch (NumberFormatException numberFormatException) {
                    this.showMessage("Illegal NAG: " + string3);
                }
            } else if (string2.equals("c")) {
                this.jcb.history.addComment(string3);
                this.jcb.update();
            } else if (string2.equals("lsnags")) {
                this.showMessage("Available Numeric Annotation Glyphs:");
                for (int i = 0; i < PGN.NAGStrings.length; ++i) {
                    this.showMessage(i + ". " + PGN.NAGStrings[i]);
                }
            } else if (string2.equals("getpgn")) {
                this.showMessage(this.jcb.history.getPGNBody());
            } else if (string2.equals("eval")) {
                this.showMessage(AI.evaluate(this.jcb.getCurrentVirtualBoard()) + "");
            } else if (string2.equals("ver")) {
                this.showMessage(AI.getVersion() + "\n" + BoardConnector.getVersion() + "\n" + Chat.getVersion() + "\n" + ChessClock.getVersion() + "\n" + ConnectionListener.getVersion() + "\n" + ConnectionIndicator.getVersion() + "\n" + History.getVersion() + "\n" + JChessBoard.getVersion() + "\n" + Move.getVersion() + "\n" + PGN.getVersion() + "\n" + VirtualBoard.getVersion() + "\n" + VisualBoard.getVersion());
            } else if (string2.equals("help")) {
                this.showMessage("---- Available commands: ----", "help");
                this.showMessage("/getfen       Give Forsyth-Edwards Notation for the current board.", "help");
                this.showMessage("/fen <FEN>    Initialize board from FEN.", "help");
                this.showMessage("/help         Show this.", "help");
                this.showMessage("/m <move>     Make <move>, <move> must be in algebraic notation.", "help");
                this.showMessage("/undo         Undo the last move.", "help");
                this.showMessage("/nag <nag>    Add a Numeric Annotation Glyph to the last move.", "help");
                this.showMessage("/c <comment>        Add <comment> to the last move.", "help");
                this.showMessage("/lsnags       Show the list of available NAGs.", "help");
                this.showMessage("/eval         Evaluate the current position.", "help");
                this.showMessage("/ver          Show version of each module.", "help");
                this.showMessage("/name <name>  Set your name.", "help");
                this.showMessage("/exit         Exit JChessBoard.", "help");
            } else {
                this.showMessage("Unknown command: " + string2);
            }
        } else {
            if (this.jcb.isConnected()) {
                this.jcb.protocol.sendMessage("message", string);
            }
            this.showMessage("You: " + string, "chatOut");
        }
    }

    public Chat(JChessBoard jChessBoard) {
        super(new BorderLayout());
        this.jcb = jChessBoard;
        this.setBorder(new EtchedBorder());
        this.document = new DefaultStyledDocument();
        this.endPosition = this.document.getEndPosition();
        this.textPane = new JTextPane(this.document);
        this.textPane.setEditable(false);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollBar = this.scrollPane.getVerticalScrollBar();
        this.chatViewport = this.scrollPane.getViewport();
        this.chatViewport.add(this.textPane);
        this.view = this.chatViewport.getView();
        this.add("Center", this.scrollPane);
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        Style style2 = this.textPane.addStyle("regular", style);
        StyleConstants.setFontFamily(style, "SansSerif");
        Style style3 = this.textPane.addStyle("italic", style2);
        StyleConstants.setItalic(style3, true);
        style3 = this.textPane.addStyle("annotation", style2);
        StyleConstants.setFontFamily(style3, "Serif");
        StyleConstants.setBold(style3, true);
        style3 = this.textPane.addStyle("action", style2);
        StyleConstants.setUnderline(style3, true);
        StyleConstants.setForeground(style3, new Color(0, 0, 255));
        style3 = this.textPane.addStyle("bold", style2);
        StyleConstants.setBold(style3, true);
        style3 = this.textPane.addStyle("help", style2);
        StyleConstants.setBold(style3, true);
        StyleConstants.setFontFamily(style3, "Monospaced");
        style3 = this.textPane.addStyle("chatIn", style2);
        StyleConstants.setBold(style3, true);
        StyleConstants.setForeground(style3, jChessBoard.settings.chatColorOpponent);
        style3 = this.textPane.addStyle("chatOut", style2);
        StyleConstants.setBold(style3, true);
        StyleConstants.setForeground(style3, jChessBoard.settings.chatColorYou);
        style3 = this.textPane.addStyle("small", style2);
        StyleConstants.setFontSize(style3, 8);
        style3 = this.textPane.addStyle("debug", style2);
        StyleConstants.setFontSize(style3, 8);
        StyleConstants.setForeground(style3, jChessBoard.settings.chatColorDebug);
        style3 = this.textPane.addStyle("large", style2);
        StyleConstants.setFontSize(style3, 16);
        this.textfield = new JTextField();
        this.textfield.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = Chat.this.textfield.getText();
                Chat.this.textfield.setText("");
                Chat.this.parseInput(string);
            }
        });
        Keymap keymap = this.textfield.getKeymap();
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(38, 0), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Chat.this.inputHistoryIndex > 0) {
                    Chat.this.inputHistoryIndex--;
                }
                if (Chat.this.inputHistory.size() > 0) {
                    Chat.this.textfield.setText((String)Chat.this.inputHistory.get(Chat.this.inputHistoryIndex));
                }
            }
        });
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(40, 0), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Chat.this.inputHistoryIndex < Chat.this.inputHistory.size()) {
                    Chat.this.inputHistoryIndex++;
                }
                if (Chat.this.inputHistoryIndex == Chat.this.inputHistory.size()) {
                    Chat.this.textfield.setText("");
                } else {
                    Chat.this.textfield.setText((String)Chat.this.inputHistory.get(Chat.this.inputHistoryIndex));
                }
            }
        });
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(27, 0), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Chat.this.inputHistoryIndex = Chat.this.inputHistory.size();
                Chat.this.textfield.setText("");
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(LineBorder.createBlackLineBorder());
        jPanel.add("Center", this.textfield);
        jPanel.add("East", jChessBoard.connectionIndicator);
        this.add("South", jPanel);
        this.textPane.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                Object object;
                AttributeSet attributeSet = Chat.this.document.getCharacterElement(Chat.this.textPane.viewToModel(mouseEvent.getPoint())).getAttributes();
                if (attributeSet.isDefined("action") && (object = attributeSet.getAttribute("action")) instanceof String) {
                    Chat.this.parseInput((String)object);
                }
            }

            public void mouseMoved(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }
        });
    }
}

