/*
 * Decompiled with CFR 0.152.
 */
package jchessboard;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.text.DecimalFormat;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import jchessboard.JChessBoard;

class ChessClock
extends JPanel {
    private JChessBoard jcb;
    private boolean isEnabled = true;
    private boolean whiteTimeIsRunning = false;
    private boolean blackTimeIsRunning = false;
    private long whiteTime = 600000L;
    private long blackTime = 600000L;
    private JLabel whiteTimeLabel;
    private JLabel blackTimeLabel;
    private boolean isWhiteTurn = true;
    private boolean newPlayerIsWhite = true;
    private long lastSysTime;
    private long newGameTime;
    private ImageIcon aiIcon;
    private ImageIcon humanIcon;
    private ImageIcon netIcon;
    private ImageIcon unknownIcon;
    private DecimalFormat timeFormater = new DecimalFormat("00");
    private ActionListener listener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            ChessClock.this.updateClocks();
        }
    };
    private Timer clockTimer = new Timer(250, this.listener);
    static final Color WHITE = new Color(255, 255, 255);
    static final Color BLACK = new Color(0, 0, 0);
    static final Color GRAY = new Color(128, 128, 128);
    JComboBox whitePlayerSelector;
    JComboBox blackPlayerSelector;
    private ActionListener whitePlayerSelectorListener;
    private ActionListener blackPlayerSelectorListener;
    static /* synthetic */ Class class$jchessboard$JChessBoard;

    public static String getVersion() {
        return "$Id: ChessClock.java,v 1.28 2004/12/26 23:12:14 cdivossen Exp $";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClocks() {
        if (this.jcb.isConnected() && this.jcb.connectionIndicator.isWaiting()) {
            this.lastSysTime = System.currentTimeMillis();
            return;
        }
        long l = System.currentTimeMillis();
        if (this.whiteTimeIsRunning) {
            this.whiteTime -= l - this.lastSysTime;
            if (this.whiteTime <= 0L) {
                this.whiteTime = 0L;
                this.whiteTimeIsRunning = false;
                this.blackTimeIsRunning = false;
                if (this.jcb.whitePlayer.equals("Human")) {
                    JChessBoard jChessBoard = this.jcb;
                    synchronized (jChessBoard) {
                        this.jcb.timeForfeit();
                    }
                }
            }
        } else if (this.blackTimeIsRunning) {
            this.blackTime -= l - this.lastSysTime;
            if (this.blackTime <= 0L) {
                this.blackTime = 0L;
                this.blackTimeIsRunning = false;
                this.whiteTimeIsRunning = false;
                if (this.jcb.blackPlayer == "Human") {
                    JChessBoard jChessBoard = this.jcb;
                    synchronized (jChessBoard) {
                        this.jcb.timeForfeit();
                    }
                }
            }
        }
        this.showTimes();
        this.lastSysTime = System.currentTimeMillis();
    }

    private void showTimes() {
        if (this.isEnabled) {
            this.whiteTimeLabel.setText(this.formatTime(this.whiteTime));
            this.blackTimeLabel.setText(this.formatTime(this.blackTime));
        } else {
            this.whiteTimeLabel.setText("--:--");
            this.blackTimeLabel.setText("--:--");
        }
    }

    public String formatTime(long l) {
        long l2 = l / 1000L;
        if (l2 * 1000L < l) {
            ++l2;
        }
        return this.timeFormater.format(l2 / 60L) + ":" + this.timeFormater.format(l2 % 60L);
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled && !bl) {
            this.stopClock();
        }
        if (!this.isEnabled && bl) {
            this.resetClocks();
        }
        this.isEnabled = bl;
        this.showTimes();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void stopClock() {
        this.blackTimeIsRunning = false;
        this.whiteTimeIsRunning = false;
        this.clockTimer.stop();
        this.updateClocks();
    }

    public boolean isRunning() {
        return this.blackTimeIsRunning || this.whiteTimeIsRunning;
    }

    public void startClock() {
        if (!this.isEnabled) {
            return;
        }
        if (this.jcb.isWhiteTurn()) {
            this.blackTimeIsRunning = false;
            this.whiteTimeIsRunning = true;
        } else {
            this.blackTimeIsRunning = true;
            this.whiteTimeIsRunning = false;
        }
        this.lastSysTime = System.currentTimeMillis();
        this.showTimes();
        this.clockTimer.start();
    }

    public void resetClocks() {
        this.whiteTime = this.jcb.settings.whiteTime;
        this.blackTime = this.jcb.settings.blackTime;
        this.showTimes();
    }

    public void setWhitePlayersTime(long l) {
        this.whiteTime = l;
        this.showTimes();
    }

    public void setBlackPlayersTime(long l) {
        this.blackTime = l;
        this.showTimes();
    }

    public long getWhiteTime() {
        return this.whiteTime;
    }

    public long getBlackTime() {
        return this.blackTime;
    }

    public void updatePlayerSelectors() {
        this.whitePlayerSelector.removeActionListener(this.whitePlayerSelectorListener);
        this.blackPlayerSelector.removeActionListener(this.blackPlayerSelectorListener);
        if (this.jcb.isConnected()) {
            if (this.whitePlayerSelector.getItemCount() < 4) {
                this.whitePlayerSelector.addItem("-----");
                this.whitePlayerSelector.addItem("Peer");
            }
            if (this.blackPlayerSelector.getItemCount() < 4) {
                this.blackPlayerSelector.addItem("-----");
                this.blackPlayerSelector.addItem("Peer");
            }
            this.whitePlayerSelector.setEnabled(false);
            this.blackPlayerSelector.setEnabled(false);
        } else {
            if (this.whitePlayerSelector.getItemCount() > 2) {
                this.whitePlayerSelector.removeItem("Peer");
                this.whitePlayerSelector.removeItem("-----");
            }
            if (this.blackPlayerSelector.getItemCount() > 2) {
                this.blackPlayerSelector.removeItem("-----");
                this.blackPlayerSelector.removeItem("Peer");
            }
            this.whitePlayerSelector.setEnabled(true);
            this.blackPlayerSelector.setEnabled(true);
        }
        this.whitePlayerSelector.setSelectedItem(this.jcb.whitePlayer);
        this.blackPlayerSelector.setSelectedItem(this.jcb.blackPlayer);
        this.whitePlayerSelector.addActionListener(this.whitePlayerSelectorListener);
        this.blackPlayerSelector.addActionListener(this.blackPlayerSelectorListener);
    }

    public ChessClock(JChessBoard jChessBoard) {
        this.jcb = jChessBoard;
        URL uRL = (class$jchessboard$JChessBoard == null ? (class$jchessboard$JChessBoard = ChessClock.class$("jchessboard.JChessBoard")) : class$jchessboard$JChessBoard).getResource("/images/ai.gif");
        this.aiIcon = uRL != null ? new ImageIcon(uRL) : new ImageIcon("null");
        uRL = (class$jchessboard$JChessBoard == null ? (class$jchessboard$JChessBoard = ChessClock.class$("jchessboard.JChessBoard")) : class$jchessboard$JChessBoard).getResource("/images/human.gif");
        this.humanIcon = uRL != null ? new ImageIcon(uRL) : new ImageIcon("null");
        uRL = (class$jchessboard$JChessBoard == null ? (class$jchessboard$JChessBoard = ChessClock.class$("jchessboard.JChessBoard")) : class$jchessboard$JChessBoard).getResource("/images/net.gif");
        this.netIcon = uRL != null ? new ImageIcon(uRL) : new ImageIcon("null");
        uRL = (class$jchessboard$JChessBoard == null ? (class$jchessboard$JChessBoard = ChessClock.class$("jchessboard.JChessBoard")) : class$jchessboard$JChessBoard).getResource("/images/unknown.gif");
        this.unknownIcon = uRL != null ? new ImageIcon(uRL) : new ImageIcon("null");
        this.whiteTimeLabel = new JLabel();
        this.blackTimeLabel = new JLabel();
        Font font = new Font("SansSerif", 1, 18);
        this.whiteTimeLabel.setFont(font);
        EtchedBorder etchedBorder = new EtchedBorder();
        this.setBorder(etchedBorder);
        BevelBorder bevelBorder = new BevelBorder(1, new Color(220, 220, 220), new Color(100, 100, 100));
        this.blackTimeLabel.setFont(font);
        this.whiteTimeLabel.setForeground(GRAY);
        this.whiteTimeLabel.setBackground(WHITE);
        this.whiteTimeLabel.setOpaque(true);
        this.whiteTimeLabel.setHorizontalAlignment(0);
        this.whiteTimeLabel.setBorder(bevelBorder);
        this.blackTimeLabel.setForeground(GRAY);
        this.blackTimeLabel.setBackground(BLACK);
        this.blackTimeLabel.setHorizontalAlignment(0);
        this.blackTimeLabel.setOpaque(true);
        this.blackTimeLabel.setBorder(bevelBorder);
        this.resetClocks();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        Dimension dimension = new Dimension(75, 30);
        this.whiteTimeLabel.setPreferredSize(dimension);
        this.whiteTimeLabel.setMinimumSize(dimension);
        gridBagLayout.setConstraints(this.whiteTimeLabel, gridBagConstraints);
        this.add(this.whiteTimeLabel);
        gridBagConstraints.gridx = 1;
        this.whitePlayerSelector = new JComboBox();
        this.whitePlayerSelector.addItem("Human");
        this.whitePlayerSelector.addItem("Computer");
        this.whitePlayerSelector.setFont(new Font("SanSerif", 0, 10));
        gridBagLayout.setConstraints(this.whitePlayerSelector, gridBagConstraints);
        this.add(this.whitePlayerSelector);
        this.whitePlayerSelectorListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                ((ChessClock)ChessClock.this).jcb.whitePlayer = string = (String)ChessClock.this.whitePlayerSelector.getSelectedItem();
                ChessClock.this.jcb.updateSTR();
                ChessClock.this.jcb.triggerAI();
            }
        };
        this.whitePlayerSelector.addActionListener(this.whitePlayerSelectorListener);
        gridBagConstraints.gridx = 2;
        this.blackTimeLabel.setPreferredSize(dimension);
        this.blackTimeLabel.setMinimumSize(dimension);
        gridBagLayout.setConstraints(this.blackTimeLabel, gridBagConstraints);
        this.add(this.blackTimeLabel);
        gridBagConstraints.gridx = 3;
        this.blackPlayerSelector = new JComboBox();
        this.blackPlayerSelector.addItem("Human");
        this.blackPlayerSelector.addItem("Computer");
        this.blackPlayerSelector.setFont(new Font("SanSerif", 0, 10));
        gridBagLayout.setConstraints(this.blackPlayerSelector, gridBagConstraints);
        this.add(this.blackPlayerSelector);
        this.blackPlayerSelectorListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                ((ChessClock)ChessClock.this).jcb.blackPlayer = string = (String)ChessClock.this.blackPlayerSelector.getSelectedItem();
                ChessClock.this.jcb.updateSTR();
                ChessClock.this.jcb.triggerAI();
            }
        };
        this.blackPlayerSelector.addActionListener(this.blackPlayerSelectorListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

