/*
 * Decompiled with CFR 0.152.
 */
package jchessboard;

import javax.swing.tree.DefaultMutableTreeNode;
import jchessboard.PGN;
import jchessboard.VirtualBoard;

class GameNode
extends DefaultMutableTreeNode {
    private String comment = "";
    private String output = null;
    private int[] nags = new int[0];
    private String move = "";
    private VirtualBoard board;

    public boolean isWhiteMove() {
        return !this.board.isWhiteTurn();
    }

    public int getFullMoveNumber() {
        return this.board.getFullMoveNumber();
    }

    public String getMove() {
        return this.move;
    }

    public VirtualBoard getBoard() {
        return this.board;
    }

    public void setBoard(VirtualBoard virtualBoard) {
        this.board = virtualBoard;
    }

    public Object getUserObject() {
        return this.toString();
    }

    public String toString() {
        this.output = this.makeOutput();
        return this.output;
    }

    private String makeShortOutput() {
        if (this.getParent() == null) {
            return "Start";
        }
        if (this.isLeaf()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.board.getFullMoveNumber());
            if (this.board.isWhiteTurn()) {
                stringBuffer.append("... ");
            } else {
                stringBuffer.append(". ");
            }
            stringBuffer.append(this.move);
            return new String(stringBuffer.toString());
        }
        return "Variation";
    }

    private String makeOutput() {
        StringBuffer stringBuffer = new StringBuffer(this.makeShortOutput());
        if (this.comment.length() > 0 || this.nags.length > 0) {
            stringBuffer.append("  [");
            for (int i = 0; i < this.nags.length; ++i) {
                if (this.nags[i] <= 0 || this.nags[i] >= PGN.NAGStrings.length) continue;
                stringBuffer.append(PGN.NAGStrings[this.nags[i]]);
                stringBuffer.append(" ");
            }
            if (this.comment.length() > 0) {
                stringBuffer.append("\"");
                if (this.comment.length() + stringBuffer.length() < 50) {
                    stringBuffer.append(this.comment);
                } else if (stringBuffer.length() < 46) {
                    stringBuffer.append(this.comment.substring(0, 46 - stringBuffer.length()));
                    stringBuffer.append("...");
                }
                stringBuffer.append("\"");
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public void setComment(String string) {
        this.comment = string;
        this.output = null;
    }

    public void addComment(String string) {
        this.comment = this.comment.equals("") ? string : this.comment + " " + string;
        this.output = null;
    }

    public boolean hasComment() {
        return this.comment.length() > 0 || this.nags.length > 0;
    }

    public String getComment() {
        return new String(this.comment);
    }

    public String getAnnotation() {
        if (this.comment.length() == 0 && this.nags.length == 0) {
            return "";
        }
        String string = new String();
        string = "Annotation for move " + this.board.getFullMoveNumber() + ". " + this.move.toString() + "\n";
        if (this.nags.length > 0) {
            for (int i = 0; i < this.nags.length; ++i) {
                if (this.nags[i] <= 0 || this.nags[i] >= PGN.NAGStrings.length) continue;
                string = string + "NAG $" + this.nags[i] + ": " + PGN.NAGStrings[this.nags[i]] + "\n";
            }
        }
        if (this.comment.length() > 0) {
            string = string + "\"" + this.comment + "\"";
        }
        return string;
    }

    public void addNAG(int n) {
        int[] nArray = new int[this.nags.length + 1];
        for (int i = 0; i < this.nags.length; ++i) {
            nArray[i] = this.nags[i];
        }
        nArray[this.nags.length] = n;
        this.nags = nArray;
        this.output = null;
    }

    public int[] getNags() {
        return this.nags;
    }

    public void setNags(int[] nArray) {
        this.nags = nArray;
        this.output = null;
    }

    public boolean whiteMoveExpected() {
        return this.board.isWhiteTurn();
    }

    public String getPGN() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (this.comment.length() > 0) {
            stringBuffer.append("{");
            stringBuffer.append(this.comment);
            stringBuffer.append("} ");
        }
        GameNode gameNode = this;
        for (int i = 0; i < this.getChildCount(); ++i) {
            gameNode = (GameNode)this.getChildAt(i);
            if (gameNode.isLeaf()) {
                if (gameNode.isWhiteMove()) {
                    stringBuffer.append(gameNode.getFullMoveNumber());
                    stringBuffer.append(". ");
                    stringBuffer.append(gameNode.getMove());
                    bl = true;
                } else if (bl) {
                    stringBuffer.append(gameNode.getMove());
                } else {
                    bl = true;
                    stringBuffer.append(gameNode.getFullMoveNumber());
                    stringBuffer.append("... ");
                    stringBuffer.append(gameNode.getMove());
                }
                stringBuffer.append(" ");
                if (!gameNode.hasComment()) continue;
                for (int j = 0; j < gameNode.getNags().length; ++j) {
                    stringBuffer.append("$");
                    stringBuffer.append(Integer.toString(gameNode.getNags()[j]));
                    stringBuffer.append(" ");
                }
                if (gameNode.comment.length() <= 0) continue;
                stringBuffer.append("{");
                stringBuffer.append(gameNode.comment);
                stringBuffer.append("} ");
                continue;
            }
            bl = false;
            stringBuffer.append("(");
            stringBuffer.append(gameNode.getPGN());
            stringBuffer.append(") ");
        }
        return stringBuffer.toString();
    }

    public void reset() {
        this.removeAllChildren();
        this.board.init();
        this.output = null;
        this.nags = new int[0];
        this.move = "";
        this.comment = "";
    }

    public GameNode(String string, VirtualBoard virtualBoard) {
        this.move = string;
        this.board = virtualBoard;
    }
}

