/*
 * Decompiled with CFR 0.152.
 */
package jchessboard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import jchessboard.AI;
import jchessboard.BoardConnector;
import jchessboard.BoardEditor;
import jchessboard.Chat;
import jchessboard.ChessClock;
import jchessboard.ConnectionIndicator;
import jchessboard.ConnectionListener;
import jchessboard.GameTable;
import jchessboard.History;
import jchessboard.InfoPanel;
import jchessboard.Move;
import jchessboard.Notation;
import jchessboard.PGN;
import jchessboard.Protocol;
import jchessboard.Settings;
import jchessboard.VirtualBoard;
import jchessboard.VisualBoard;

public class JChessBoard
extends JFrame {
    static final String TITLE = "JChessBoard v1.5";
    static final String COPYRIGHT_MESSAGE = "JChessBoard -- a chess game\nCopyright (C) 2000 Claus Divossen <claus.divossen@gmx.de>\n\nThis program is free software; you can redistribute it and/or modify\nit under the terms of the GNU General Public License as published by\nthe Free Software Foundation; either version 2 of the License, or\n(at your option) any later version.\n\nThis program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\nGNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License\nalong with this program; if not, write to the Free Software\nFoundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n";
    static final int MIN_WIDTH = 350;
    static final int MIN_HEIGHT = 471;
    static final String HUMAN = "Human";
    static final String COMPUTER = "Computer";
    static final String PEER = "Peer";
    static final String UNKNOWN = "-----";
    VisualBoard visualBoard;
    ConnectionIndicator connectionIndicator;
    BoardConnector boardConnector;
    AI ai;
    ChessClock chessClock;
    Chat chat;
    String whitePlayer = "Human";
    String blackPlayer = "Human";
    History history;
    static List windowList = new Vector();
    private JMenuItem menuItemNewGame;
    private JMenuItem menuItemLoadFile;
    private JMenuItem menuItemSave;
    private JMenuItem menuItemSaveAs;
    private JMenuItem menuItemUploadGame;
    private JMenuItem menuItemOfferDraw;
    private JMenuItem menuItemResign;
    private JMenuItem menuItemSwitchSides;
    private JMenuItem menuItemConnect;
    private JMenuItem menuItemCloseConnection;
    private JMenuItem about;
    private JMenuItem help;
    private JCheckBoxMenuItem clockCheckbox;
    private JCheckBoxMenuItem enableBeep;
    private JCheckBoxMenuItem reverseBoard;
    private JCheckBoxMenuItem showPossibleMoves;
    private JMenuItem undoMove;
    private static ConnectionListener connectionListener;
    private String otherHostname = "";
    private static String fileChooserDir;
    private String fileName = "";
    private boolean fileIsChanged = false;
    private static final String settingsFileName = "JChessBoard.conf";
    Settings settings;
    private JPanel buttonPanel;
    private JButton buttonPrevious;
    private JButton buttonNext;
    private JButton buttonStart;
    private JButton buttonEnd;
    private boolean gameIsFinished = false;
    JSlider whiteSlider;
    JSlider blackSlider;
    long newWhiteTime;
    long newBlackTime;
    JLabel whiteTimeoutLabel;
    JLabel blackTimeoutLabel;
    boolean coupleSliders;
    JCheckBox coupleSlidersCheckBox;
    Protocol protocol = new Protocol(this);
    GameTable gameTable = null;
    int currentGameIndex = 0;
    private InfoPanel infoPanel;
    private JTabbedPane tabbedPane;
    private Notation notation;
    static /* synthetic */ Class class$jchessboard$JChessBoard;

    public static String getVersion() {
        return "$Id: JChessBoard.java,v 1.79 2004/12/26 23:12:13 cdivossen Exp $";
    }

    public BoardConnector getBoardConnector() {
        return this.boardConnector;
    }

    public void setBoardConnector(BoardConnector boardConnector) {
        this.boardConnector = boardConnector;
    }

    public boolean isConnected() {
        return this.protocol.isConnected() && this.boardConnector != null;
    }

    public void setEnableClock(boolean bl) {
        this.clockCheckbox.setSelected(bl);
        this.chessClock.setEnabled(bl);
        this.settings.enableClock = bl;
    }

    public boolean getEnableClock() {
        return this.clockCheckbox.isSelected();
    }

    public void connectionClosed() {
        this.protocol.connectionClosed();
        this.chessClock.stopClock();
        this.connectionIndicator.setNoConnection();
        this.showMessage("Connection closed.");
        this.gameTable.setEnabled(true);
        this.setEnableClock(false);
        this.gameTable.setNetworkGameIndex(-1);
        if (this.fileName != null && this.fileName.length() > 0) {
            this.setTitle("JChessBoard v1.5 - " + this.fileName);
        } else {
            this.setTitle(TITLE);
        }
        this.beep();
        this.whitePlayer = HUMAN;
        this.blackPlayer = HUMAN;
        this.boardConnector = null;
        this.prepareMove();
    }

    public void connectionEstablished() {
        this.protocol.connectionEstablished();
        this.connectionIndicator.setReady();
        this.setEnableClock(true);
        this.settings.whiteTime = 600000L;
        this.settings.blackTime = 600000L;
        this.newGame();
        this.gameTable.setNetworkGameIndex(this.gameTable.getCurrentGameIndex());
        this.protocol.sendPlayerName(this.settings.userName);
        if (this.fileName != null && this.fileName.length() > 0) {
            this.setTitle("JChessBoard v1.5 - Connected with \"" + this.otherHostname + "\" - " + this.fileName);
        } else {
            this.setTitle("JChessBoard v1.5 - Connected with \"" + this.otherHostname + "\"");
        }
        this.beep();
        this.showMessage("Connected.");
        this.showMessage("Your are now playing with \"" + this.otherHostname + "\".");
        this.showMessage("Either player can make a move. The first move decides who plays which side.");
        this.showMessage("You can set your chat name with /name <your name>");
        this.prepareMove();
    }

    public void updateNavigationButtons() {
        if (this.history.getPreviousGameNode() == this.history.getCurrentGameNode()) {
            this.buttonStart.setEnabled(false);
            this.buttonPrevious.setEnabled(false);
            boolean bl = false;
        } else {
            this.buttonStart.setEnabled(true);
            this.buttonPrevious.setEnabled(true);
            boolean bl = true;
        }
        if (this.history.getNextGameNode() == this.history.getCurrentGameNode()) {
            this.buttonNext.setEnabled(false);
            this.buttonEnd.setEnabled(false);
        } else {
            this.buttonNext.setEnabled(true);
            this.buttonEnd.setEnabled(true);
        }
    }

    public VirtualBoard getCurrentVirtualBoard() {
        return this.history.getCurrentBoard();
    }

    public boolean isWhiteTurn() {
        return this.history.getCurrentBoard().isWhiteTurn();
    }

    public void makePeersMove(Move move) {
        this.chessClock.stopClock();
        this.beep();
        this.gotoGame(this.gameTable.getNetworkGameIndex());
        this.history.gotoLast();
        if (this.whitePlayer.equals(UNKNOWN) || this.blackPlayer == UNKNOWN) {
            if (this.isWhiteTurn()) {
                this.whitePlayer = PEER;
                this.blackPlayer = HUMAN;
                this.visualBoard.setReverseBoard(true);
                this.reverseBoard.setSelected(true);
            } else {
                this.whitePlayer = HUMAN;
                this.blackPlayer = PEER;
            }
        }
        this.updateSTR();
        VirtualBoard virtualBoard = this.getCurrentVirtualBoard().clonedBoard();
        String string = virtualBoard.algebraic(move);
        if (this.isConnected()) {
            this.showMessage("Opponents move: " + string);
        }
        try {
            virtualBoard.makeMove(move);
            this.history.addMove(string, virtualBoard);
            this.visualBoard.showMove(move, 500);
            this.chessClock.startClock();
            this.checkFinish();
        }
        catch (VirtualBoard.ImpossibleMoveException impossibleMoveException) {
            this.showMessage("Error parsing opponents move: " + move);
            this.protocol.sendError("Error parsing move: " + move);
        }
        this.prepareMove();
    }

    public void makeBatchMove(Move move) {
        VirtualBoard virtualBoard = this.getCurrentVirtualBoard().clonedBoard();
        String string = virtualBoard.algebraic(move);
        try {
            virtualBoard.makeMove(move);
        }
        catch (VirtualBoard.ImpossibleMoveException impossibleMoveException) {
            this.showMessage("Error parsing batch move: " + move);
        }
        this.history.addMove(string, virtualBoard);
    }

    public void makeAIsMove(Move move) {
        this.chessClock.stopClock();
        VirtualBoard virtualBoard = this.getCurrentVirtualBoard().clonedBoard();
        String string = virtualBoard.algebraic(move);
        this.showMessage("AI's move: " + string);
        try {
            virtualBoard.makeMove(move);
            this.history.addMove(string, virtualBoard);
            this.visualBoard.showMove(move, 500);
            this.chessClock.startClock();
            this.triggerAI();
            this.checkFinish();
        }
        catch (VirtualBoard.ImpossibleMoveException impossibleMoveException) {
            // empty catch block
        }
    }

    public void makeUsersMove(Move move) {
        this.chessClock.stopClock();
        VirtualBoard virtualBoard = this.getCurrentVirtualBoard().clonedBoard();
        String string = virtualBoard.algebraic(move);
        if (this.isConnected()) {
            this.showMessage("Your move: " + string);
        }
        try {
            virtualBoard.makeMove(move);
        }
        catch (VirtualBoard.ImpossibleMoveException impossibleMoveException) {
            // empty catch block
        }
        this.history.addMove(string, virtualBoard);
        if (this.isConnected() && this.gameTable.getCurrentGameIndex() == this.gameTable.getNetworkGameIndex()) {
            this.protocol.sendMove(move);
            if (this.whitePlayer.equals(UNKNOWN) || this.blackPlayer == UNKNOWN) {
                if (this.isWhiteTurn()) {
                    this.whitePlayer = PEER;
                    this.blackPlayer = HUMAN;
                    this.visualBoard.setReverseBoard(true);
                    this.reverseBoard.setSelected(true);
                } else {
                    this.whitePlayer = HUMAN;
                    this.blackPlayer = PEER;
                }
            }
            this.updateSTR();
            if (this.getEnableClock()) {
                if (virtualBoard.isWhiteTurn()) {
                    this.protocol.sendPlayersTime(this.chessClock.getBlackTime());
                } else {
                    this.protocol.sendPlayersTime(this.chessClock.getWhiteTime());
                }
            }
        }
        this.chessClock.startClock();
        this.triggerAI();
        this.checkFinish();
    }

    public void triggerAI() {
        if (this.whitePlayer != COMPUTER && this.blackPlayer != COMPUTER) {
            return;
        }
        if ((this.whitePlayer == COMPUTER || this.blackPlayer == COMPUTER) && this.ai == null) {
            this.ai = new AI(this);
        }
        if (this.ai != null && this.whitePlayer != COMPUTER && this.blackPlayer != COMPUTER) {
            this.ai.shutdown();
            this.ai = null;
            return;
        }
        if (this.isWhiteTurn()) {
            if (this.whitePlayer == COMPUTER) {
                long l;
                if (this.clockCheckbox.isSelected()) {
                    l = this.history.getFullMoveNumber() < 40 ? this.chessClock.getWhiteTime() / (long)(60 - this.history.getFullMoveNumber()) : this.chessClock.getWhiteTime() / 20L;
                    if (l < 500L) {
                        l = 500L;
                    }
                } else {
                    l = 5000L;
                }
                this.ai.prepareMove(l);
            }
        } else if (this.blackPlayer == COMPUTER) {
            long l;
            if (this.clockCheckbox.isSelected()) {
                l = this.history.getFullMoveNumber() < 40 ? this.chessClock.getBlackTime() / (long)(60 - this.history.getFullMoveNumber()) : this.chessClock.getBlackTime() / 20L;
                if (l < 500L) {
                    l = 500L;
                }
            } else {
                l = 5000L;
            }
            this.ai.prepareMove(l);
        }
    }

    public void prepareMove() {
        this.visualBoard.setLocked(false);
        if (this.isConnected() && this.history.getNextGameNode() != this.history.getCurrentGameNode()) {
            this.visualBoard.setLocked(true);
        }
        if (this.isConnected() && this.gameTable.getCurrentGameIndex() != this.gameTable.getNetworkGameIndex()) {
            this.visualBoard.setLocked(true);
        }
        if (this.isWhiteTurn() && (this.whitePlayer == PEER || this.whitePlayer == COMPUTER)) {
            this.visualBoard.setLocked(true);
        }
        if (!(this.isWhiteTurn() || this.blackPlayer != PEER && this.blackPlayer != COMPUTER)) {
            this.visualBoard.setLocked(true);
        }
        this.updateMenu();
        this.chessClock.updatePlayerSelectors();
    }

    public void switchSides() {
        String string = this.whitePlayer;
        this.whitePlayer = this.blackPlayer;
        this.blackPlayer = string;
        this.reverseBoard.setSelected(!this.reverseBoard.isSelected());
        this.visualBoard.setReverseBoard(this.reverseBoard.isSelected());
        this.updateSTR();
        this.showMessage("Sides switched.");
        this.prepareMove();
    }

    public void updateSTR() {
        PGN.STR sTR = this.gameTable.getSTR(this.gameTable.getCurrentGameIndex());
        sTR.setTag("White", "?");
        sTR.setTag("Black", "?");
        if (this.whitePlayer.equals(PEER)) {
            sTR.setTag("White", this.protocol.getOtherPlayersName());
        }
        if (this.whitePlayer.equals(HUMAN)) {
            sTR.setTag("White", this.settings.userName);
        }
        if (this.whitePlayer.equals(COMPUTER)) {
            sTR.setTag("White", TITLE);
        }
        if (this.blackPlayer.equals(PEER)) {
            sTR.setTag("Black", this.protocol.getOtherPlayersName());
        }
        if (this.blackPlayer.equals(HUMAN)) {
            sTR.setTag("Black", this.settings.userName);
        }
        if (this.blackPlayer.equals(COMPUTER)) {
            sTR.setTag("Black", TITLE);
        }
        this.infoPanel.repaint();
        this.gameTable.repaint();
    }

    public void checkFinish() {
        VirtualBoard virtualBoard = this.history.getCurrentBoard();
        if (virtualBoard.gameIsFinished()) {
            if (virtualBoard.onlyKingsLeft()) {
                this.showMessage("Draw!");
            } else if (virtualBoard.isWhiteTurn()) {
                if (virtualBoard.isAttackedByBlack(virtualBoard.getWhiteKingPos())) {
                    Object[] objectArray = new Object[]{"Accept", "Reject"};
                    this.showMessage("Black wins!");
                    JOptionPane.showMessageDialog(null, "Black wins!");
                } else {
                    this.showMessage("Draw (stalemate)!");
                    JOptionPane.showMessageDialog(null, "Draw!");
                }
            } else if (virtualBoard.isAttackedByWhite(virtualBoard.getBlackKingPos())) {
                this.showMessage("White wins!");
                JOptionPane.showMessageDialog(null, "White wins!");
            } else {
                this.showMessage("Draw (stalemate)!");
                JOptionPane.showMessageDialog(null, "Draw!");
            }
            this.chessClock.stopClock();
        } else if (this.clockCheckbox.isSelected() && (this.chessClock.getWhiteTime() <= 0L || this.chessClock.getBlackTime() <= 0L)) {
            this.chessClock.stopClock();
            if (this.chessClock.getWhiteTime() <= 0L) {
                this.showMessage("Black wins (time forfeit)!");
                JOptionPane.showMessageDialog(null, "Black wins!");
            } else {
                this.showMessage("White wins (time forfeit)!");
                JOptionPane.showMessageDialog(null, "White wins!");
            }
            this.showMessage("White: " + this.chessClock.formatTime(this.chessClock.getWhiteTime()) + ", Black: " + this.chessClock.formatTime(this.chessClock.getBlackTime()));
            this.setEnableClock(false);
            this.showMessage("The clocks have been disabled, you can continue playing, if you want to.");
        } else {
            this.prepareMove();
        }
    }

    public void newGame() {
        PGN.STR sTR = new PGN.STR();
        this.gotoGame(this.gameTable.addGame("", sTR));
        this.visualBoard.setReverseBoard(false);
        if (this.isConnected()) {
            this.whitePlayer = UNKNOWN;
            this.blackPlayer = UNKNOWN;
            this.gameTable.setNetworkGameIndex(this.gameTable.getCurrentGameIndex());
        } else {
            this.whitePlayer = HUMAN;
            this.blackPlayer = HUMAN;
        }
        Calendar calendar = Calendar.getInstance();
        sTR.setTag("Date", calendar.get(1) + "." + (calendar.get(2) + 1) + "." + calendar.get(5));
        this.chessClock.updatePlayerSelectors();
        this.updateSTR();
        if (this.ai != null) {
            this.ai.newGame();
        }
        this.chessClock.stopClock();
        this.chessClock.resetClocks();
        this.prepareMove();
        this.gameIsFinished = false;
        this.fileIsChanged = true;
    }

    public void newGame(VirtualBoard virtualBoard) {
        this.newGame();
        this.history.setBoard(virtualBoard.clonedBoard());
        PGN.STR sTR = this.gameTable.getSTR(this.gameTable.getCurrentGameIndex());
        sTR.setTag("SetUp", "1");
        sTR.setTag("FEN", virtualBoard.getFEN());
        this.update();
    }

    public void exit() {
        if (this.isConnected()) {
            int n = JOptionPane.showConfirmDialog(null, "Are you sure?", "Close connection?", 0);
            if (n == 0) {
                this.boardConnector.closeConnection();
                this.connectionClosed();
            } else {
                return;
            }
        }
        if (this.isFileChanged()) {
            this.askForSaving();
        }
        if (this.ai != null) {
            this.ai.shutdown();
        }
        try {
            this.dispose();
            this.finalize();
        }
        catch (Throwable throwable) {
            System.out.println(throwable);
        }
        System.gc();
        windowList.remove(this);
        if (windowList.size() == 0) {
            System.exit(0);
        }
    }

    public void updateMenu() {
        this.reverseBoard.setSelected(this.visualBoard.reverseBoard());
        if (this.isConnected()) {
            this.menuItemOfferDraw.setEnabled(true);
            this.menuItemResign.setEnabled(true);
            this.menuItemSwitchSides.setEnabled(true);
            this.menuItemUploadGame.setEnabled(true);
            this.menuItemCloseConnection.setEnabled(true);
            this.menuItemConnect.setEnabled(false);
        } else {
            this.menuItemUploadGame.setEnabled(false);
            this.menuItemOfferDraw.setEnabled(false);
            this.menuItemResign.setEnabled(false);
            this.menuItemSwitchSides.setEnabled(false);
            this.menuItemCloseConnection.setEnabled(false);
            this.menuItemConnect.setEnabled(true);
        }
    }

    public void undoMove() {
        this.history.removeLastMove();
        this.showMessage("Last move reversed.");
        if ((!this.isWhiteTurn() && this.blackPlayer == COMPUTER || this.isWhiteTurn() && this.whitePlayer == COMPUTER) && this.history.getFullMoveNumber() > 0) {
            this.history.removeLastMove();
        }
        this.gameIsFinished = false;
        this.prepareMove();
    }

    public void beep() {
        if (this.enableBeep.isSelected()) {
            this.getToolkit().beep();
        }
    }

    public void showMessage(String string) {
        this.chat.showMessage(string);
    }

    public void showMessage(String string, String string2) {
        this.chat.showMessage(string, string2);
    }

    public void showReplaceableMessage(String string) {
        this.chat.showReplaceableMessage(string);
    }

    public void showReplaceableMessage(String string, String string2) {
        this.chat.showReplaceableMessage(string, string2);
    }

    public void timeForfeit() {
        if (this.isConnected() && this.whitePlayer == HUMAN) {
            this.protocol.sendPlayersTime(this.chessClock.getWhiteTime());
        }
        if (this.isConnected() && this.blackPlayer == HUMAN) {
            this.protocol.sendPlayersTime(this.chessClock.getBlackTime());
        }
        this.checkFinish();
    }

    public void showTimeoutSelector() {
        Object[] objectArray = new Object[6];
        objectArray[0] = "Select the time each player has to make his moves:";
        this.newWhiteTime = this.settings.whiteTime;
        this.newBlackTime = this.settings.blackTime;
        this.coupleSlidersCheckBox = new JCheckBox("Couple sliders");
        this.coupleSlidersCheckBox.setSelected(this.settings.whiteTime == this.settings.blackTime);
        this.whiteTimeoutLabel = new JLabel("White: " + this.newWhiteTime / 60000L + " min.");
        this.whiteSlider = new JSlider(1, 60, (int)(this.newWhiteTime / 60000L));
        this.whiteSlider.setPreferredSize(new Dimension(300, 40));
        this.whiteSlider.setPaintTicks(true);
        this.whiteSlider.setMajorTickSpacing(10);
        this.whiteSlider.setMinorTickSpacing(5);
        this.whiteSlider.setPaintLabels(false);
        this.whiteSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JChessBoard.this.newWhiteTime = (long)JChessBoard.this.whiteSlider.getValue() * 60000L;
                JChessBoard.this.whiteTimeoutLabel.setText("White: " + JChessBoard.this.newWhiteTime / 60000L + " min.");
                if (JChessBoard.this.coupleSlidersCheckBox.isSelected()) {
                    JChessBoard.this.newBlackTime = JChessBoard.this.newWhiteTime;
                    JChessBoard.this.blackSlider.setValue((int)JChessBoard.this.newBlackTime / 60000);
                    JChessBoard.this.blackTimeoutLabel.setText("Black: " + JChessBoard.this.newBlackTime / 60000L + " min.");
                }
            }
        });
        this.blackTimeoutLabel = new JLabel("Black: " + this.newBlackTime / 60000L + " min.");
        this.blackSlider = new JSlider(1, 60, (int)(this.newBlackTime / 60000L));
        this.blackSlider.setPreferredSize(new Dimension(300, 40));
        this.blackSlider.setPaintTicks(true);
        this.blackSlider.setMajorTickSpacing(10);
        this.blackSlider.setMinorTickSpacing(5);
        this.blackSlider.setPaintLabels(false);
        this.blackSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JChessBoard.this.newBlackTime = (long)JChessBoard.this.blackSlider.getValue() * 60000L;
                JChessBoard.this.blackTimeoutLabel.setText("Black: " + JChessBoard.this.newBlackTime / 60000L + " min.");
                if (JChessBoard.this.coupleSlidersCheckBox.isSelected()) {
                    JChessBoard.this.newWhiteTime = JChessBoard.this.newBlackTime;
                    JChessBoard.this.whiteSlider.setValue((int)JChessBoard.this.newWhiteTime / 60000);
                    JChessBoard.this.whiteTimeoutLabel.setText("White: " + JChessBoard.this.newWhiteTime / 60000L + " min.");
                }
            }
        });
        objectArray[1] = this.whiteSlider;
        objectArray[2] = this.whiteTimeoutLabel;
        objectArray[3] = this.blackSlider;
        objectArray[4] = this.blackTimeoutLabel;
        objectArray[5] = this.coupleSlidersCheckBox;
        Object[] objectArray2 = new Object[]{"OK", "Cancel"};
        int n = JOptionPane.showOptionDialog(null, objectArray, "Set game time", 0, 3, null, objectArray2, objectArray2[0]);
        if (n == 0) {
            if (this.isConnected()) {
                this.showMessage("Requesting clock change...");
                this.protocol.requestClockChange(this.newWhiteTime, this.newBlackTime);
            } else {
                this.settings.whiteTime = this.newWhiteTime;
                this.settings.blackTime = this.newBlackTime;
                this.chessClock.resetClocks();
                this.prepareMove();
            }
        }
    }

    public void setClocks(long l, long l2) {
        this.settings.whiteTime = l;
        this.settings.blackTime = l2;
        this.chessClock.resetClocks();
        this.showMessage("Game time was changed.");
        this.prepareMove();
    }

    public void gotoGame(int n) {
        if (this.currentGameIndex != -1 && this.history.isChanged()) {
            this.gameTable.setPGN(this.currentGameIndex, this.history.getPGNBody());
            this.fileIsChanged = true;
        }
        if (n >= this.gameTable.getGameCount()) {
            n = this.gameTable.getGameCount() - 1;
        }
        int n2 = this.currentGameIndex;
        this.currentGameIndex = n;
        this.gameTable.setSelectedIndex(this.currentGameIndex);
        this.gameTable.setCurrentGameIndex(this.currentGameIndex);
        this.gameTable.updateRow(n2);
        try {
            this.history.loadGame(this.gameTable.getPGN(this.currentGameIndex), this.gameTable.getSTR(this.currentGameIndex));
        }
        catch (VirtualBoard.ImpossibleMoveException impossibleMoveException) {
            this.showMessage(impossibleMoveException.toString());
        }
        this.infoPanel.setSTR(this.gameTable.getSTR(this.currentGameIndex));
        this.history.gotoLast();
        this.update();
        this.prepareMove();
    }

    public void update() {
        this.visualBoard.update();
        this.gameTable.repaint();
        this.updateMenu();
        this.updateNavigationButtons();
        this.notation.update();
        this.chessClock.updatePlayerSelectors();
    }

    public boolean isFileChanged() {
        if (this.fileName == null || this.fileName.length() == 0) {
            return false;
        }
        if (this.fileIsChanged) {
            return true;
        }
        if (this.currentGameIndex != -1 && this.history.isChanged()) {
            this.fileIsChanged = true;
            return true;
        }
        return false;
    }

    public void loadFile(File file) {
        fileChooserDir = file.getPath();
        String string = null;
        PGN.STR sTR = null;
        if (this.isConnected()) {
            string = this.gameTable.getPGN(this.gameTable.getNetworkGameIndex());
            sTR = this.gameTable.getSTR(this.gameTable.getNetworkGameIndex());
        }
        this.history.clear();
        this.gameTable.clear();
        PGN.loadPGN(file, this);
        if (this.isConnected()) {
            this.gameTable.setNetworkGameIndex(this.gameTable.addGame(string, sTR));
        }
        this.chessClock.resetClocks();
        this.chessClock.stopClock();
        this.whitePlayer = HUMAN;
        this.blackPlayer = HUMAN;
    }

    public void askForSaving() {
        int n = JOptionPane.showConfirmDialog(null, this.fileName + " was changed. Save file?", "Save?", 0);
        if (n == 0) {
            this.save(this.fileName, false);
        }
    }

    public void save(String string, boolean bl) {
        if (this.currentGameIndex != -1 && this.history.isChanged()) {
            this.gameTable.setPGN(this.currentGameIndex, this.history.getPGNBody());
        }
        try {
            PGN.writePGN(new File(string), this.gameTable, bl);
            this.showMessage("Game(s) saved to " + string + ".");
            this.fileIsChanged = false;
        }
        catch (IOException iOException) {
            this.showMessage("IOException: " + iOException);
        }
    }

    public void saveAs() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File(fileChooserDir));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.resetChoosableFileFilters();
        jFileChooser.addChoosableFileFilter(new PGNFileFilter());
        int n = jFileChooser.showSaveDialog(null);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            fileChooserDir = file.getPath();
            this.fileName = file.getName();
            if (!this.fileName.endsWith(".pgn")) {
                this.fileName = this.fileName + ".pgn";
                file = new File(this.fileName);
            }
            this.setTitle("JChessBoard v1.5 - " + this.fileName);
            if (file.exists()) {
                Object[] objectArray = new Object[]{"Append", "Overwrite", "Cancel"};
                n = JOptionPane.showOptionDialog(null, "File \"" + file.getName() + "\" exists.", "File exists", 0, 3, null, objectArray, objectArray[0]);
            }
            if (n == 0) {
                this.save(file.getName(), true);
                this.fileIsChanged = false;
                this.showMessage("Reloading complete file...");
                this.loadFile(file);
            } else if (n == 1) {
                this.save(file.getName(), false);
            } else {
                return;
            }
        }
    }

    public void uploadGame() {
        this.history.gotoLast();
        List list = this.history.getAllBoards();
        this.protocol.startUpload();
        PGN.STR sTR = this.gameTable.getSTR(this.gameTable.getCurrentGameIndex());
        if (sTR.hasTag("SetUp")) {
            this.protocol.initFromFEN(sTR.getTag("FEN"));
        }
        if (list.size() > 0) {
            for (int i = list.size() - 1; i >= 0; --i) {
                Move move = ((VirtualBoard)list.get(i)).getLastMove();
                if (move == null) continue;
                this.protocol.sendBatchMove(move);
            }
        }
        this.protocol.uploadDone();
        this.whitePlayer = UNKNOWN;
        this.blackPlayer = UNKNOWN;
        this.showMessage("Upload finished");
        this.gameTable.setNetworkGameIndex(this.gameTable.getCurrentGameIndex());
        this.chessClock.stopClock();
        this.chessClock.resetClocks();
        this.update();
        this.prepareMove();
    }

    public JChessBoard(String string) {
        super(string);
        this.settings = new Settings(settingsFileName);
        boolean bl = this.settings.read();
        this.setDefaultCloseOperation(0);
        windowList.add(this);
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(150);
        this.gameTable = new GameTable();
        final JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Remove game(s)");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JChessBoard.this.gotoGame(JChessBoard.this.gameTable.removeSelectedGames());
                JChessBoard.this.fileIsChanged = true;
            }
        });
        jPopupMenu.add(jMenuItem);
        this.gameTable.getJTable().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n = JChessBoard.this.gameTable.getSelectedIndex();
                    JChessBoard.this.gotoGame(n);
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        this.gameTable.getJTable().unregisterKeyboardAction(keyStroke);
        this.gameTable.getJTable().registerKeyboardAction(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                5 var2_2 = this;
                synchronized (var2_2) {
                    JChessBoard.this.gotoGame(JChessBoard.this.gameTable.getSelectedIndex());
                }
            }
        }, keyStroke, 0);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(127, 0);
        this.gameTable.getJTable().unregisterKeyboardAction(keyStroke2);
        this.gameTable.getJTable().registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JChessBoard.this.gotoGame(JChessBoard.this.gameTable.removeSelectedGames());
                JChessBoard.this.fileIsChanged = true;
            }
        }, keyStroke2, 0);
        jSplitPane.setTopComponent(this.gameTable);
        this.tabbedPane = new JTabbedPane();
        this.history = new History(this);
        this.infoPanel = new InfoPanel();
        this.notation = new Notation(this.history);
        this.tabbedPane.add("Notation", this.notation);
        this.tabbedPane.add("Tree", this.history);
        this.tabbedPane.add("Info", this.infoPanel);
        jSplitPane.setBottomComponent(this.tabbedPane);
        this.visualBoard = new VisualBoard(this);
        this.connectionIndicator = new ConnectionIndicator();
        this.chat = new Chat(this);
        this.boardConnector = null;
        if (connectionListener == null) {
            connectionListener = new ConnectionListener();
        }
        connectionListener.setPort(this.settings.networkPort);
        connectionListener.setEnabled(this.settings.enableServer);
        this.ai = null;
        this.chessClock = new ChessClock(this);
        this.chessClock.setEnabled(this.settings.enableClock);
        fileChooserDir = System.getProperty("user.dir");
        this.buttonPanel = new JPanel(new GridLayout(1, 5));
        URL uRL = (class$jchessboard$JChessBoard == null ? (class$jchessboard$JChessBoard = JChessBoard.class$("jchessboard.JChessBoard")) : class$jchessboard$JChessBoard).getResource("/images/start.gif");
        ImageIcon imageIcon = uRL != null ? new ImageIcon(uRL) : new ImageIcon("null");
        this.buttonStart = new JButton(imageIcon);
        this.buttonStart.setContentAreaFilled(false);
        this.buttonStart.setMargin(new Insets(2, 2, 2, 2));
        this.buttonStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JChessBoard.this.history.gotoFirst();
            }
        });
        this.buttonPanel.add(this.buttonStart);
        uRL = (class$jchessboard$JChessBoard == null ? (class$jchessboard$JChessBoard = JChessBoard.class$("jchessboard.JChessBoard")) : class$jchessboard$JChessBoard).getResource("/images/prev.gif");
        imageIcon = uRL != null ? new ImageIcon(uRL) : new ImageIcon("null");
        this.buttonPrevious = new JButton(imageIcon);
        this.buttonPrevious.setContentAreaFilled(false);
        this.buttonPrevious.setMargin(new Insets(2, 2, 2, 2));
        this.buttonPrevious.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JChessBoard.this.history.prev();
            }
        });
        this.buttonPanel.add(this.buttonPrevious);
        uRL = (class$jchessboard$JChessBoard == null ? (class$jchessboard$JChessBoard = JChessBoard.class$("jchessboard.JChessBoard")) : class$jchessboard$JChessBoard).getResource("/images/next.gif");
        imageIcon = uRL != null ? new ImageIcon(uRL) : new ImageIcon("null");
        this.buttonNext = new JButton(imageIcon);
        this.buttonNext.setContentAreaFilled(false);
        this.buttonNext.setMargin(new Insets(2, 2, 2, 2));
        this.buttonNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JChessBoard.this.history.next();
            }
        });
        this.buttonPanel.add(this.buttonNext);
        uRL = (class$jchessboard$JChessBoard == null ? (class$jchessboard$JChessBoard = JChessBoard.class$("jchessboard.JChessBoard")) : class$jchessboard$JChessBoard).getResource("/images/end.gif");
        imageIcon = uRL != null ? new ImageIcon(uRL) : new ImageIcon("null");
        this.buttonEnd = new JButton(imageIcon);
        this.buttonEnd.setContentAreaFilled(false);
        this.buttonEnd.setMargin(new Insets(2, 2, 2, 2));
        this.buttonEnd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JChessBoard.this.history.gotoLast();
            }
        });
        this.buttonPanel.add(this.buttonEnd);
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.chessClock, gridBagConstraints);
        container.add(this.chessClock);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.visualBoard, gridBagConstraints);
        container.add(this.visualBoard);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.buttonPanel, gridBagConstraints);
        container.add(this.buttonPanel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jSplitPane, gridBagConstraints);
        jSplitPane.setPreferredSize(new Dimension(210, 1));
        jSplitPane.setMinimumSize(new Dimension(210, 1));
        container.add(jSplitPane);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.chat, gridBagConstraints);
        container.add(this.chat);
        this.showMessage("Welcome to JChessBoard v1.5!");
        this.chat.showMessagePart("Enter ");
        this.chat.showActionMessagePart("/help", "/help");
        this.chat.showMessagePart(" for a list of available commands.\n");
        if (bl) {
            this.showMessage("Settings have been loaded from JChessBoard.conf.");
        }
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("Game");
        JMenu jMenu2 = new JMenu("Move");
        JMenu jMenu3 = new JMenu("Settings");
        JMenu jMenu4 = new JMenu("About");
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        jMenuBar.add(jMenu4);
        JMenuItem jMenuItem2 = new JMenuItem("New window");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JChessBoard jChessBoard = new JChessBoard(JChessBoard.TITLE);
            }
        });
        jMenu.add(jMenuItem2);
        this.menuItemNewGame = new JMenuItem("New game");
        this.menuItemNewGame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JChessBoard.this.isConnected()) {
                    JChessBoard.this.showMessage("Requesting new game...");
                    JChessBoard.this.protocol.requestNewGame();
                } else {
                    JChessBoard.this.newGame();
                    JChessBoard.this.showMessage("New game.");
                }
            }
        });
        jMenu.add(this.menuItemNewGame);
        this.menuItemLoadFile = new JMenuItem("Load file...");
        this.menuItemLoadFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JChessBoard.this.isFileChanged()) {
                    JChessBoard.this.askForSaving();
                }
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setCurrentDirectory(new File(fileChooserDir));
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.resetChoosableFileFilters();
                jFileChooser.addChoosableFileFilter(new PGNFileFilter());
                int n = jFileChooser.showOpenDialog(null);
                if (n == 0) {
                    JChessBoard.this.loadFile(jFileChooser.getSelectedFile());
                    JChessBoard.this.fileName = jFileChooser.getSelectedFile().getName();
                    JChessBoard.this.setTitle("JChessBoard v1.5 - " + JChessBoard.this.fileName);
                    JChessBoard.this.fileIsChanged = false;
                }
            }
        });
        jMenu.add(this.menuItemLoadFile);
        this.menuItemSave = new JMenuItem("Save");
        this.menuItemSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JChessBoard.this.fileName != null && JChessBoard.this.fileName.length() > 0) {
                    JChessBoard.this.save(JChessBoard.this.fileName, false);
                } else {
                    JChessBoard.this.saveAs();
                }
            }
        });
        jMenu.add(this.menuItemSave);
        this.menuItemSaveAs = new JMenuItem("Save as...");
        this.menuItemSaveAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JChessBoard.this.saveAs();
            }
        });
        jMenu.add(this.menuItemSaveAs);
        JMenuItem jMenuItem3 = new JMenuItem("Open board editor...");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new BoardEditor(JChessBoard.this);
            }
        });
        jMenu.add(jMenuItem3);
        jMenu.addSeparator();
        this.menuItemConnect = new JMenuItem("Connect...");
        this.menuItemConnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = new Object[4];
                objectArray[0] = "Hostname: ";
                JTextField jTextField = new JTextField(JChessBoard.this.otherHostname, 30);
                objectArray[1] = jTextField;
                objectArray[2] = "Port: ";
                JTextField jTextField2 = new JTextField("" + JChessBoard.this.settings.networkPort, 5);
                objectArray[3] = jTextField2;
                Object[] objectArray2 = new Object[]{"OK", "Cancel"};
                int n = JOptionPane.showOptionDialog(null, objectArray, "Connect...", 0, 3, null, objectArray2, objectArray2[0]);
                if (n == 0) {
                    try {
                        JChessBoard.this.otherHostname = jTextField.getText();
                        int n2 = Integer.parseInt(jTextField2.getText());
                        if (n2 > 65535) {
                            throw new NumberFormatException();
                        }
                        JChessBoard.this.settings.networkPort = n2;
                        JChessBoard.this.boardConnector = new BoardConnector(JChessBoard.this, JChessBoard.this.otherHostname, JChessBoard.this.settings.networkPort);
                        JChessBoard.this.whitePlayer = JChessBoard.UNKNOWN;
                        JChessBoard.this.blackPlayer = JChessBoard.UNKNOWN;
                        JChessBoard.this.protocol.connecting();
                    }
                    catch (NumberFormatException numberFormatException) {
                        JOptionPane.showMessageDialog(null, "Illegal port: " + jTextField2.getText(), "Illegal port", 0);
                    }
                }
                JChessBoard.this.updateMenu();
            }
        });
        jMenu.add(this.menuItemConnect);
        this.menuItemCloseConnection = new JMenuItem("Close connection");
        this.menuItemCloseConnection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(null, "Are you sure?", "Close connection?", 0);
                if (n == 0) {
                    JChessBoard.this.boardConnector.closeConnection();
                    JChessBoard.this.connectionClosed();
                }
            }
        });
        jMenu.add(this.menuItemCloseConnection);
        this.menuItemCloseConnection.setEnabled(false);
        this.menuItemOfferDraw = new JMenuItem("Offer draw");
        this.menuItemOfferDraw.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                if (JChessBoard.this.isConnected() && (n = JOptionPane.showConfirmDialog(null, "Are you sure?", "Offer draw?", 0)) == 0) {
                    JChessBoard.this.showMessage("Offering draw...");
                    JChessBoard.this.protocol.offerDraw();
                }
            }
        });
        jMenu.add(this.menuItemOfferDraw);
        this.menuItemOfferDraw.setEnabled(false);
        this.menuItemResign = new JMenuItem("Resign");
        this.menuItemResign.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                if (JChessBoard.this.isConnected() && (n = JOptionPane.showConfirmDialog(null, "Are you sure?", "Resign?", 0)) == 0) {
                    JChessBoard.this.showMessage("Resigned.");
                    JChessBoard.this.protocol.resigned();
                    if (JChessBoard.this.whitePlayer == JChessBoard.HUMAN) {
                        JChessBoard.this.history.setResult("0-1");
                    } else if (JChessBoard.this.blackPlayer == JChessBoard.HUMAN) {
                        JChessBoard.this.history.setResult("1-0");
                    }
                }
            }
        });
        jMenu.add(this.menuItemResign);
        this.menuItemResign.setEnabled(false);
        this.menuItemSwitchSides = new JMenuItem("Switch sides");
        this.menuItemSwitchSides.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                if (JChessBoard.this.isConnected() && (n = JOptionPane.showConfirmDialog(null, "Are you sure?", "Switch sides?", 0)) == 0) {
                    JChessBoard.this.showMessage("Requesting side switch...");
                    JChessBoard.this.protocol.requestSideSwitch();
                }
            }
        });
        jMenu.add(this.menuItemSwitchSides);
        this.menuItemUploadGame = new JMenuItem("Upload this game to peer");
        this.menuItemUploadGame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JChessBoard.this.isConnected()) {
                    JChessBoard.this.showMessage("Asking opponent...");
                    JChessBoard.this.protocol.requestUpload();
                }
            }
        });
        jMenu.add(this.menuItemUploadGame);
        jMenu.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem("Exit");
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JChessBoard.this.exit();
            }
        });
        jMenu.add(jMenuItem4);
        this.undoMove = new JMenuItem("Take back last move");
        this.undoMove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JChessBoard.this.isConnected()) {
                    JChessBoard.this.showMessage("Requesting undo...");
                    JChessBoard.this.protocol.requestUndo();
                } else {
                    JChessBoard.this.undoMove();
                }
            }
        });
        jMenu2.add(this.undoMove);
        JMenuItem jMenuItem5 = new JMenuItem("Edit comment");
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JChessBoard.this.history.editComment();
                JChessBoard.this.update();
            }
        });
        jMenu2.add(jMenuItem5);
        this.clockCheckbox = new JCheckBoxMenuItem("Clock");
        this.clockCheckbox.setSelected(this.settings.enableClock);
        this.clockCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JChessBoard.this.isConnected()) {
                    JChessBoard.this.clockCheckbox.setSelected(!JChessBoard.this.clockCheckbox.isSelected());
                    JChessBoard.this.showMessage("Asking opponent...");
                    JChessBoard.this.protocol.requestToggleClock();
                } else {
                    JChessBoard.this.setEnableClock(JChessBoard.this.clockCheckbox.isSelected());
                }
            }
        });
        jMenu3.add(this.clockCheckbox);
        JMenuItem jMenuItem6 = new JMenuItem("Set time...");
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JChessBoard.this.showTimeoutSelector();
            }
        });
        jMenu3.add(jMenuItem6);
        jMenu3.addSeparator();
        this.enableBeep = new JCheckBoxMenuItem("Beep");
        this.enableBeep.setSelected(this.settings.enableBeep);
        this.enableBeep.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JChessBoard.this.settings.enableBeep = JChessBoard.this.enableBeep.isSelected();
            }
        });
        jMenu3.add(this.enableBeep);
        this.reverseBoard = new JCheckBoxMenuItem("Reverse board");
        this.reverseBoard.setSelected(false);
        this.reverseBoard.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JChessBoard.this.visualBoard.setReverseBoard(JChessBoard.this.reverseBoard.isSelected());
            }
        });
        jMenu3.add(this.reverseBoard);
        this.showPossibleMoves = new JCheckBoxMenuItem("Show possible moves");
        this.showPossibleMoves.setSelected(this.settings.showPossibleMoves);
        this.showPossibleMoves.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JChessBoard.this.settings.showPossibleMoves = JChessBoard.this.showPossibleMoves.isSelected();
            }
        });
        jMenu3.add(this.showPossibleMoves);
        jMenu3.addSeparator();
        JMenuItem jMenuItem7 = new JMenuItem("Server settings...");
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                connectionListener.showSettingsPane();
                JChessBoard.this.settings.enableServer = connectionListener.isEnabled();
                JChessBoard.this.settings.networkPort = connectionListener.getPort();
            }
        });
        jMenu3.add(jMenuItem7);
        jMenu3.addSeparator();
        JMenuItem jMenuItem8 = new JMenuItem("Save settings");
        jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Dimension dimension = JChessBoard.this.getSize();
                JChessBoard.this.settings.windowWidth = (int)dimension.getWidth();
                JChessBoard.this.settings.windowHeight = (int)dimension.getHeight();
                try {
                    JChessBoard.this.settings.save();
                    JChessBoard.this.showMessage("Settings saved to JChessBoard.conf.");
                }
                catch (IOException iOException) {
                    JChessBoard.this.showMessage("IOException saving settings: " + iOException);
                }
            }
        });
        jMenu3.add(jMenuItem8);
        JMenuItem jMenuItem9 = new JMenuItem("Licensing");
        jMenuItem9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(null, JChessBoard.COPYRIGHT_MESSAGE, "About", 1);
            }
        });
        jMenu4.add(jMenuItem9);
        JMenuItem jMenuItem10 = new JMenuItem("Versions");
        jMenuItem10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(null, AI.getVersion() + "\n" + BoardConnector.getVersion() + "\n" + Chat.getVersion() + "\n" + ChessClock.getVersion() + "\n" + ConnectionListener.getVersion() + "\n" + ConnectionIndicator.getVersion() + "\n" + History.getVersion() + "\n" + JChessBoard.getVersion() + "\n" + Move.getVersion() + "\n" + PGN.getVersion() + "\n" + VirtualBoard.getVersion() + "\n" + VisualBoard.getVersion(), "Version Information", 1);
            }
        });
        jMenu4.add(jMenuItem10);
        this.updateMenu();
        this.updateNavigationButtons();
        this.pack();
        this.setSize(this.settings.windowWidth, this.settings.windowHeight);
        this.setVisible(true);
        this.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent componentEvent) {
                int n = JChessBoard.this.getWidth();
                int n2 = JChessBoard.this.getHeight();
                if (n < 350 || n2 < 471) {
                    n = n < 350 ? 350 : n;
                    n2 = n2 < 471 ? 471 : n2;
                    JChessBoard.this.setSize(n, n2);
                }
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentShown(ComponentEvent componentEvent) {
            }

            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JChessBoard.this.exit();
            }
        });
        this.fileIsChanged = false;
        this.newGame();
    }

    public static void main(String[] stringArray) {
        JChessBoard jChessBoard = new JChessBoard(TITLE);
        if (stringArray.length > 0) {
            jChessBoard.loadFile(new File(stringArray[0]));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class PGNFileFilter
    extends FileFilter {
        PGNFileFilter() {
        }

        public String getDescription() {
            return "PGN Files (*.pgn)";
        }

        public boolean accept(File file) {
            return file.exists() && file.canRead() && (file.getName().endsWith(".pgn") || file.isDirectory());
        }
    }
}

