/*
 * Decompiled with CFR 0.152.
 */
package jchessboard;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import jchessboard.GameTable;
import jchessboard.History;
import jchessboard.JChessBoard;
import jchessboard.VirtualBoard;

class PGN {
    static final String[] NAGStrings = new String[]{"", "!", "?", "!!", "??", "!?", "?!", "forced move (all others lose quickly)", "singular move (no reasonable alternatives)", "worst move", "drawish position", "equal chances, quiet position", "equal chances, active position", "unclear position", "White has a slight advantage", "Black has a slight advantage", "White has a moderate advantage", "Black has a moderate advantage", "White has a decisive advantage", "Black has a decisive advantage", "White has a crushing advantage (Black should resign)", "Black has a crushing advantage (White should resign)", "White is in zugzwang", "Black is in zugzwang", "White has a slight space advantage", "Black has a slight space advantage", "White has a moderate space advantage", "Black has a moderate space advantage", "White has a decisive space advantage", "Black has a decisive space advantage", "White has a slight time (development) advantage", "Black has a slight time (development) advantage", "White has a moderate time (development) advantage", "Black has a moderate time (development) advantage", "White has a decisive time (development) advantage", "Black has a decisive time (development) advantage", "White has the initiative", "Black has the initiative", "White has a lasting initiative", "Black has a lasting initiative", "White has the attack", "Black has the attack", "White has insufficient compensation for material deficit", "Black has insufficient compensation for material deficit", "White has sufficient compensation for material deficit", "Black has sufficient compensation for material deficit", "White has more than adequate compensation for material deficit", "Black has more than adequate compensation for material deficit", "White has a slight center control advantage", "Black has a slight center control advantage", "White has a moderate center control advantage", "Black has a moderate center control advantage", "White has a decisive center control advantage", "Black has a decisive center control advantage", "White has a slight kingside control advantage", "Black has a slight kingside control advantage", "White has a moderate kingside control advantage", "Black has a moderate kingside control advantage", "White has a decisive kingside control advantage", "Black has a decisive kingside control advantage", "White has a slight queenside control advantage", "Black has a slight queenside control advantage", "White has a moderate queenside control advantage", "Black has a moderate queenside control advantage", "White has a decisive queenside control advantage", "Black has a decisive queenside control advantage", "White has a vulnerable first rank", "Black has a vulnerable first rank", "White has a well protected first rank", "Black has a well protected first rank", "White has a poorly protected king", "Black has a poorly protected king", "White has a well protected king", "Black has a well protected king", "White has a poorly placed king", "Black has a poorly placed king", "White has a well placed king", "Black has a well placed king", "White has a very weak pawn structure", "Black has a very weak pawn structure", "White has a moderately weak pawn structure", "Black has a moderately weak pawn structure", "White has a moderately strong pawn structure", "Black has a moderately strong pawn structure", "White has a very strong pawn structure", "Black has a very strong pawn structure", "White has poor knight placement", "Black has poor knight placement", "White has good knight placement", "Black has good knight placement", "White has poor bishop placement", "Black has poor bishop placement", "White has good bishop placement", "Black has good bishop placement", "White has poor rook placement", "Black has poor rook placement", "White has good rook placement", "Black has good rook placement", "White has poor queen placement", "Black has poor queen placement", "White has good queen placement", "Black has good queen placement", "White has poor piece coordination", "Black has poor piece coordination", "White has good piece coordination", "Black has good piece coordination", "White has played the opening very poorly", "Black has played the opening very poorly", "White has played the opening poorly", "Black has played the opening poorly", "White has played the opening well", "Black has played the opening well", "White has played the opening very well", "Black has played the opening very well", "White has played the middlegame very poorly", "Black has played the middlegame very poorly", "White has played the middlegame poorly", "Black has played the middlegame poorly", "White has played the middlegame well", "Black has played the middlegame well", "White has played the middlegame very well", "Black has played the middlegame very well", "White has played the ending very poorly", "Black has played the ending very poorly", "White has played the ending poorly", "Black has played the ending poorly", "White has played the ending well", "Black has played the ending well", "White has played the ending very well", "Black has played the ending very well", "White has slight counterplay", "Black has slight counterplay", "White has moderate counterplay", "Black has moderate counterplay", "White has decisive counterplay", "Black has decisive counterplay", "White has moderate time control pressure", "Black has moderate time control pressure", "White has severe time control pressure", "Black has severe time control pressure"};

    public static String getVersion() {
        return "$Id: PGN.java,v 1.44 2004/12/24 23:56:43 cdivossen Exp $";
    }

    public static STR getSTRfromPGN(String string) {
        int n;
        String string2;
        STR sTR = new STR();
        int n2 = 0;
        while (n2 < string.length() && (string2 = string.substring(n2, n = string.indexOf(10, n2))).length() >= 6 && string2.charAt(0) == '[') {
            String string3 = string2.substring(1, string2.indexOf(32));
            int n3 = string2.indexOf(34);
            int n4 = string2.lastIndexOf(34);
            String string4 = string2.substring(n3 + 1, n4);
            sTR.setTag(string3, string4);
            n2 = n + 1;
        }
        return sTR;
    }

    public static String getBodyFromPGN(String string) {
        int n = 0;
        while (n < string.length()) {
            int n2 = string.indexOf(10, n);
            String string2 = string.substring(n, n2);
            n = n2 + 1;
            if (string2.length() >= 6) continue;
            break;
        }
        return string.substring(n);
    }

    public static void loadPGN(File file, JChessBoard jChessBoard) {
        FileReader fileReader;
        try {
            fileReader = new FileReader(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            jChessBoard.showMessage("File not found: " + file);
            return;
        }
        new PGNLoader(jChessBoard, fileReader, file.getName()).run();
    }

    public static void parseGame(History history, VirtualBoard virtualBoard, String string, boolean bl) throws VirtualBoard.ImpossibleMoveException {
        String string2 = "";
        VirtualBoard virtualBoard2 = virtualBoard.clonedBoard();
        VirtualBoard virtualBoard3 = null;
        if (string == null) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        PGNTokenizer pGNTokenizer = new PGNTokenizer(string);
        boolean bl2 = false;
        int n = 1;
        try {
            while (pGNTokenizer.hasNext() && !bl2) {
                String string3;
                n = virtualBoard2.isWhiteTurn() ? virtualBoard2.getFullMoveNumber() + 1 : virtualBoard2.getFullMoveNumber();
                string2 = pGNTokenizer.next();
                if (pGNTokenizer.foundTag && pGNTokenizer.hasNext()) {
                    string3 = pGNTokenizer.next();
                    if (bl) {
                        System.out.println("Tag: " + string2 + ": " + string3);
                    }
                    hashMap.put(string2, string3);
                    if (!string2.equals("FEN")) continue;
                    virtualBoard2.initFromFEN(string3);
                    history.setBoard(virtualBoard2);
                    continue;
                }
                if (pGNTokenizer.foundNAG) {
                    try {
                        int n2;
                        if (bl) {
                            System.out.println("NAG: " + string2);
                        }
                        if ((n2 = Integer.parseInt(string2)) < 0 || n2 > 255) {
                            throw new NumberFormatException();
                        }
                        if (n2 >= NAGStrings.length) {
                            System.out.println("Unknown NAG: " + string2);
                        }
                        history.addNAG(n2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Illegal NAG: " + string2);
                    }
                    continue;
                }
                if (pGNTokenizer.foundMoveNumberIndication) {
                    if (bl) {
                        System.out.println("MoveNumber: " + string2);
                    }
                    try {
                        if (Integer.parseInt(string2) == n) continue;
                        throw new NumberFormatException();
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Wrong move number: " + string2 + ", expected: " + n);
                        continue;
                    }
                }
                if (pGNTokenizer.foundComment) {
                    if (bl) {
                        System.out.println("Comment: " + string2);
                    }
                    history.addComment(string2);
                    continue;
                }
                if (pGNTokenizer.foundRAV) {
                    if (bl) {
                        System.out.println("RAV: " + string2);
                    }
                    history.addVariation(virtualBoard3.clonedBoard(), string2);
                    continue;
                }
                if (string2.equals("1-0") || string2.equals("0-1") || string2.equals("1/2-1/2") || string2.equals("*")) {
                    if (bl) {
                        System.out.println("Game termination: " + string2);
                    }
                    bl2 = true;
                    continue;
                }
                if (bl) {
                    System.out.println("Move: " + string2);
                }
                virtualBoard3 = virtualBoard2.clonedBoard();
                virtualBoard2.makeMove(string2);
                string3 = virtualBoard3.algebraic(virtualBoard2.getLastMove());
                history.addBatchMove(string3, virtualBoard2.clonedBoard());
            }
        }
        catch (VirtualBoard.ImpossibleMoveException impossibleMoveException) {
            String string4 = virtualBoard2.isWhiteTurn() ? "" + n + ". " : "" + n + ". ... ";
            throw new VirtualBoard.ImpossibleMoveException(string4 + string2);
        }
    }

    public static void writePGN(File file, GameTable gameTable, boolean bl) throws IOException {
        BufferedWriter bufferedWriter = null;
        if (bl) {
            bufferedWriter = new BufferedWriter(new FileWriter(file.getPath(), true));
            bufferedWriter.write("\n");
        } else {
            bufferedWriter = new BufferedWriter(new FileWriter(file));
        }
        int n = gameTable.getGameCount();
        for (int i = 0; i < n; ++i) {
            bufferedWriter.write(gameTable.getSTR(i).toString());
            bufferedWriter.write("\n");
            StringBuffer stringBuffer = new StringBuffer(gameTable.getPGN(i));
            int n2 = 0;
            int n3 = 0;
            for (int j = 0; j < stringBuffer.length(); ++j) {
                char c = stringBuffer.charAt(j);
                if (c == '\n') {
                    bufferedWriter.write(stringBuffer.substring(n3, j + 1));
                    n3 = j + 1;
                }
                if (j - n3 > 78) {
                    bufferedWriter.write(stringBuffer.substring(n3, n2));
                    bufferedWriter.write("\n");
                    n3 = n2 + 1;
                }
                if (c != ' ') continue;
                n2 = j;
            }
            bufferedWriter.write("\n");
        }
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    static class PGNLoader
    implements Runnable {
        private JChessBoard jcb;
        private BufferedReader reader;
        private String filename;

        public void run() {
            ArrayList arrayList = new ArrayList();
            ArrayList<StringBuffer> arrayList2 = new ArrayList<StringBuffer>();
            this.jcb.setEnabled(false);
            this.jcb.showMessage("Loading " + this.filename + "...");
            try {
                String string;
                StringBuffer stringBuffer = null;
                while ((string = this.reader.readLine()) != null) {
                    if (string.startsWith("[Event ")) {
                        stringBuffer = new StringBuffer();
                        arrayList2.add(stringBuffer);
                    }
                    if (!string.equals("") && stringBuffer == null) {
                        this.jcb.showMessage("Malformed PGN file.");
                        return;
                    }
                    if (stringBuffer == null) continue;
                    stringBuffer.append(string);
                    stringBuffer.append("\n");
                }
            }
            catch (IOException iOException) {
                this.jcb.showMessage("IOExcpetion reading PGN file.");
                this.jcb.setEnabled(true);
                return;
            }
            int n = arrayList2.size();
            if (n == 0) {
                this.jcb.showMessage("No game was found.");
                this.jcb.setEnabled(true);
                this.jcb.newGame();
                return;
            }
            this.jcb.showMessage("Found " + n + " game" + (n > 1 ? "s." : "."));
            for (int i = 0; i < n; ++i) {
                STR sTR = PGN.getSTRfromPGN(((StringBuffer)arrayList2.get(i)).toString());
                String string = PGN.getBodyFromPGN(((StringBuffer)arrayList2.get(i)).toString());
                this.jcb.gameTable.addGame(string, sTR);
            }
            this.jcb.gotoGame(0);
            this.jcb.showMessage("Loading finished.");
            this.jcb.setEnabled(true);
        }

        public PGNLoader(JChessBoard jChessBoard, Reader reader, String string) {
            this.jcb = jChessBoard;
            this.reader = new BufferedReader(reader);
            this.filename = string;
        }
    }

    static class PGNTokenizer {
        String game;
        int gameLength;
        int currentPos = 0;
        boolean foundTag = false;
        boolean foundNAG = false;
        boolean foundMoveNumberIndication = false;
        boolean foundComment = false;
        boolean foundRAV = false;
        String nextToken = null;

        public String next() {
            if (this.nextToken == null) {
                this.hasNext();
            }
            if (this.nextToken != null) {
                String string = this.nextToken;
                this.nextToken = null;
                return string;
            }
            return null;
        }

        public boolean hasNext() {
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            this.foundNAG = false;
            this.foundMoveNumberIndication = false;
            this.foundComment = false;
            this.foundRAV = false;
            while (this.currentPos < this.gameLength && !bl) {
                char c;
                if ((c = this.game.charAt(this.currentPos++)) == '[') {
                    this.foundTag = true;
                    continue;
                }
                if (c == ']' && this.foundTag) {
                    this.foundTag = false;
                    if (stringBuffer.length() <= 0) continue;
                    bl = true;
                    continue;
                }
                if (c == '.') {
                    if (stringBuffer.length() <= 0) continue;
                    bl = true;
                    this.foundMoveNumberIndication = true;
                    continue;
                }
                if (c == '<') {
                    do {
                        c = this.game.charAt(this.currentPos++);
                    } while (this.currentPos < this.gameLength && c != '>');
                    continue;
                }
                if (c == '(') {
                    int n = 1;
                    do {
                        if ((c = this.game.charAt(this.currentPos++)) == ';') {
                            stringBuffer.append(c);
                            do {
                                c = this.game.charAt(this.currentPos++);
                                stringBuffer.append(c);
                            } while (this.currentPos < this.gameLength && c != '\n');
                            continue;
                        }
                        if (c == '%') {
                            do {
                                c = this.game.charAt(this.currentPos++);
                            } while (this.currentPos < this.gameLength && c != '\n');
                            continue;
                        }
                        if (c == '{') {
                            stringBuffer.append(c);
                            do {
                                c = this.game.charAt(this.currentPos++);
                                stringBuffer.append(c);
                            } while (this.currentPos < this.gameLength && c != '}');
                            continue;
                        }
                        if (c == '(') {
                            stringBuffer.append(c);
                            ++n;
                            continue;
                        }
                        if (c == ')') {
                            if (--n <= 0) continue;
                            stringBuffer.append(c);
                            continue;
                        }
                        stringBuffer.append(c);
                    } while (this.currentPos < this.gameLength && n > 0);
                    if (stringBuffer.length() <= 0) continue;
                    bl = true;
                    this.foundRAV = true;
                    continue;
                }
                if (c == '{') {
                    this.foundComment = true;
                    do {
                        if ((c = this.game.charAt(this.currentPos++)) == '\n') {
                            stringBuffer.append(' ');
                            continue;
                        }
                        if (c == '}') continue;
                        stringBuffer.append(c);
                    } while (this.currentPos < this.gameLength && c != '}');
                    if (stringBuffer.length() <= 0) continue;
                    bl = true;
                    continue;
                }
                if (c == ';') {
                    this.foundComment = true;
                    do {
                        if ((c = this.game.charAt(this.currentPos++)) == '\n') continue;
                        stringBuffer.append(c);
                    } while (this.currentPos < this.gameLength && c != '\n');
                    if (stringBuffer.length() <= 0) continue;
                    bl = true;
                    continue;
                }
                if (c == '%') {
                    do {
                        c = this.game.charAt(this.currentPos++);
                    } while (this.currentPos < this.gameLength && c != '\n');
                    continue;
                }
                if (c == '$') {
                    this.foundNAG = true;
                    continue;
                }
                if (c == '\"') {
                    do {
                        if ((c = this.game.charAt(this.currentPos++)) == '\"') continue;
                        stringBuffer.append(c);
                    } while (this.currentPos < this.gameLength && c != '\"');
                    if (stringBuffer.length() <= 0) continue;
                    bl = true;
                    continue;
                }
                if (c == '\n' || c == ' ' || c == '\t') {
                    if (stringBuffer.length() <= 0) continue;
                    bl = true;
                    continue;
                }
                stringBuffer.append(c);
            }
            if (stringBuffer.length() == 0) {
                this.nextToken = null;
                return false;
            }
            this.nextToken = stringBuffer.toString();
            return true;
        }

        public PGNTokenizer(String string) {
            this.game = string;
            this.gameLength = string.length();
        }
    }

    static class STR {
        Hashtable tags = new Hashtable();
        String[] tagNames = new String[]{"Event", "Site", "Date", "Round", "White", "Black", "Result", "WhiteTitle", "BlackTitle", "WhiteElo", "BlackElo", "WhiteUSCF", "BlackUSCF", "WhiteNA", "BlackNA", "WhiteType", "BlackType", "EventDate", "EventSponsor", "Section", "Stage", "Board", "Opening", "Variation", "SubVariation", "ECO", "NIC", "Time", "UTCTime", "UTCDate", "TimeControl", "SetUp", "FEN", "Termination", "Annotator", "Mode", "PlyCount"};

        private boolean isSTRTag(String string) {
            return string.equals("Event") || string.equals("Site") || string.equals("Date") || string.equals("Round") || string.equals("White") || string.equals("Black") || string.equals("Result");
        }

        public String[] tags() {
            String[] stringArray = new String[this.tags.size()];
            stringArray[0] = "Event";
            stringArray[1] = "Site";
            stringArray[2] = "Date";
            stringArray[3] = "Round";
            stringArray[4] = "White";
            stringArray[5] = "Black";
            stringArray[6] = "Result";
            int n = 7;
            Enumeration enumeration = this.tags.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (this.isSTRTag(string)) continue;
                stringArray[n++] = string;
            }
            return stringArray;
        }

        public String toString() {
            Enumeration enumeration = this.tags.keys();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[Event \"" + this.tags.get("Event") + "\"]\n");
            stringBuffer.append("[Site \"" + this.tags.get("Site") + "\"]\n");
            stringBuffer.append("[Date \"" + this.tags.get("Date") + "\"]\n");
            stringBuffer.append("[Round \"" + this.tags.get("Round") + "\"]\n");
            stringBuffer.append("[White \"" + this.tags.get("White") + "\"]\n");
            stringBuffer.append("[Black \"" + this.tags.get("Black") + "\"]\n");
            stringBuffer.append("[Result \"" + this.tags.get("Result") + "\"]\n");
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (this.isSTRTag(string)) continue;
                stringBuffer.append("[" + string + " \"" + (String)this.tags.get(string) + "\"]\n");
            }
            return stringBuffer.toString();
        }

        public STR getCopy() {
            STR sTR = new STR();
            Enumeration enumeration = this.tags.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                sTR.setTag(string, (String)this.tags.get(string));
            }
            return sTR;
        }

        public void setTag(String string, String string2) {
            this.tags.put(string, string2);
        }

        public String getTag(String string) {
            return (String)this.tags.get(string);
        }

        public void removeTag(String string) {
            if (!this.isSTRTag(string)) {
                this.tags.remove(string);
            }
        }

        public int size() {
            return this.tags.size();
        }

        public boolean hasTag(String string) {
            return this.tags.containsKey(string);
        }

        public STR() {
            this.tags.put("Event", "?");
            this.tags.put("Site", "?");
            this.tags.put("Date", "????.??.??");
            this.tags.put("Round", "?");
            this.tags.put("Black", "?");
            this.tags.put("White", "?");
            this.tags.put("Result", "?");
        }
    }
}

