/*
 * Decompiled with CFR 0.152.
 */
package ReversiMonitor;

import Common.animMatrix;
import Common.boardInfo;
import Common.generalPlayer;
import Common.loc;
import Common.matrix;
import ReversiMonitor.boardView_PBMTimer_actionAdapter;
import ReversiMonitor.boardView_this_mouseAdapter;
import ReversiMonitor.boardView_timer_actionAdapter;
import ReversiMonitor.moveList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;

public class boardView
extends JPanel {
    public animMatrix am;
    public int animationSpeed = 5;
    public boardInfo board = new boardInfo();
    public int boardBorder;
    public ImageIcon border;
    BorderLayout borderLayout1;
    static /* synthetic */ Class class$ReversiMonitor$mainForm;
    public int deltaX = 0;
    public int deltaY = 0;
    public boolean gamePaused = true;
    public moveList mlPointer;
    public JFrame parent;
    public Timer pauseBeforeMoveTimer;
    public ImageIcon pieces;
    public generalPlayer playerBPointer;
    public generalPlayer playerWPointer;
    public boolean showGuides = true;
    public JLabel statusBar;
    public Timer timer;
    TitledBorder titledBorder1;

    public boardView(moveList ml, JFrame parent, int boardBorderSelector) {
        this.am = new animMatrix();
        this.pieces = new ImageIcon();
        this.border = new ImageIcon();
        this.statusBar = new JLabel();
        this.borderLayout1 = new BorderLayout();
        try {
            this.boardBorder = boardBorderSelector;
            this.mlPointer = ml;
            this.parent = parent;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void PBMTimer_actionPerformed(ActionEvent e) {
        this.pauseBeforeMoveTimer.stop();
        if (this.board.turn == boardInfo.PLAYER_BLACK && this.playerBPointer != null) {
            this.startMove(this.playerBPointer.getMove(this.board));
        } else if (this.board.turn == boardInfo.PLAYER_WHITE && this.playerWPointer != null) {
            this.startMove(this.playerWPointer.getMove(this.board));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private void jbInit() throws Exception {
        this.timer = new Timer(50, new boardView_timer_actionAdapter(this));
        this.pauseBeforeMoveTimer = new Timer(100, new boardView_PBMTimer_actionAdapter(this));
        this.addMouseListener(new boardView_this_mouseAdapter(this));
        this.pieces = new ImageIcon((class$ReversiMonitor$mainForm == null ? (class$ReversiMonitor$mainForm = boardView.class$("ReversiMonitor.mainForm")) : class$ReversiMonitor$mainForm).getResource("pixmaps/standard-1.png"));
        this.border = new ImageIcon((class$ReversiMonitor$mainForm == null ? (class$ReversiMonitor$mainForm = boardView.class$("ReversiMonitor.mainForm")) : class$ReversiMonitor$mainForm).getResource("pixmaps/540px-board-" + this.boardBorder + ".png"));
        this.setLayout(this.borderLayout1);
        this.titledBorder1 = new TitledBorder("");
        this.statusBar.setBorder(this.titledBorder1);
        this.statusBar.setText(" ");
        this.add((Component)this.statusBar, "South");
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(new Color(200, 200, 200));
        g.setFont(new Font("Default", 1, 12));
        int nr = boardInfo.ROW_COUNT;
        int nc = boardInfo.COL_COUNT;
        matrix m = new matrix();
        if (!this.timer.isRunning()) {
            m = this.board.getGainMatrix();
        }
        g.drawImage(this.border.getImage(), this.deltaX, this.deltaY, this);
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                int x = this.deltaX + 31 + j * 60;
                int y = this.deltaY + 31 + i * 60;
                int b = this.board.b[i][j];
                int sx = b % 8 * 60;
                int sy = b / 8 * 60;
                g.drawImage(this.pieces.getImage(), x, y, x + 60, y + 60, sx, sy, sx + 60, sy + 60, this);
                if (!this.timer.isRunning() && this.showGuides && (b = m.get(i, j)) != 0 && b != -1) {
                    g.drawString("" + b, x + 25, y + 35);
                }
                ++j;
            }
            ++i;
        }
    }

    public void startMove(loc move) {
        if (this.gamePaused) {
            return;
        }
        if (move.r < 0 || move.r > 7 || move.c < 0 || move.c > 7) {
            return;
        }
        if (!this.board.isValidMove(move.r, move.c)) {
            return;
        }
        this.am = this.board.calculateMoveAnimation(move.r, move.c);
        this.repaint();
        this.timer.start();
    }

    void this_mouseClicked(MouseEvent e) {
        if (this.timer.isRunning()) {
            return;
        }
        if (this.board.turn == boardInfo.NO_GAME || this.board.turn == boardInfo.GAME_OVER) {
            this.statusBar.setText("To Start New Game choose Game | New.");
            return;
        }
        int r = (e.getY() - 30 - this.deltaY) / 60;
        int c = (e.getX() - 30 - this.deltaX) / 60;
        int br = (e.getY() - 30 - this.deltaY) % 60;
        int bc = (e.getX() - 30 - this.deltaX) % 60;
        if (Math.abs(br - 30) > 28 || Math.abs(bc - 30) > 28) {
            return;
        }
        if (this.board.turn == boardInfo.PLAYER_BLACK && this.playerBPointer == null) {
            this.startMove(new loc(r, c));
        } else if (this.board.turn == boardInfo.PLAYER_WHITE && this.playerWPointer == null) {
            this.startMove(new loc(r, c));
        }
    }

    void timer_actionPerformed(ActionEvent e) {
        int count = this.am.perform(this.board, this.animationSpeed);
        this.repaint();
        if (count == boardInfo.ROW_COUNT * boardInfo.COL_COUNT) {
            this.timer.stop();
            if (this.board.correctTurn() == 2) {
                String s = "Game Over";
                int p1 = this.board.getPieceCount(boardInfo.PLAYER_BLACK);
                int p2 = this.board.getPieceCount(boardInfo.PLAYER_WHITE);
                s = s + " ( ";
                s = s + p1 + " : " + p2;
                s = s + " ) ";
                s = p1 == p2 ? s + " It's a Draw ! " : (p1 > p2 ? s + " Black is Winner ! " : s + " White is Winner ! ");
                this.statusBar.setText(s);
                if (this.mlPointer != null) {
                    this.mlPointer.updateMoveList(this.board);
                }
            } else {
                this.updateTurn();
            }
        }
    }

    public void updateTurn() {
        if (this.mlPointer != null) {
            this.mlPointer.updateMoveList(this.board);
        }
        if (this.board.turn == boardInfo.NO_GAME) {
            this.statusBar.setText("To Start New Game choose Game | New.");
            return;
        }
        String s = this.board.getTurnString();
        s = s + " ( ";
        s = s + this.board.getPieceCount(boardInfo.PLAYER_BLACK) + " : ";
        s = s + this.board.getPieceCount(boardInfo.PLAYER_WHITE);
        s = s + " ) ";
        this.statusBar.setText(s);
        if (this.gamePaused) {
            return;
        }
        if (this.board.turn == boardInfo.PLAYER_BLACK && this.playerBPointer != null) {
            this.pauseBeforeMoveTimer.start();
        } else if (this.board.turn == boardInfo.PLAYER_WHITE && this.playerWPointer != null) {
            this.pauseBeforeMoveTimer.start();
        }
    }
}

