/*
 * Decompiled with CFR 0.152.
 */
package megamek.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import megamek.client.Client;
import megamek.client.GameEvent;
import megamek.client.GameListener;
import megamek.common.Player;

public class ChatterBox
implements GameListener,
KeyListener {
    public Client client;
    public String[] chatBuffer;
    public Panel chatPanel;
    private TextArea chatArea;
    private List playerList;
    private TextField inputField;

    public ChatterBox(Client client) {
        this.client = client;
        client.addGameListener(this);
        this.chatArea = new TextArea(" \n", 5, 40, 1);
        this.chatArea.setEditable(false);
        this.playerList = new List();
        this.inputField = new TextField();
        this.inputField.addKeyListener(this);
        this.chatPanel = new Panel(new BorderLayout());
        this.chatPanel.add((Component)this.chatArea, "Center");
        this.chatPanel.add((Component)this.playerList, "West");
        this.chatPanel.add((Component)this.inputField, "South");
    }

    public void moveToEnd() {
        int n = this.chatArea.getText().length() - 1;
        this.chatArea.select(n, n);
    }

    public void refreshPlayerList() {
        this.playerList.removeAll();
        Enumeration enumeration = this.client.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            StringBuffer stringBuffer = new StringBuffer(player.getName());
            if (player.isGhost()) {
                stringBuffer.append(" (ghost)");
            } else if (player.isObserver()) {
                stringBuffer.append(" (observer)");
            } else if (player.isReady()) {
                stringBuffer.append(" (ready)");
            }
            this.playerList.add(stringBuffer.toString());
        }
    }

    public Component getComponent() {
        return this.chatPanel;
    }

    public void systemMessage(String string) {
        this.chatArea.append("\nMegaMek: " + string);
    }

    public void gamePlayerChat(GameEvent gameEvent) {
        this.chatArea.append("\n" + gameEvent.getMessage());
        this.refreshPlayerList();
    }

    public void gamePlayerStatusChange(GameEvent gameEvent) {
        this.refreshPlayerList();
    }

    public void gameTurnChange(GameEvent gameEvent) {
        this.refreshPlayerList();
    }

    public void gamePhaseChange(GameEvent gameEvent) {
        this.refreshPlayerList();
    }

    public void gameNewEntities(GameEvent gameEvent) {
        this.refreshPlayerList();
    }

    public void gameNewSettings(GameEvent gameEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.client.sendChat(this.inputField.getText());
            this.inputField.setText("");
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

