/*
 * Decompiled with CFR 0.152.
 */
package megamek.client;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import megamek.client.Client;
import megamek.common.Player;

public class StartingPositionDialog
extends Dialog
implements ActionListener {
    private static final String[] startNames = new String[]{"Any", "NW", "N", "NE", "E", "SE", "S", "SW", "W"};
    private Client client;
    private Panel panButtons = new Panel();
    private Button butOkay = new Button("Okay");
    private Button butCancel = new Button("Cancel");
    private Panel panStartButtons = new Panel();
    private Button[] butStartPos = new Button[9];
    private List lisStartList = new List(5);

    public StartingPositionDialog(Client client) {
        super(client.frame, "Select a Starting Position...", true);
        this.client = client;
        this.lisStartList.setEnabled(false);
        this.setupStartGrid();
        this.setupButtons();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.panStartButtons, gridBagConstraints);
        this.add(this.panStartButtons);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.lisStartList, gridBagConstraints);
        this.add(this.lisStartList);
        gridBagConstraints.fill = 3;
        gridBagLayout.setConstraints(this.panButtons, gridBagConstraints);
        this.add(this.panButtons);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ((Component)StartingPositionDialog.this).setVisible(false);
            }
        });
        this.pack();
        this.setResizable(false);
        ((Component)this).setLocation(client.frame.getLocation().x + client.frame.getSize().width / 2 - this.getSize().width / 2, client.frame.getLocation().y + client.frame.getSize().height / 2 - this.getSize().height / 2);
    }

    private void setupStartGrid() {
        int n = 0;
        while (n < 9) {
            this.butStartPos[n] = new Button(startNames[n]);
            this.butStartPos[n].addActionListener(this);
            ++n;
        }
        this.panStartButtons.setLayout(new GridLayout(3, 3));
        this.panStartButtons.add(this.butStartPos[1]);
        this.panStartButtons.add(this.butStartPos[2]);
        this.panStartButtons.add(this.butStartPos[3]);
        this.panStartButtons.add(this.butStartPos[8]);
        this.panStartButtons.add(this.butStartPos[0]);
        this.panStartButtons.add(this.butStartPos[4]);
        this.panStartButtons.add(this.butStartPos[7]);
        this.panStartButtons.add(this.butStartPos[6]);
        this.panStartButtons.add(this.butStartPos[5]);
    }

    private void setupButtons() {
        this.butOkay.addActionListener(this);
        this.butCancel.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panButtons.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.butOkay, gridBagConstraints);
        this.panButtons.add(this.butOkay);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.butCancel, gridBagConstraints);
        this.panButtons.add(this.butCancel);
    }

    public void update() {
        this.lisStartList.removeAll();
        Enumeration enumeration = this.client.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            if (player == null) continue;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(player.getName()).append(" : ");
            stringBuffer.append(startNames[player.getStartingPos()]);
            this.lisStartList.add(stringBuffer.toString());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = 0;
        while (n < 9) {
            if (actionEvent.getSource() == this.butStartPos[n]) {
                this.client.getLocalPlayer().setStartingPos(n);
                this.client.sendPlayerInfo();
            }
            ++n;
        }
        ((Component)this).setVisible(false);
    }
}

