/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.bot;

import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.TreeMap;
import java.awt.Frame;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import megamek.client.GameEvent;
import megamek.client.bot.BotClient;
import megamek.client.bot.BotClientWrapper;
import megamek.client.bot.CEntity;
import megamek.client.bot.Compute;
import megamek.client.bot.ConnectionThread;
import megamek.client.bot.EntityState;
import megamek.client.bot.GAAttack;
import megamek.client.bot.GALance;
import megamek.client.bot.Strategy;
import megamek.client.bot.ga.GAException;
import megamek.common.AmmoType;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.Hex;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.MovementData;
import megamek.common.Player;
import megamek.common.Tank;
import megamek.common.ToHitData;
import megamek.common.WeaponType;
import megamek.common.actions.AbstractAttackAction;
import megamek.common.actions.TorsoTwistAction;
import megamek.common.actions.WeaponAttackAction;
import megamek.server.Server;

public class TestBot
extends BotClientWrapper {
    public static CEntity.Table enemies = new CEntity.Table();
    public LinkedList unit_values = new LinkedList();
    public LinkedList enemy_values = new LinkedList();
    public static Properties BotProperties = new Properties();
    public static int Ignore = 10;
    int enemies_moved = 0;
    GALance old_moves = null;
    int my_mechs_moved = 0;
    boolean initMovement = false;
    int NumEnemies = 0;
    int NumFriends = 0;

    public TestBot(Frame frame, String string) {
        super(frame, string);
        this.setup();
    }

    public TestBot(String string) {
        super(string);
        this.setup();
    }

    private void setup() {
        try {
            BotProperties.load(new FileInputStream("bot.properties"));
        }
        catch (Exception exception) {
            System.out.println("Bot properties could not be loaded, will use defaults");
        }
        int n = 3;
        try {
            n = Integer.parseInt(BotProperties.getProperty("difficulty", "3"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (n) {
            case 1: {
                Ignore = 8;
                break;
            }
            case 2: {
                Ignore = 9;
                break;
            }
            case 3: {
                Ignore = 10;
            }
        }
    }

    public void initialize() {
        EntityState.game = this.game;
        EntityState.tb = this;
        CEntity.game = this.game;
        CEntity.tb = this;
    }

    public void calculatePhysicalTurn() {
        int n;
        int n2 = n = this.game.getFirstEntityNum(this.getLocalPlayer());
        do {
            Entity entity = this.game.getEntity(n);
            CEntity cEntity = enemies.get(entity);
            BotClient.PhysicalOption physicalOption = this.getBestPhysical(entity);
            if (physicalOption == null) continue;
            if (physicalOption.type == 4 || physicalOption.type == 5) {
                double d;
                double d2;
                int n3 = Compute.getThreatHitArc(physicalOption.target.getPosition(), physicalOption.target.getFacing(), entity.getPosition());
                double d3 = 1.0 - megamek.common.Compute.oddsAbove(megamek.common.Compute.toHitKick(this.game, n, physicalOption.target.getId(), physicalOption.type - 3).getValue()) / 100.0;
                double d4 = 1.0;
                if (physicalOption.target instanceof Mech) {
                    d2 = physicalOption.target.getArmor(7) / physicalOption.target.getOArmor(7);
                    d = physicalOption.target.getArmor(6) / physicalOption.target.getOArmor(6);
                    switch (n3) {
                        case 0: {
                            d4 = (d2 + d) / 2.0;
                            break;
                        }
                        case 2: {
                            d4 = d2;
                            break;
                        }
                        case 3: {
                            d4 = d;
                        }
                    }
                } else if (physicalOption.target instanceof Infantry) {
                    d4 = 0.0;
                } else if (physicalOption.target instanceof Tank) {
                    switch (n3) {
                        case 0: {
                            d4 = physicalOption.target.getArmor(1) / physicalOption.target.getOArmor(1);
                            break;
                        }
                        case 2: {
                            d4 = physicalOption.target.getArmor(3) / physicalOption.target.getOArmor(3);
                            break;
                        }
                        case 3: {
                            d4 = physicalOption.target.getArmor(2) / physicalOption.target.getOArmor(2);
                            break;
                        }
                        case 1: {
                            d4 = physicalOption.target.getArmor(4) / physicalOption.target.getOArmor(4);
                        }
                    }
                }
                d2 = 2.0 / (1.0 + d4) * physicalOption.expectedDmg;
                d = 0.2 * (double)entity.getWeight() * d3 * (1.0 - cEntity.base_psr_odds);
                Hex hex = this.game.board.getHex(physicalOption.target.getPosition());
                Hex hex2 = this.game.board.getHex(entity.getPosition());
                if (hex2.getElevation() > hex.getElevation()) {
                    d2 *= 2.0;
                }
                Enumeration enumeration = this.game.getEntities();
                double d5 = 0.0;
                int n4 = 0;
                while (enumeration.hasMoreElements()) {
                    Entity entity2 = (Entity)enumeration.nextElement();
                    if (entity2.isProne() || entity2.getPosition().distance(entity.getPosition()) >= 3) continue;
                    if (entity2.isEnemyOf(entity)) {
                        ++n4;
                        continue;
                    }
                    --n4;
                }
                if (n4 > 0) {
                    d += (double)n4 * d5;
                }
                if (!(d2 > d && (!(cEntity.overall_armor_percent > 0.8) || !(d3 > 0.9)) || d3 < 0.5 && cEntity.base_psr_odds > 0.5)) {
                    boolean bl = false;
                    boolean bl2 = false;
                    ToHitData toHitData = megamek.common.Compute.toHitPunch(this.game, entity.getId(), physicalOption.target.getId(), 1);
                    if (toHitData.getValue() != Integer.MAX_VALUE) {
                        bl = true;
                    }
                    if ((toHitData = megamek.common.Compute.toHitPunch(this.game, entity.getId(), physicalOption.target.getId(), 2)).getValue() != Integer.MAX_VALUE) {
                        bl2 = true;
                    }
                    if (bl) {
                        physicalOption.type = bl2 ? 3 : 1;
                    } else if (bl2) {
                        physicalOption.type = 2;
                    } else {
                        this.sendReady(true);
                        return;
                    }
                }
            }
            Vector<AbstractAttackAction> vector = new Vector<AbstractAttackAction>();
            vector.addElement(physicalOption.toAction(this.game, n));
            this.sendAttackData(n, vector);
            this.sendEntityReady(n);
            this.sendReady(true);
            return;
        } while ((n = this.game.getNextEntityNum(this.getLocalPlayer(), n)) != -1 && n != n2);
        this.sendReady(true);
    }

    public com.sun.java.util.collections.Vector getEntitiesOwned() {
        com.sun.java.util.collections.Vector vector = new com.sun.java.util.collections.Vector();
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!entity.getOwner().equals(this.getLocalPlayer())) continue;
            vector.add((Object)entity);
        }
        return vector;
    }

    protected com.sun.java.util.collections.Vector getEnemyEntities() {
        com.sun.java.util.collections.Vector vector = new com.sun.java.util.collections.Vector();
        Object var2_2 = null;
        Entity entity = null;
        Iterator iterator = this.getEntitiesOwned().iterator();
        if (!iterator.hasNext()) {
            return vector;
        }
        entity = (Entity)iterator.next();
        Vector vector2 = this.game.getValidTargets(entity);
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        return vector;
    }

    public void calculateMoveTurn() {
        int n;
        Object object;
        Object object2;
        Object object3;
        int n2 = 0;
        EntityState entityState = null;
        boolean bl = this.game.getOptions().booleanOption("inf_move_last");
        boolean bl2 = this.game.getOptions().booleanOption("inf_move_multi");
        if (this.game.getTurn().getEntityNum() != -1) {
            object3 = this.game.getEntity(this.game.getTurn().getEntityNum());
            enemies.get((Entity)object3).refresh();
            TestBot.enemies.get((Entity)object3).moved = false;
        }
        object3 = this.getEnemyEntities().toArray();
        int n3 = 0;
        while (n3 < ((Object[])object3).length) {
            if (!((Entity)object3[n3]).isSelectable()) {
                ++n2;
            }
            ++n3;
        }
        if (n2 == this.enemies_moved && this.old_moves != null) {
            entityState = this.old_moves.getResult();
            if (entityState == null) {
                return;
            }
            if (!entityState.isMoveLegal() || entityState.isPhysical && entityState.PhysicalTarget.isPhysicalTarget) {
                this.old_moves = null;
                this.calculateMoveTurn();
                return;
            }
        } else {
            Object object4;
            Object object5;
            this.enemies_moved = n2;
            com.sun.java.util.collections.Vector vector = new com.sun.java.util.collections.Vector();
            object2 = new com.sun.java.util.collections.Vector();
            object = this.getEntitiesOwned().iterator();
            n = 0;
            Object var11_12 = null;
            boolean bl3 = false;
            while (object.hasNext()) {
                object5 = (Entity)object.next();
                object4 = enemies.get((Entity)object5);
                if (this.game.getTurn().getEntityNum() != -1 && ((Entity)object5).getId() != this.game.getTurn().getEntityNum()) continue;
                MoveThread moveThread = new MoveThread((Entity)object5);
                System.out.println("Contimplating movement of " + ((Entity)object5).getShortName() + " " + ((Entity)object5).getId());
                moveThread.start();
                try {
                    moveThread.join();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (bl2 && this.turnInfMoved % 3 > 0 && !(object5 instanceof Infantry)) {
                    if (this.game.hasInfantry(this.local_pn)) continue;
                    this.turnInfMoved = 0;
                    vector.add((Object)moveThread.result);
                } else if (bl && this.turnInfMoved == 0 && object5 instanceof Infantry) {
                    object2.add((Object)moveThread.result);
                } else if (!((CEntity)object4).moved) {
                    vector.add((Object)moveThread.result);
                }
                if (((CEntity)object4).entity.isImmobile() && !((CEntity)object4).moved) {
                    ((CEntity)object4).moved = true;
                    this.calculateMoveTurn();
                    return;
                }
                if (((CEntity)object4).moved || moveThread.result.length >= 6) continue;
                entityState = moveThread.result[0];
                bl3 = true;
            }
            if (vector.size() <= 0) {
                vector = object2;
            }
            object2 = null;
            if (!bl3) {
                if (this.getEntitiesOwned().size() > 1) {
                    try {
                        object5 = new GALance(this, vector, 50, 80);
                        object4 = new Thread((Runnable)object5);
                        ((Thread)object4).start();
                        ((Thread)object4).join();
                        entityState = ((GALance)object5).getResult();
                        this.old_moves = object5;
                    }
                    catch (GAException gAException) {
                        System.out.println(gAException.getMessage());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    entityState = ((EntityState[])vector.elementAt(0))[0];
                }
            }
        }
        int n4 = 0;
        while (n4 < ((Object[])object3).length) {
            object2 = (Entity)object3[n4];
            object = enemies.get((Entity)object2);
            int n5 = n = Compute.getThreatHitArc(object.old.curPos, object.old.curFacing, entityState.curPos);
            object.expected_damage[n5] = object.expected_damage[n5] + entityState.damages[n4];
            if (object.expected_damage[n] > 0.0) {
                object.hasTakenDamage = true;
            }
            ++n4;
        }
        if (entityState.isPhysical) {
            entityState.PhysicalTarget.isPhysicalTarget = true;
        }
        object2 = entityState.tv.iterator();
        object = "";
        while (object2.hasNext()) {
            object = (String)object + object2.next() + " ";
        }
        System.out.println(entityState.entity.getShortName() + " " + entityState.entity.getId() + " to " + entityState.getKey() + " from " + TestBot.enemies.get((Entity)entityState.entity).old.getKey() + " " + entityState + "\n Utility: " + entityState.getUtility() + " \n" + (String)object + "\n");
        this.sendChat("Moved " + entityState.entity.getShortName() + " to " + entityState.curPos);
        ++this.my_mechs_moved;
        if (entityState.entity instanceof Infantry) {
            ++this.turnInfMoved;
        }
        this.moveEntity(entityState.entity.getId(), entityState.getMovementData());
        entityState.centity.moved = true;
        entityState.centity.old = entityState;
        entityState.centity.last = entityState;
        this.sendReady(true);
    }

    public EntityState[] calculateMove(Entity entity) {
        int n;
        int n2;
        Object object;
        Object object2;
        int n3;
        int n4;
        Object object3;
        int n5;
        Object object4;
        Object[] objectArray = Compute.vectorToArray(this.game.getValidTargets(entity));
        CEntity cEntity = enemies.get(entity);
        EntityState entityState = cEntity.old;
        Object[] objectArray2 = entity.isSelectable() && !cEntity.moved ? cEntity.getAllMoves().toArray() : new Object[]{entityState};
        Compute.randomize(objectArray2);
        EntityState.Table table = new EntityState.Table();
        com.sun.java.util.collections.Vector vector = new com.sun.java.util.collections.Vector();
        Iterator iterator = this.getEntitiesOwned().iterator();
        while (iterator.hasNext()) {
            object4 = (Entity)iterator.next();
            if (((Entity)object4).getId() == entity.getId()) continue;
            vector.add((Object)new EntityState(TestBot.enemies.get((Entity)object4).old));
        }
        object4 = vector.toArray();
        int n6 = 0;
        while (n6 < objectArray2.length + ((Object)object4).length) {
            EntityState entityState2 = null;
            entityState2 = n6 >= objectArray2.length ? (EntityState)object4[n6 - objectArray2.length] : (EntityState)objectArray2[n6];
            entityState2.setState();
            if (this.game.getBoard().contains(entityState2.entity.getPosition())) {
                if (entityState2.damages == null) {
                    entityState2.damages = new double[objectArray.length];
                }
                if (entityState2.threats == null) {
                    entityState2.threats = new double[objectArray.length];
                }
                if (entityState2.max_threats == null) {
                    entityState2.max_threats = new double[objectArray.length];
                }
                if (entityState2.min_damages == null) {
                    entityState2.min_damages = new double[objectArray.length];
                }
                n5 = 0;
                while (n5 < objectArray.length) {
                    double d;
                    Entity entity2 = (Entity)objectArray[n5];
                    object3 = enemies.get(entity2);
                    n4 = Compute.getThreatHitArc(((CEntity)object3).old.curPos, ((CEntity)object3).old.curFacing, entityState2.curPos);
                    n3 = Compute.getThreatHitArc(entityState2.curPos, entityState2.curFacing, ((CEntity)object3).old.curPos);
                    object2 = entityState2.getModifiers(((CEntity)object3).entity);
                    if (!((CEntity)object3).entity.isImmobile() && object2[1] != Integer.MAX_VALUE) {
                        cEntity.engaged = true;
                        object = object2[1];
                        d = entityState2.getMaxModifiedDamage(((CEntity)object3).old, enemies.get(entity2), (int)object, (int)object2[3]);
                        if (entity2.isSelectable()) {
                            ((CEntity)object3).old.curFacing = (((CEntity)object3).old.curFacing + 1) % 6;
                            d = Math.max(entityState2.getMaxModifiedDamage(((CEntity)object3).old, enemies.get(entity2), object + 1, (int)object2[3]), d);
                            ((CEntity)object3).old.curFacing = (((CEntity)object3).old.curFacing + 4) % 6;
                            d = Math.max(entityState2.getMaxModifiedDamage(((CEntity)object3).old, enemies.get(entity2), object + 1, (int)object2[3]), d);
                            ((CEntity)object3).old.curFacing = (((CEntity)object3).old.curFacing + 1) % 6;
                        }
                        d = cEntity.getThreatUtility(d, n3);
                        if (((CEntity)object3).entity.isProne()) {
                            d *= 0.6;
                        }
                        entityState2.threats[n5] = d;
                        entityState2.max_threats[n5] = d;
                        entityState2.threat += d;
                        entityState2.tv.add((Object)(d + " Threat " + n5 + "\n"));
                    }
                    if (!entityState2.isPhysical) {
                        if (object2[0] != Integer.MAX_VALUE) {
                            cEntity.engaged = true;
                            double d2 = ((CEntity)object3).old.getMaxModifiedDamage(entityState2, cEntity, (int)object2[0], (int)object2[2]);
                            entityState2.damages[n5] = d2 = ((CEntity)object3).getThreatUtility(d2, n4);
                            entityState2.min_damages[n5] = d2;
                            entityState2.tv.add((Object)(d2 + " Damage " + n5 + "\n"));
                            entityState2.damage = Math.max(d2, entityState2.damage);
                        }
                    } else {
                        try {
                            if (entityState2.PhysicalTarget.entity.getId() == ((CEntity)object3).entity.getId()) {
                                if (!entityState2.PhysicalTarget.isPhysicalTarget) {
                                    MovementData movementData;
                                    ToHitData toHitData = null;
                                    d = 0.0;
                                    double d3 = 0.0;
                                    if (entityState2.isJumping) {
                                        cEntity.old.setState();
                                        movementData = entityState2.getMovementData();
                                        toHitData = megamek.common.Compute.toHitDfa(this.game, entityState2.entity.getId(), entityState2.PhysicalTarget.entity.getId(), movementData);
                                        d3 = 2 * megamek.common.Compute.getDfaDamageFor(entityState2.entity);
                                        d = entityState2.centity.getThreatUtility(megamek.common.Compute.getDfaDamageTakenBy(entityState2.entity), 1) * megamek.common.Compute.oddsAbove(toHitData.getValue()) / 100.0;
                                        d += entityState2.centity.getThreatUtility(0.1 * (double)cEntity.entity.getWeight(), 1);
                                        d *= (double)(100.0f / entityState2.centity.entity.getWeight());
                                    } else {
                                        cEntity.old.setState();
                                        movementData = entityState2.getMovementData();
                                        toHitData = megamek.common.Compute.toHitCharge(this.game, entityState2.entity.getId(), entityState2.PhysicalTarget.entity.getId(), movementData);
                                        d3 = megamek.common.Compute.getChargeDamageFor(entityState2.entity, movementData.getHexesMoved());
                                        d = entityState2.centity.getThreatUtility(megamek.common.Compute.getChargeDamageTakenBy(entityState2.entity, entityState2.PhysicalTarget.entity), 0) * (megamek.common.Compute.oddsAbove(toHitData.getValue()) / 100.0);
                                        entityState2.setState();
                                    }
                                    d3 = entityState2.PhysicalTarget.getThreatUtility(d3, toHitData.getSideTable()) * megamek.common.Compute.oddsAbove(toHitData.getValue()) / 100.0;
                                    if (!entityState2.isJumping) {
                                        d3 *= Math.sqrt((double)((CEntity)object3).bv / (double)cEntity.bv);
                                    }
                                    if (toHitData.getValue() > 10) {
                                        d3 = 0.0;
                                    }
                                    if (toHitData.getValue() < 8) {
                                        d3 *= 1.5;
                                    }
                                    if (cEntity.RangeDamages[0] < 5.0) {
                                        d3 *= 2.0;
                                    }
                                    entityState2.damages[n5] = d3;
                                    entityState2.min_damages[n5] = d3;
                                    entityState2.damage = d3;
                                    entityState2.movement_threat += d;
                                } else {
                                    entityState2.threat += 2.147483647E9;
                                }
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            entityState2.threat += 2.147483647E9;
                        }
                    }
                    ++n5;
                }
                cEntity.old.setState();
            }
            ++n6;
        }
        Arrays.sort((Object[])objectArray2);
        int n7 = 50;
        if (((Object)object4).length > 1) {
            n7 = 100;
        }
        n5 = 0;
        while (n5 < n7 && n5 < objectArray2.length) {
            table.put((EntityState)objectArray2[n5]);
            ++n5;
        }
        Arrays.sort((Object[])objectArray2, (Comparator)new Comparator(){

            public int compare(Object object, Object object2) {
                if (((EntityState)object).damage - 0.5 * ((EntityState)object).getUtility() > ((EntityState)object2).damage - 0.5 * ((EntityState)object2).getUtility()) {
                    return -1;
                }
                return 1;
            }
        });
        int n8 = 0;
        while (n8 < n7 && n8 < objectArray2.length) {
            table.put((EntityState)objectArray2[n8]);
            ++n8;
        }
        if (((Object)object4).length > 1) {
            objectArray2 = table.values().toArray();
            table.clear();
            object3 = new double[objectArray.length];
            n4 = 0;
            while (n4 < objectArray2.length) {
                EntityState entityState3 = (EntityState)objectArray2[n4];
                int n9 = 0;
                while (n9 < objectArray.length) {
                    Entity entity3 = (Entity)objectArray[n9];
                    CEntity cEntity2 = enemies.get(entity3);
                    if (entityState3.damages[n9] > 0.0) {
                        n2 = 0;
                        while (n2 < ((Object)object4).length) {
                            EntityState entityState4 = (EntityState)object4[n2];
                            double d = 1.0;
                            if (entityState4.damages[n9] > 0.0) {
                                entityState3.damage = entityState3.damage + (cEntity2.canMove() ? 0.1 : 0.2) * entityState3.damages[n9];
                                d += entityState4.centity.canMove() ? 0.4 : 0.6;
                            }
                            entityState3.threat -= entityState3.threats[n9];
                            int n10 = n9;
                            entityState3.threats[n10] = entityState3.threats[n10] / d;
                            entityState3.threat += entityState3.threats[n9];
                            ++n2;
                        }
                    }
                    ++n9;
                }
                ++n4;
            }
            Arrays.sort((Object[])objectArray2);
            n7 = 50;
            n3 = 0;
            while (n3 < n7 && n3 < objectArray2.length) {
                table.put((EntityState)objectArray2[n3]);
                ++n3;
            }
            Arrays.sort((Object[])objectArray2, (Comparator)new Comparator(){

                public int compare(Object object, Object object2) {
                    if (((EntityState)object).damage - 0.5 * ((EntityState)object).getUtility() > ((EntityState)object2).damage - 0.5 * ((EntityState)object2).getUtility()) {
                        return -1;
                    }
                    return 1;
                }
            });
            int n11 = 0;
            while (n11 < n7 && n11 < objectArray2.length) {
                table.put((EntityState)objectArray2[n11]);
                ++n11;
            }
        }
        objectArray2 = table.values().toArray();
        table.clear();
        int n12 = 0;
        while (n12 < objectArray2.length) {
            int n13;
            EntityState entityState5 = (EntityState)objectArray2[n12];
            entityState5.setState();
            double d = 0.0;
            double d4 = 0.0;
            n2 = 0;
            while (n2 < objectArray.length) {
                Entity entity4 = (Entity)objectArray[n2];
                CEntity cEntity3 = enemies.get(entity4);
                int n14 = cEntity.old.curPos.distance(cEntity3.old.curPos);
                int n15 = entityState5.curPos.distance(cEntity3.old.curPos);
                if (n15 > cEntity.long_range) {
                    d4 += (n15 >= cEntity3.long_range ? 0.5 : 1.0) * (1.0 + cEntity.RangeDamages[cEntity.Range]) * Math.max((double)(n15 - cEntity.long_range) - 0.5 * Math.max((double)cEntity.jumpMP, 0.8 * (double)cEntity.runMP), 0.0);
                }
                if (cEntity.Range == 0 && (n14 > 5 || n15 > 9) || cEntity.RangeDamages[0] < 4.0 && n14 > 10) {
                    d4 += (cEntity3.Range > 0 ? 0.5 : 1.0) * Math.max(1.0 + cEntity.RangeDamages[0], 5.0) * Math.max((double)n15 - 0.5 * Math.max((double)cEntity.jumpMP, 0.8 * (double)cEntity.runMP), 0.0);
                } else if (cEntity.Range == 1) {
                    d4 += (n14 < 6 || n14 > 12 ? 1.0 : 0.25) * (cEntity3.Range > 0 ? 0.5 : 1.0) * (1.0 + cEntity.RangeDamages[1]) * Math.abs((double)n15 - 0.5 * Math.max((double)cEntity.jumpMP, 0.8 * (double)cEntity.runMP));
                } else if (entityState5.damage < 0.25 * cEntity.RangeDamages[2]) {
                    d4 += (n15 < 10 ? 0.25 : 1.0) * Math.max(1.0 + cEntity.RangeDamages[2], 3.0) * (1.0 / (1.0 + entityState5.threat));
                }
                d += Math.sqrt(d4 * (double)cEntity3.bv / (double)cEntity.bv);
                if (!cEntity3.entity.isProne() && !cEntity3.entity.isImmobile() && Compute.getThreatHitArc(entityState5.curPos, entityState5.curFacing, cEntity3.entity.getPosition()) != 0 && (n13 = Compute.getFiringAngle(entityState5.curPos, entityState5.curFacing, cEntity3.entity.getPosition())) > 90 && n13 < 270) {
                    n = entityState5.curPos.distance(cEntity3.old.curPos);
                    double d5 = 1.0;
                    if (n13 > 130 && n13 < 240) {
                        d5 = 2.0;
                    }
                    entityState5.self_threat += (d5 *= (double)(Math.max((double)cEntity.jumpMP, 0.8 * (double)cEntity.runMP) < 5.0 ? 2 : 1) * ((double)cEntity.bv / 50.0) * Math.sqrt((double)cEntity.bv / (double)cEntity3.bv) / ((double)n / 6.0 + 1.0));
                    entityState5.tv.add((Object)(d5 + " " + n13 + " Back to enemy\n"));
                }
                ++n2;
            }
            d *= cEntity.overall_armor_percent * cEntity.strategy.attack / (double)objectArray.length;
            Hex hex = this.game.board.getHex(entityState5.curPos);
            if (hex.contains(4) && hex.surface() > cEntity.entity.elevation() + (entityState5.isProne ? 0 : 1)) {
                double d6 = cEntity.entity.heat + entityState5.getMovementheatBuildup() <= 7 ? 100.0 : 30.0;
                d += (double)cEntity.bv / d6;
            }
            if (cEntity.Range > 0) {
                int n16 = this.game.board.getHex(entityState5.curPos).getElevation() - this.game.board.getHex(cEntity.old.curPos).getElevation();
                d -= (double)(Math.max(n16, 0) + 1) * ((double)megamek.common.Compute.getTargetTerrainModifier(this.game, entityState5.entity.getId()).getValue() + 1.0);
            }
            if (entityState5.damage < 0.25 * cEntity.RangeDamages[cEntity.Range] && d < cEntity.RangeDamages[cEntity.Range]) {
                int n17 = 0;
                while (n17 < objectArray.length) {
                    Entity entity5 = (Entity)objectArray[n17];
                    CEntity cEntity4 = enemies.get(entity5);
                    n13 = entityState5.curPos.distance(cEntity4.old.curPos);
                    if (n13 > 5) {
                        d += Math.pow(cEntity.overall_armor_percent, 2.0) * Math.sqrt((double)(n13 - 4) * (double)cEntity4.bv / (double)cEntity.bv) / (double)objectArray.length;
                    }
                    ++n17;
                }
            }
            if (entityState5.damage < 0.25 * (1.0 + cEntity.RangeDamages[cEntity.Range])) {
                entityState5.self_threat += 2.0 * d;
            } else if (entityState5.damage < 0.5 * (1.0 + cEntity.RangeDamages[cEntity.Range])) {
                entityState5.self_threat += d;
            }
            entityState5.tv.add((Object)(entityState5.self_threat + " Initial Damage Adjustment " + "\n"));
            ++n12;
        }
        Arrays.sort((Object[])objectArray2);
        int n18 = 0;
        while (n18 < 30 && n18 < objectArray2.length) {
            table.put((EntityState)objectArray2[n18]);
            ++n18;
        }
        Arrays.sort((Object[])objectArray2, (Comparator)new Comparator(){

            public int compare(Object object, Object object2) {
                if (((EntityState)object).damage - ((EntityState)object).getUtility() > ((EntityState)object2).damage - ((EntityState)object2).getUtility()) {
                    return -1;
                }
                return 1;
            }
        });
        int n19 = 0;
        while (n19 < 30 && n19 < objectArray2.length) {
            table.put((EntityState)objectArray2[n19]);
            ++n19;
        }
        object2 = table.values().iterator();
        while (object2.hasNext()) {
            EntityState entityState6 = (EntityState)object2.next();
            entityState6.setState();
            entityState6.self_damage *= 0.5;
            entityState6.self_threat *= 0.5;
            double d = 2.0 * (double)megamek.common.Compute.getTargetTerrainModifier(this.game, entityState6.entity.getId()).getValue();
            entityState6.tv.add((Object)(d + " Terrain Adjusment " + "\n"));
            entityState6.self_threat -= d;
        }
        objectArray2 = table.values().toArray();
        table.clear();
        object = 0;
        while (object < objectArray.length) {
            Entity entity6 = (Entity)objectArray[object];
            CEntity cEntity5 = enemies.get(entity6);
            if (cEntity5.canMove()) {
                Object[] objectArray3 = cEntity5.calculateCounterMoves().toArray();
                com.sun.java.util.collections.Vector vector2 = new com.sun.java.util.collections.Vector();
                int n20 = 0;
                while (n20 < objectArray2.length) {
                    EntityState entityState7 = null;
                    vector2.clear();
                    entityState7 = (EntityState)objectArray2[n20];
                    entityState7.setState();
                    com.sun.java.util.collections.Vector vector3 = new com.sun.java.util.collections.Vector();
                    Coords coords = entityState7.curPos.translated((entityState7.curFacing + 3) % 6);
                    vector3.add((Object)coords);
                    vector3.add((Object)coords.translated((entityState7.curFacing + 2) % 6));
                    vector3.add((Object)coords.translated((entityState7.curFacing + 4) % 6));
                    vector3.add((Object)entityState7.curPos.translated(entityState7.curFacing));
                    vector3.add((Object)entityState7.curPos.translated((entityState7.curFacing + 1) % 6));
                    vector3.add((Object)entityState7.curPos.translated((entityState7.curFacing + 2) % 6));
                    vector3.add((Object)entityState7.curPos.translated((entityState7.curFacing + 4) % 6));
                    vector3.add((Object)entityState7.curPos.translated((entityState7.curFacing + 5) % 6));
                    Iterator iterator2 = vector3.iterator();
                    while (iterator2.hasNext()) {
                        Coords coords2 = (Coords)iterator2.next();
                        com.sun.java.util.collections.Vector vector4 = cEntity5.findMoves(coords2);
                        if (vector4.size() == 0) continue;
                        vector2.addAll((Collection)vector4);
                    }
                    int n21 = entityState7.curPos.distance(cEntity5.old.curPos);
                    int n22 = 0;
                    if (cEntity5.long_range > n21 - Math.max(cEntity5.jumpMP, cEntity5.runMP)) {
                        n22 = 30;
                    } else if (cEntity5.long_range > n21) {
                        n22 = 10;
                    }
                    double d = this.enemies_moved / this.getEnemyEntities().size();
                    n22 = (int)((double)n22 * (1.0 + d));
                    int n23 = 0;
                    while (n23 <= n22 && n23 < objectArray3.length) {
                        if (objectArray3.length < n22) {
                            vector2.add(objectArray3[n23]);
                        } else {
                            int n24 = megamek.common.Compute.random.nextInt(objectArray3.length);
                            if (n24 % 2 == 1) {
                                vector2.add(objectArray3[n24]);
                            } else {
                                vector2.add(objectArray3[n23]);
                            }
                        }
                        ++n23;
                    }
                    Iterator iterator3 = vector2.iterator();
                    while (iterator3.hasNext()) {
                        int[] nArray;
                        EntityState entityState8 = (EntityState)iterator3.next();
                        double d7 = 0.0;
                        double d8 = 0.0;
                        entityState8.setState();
                        int n25 = Compute.getThreatHitArc(entityState8.curPos, entityState8.curFacing, entityState7.curPos);
                        int n26 = Compute.getThreatHitArc(entityState8.curPos, entityState8.curFacing, entityState7.curPos);
                        if (entityState8.isJumping) {
                            n25 = 1;
                        }
                        if ((nArray = entityState7.getModifiers(entityState8.entity))[1] != Integer.MAX_VALUE) {
                            cEntity.engaged = true;
                            d7 = !entityState8.isJumping ? entityState7.getMaxModifiedDamage(entityState8, enemies.get(entity6), nArray[1], nArray[3]) : 0.8 * cEntity5.getModifiedDamage(nArray[3] == 1 ? 4 : 0, entityState8.curPos.distance(entityState7.curPos), nArray[1]);
                            d7 = cEntity.getThreatUtility(d7, n26);
                        }
                        if (nArray[0] != Integer.MAX_VALUE) {
                            cEntity.engaged = true;
                            d8 = entityState8.getMaxModifiedDamage(entityState7, cEntity, nArray[0], nArray[2]);
                            d8 = cEntity5.getThreatUtility(d8, n25);
                            if (entityState7.isPhysical) {
                                d8 = entityState7.PhysicalTarget.entity.getId() == cEntity5.entity.getId() ? entityState7.damages[object] : 0.0;
                            }
                        }
                        entityState7.max_threats[object] = Math.max(d7, entityState7.max_threats[object]);
                        entityState7.min_damages[object] = Math.min(entityState7.min_damages[object], d8);
                        if (!(d7 - d8 > entityState7.threats[object] - entityState7.damages[object])) continue;
                        entityState7.threats[object] = d7;
                        entityState7.damages[object] = d8;
                        entityState7.tv.add((Object)(d7 + " Spec Threat " + object + "\n"));
                        entityState7.tv.add((Object)(d8 + " Spec Damage " + object + "\n"));
                    }
                    entityState7.damage = 0.0;
                    entityState7.threat = 0.0;
                    int n27 = 0;
                    while (n27 < entityState7.damages.length) {
                        CEntity cEntity6 = enemies.get((Entity)objectArray[object]);
                        Object object5 = object;
                        entityState7.min_damages[object5] = entityState7.min_damages[object5] / cEntity6.strategy.target;
                        Object object6 = object;
                        entityState7.damages[object6] = entityState7.damages[object6] / cEntity6.strategy.target;
                        entityState7.damage += (entityState7.min_damages[object] + entityState7.damages[object]) / 2.0;
                        entityState7.threat = Math.max(entityState7.threat, entityState7.max_threats[object] + entityState7.threats[object]) / 2.0;
                        entityState7.threats[object] = (entityState7.max_threats[object] + 2.0 * entityState7.threats[object]) / 3.0;
                        ++n27;
                    }
                    ++n20;
                }
                cEntity5.old.setState();
            }
            cEntity.old.setState();
            ++object;
        }
        Arrays.sort((Object[])objectArray2);
        int n28 = 0;
        while (n28 < 30 && n28 < objectArray2.length) {
            table.put((EntityState)objectArray2[n28]);
            ++n28;
        }
        Iterator iterator4 = table.values().iterator();
        while (iterator4.hasNext()) {
            EntityState entityState9 = (EntityState)iterator4.next();
            entityState9.self_threat *= 0.5;
            entityState9.self_damage *= 0.5;
        }
        objectArray2 = table.values().toArray();
        table.clear();
        if (cEntity.engaged) {
            int n29 = 0;
            while (n29 < objectArray2.length) {
                EntityState entityState10 = (EntityState)objectArray2[n29];
                entityState10.setState();
                GAAttack gAAttack = this.bestAttack(entityState10);
                Object var24_73 = null;
                entityState10.damage = gAAttack != null ? (entityState10.damage + gAAttack.getFittestChromosomesFitness()) / 2.0 : (entityState10.damage /= 2.0);
                int n30 = 0;
                while (n30 < objectArray.length) {
                    Entity entity7 = (Entity)objectArray[n30];
                    CEntity cEntity7 = enemies.get(entity7);
                    if (!cEntity7.canMove()) {
                        entityState10.threats[n30] = (entityState10.threats[n30] + this.attackUtility(cEntity7.old, cEntity)) / 2.0;
                        entityState10.tv.add((Object)(entityState10.threats[n30] + " Revised Threat " + n30 + " \n"));
                        if (!entityState10.isPhysical) {
                            if (gAAttack != null) {
                                entityState10.damages[n30] = (entityState10.damages[n30] + gAAttack.getDamageUtility(cEntity7)) / 2.0;
                                entityState10.tv.add((Object)(entityState10.damages[n30] + " Revised Damage " + n30 + " \n"));
                            } else {
                                entityState10.damages[n30] = entityState10.min_damages[n30];
                                entityState10.tv.add((Object)(entityState10.damages[n30] + " Revised Damage " + n30 + " \n"));
                            }
                            if (entityState10.curPos.distance(cEntity7.old.curPos) == 1) {
                                BotClient.PhysicalOption physicalOption = this.getBestPhysicalAttack(entityState10.entity.getId(), cEntity7.entity.getId());
                                if (physicalOption != null) {
                                    int n31 = n30;
                                    entityState10.damages[n31] = entityState10.damages[n31] + physicalOption.expectedDmg;
                                    entityState10.tv.add((Object)(physicalOption.expectedDmg + " Physical Damage " + n30 + " \n"));
                                }
                                if ((physicalOption = this.getBestPhysicalAttack(cEntity7.entity.getId(), entityState10.entity.getId())) != null) {
                                    int n32 = n30;
                                    entityState10.threats[n32] = entityState10.threats[n32] + 0.5 * physicalOption.expectedDmg;
                                    entityState10.tv.add((Object)(0.5 * physicalOption.expectedDmg + " Physical Threat " + n30 + " \n"));
                                }
                            }
                        }
                    } else if (!entityState10.isPhysical) {
                        entityState10.damages[n30] = gAAttack != null ? (2.0 * entityState10.damages[n30] + gAAttack.getDamageUtility(cEntity7)) / 3.0 : entityState10.min_damages[n30];
                    } else {
                        int n33 = n30;
                        entityState10.damages[n33] = entityState10.damages[n33] / Math.sqrt((double)cEntity7.bv / (double)cEntity.bv);
                        entityState10.damage = entityState10.damages[n30];
                    }
                    ++n30;
                }
                entityState10.threat = 0.0;
                n = 0;
                while (n < entityState10.damages.length) {
                    entityState10.threat += entityState10.threats[n];
                    ++n;
                }
                entityState10.tv.add((Object)(entityState10.threat + " Revised Threat Utility\n"));
                entityState10.tv.add((Object)(entityState10.damage + " Revised Damage Utility\n"));
                ++n29;
            }
        }
        Arrays.sort((Object[])objectArray2);
        cEntity.old.setState();
        EntityState[] entityStateArray = new EntityState[Math.min(objectArray2.length, 20)];
        int n34 = 0;
        int n35 = 0;
        while (n35 < Math.min(objectArray2.length, 20)) {
            EntityState entityState11 = (EntityState)objectArray2[n35];
            if (entityState11.isPhysical && cEntity.RangeDamages[0] > 5.0 && entityState11.Doomed && n34 + 20 < objectArray2.length) {
                entityState11 = (EntityState)objectArray2[n34 + 20];
                ++n34;
            }
            entityStateArray[n35] = entityState11;
            ++n35;
        }
        return entityStateArray;
    }

    protected com.sun.java.util.collections.Vector calculateWeaponAttacks(Entity entity, Mounted mounted) {
        return this.calculateWeaponAttacks(entity, mounted, false);
    }

    protected void initFiring() {
        Object object;
        Object object2;
        Object[] objectArray = Compute.vectorToArray(this.game.getEntitiesVector());
        int n = 0;
        while (n < objectArray.length) {
            object2 = (Entity)objectArray[n];
            object = enemies.get((Entity)object2);
            ((CEntity)object).reset();
            ((CEntity)object).enemy_num = n++;
        }
        object2 = this.getEnemyEntities().iterator();
        while (object2.hasNext()) {
            object = (Entity)object2.next();
            CEntity cEntity = enemies.get((Entity)object);
            if (!((Entity)object).isMakingDfa() && !((Entity)object).isCharging()) continue;
            cEntity.strategy.target = 2.5;
        }
    }

    protected com.sun.java.util.collections.Vector calculateWeaponAttacks(Entity entity, Mounted mounted, boolean bl) {
        int n = entity.getId();
        int n2 = entity.getEquipmentNum(mounted);
        com.sun.java.util.collections.Vector vector = new com.sun.java.util.collections.Vector();
        Enumeration enumeration = this.game.getValidTargets(entity).elements();
        AttackOption attackOption = null;
        AttackOption attackOption2 = new AttackOption(null, null, 0.0, null);
        Vector vector2 = new Vector();
        while (enumeration.hasMoreElements()) {
            double d;
            Serializable serializable;
            Entity entity2 = (Entity)enumeration.nextElement();
            CEntity cEntity = enemies.get(entity2);
            ToHitData toHitData = megamek.common.Compute.toHitWeapon(this.game, n, entity2.getId(), n2, vector2);
            if (toHitData.getValue() == Integer.MAX_VALUE || toHitData.getValue() >= 13) continue;
            if (entity instanceof Infantry) {
                serializable = (Infantry)entity;
                d = ((Infantry)serializable).getDamage(((Infantry)serializable).getShootingStrength());
            } else {
                d = Compute.getExpectedDamage((WeaponType)mounted.getType());
            }
            if (entity2 instanceof Infantry && !((Hex)(serializable = this.game.getBoard().getHex(entity2.getPosition()))).contains(1) && !((Hex)serializable).contains(10)) {
                d *= 2.0;
            }
            attackOption = new AttackOption(cEntity, mounted, d, toHitData);
            if (attackOption.value > attackOption2.value) {
                if (bl) {
                    attackOption2 = attackOption;
                    continue;
                }
                vector.add(0, (Object)attackOption);
                continue;
            }
            vector.add((Object)attackOption);
        }
        if (bl && attackOption2.target != null) {
            vector.add((Object)attackOption2);
        }
        if (vector.size() > 0) {
            vector.add((Object)new AttackOption(null, mounted, 0.0, null));
        }
        return vector;
    }

    public double attackUtility(EntityState entityState) {
        return this.attackUtility(entityState, null);
    }

    public GAAttack bestAttack(EntityState entityState) {
        Object object;
        int n = entityState.entity.getId();
        Entity entity = entityState.entity;
        int[] nArray = new int[3];
        com.sun.java.util.collections.Vector vector = new com.sun.java.util.collections.Vector();
        com.sun.java.util.collections.Vector vector2 = new com.sun.java.util.collections.Vector();
        com.sun.java.util.collections.Vector vector3 = new com.sun.java.util.collections.Vector();
        GAAttack gAAttack = null;
        int n2 = entity.getFacing();
        Enumeration enumeration = entity.getWeapons();
        while (enumeration.hasMoreElements()) {
            object = (Mounted)enumeration.nextElement();
            com.sun.java.util.collections.Vector vector4 = this.calculateWeaponAttacks(entity, (Mounted)object, true);
            if (vector4.size() > 0) {
                vector.add((Object)vector4);
                nArray[0] = Math.max(nArray[0], vector4.size());
            }
            if (!entity.isProne()) {
                entity.setSecondaryFacing((n2 + 5) % 6);
                vector4 = this.calculateWeaponAttacks(entity, (Mounted)object, true);
                if (vector4.size() > 0) {
                    vector2.add((Object)vector4);
                    nArray[1] = Math.max(nArray[1], vector4.size());
                }
                entity.setSecondaryFacing((n2 + 1) % 6);
                vector4 = this.calculateWeaponAttacks(entity, (Mounted)object, true);
                if (vector4.size() > 0) {
                    vector3.add((Object)vector4);
                    nArray[2] = Math.max(nArray[2], vector4.size());
                }
            }
            entity.setSecondaryFacing(n2);
        }
        object = new com.sun.java.util.collections.Vector();
        object.add((Object)vector);
        object.add((Object)vector2);
        object.add((Object)vector3);
        double d = 0.0;
        int[] nArray2 = null;
        int n3 = 0;
        int n4 = 0;
        while (n4 < object.size()) {
            com.sun.java.util.collections.Vector vector5 = (com.sun.java.util.collections.Vector)object.elementAt(n4);
            if (vector5.size() > 0) {
                try {
                    GAAttack gAAttack2 = new GAAttack(this.game, enemies.get(entity), vector5, Math.max((vector5.size() + nArray[n4]) * 2, 40), 30, entity.isEnemyOf((Entity)this.getEntitiesOwned().elementAt(0)));
                    Thread thread = new Thread(gAAttack2);
                    thread.start();
                    thread.join();
                    if (gAAttack2.getFittestChromosomesFitness() > d) {
                        d = gAAttack2.getFittestChromosomesFitness();
                        nArray2 = gAAttack2.getResultChromosome();
                        n3 = n4;
                        gAAttack = gAAttack2;
                    }
                }
                catch (GAException gAException) {
                    System.out.println(gAException.getMessage());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            ++n4;
        }
        return gAAttack;
    }

    public double attackUtility(EntityState entityState, CEntity cEntity) {
        Object object;
        int n = entityState.entity.getId();
        Entity entity = entityState.entity;
        int[] nArray = new int[3];
        com.sun.java.util.collections.Vector vector = new com.sun.java.util.collections.Vector();
        com.sun.java.util.collections.Vector vector2 = new com.sun.java.util.collections.Vector();
        com.sun.java.util.collections.Vector vector3 = new com.sun.java.util.collections.Vector();
        int n2 = entity.getFacing();
        Enumeration enumeration = entity.getWeapons();
        while (enumeration.hasMoreElements()) {
            object = (Mounted)enumeration.nextElement();
            com.sun.java.util.collections.Vector vector4 = this.calculateWeaponAttacks(entity, (Mounted)object, true);
            if (vector4.size() > 0) {
                vector.add((Object)vector4);
                nArray[0] = Math.max(nArray[0], vector4.size());
            }
            if (!entity.isProne()) {
                entity.setSecondaryFacing((n2 + 5) % 6);
                vector4 = this.calculateWeaponAttacks(entity, (Mounted)object, true);
                if (vector4.size() > 0) {
                    vector2.add((Object)vector4);
                    nArray[1] = Math.max(nArray[1], vector4.size());
                }
                entity.setSecondaryFacing((n2 + 1) % 6);
                vector4 = this.calculateWeaponAttacks(entity, (Mounted)object, true);
                if (vector4.size() > 0) {
                    vector3.add((Object)vector4);
                    nArray[2] = Math.max(nArray[2], vector4.size());
                }
            }
            entity.setSecondaryFacing(n2);
        }
        object = new com.sun.java.util.collections.Vector();
        object.add((Object)vector);
        object.add((Object)vector2);
        object.add((Object)vector3);
        double d = 0.0;
        int[] nArray2 = null;
        int n3 = 0;
        int n4 = 0;
        while (n4 < object.size()) {
            com.sun.java.util.collections.Vector vector5 = (com.sun.java.util.collections.Vector)object.elementAt(n4);
            if (vector5.size() > 0) {
                try {
                    GAAttack gAAttack = new GAAttack(this.game, enemies.get(entity), vector5, Math.max((vector5.size() + nArray[n4]) * 2, 20), 30, entity.isEnemyOf((Entity)this.getEntitiesOwned().elementAt(0)));
                    Thread thread = new Thread(gAAttack);
                    thread.start();
                    thread.join();
                    if (cEntity != null) {
                        d = Math.max(d, gAAttack.getDamageUtility(cEntity));
                    } else if (gAAttack.getFittestChromosomesFitness() > d) {
                        d = gAAttack.getFittestChromosomesFitness();
                        nArray2 = gAAttack.getResultChromosome();
                        n3 = n4;
                    }
                }
                catch (GAException gAException) {
                    System.out.println(gAException.getMessage());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            ++n4;
        }
        return d;
    }

    public void calculateFiringTurn() {
        Object object;
        com.sun.java.util.collections.Vector vector;
        Object object2;
        Object object3;
        Serializable serializable;
        int n;
        int n2 = n = this.game.getFirstEntityNum(this.getLocalPlayer());
        int n3 = n;
        double d = Double.MIN_VALUE;
        int[] nArray = null;
        com.sun.java.util.collections.Vector vector2 = null;
        int n4 = 0;
        boolean bl = this.game.getOptions().booleanOption("inf_move_last");
        boolean bl2 = this.game.getOptions().booleanOption("inf_move_multi");
        if (n2 == -1) {
            return;
        }
        do {
            Object object4;
            serializable = this.game.getEntity(n2);
            object3 = enemies.get((Entity)serializable);
            if (bl2 && this.turnInfMoved % 3 > 0 && !(serializable instanceof Infantry)) {
                if (this.game.hasInfantry(this.local_pn)) {
                    n2 = this.game.getNextEntityNum(this.getLocalPlayer(), n2);
                    continue;
                }
                this.turnInfMoved = 0;
            }
            object2 = new int[3];
            vector = new com.sun.java.util.collections.Vector();
            com.sun.java.util.collections.Vector vector3 = new com.sun.java.util.collections.Vector();
            object = new com.sun.java.util.collections.Vector();
            int n5 = ((Entity)serializable).getFacing();
            Enumeration enumeration = ((Entity)serializable).getWeapons();
            while (enumeration.hasMoreElements()) {
                object4 = (Mounted)enumeration.nextElement();
                com.sun.java.util.collections.Vector vector4 = this.calculateWeaponAttacks((Entity)serializable, (Mounted)object4);
                if (vector4.size() > 0) {
                    vector.add((Object)vector4);
                    object2[0] = Math.max(object2[0], vector4.size());
                }
                ((Entity)serializable).setSecondaryFacing((n5 + 5) % 6);
                vector4 = this.calculateWeaponAttacks((Entity)serializable, (Mounted)object4);
                if (vector4.size() > 0) {
                    vector3.add((Object)vector4);
                    object2[1] = Math.max(object2[1], vector4.size());
                }
                ((Entity)serializable).setSecondaryFacing((n5 + 1) % 6);
                vector4 = this.calculateWeaponAttacks((Entity)serializable, (Mounted)object4);
                if (vector4.size() > 0) {
                    object.add((Object)vector4);
                    object2[2] = Math.max(object2[2], vector4.size());
                }
                ((Entity)serializable).setSecondaryFacing(n5);
            }
            object4 = new com.sun.java.util.collections.Vector();
            object4.add((Object)vector);
            if (!((CEntity)object3).entity.isProne()) {
                object4.add((Object)vector3);
                object4.add(object);
            }
            int n6 = 0;
            while (n6 < object4.size()) {
                com.sun.java.util.collections.Vector vector5 = (com.sun.java.util.collections.Vector)object4.elementAt(n6);
                if (vector5.size() > 0) {
                    try {
                        GAAttack gAAttack = new GAAttack(this.game, enemies.get((Entity)serializable), vector5, Math.max((vector5.size() + object2[n6]) * 4, 50), 100, ((Entity)serializable).isEnemyOf((Entity)this.getEntitiesOwned().elementAt(0)));
                        Thread thread = new Thread(gAAttack);
                        thread.start();
                        thread.join();
                        if (gAAttack.getFittestChromosomesFitness() > d) {
                            d = gAAttack.getFittestChromosomesFitness();
                            nArray = gAAttack.getResultChromosome();
                            n4 = n6;
                            n3 = n2;
                            vector2 = (com.sun.java.util.collections.Vector)object4.elementAt(n4);
                        }
                    }
                    catch (GAException gAException) {
                        System.out.println(gAException.getMessage());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                ++n6;
            }
            n2 = this.game.getNextEntityNum(this.getLocalPlayer(), n2);
        } while (n2 != n && n2 != -1);
        serializable = new Vector();
        object3 = this.game.getEntity(n3);
        if (nArray != null) {
            object2 = (Entity)Compute.vectorToArray(this.game.getEntitiesVector())[nArray[nArray.length - 1]];
            vector = new TreeMap((Comparator)new AttackOptionSorter(enemies.get((Entity)object2)));
            int n7 = 0;
            while (n7 < nArray.length - 1) {
                object = (AttackOption)((com.sun.java.util.collections.Vector)vector2.elementAt(n7)).elementAt((int)nArray[n7]);
                if (object.target != null) {
                    int n8 = object.toHit.getSideTable();
                    object.target.expected_damage[n8] = object.target.expected_damage[n8] + object.value;
                    object.target.hasTakenDamage = true;
                    vector.put(object, object);
                }
                ++n7;
            }
            object = vector.values().iterator();
            while (object.hasNext()) {
                AttackOption attackOption = (AttackOption)object.next();
                ((Vector)serializable).addElement(new WeaponAttackAction(((Entity)object3).getId(), attackOption.target.entity.getId(), ((Entity)object3).getEquipmentNum(attackOption.weapon)));
            }
        }
        switch (n4) {
            case 1: {
                ((Vector)serializable).insertElementAt(new TorsoTwistAction(((Entity)object3).getId(), (((Entity)object3).getFacing() + 5) % 6), 0);
                break;
            }
            case 2: {
                ((Vector)serializable).insertElementAt(new TorsoTwistAction(((Entity)object3).getId(), (((Entity)object3).getFacing() + 1) % 6), 0);
            }
        }
        this.sendAttackData(n3, (Vector)serializable);
        this.sendEntityReady(n3);
        this.sendReady(true);
    }

    protected void initMovement() {
        InitMoveThread initMoveThread = new InitMoveThread();
        initMoveThread.start();
        try {
            initMoveThread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void preMovement() {
        CEntity cEntity;
        Entity entity;
        this.my_mechs_moved = 0;
        this.old_moves = null;
        this.enemies_moved = 0;
        double d = 1.4;
        Object[] objectArray = Compute.vectorToArray(this.game.getEntitiesVector());
        double d2 = Math.sqrt(objectArray.length) / 100.0;
        com.sun.java.util.collections.Vector vector = new com.sun.java.util.collections.Vector();
        com.sun.java.util.collections.Vector vector2 = new com.sun.java.util.collections.Vector();
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        CEntity cEntity2 = null;
        int n = 0;
        while (n < objectArray.length) {
            entity = (Entity)objectArray[n];
            cEntity = enemies.get(entity);
            cEntity.enemy_num = n;
            double d6 = (double)cEntity.bv * (cEntity.overall_armor_percent + 1.0);
            cEntity.reset();
            double d7 = (double)cEntity.bv * (cEntity.overall_armor_percent + 1.0);
            double d8 = 1.0 + (d7 - d6) / d6;
            if (entity.getOwner().equals(this.getLocalPlayer())) {
                vector.add((Object)cEntity);
                d3 += d7;
                if (d8 < 0.85) {
                    cEntity.strategy.attack = 0.85;
                } else if (d8 < 0.95) {
                    cEntity.strategy.attack = 1.0;
                } else if (d8 <= 1.0 && cEntity.strategy.attack < d) {
                    cEntity.strategy.attack = d8 == 1.0 ? (cEntity.strategy.attack < 1.0 ? Math.min(1.4 * cEntity.strategy.attack, 1.0) : (cEntity.strategy.attack *= 1.0 + d2)) : (cEntity.strategy.attack *= 1.0 + 2.0 * d2);
                }
            } else if (!entity.getOwner().isEnemyOf(this.getLocalPlayer())) {
                d3 += d7;
            } else {
                vector2.add((Object)cEntity);
                d4 += d7;
                if (d7 > d5) {
                    d5 = d7;
                    cEntity2 = cEntity;
                }
                if (this.getEntitiesOwned().size() > 2) {
                    if (cEntity.strategy.target > 2.0) {
                        cEntity.strategy.target = 1.0 + 0.5 * (cEntity.strategy.target - 2.0);
                    }
                    if (d8 < 0.85 && cEntity.strategy.target < d) {
                        cEntity.strategy.target *= 1.0 + 6.0 * d2;
                    } else if (d8 < 0.95 && cEntity.strategy.target < d) {
                        cEntity.strategy.target *= 1.0 + 4.0 * d2;
                    } else if (d8 <= 1.0) {
                        cEntity.strategy.target = d8 == 1.0 ? (cEntity.strategy.target /= 1.0 + 2.0 * d2) : (cEntity.strategy.target /= 1.0 + d2);
                    }
                    if (cEntity.strategy.target < 1.0) {
                        cEntity.strategy.target = 1.0;
                    }
                }
            }
            ++n;
        }
        this.NumFriends = vector.size();
        this.NumEnemies = vector2.size();
        System.out.println("Us " + d3 + " Them " + d4);
        if (this.unit_values.size() == 0) {
            this.unit_values.add((Object)new Double(d3));
            this.enemy_values.add((Object)new Double(d4));
            return;
        }
        entity = vector2.iterator();
        if (this.NumFriends > 1) {
            if (Strategy.MainTarget == null || null == this.game.getEntity(Strategy.MainTarget.entity.getId())) {
                Strategy.MainTarget = cEntity2;
            }
            Strategy.MainTarget.strategy.target += 0.2;
            while (entity.hasNext()) {
                cEntity = (CEntity)entity.next();
                if (d3 - d4 >= 0.9 * ((Double)this.unit_values.getLast() - (Double)this.enemy_values.getLast())) {
                    if (megamek.common.Compute.random.nextInt(2) == 1) {
                        cEntity.strategy.target += 0.3;
                    }
                } else if (d3 > 0.9 * d4) {
                    cEntity.strategy.target += 0.15;
                } else if (cEntity.strategy.target < 2.0) {
                    cEntity.strategy.target += 0.3;
                }
                System.out.println(cEntity.entity.getShortName() + " " + cEntity.strategy.target);
            }
        }
        double d9 = d3 / d4;
        double d10 = 1.0;
        if (d9 < 0.9) {
            d10 = 0.95;
        } else if (!(d9 < 1.0)) {
            d10 = 1.0 + d2;
        }
        entity = vector.iterator();
        while (entity.hasNext()) {
            CEntity cEntity3 = (CEntity)entity.next();
            if (!(d10 < 1.0 && cEntity3.strategy.attack < 0.6 || d10 > 1.0 && cEntity3.strategy.attack >= d)) {
                cEntity3.strategy.attack *= d10;
            }
            System.out.println(cEntity3.strategy.attack);
        }
        System.gc();
    }

    protected void processChat(GameEvent gameEvent) {
        if (gameEvent.getType() != 3) {
            return;
        }
        if (this.getLocalPlayer() == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(gameEvent.getMessage(), ":");
        if (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            Enumeration enumeration = this.game.getPlayers();
            boolean bl = false;
            Player player = null;
            while (enumeration.hasMoreElements() && !bl) {
                player = (Player)enumeration.nextElement();
                if (!string.equalsIgnoreCase(player.getName())) continue;
                bl = true;
            }
            if (bl) {
                try {
                    if (stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().trim().equalsIgnoreCase(this.getLocalPlayer().getName())) {
                        if (!player.isEnemyOf(this.getLocalPlayer())) {
                            if (stringTokenizer.hasMoreTokens()) {
                                int n;
                                int n2;
                                Entity entity;
                                String string2 = stringTokenizer.nextToken().trim();
                                boolean bl2 = false;
                                if (string2.equalsIgnoreCase("echo")) {
                                    bl2 = true;
                                }
                                if (string2.equalsIgnoreCase("calm down")) {
                                    Iterator iterator = this.getEntitiesOwned().iterator();
                                    while (iterator.hasNext()) {
                                        CEntity cEntity = enemies.get((Entity)iterator.next());
                                        if (!(cEntity.strategy.attack > 1.0)) continue;
                                        cEntity.strategy.attack = 1.0;
                                    }
                                    bl2 = true;
                                } else if (string2.equalsIgnoreCase("be aggressive")) {
                                    Iterator iterator = this.getEntitiesOwned().iterator();
                                    while (iterator.hasNext()) {
                                        CEntity cEntity = enemies.get((Entity)iterator.next());
                                        cEntity.strategy.attack = Math.min(cEntity.strategy.attack * 1.2, 1.5);
                                    }
                                    bl2 = true;
                                } else if (string2.equalsIgnoreCase("attack") && (entity = this.game.getFirstEntity(new Coords((n2 = Integer.parseInt(stringTokenizer.nextToken().trim())) - 1, (n = Integer.parseInt(stringTokenizer.nextToken().trim())) - 1))) != null && entity.isEnemyOf((Entity)this.getEntitiesOwned().elementAt(0))) {
                                    CEntity cEntity = enemies.get(entity);
                                    cEntity.strategy.target += 3.0;
                                    System.out.println(cEntity.entity.getShortName() + " " + cEntity.strategy.target);
                                    bl2 = true;
                                }
                                if (bl2) {
                                    this.sendChat("Understood " + player.getName());
                                }
                            }
                        } else {
                            this.sendChat("I can't do that, " + player.getName());
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        Frame frame2 = new Frame();
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        while (n3 <= 5) {
            Server server = new Server("hello", 2348);
            ConnectionThread connectionThread = new ConnectionThread("Player 1", 1, 0, frame);
            ConnectionThread connectionThread2 = new ConnectionThread("Player 2", 2, 1, frame2);
            System.gc();
            connectionThread.start();
            connectionThread2.start();
            try {
                connectionThread2.join();
                connectionThread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
            server.die();
            System.out.println("Trial " + n3 + " " + (n += ((BotClientWrapper)connectionThread.result.client).winner) + " " + (n2 += ((BotClientWrapper)connectionThread2.result.client).winner));
            System.gc();
            ++n3;
        }
        System.out.println("Player 1: " + n);
        System.out.println("Player 2: " + n2);
    }

    class InitMoveThread
    extends Thread {
        public InitMoveThread() {
            this.setPriority(1);
        }

        public void run() {
            TestBot.this.preMovement();
        }
    }

    class MoveThread
    extends Thread {
        Entity myEntity;
        EntityState[] result;

        public MoveThread(Entity entity) {
            this.myEntity = entity;
            this.setPriority(1);
        }

        public void run() {
            this.result = TestBot.this.calculateMove(this.myEntity);
        }
    }

    public static class AttackOption
    extends ToHitData {
        public CEntity target;
        public double value;
        public Mounted weapon;
        public ToHitData toHit;
        public double odds;
        public double primary_odds;
        public int heat;
        public double expected;
        public double primary_expected;
        public int ammoLeft = -1;

        public AttackOption(CEntity cEntity, Mounted mounted, double d, ToHitData toHitData) {
            this.target = cEntity;
            this.weapon = mounted;
            this.toHit = toHitData;
            this.value = d;
            if (cEntity != null) {
                AmmoType ammoType;
                WeaponType weaponType = (WeaponType)mounted.getType();
                this.primary_odds = megamek.common.Compute.oddsAbove(toHitData.getValue()) / 100.0;
                this.odds = megamek.common.Compute.oddsAbove(toHitData.getValue() + 1) / 100.0;
                this.heat = weaponType.getHeat();
                this.expected = this.odds * this.value;
                this.primary_expected = this.primary_odds * this.value;
                boolean bl = (weaponType.getFlags() & 0xF00) == 3840;
                boolean bl2 = !bl && weaponType.getAmmoType() != -1;
                Mounted mounted2 = bl2 ? mounted.getLinked() : null;
                AmmoType ammoType2 = ammoType = mounted2 == null ? null : (AmmoType)mounted2.getType();
                if (bl2 && (mounted2 == null || mounted2.getShotsLeft() == 0)) {
                    this.value = 0.0;
                } else if (bl2) {
                    this.ammoLeft = mounted2.getShotsLeft();
                }
            }
        }
    }

    public static class AttackOptionSorter
    implements Comparator {
        CEntity primary = null;

        public AttackOptionSorter(CEntity cEntity) {
            this.primary = cEntity;
        }

        public int compare(Object object, Object object2) {
            AttackOption attackOption = (AttackOption)object;
            AttackOption attackOption2 = (AttackOption)object2;
            if (attackOption.target.getKey().intValue() == attackOption2.target.getKey().intValue()) {
                WeaponType weaponType = (WeaponType)attackOption.weapon.getType();
                WeaponType weaponType2 = (WeaponType)attackOption2.weapon.getType();
                if (weaponType.getDamage() == -2) {
                    if (weaponType2.getDamage() == -2) {
                        if (attackOption.expected > attackOption2.expected) {
                            return -1;
                        }
                        return 1;
                    }
                    return 1;
                }
                if (weaponType.getDamage() == -2) {
                    return -1;
                }
                if (attackOption.expected > attackOption2.expected) {
                    return -1;
                }
                return 1;
            }
            if (attackOption.target.getKey().equals(this.primary.getKey())) {
                return -1;
            }
            return 1;
        }
    }
}

