/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.InputStream;
import megamek.common.Entity;
import megamek.common.EntityLoadingException;
import megamek.common.EquipmentType;
import megamek.common.Infantry;
import megamek.common.LocationFullException;
import megamek.common.MechLoader;
import megamek.common.util.BuildingBlock;

public class BLKInfantryFile
implements MechLoader {
    BuildingBlock dataFile;
    private static final String[] MOVES = new String[]{"", "Leg", "", "", "Motorized", "Jump"};

    public BLKInfantryFile(InputStream inputStream) {
        this.dataFile = new BuildingBlock(inputStream);
    }

    public BLKInfantryFile(BuildingBlock buildingBlock) {
        this.dataFile = buildingBlock;
    }

    public boolean isMine() {
        return this.dataFile.exists("blockversion");
    }

    public Entity getEntity() throws EntityLoadingException {
        Infantry infantry = new Infantry();
        if (!this.dataFile.exists("name")) {
            throw new EntityLoadingException("Could not find name block.");
        }
        infantry.setChassis(this.dataFile.getDataAsString("Name")[0]);
        if (!this.dataFile.exists("model")) {
            throw new EntityLoadingException("Could not find model block.");
        }
        infantry.setModel(this.dataFile.getDataAsString("Model")[0]);
        if (!this.dataFile.exists("year")) {
            throw new EntityLoadingException("Could not find year block.");
        }
        infantry.setYear(this.dataFile.getDataAsInt("year")[0]);
        if (!this.dataFile.exists("type")) {
            throw new EntityLoadingException("Could not find type block.");
        }
        if (this.dataFile.getDataAsString("type")[0].equals("IS")) {
            if (infantry.getYear() == 3025) {
                infantry.setTechLevel(0);
            } else {
                infantry.setTechLevel(1);
            }
        } else {
            infantry.setTechLevel(2);
        }
        if (!this.dataFile.exists("tonnage")) {
            throw new EntityLoadingException("Could not find weight block.");
        }
        infantry.weight = this.dataFile.getDataAsFloat("tonnage")[0];
        if (!this.dataFile.exists("motion_type")) {
            throw new EntityLoadingException("Could not find movement block.");
        }
        String string = this.dataFile.getDataAsString("motion_type")[0];
        int n = -1;
        int n2 = 0;
        while (n2 < MOVES.length) {
            if (string.equals(MOVES[n2])) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            throw new EntityLoadingException("Invalid movment type: " + string);
        }
        infantry.setMovementType(n);
        infantry.autoSetInternal();
        this.loadEquipment(infantry, "Platoon", 0);
        return infantry;
    }

    private void loadEquipment(Infantry infantry, String string, int n) throws EntityLoadingException {
        String[] stringArray = this.dataFile.getDataAsString(string + " Equipment");
        if (stringArray == null) {
            return;
        }
        String string2 = infantry.getTechLevel() == 2 ? "Clan " : "IS ";
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string3 = stringArray[n2].trim();
            EquipmentType equipmentType = EquipmentType.getByMtfName(string3);
            if (equipmentType == null) {
                equipmentType = EquipmentType.getByMepName(string3);
            }
            if (equipmentType == null) {
                equipmentType = EquipmentType.getByMepName(string2 + string3);
            }
            if (equipmentType != null) {
                try {
                    infantry.addEquipment(equipmentType, n);
                }
                catch (LocationFullException locationFullException) {
                    throw new EntityLoadingException(locationFullException.getMessage());
                }
            }
            ++n2;
        }
    }
}

