/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.Entity;
import megamek.common.MiscType;
import megamek.common.WeaponType;

public class EquipmentType {
    public static final float TONNAGE_VARIABLE = Float.MIN_VALUE;
    public static final int CRITICALS_VARIABLE = Integer.MIN_VALUE;
    public static final int BV_VARIABLE = Integer.MIN_VALUE;
    protected String name = null;
    protected String internalName = null;
    protected String mepName = null;
    protected String mtfName = null;
    protected float tonnage = 0.0f;
    protected int criticals = 0;
    protected boolean explosive = false;
    protected boolean hittable = true;
    protected boolean spreadable = false;
    protected int toHitModifier = 0;
    protected int flags = 0;
    protected double bv = 0.0;
    protected String[] m_saModes = null;
    protected boolean m_bInstantModeSwitch = true;
    protected static Vector allTypes;
    protected static Hashtable internalNameHash;
    protected static Hashtable mepNameHash;
    protected static Hashtable mtfNameHash;

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.name;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String getMepName() {
        return this.mepName;
    }

    public String getMtfName() {
        return this.mtfName;
    }

    public float getTonnage(Entity entity) {
        return this.tonnage;
    }

    public int getCriticals(Entity entity) {
        return this.criticals;
    }

    public boolean isExplosive() {
        return this.explosive;
    }

    public boolean isHittable() {
        return this.hittable;
    }

    public boolean isSpreadable() {
        return this.spreadable;
    }

    public int getToHitModifier() {
        return this.toHitModifier;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean hasFlag(int n) {
        return (this.flags & n) != 0;
    }

    public double getBV(Entity entity) {
        return this.bv;
    }

    public String[] getModes() {
        return this.m_saModes;
    }

    public void setModes(String[] stringArray) {
        this.m_saModes = stringArray;
    }

    public boolean hasModes() {
        return this.m_saModes != null;
    }

    public void setInstantModeSwitch(boolean bl) {
        this.m_bInstantModeSwitch = bl;
    }

    public boolean hasInstantModeSwitch() {
        return this.m_bInstantModeSwitch;
    }

    public static void initializeTypes() {
        allTypes = new Vector();
        WeaponType.initializeTypes();
        AmmoType.initializeTypes();
        MiscType.initializeTypes();
    }

    protected static void addType(EquipmentType equipmentType) {
        allTypes.addElement(equipmentType);
    }

    public static EquipmentType getByInternalName(String string) {
        if (internalNameHash == null) {
            EquipmentType.initializeInternalNameHash();
        }
        return (EquipmentType)internalNameHash.get(string);
    }

    public static void initializeInternalNameHash() {
        if (allTypes == null) {
            EquipmentType.initializeTypes();
        }
        internalNameHash = new Hashtable(allTypes.size());
        Enumeration enumeration = allTypes.elements();
        while (enumeration.hasMoreElements()) {
            EquipmentType equipmentType = (EquipmentType)enumeration.nextElement();
            internalNameHash.put(equipmentType.getInternalName(), equipmentType);
        }
    }

    public static EquipmentType getByMepName(String string) {
        if (mepNameHash == null) {
            EquipmentType.initializeMepNameHash();
        }
        return (EquipmentType)mepNameHash.get(string);
    }

    public static void initializeMepNameHash() {
        if (allTypes == null) {
            EquipmentType.initializeTypes();
        }
        mepNameHash = new Hashtable(allTypes.size());
        Enumeration enumeration = allTypes.elements();
        while (enumeration.hasMoreElements()) {
            EquipmentType equipmentType = (EquipmentType)enumeration.nextElement();
            mepNameHash.put(equipmentType.getMepName(), equipmentType);
        }
    }

    public static EquipmentType getByMtfName(String string) {
        if (mtfNameHash == null) {
            EquipmentType.initializeMtfNameHash();
        }
        return (EquipmentType)mtfNameHash.get(string);
    }

    public static void initializeMtfNameHash() {
        if (allTypes == null) {
            EquipmentType.initializeTypes();
        }
        mtfNameHash = new Hashtable(allTypes.size());
        Enumeration enumeration = allTypes.elements();
        while (enumeration.hasMoreElements()) {
            EquipmentType equipmentType = (EquipmentType)enumeration.nextElement();
            mtfNameHash.put(equipmentType.getMtfName(), equipmentType);
        }
    }
}

