/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Hashtable;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.Vector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import megamek.MegaMek;
import megamek.common.Entity;
import megamek.common.EntityLoadingException;
import megamek.common.MechFileParser;
import megamek.common.MechSummary;
import megamek.common.Settings;

public class MechSummaryCache {
    private static MechSummaryCache m_instance = null;
    private MechSummary[] m_data;
    private Map m_nameMap = new Hashtable();
    private static final char SEPARATOR = '|';
    private static final File ROOT = new File(Settings.mechDirectory);
    private static final File CACHE = new File(ROOT, "mechcache.txt");

    public static synchronized MechSummaryCache getInstance() {
        if (m_instance == null) {
            m_instance = new MechSummaryCache();
        }
        return m_instance;
    }

    private MechSummaryCache() {
        this.loadMechData();
    }

    public MechSummary[] getAllMechs() {
        return this.m_data;
    }

    public MechSummary getMech(String string) {
        return (MechSummary)this.m_nameMap.get((Object)string);
    }

    private void loadMechData() {
        Vector vector = new Vector();
        HashSet hashSet = new HashSet();
        long l = 0L;
        long l2 = System.currentTimeMillis();
        try {
            if (CACHE.exists() && CACHE.lastModified() >= MegaMek.TIMESTAMP) {
                String string;
                System.out.println("Reading from mechcache file");
                l = CACHE.lastModified();
                BufferedReader bufferedReader = new BufferedReader(new FileReader(CACHE));
                while ((string = bufferedReader.readLine()) != null) {
                    MechSummary mechSummary = new MechSummary();
                    int n = string.indexOf(124);
                    mechSummary.setName(string.substring(0, n));
                    int n2 = string.indexOf(124, n + 1);
                    mechSummary.setChassis(string.substring(n + 1, n2));
                    n = n2;
                    n2 = string.indexOf(124, n + 1);
                    mechSummary.setModel(string.substring(n + 1, n2));
                    n = n2;
                    n2 = string.indexOf(124, n + 1);
                    mechSummary.setSourceFile(new File(string.substring(n + 1, n2)));
                    n = n2;
                    n2 = string.indexOf(124, n + 1);
                    mechSummary.setEntryName(string.substring(n + 1, n2));
                    if (mechSummary.getEntryName().equals("null")) {
                        mechSummary.setEntryName(null);
                    }
                    n = n2;
                    n2 = string.indexOf(124, n + 1);
                    mechSummary.setYear(Integer.parseInt(string.substring(n + 1, n2)));
                    n = n2;
                    n2 = string.indexOf(124, n + 1);
                    mechSummary.setType(Integer.parseInt(string.substring(n + 1, n2)));
                    n = n2;
                    n2 = string.indexOf(124, n + 1);
                    mechSummary.setTons(Integer.parseInt(string.substring(n + 1, n2)));
                    mechSummary.setBV(Integer.parseInt(string.substring(n2 + 1)));
                    if (!mechSummary.getSourceFile().exists()) continue;
                    vector.addElement((Object)mechSummary);
                    hashSet.add((Object)mechSummary.getSourceFile().toString());
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Unable to load mechcache: " + exception.getMessage());
            exception.printStackTrace();
        }
        boolean bl = this.loadMechsFromDirectory(vector, (Set)hashSet, l, ROOT);
        this.m_data = new MechSummary[vector.size()];
        vector.copyInto((Object[])this.m_data);
        int n = 0;
        while (n < this.m_data.length) {
            this.m_nameMap.put((Object)this.m_data[n].getName(), (Object)this.m_data[n]);
            ++n;
        }
        if (bl) {
            try {
                this.saveCache(l2);
            }
            catch (Exception exception) {
                System.out.println("Unable to save mech cache");
            }
        }
        System.out.println(this.m_data.length + " mechs loaded.");
    }

    private void saveCache(long l) throws Exception {
        System.out.println("Saving mechcache");
        FileWriter fileWriter = new FileWriter(CACHE);
        int n = 0;
        while (n < this.m_data.length) {
            fileWriter.write(this.m_data[n].getName() + '|' + this.m_data[n].getChassis() + '|' + this.m_data[n].getModel() + '|' + this.m_data[n].getSourceFile().getPath() + '|' + this.m_data[n].getEntryName() + '|' + this.m_data[n].getYear() + '|' + this.m_data[n].getType() + '|' + this.m_data[n].getTons() + '|' + this.m_data[n].getBV() + "\r\n");
            ++n;
        }
        fileWriter.flush();
        fileWriter.close();
    }

    private boolean loadMechsFromDirectory(Vector vector, Set set, long l, File file) {
        boolean bl = false;
        System.out.println("Looking in " + file.getPath());
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(file, stringArray[n]);
            if (!file2.equals(CACHE)) {
                if (file2.isDirectory()) {
                    bl |= this.loadMechsFromDirectory(vector, set, l, file2);
                } else if (file2.getName().indexOf(46) != -1) {
                    if (file2.getName().toLowerCase().endsWith(".zip")) {
                        bl |= this.loadMechsFromZipFile(vector, set, l, file2);
                    } else if (file2.lastModified() >= l || !set.contains((Object)file2.toString())) {
                        try {
                            System.out.println("Loading from " + file2);
                            MechFileParser mechFileParser = new MechFileParser(file2);
                            Entity entity = mechFileParser.getEntity();
                            MechSummary mechSummary = new MechSummary();
                            mechSummary.setName(entity.getShortName());
                            mechSummary.setChassis(entity.getChassis());
                            mechSummary.setModel(entity.getModel());
                            mechSummary.setSourceFile(file2);
                            mechSummary.setEntryName(null);
                            mechSummary.setYear(entity.getYear());
                            mechSummary.setType(entity.getTechLevel());
                            mechSummary.setTons((int)entity.getWeight());
                            mechSummary.setBV(entity.calculateBattleValue());
                            vector.addElement((Object)mechSummary);
                            set.add((Object)file2.toString());
                            bl = true;
                        }
                        catch (EntityLoadingException entityLoadingException) {
                            System.err.println("couldn't load file " + file2.getName() + " : " + entityLoadingException.getMessage());
                        }
                    }
                }
            }
            ++n;
        }
        return bl;
    }

    private boolean loadMechsFromZipFile(Vector vector, Set set, long l, File file) {
        ZipFile zipFile;
        boolean bl = false;
        try {
            zipFile = new ZipFile(file);
        }
        catch (Exception exception) {
            System.err.println("couldn't load file " + file.getName() + " : " + exception.getMessage());
            return false;
        }
        System.out.println("Looking in zip file " + file.getPath());
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || Math.max(file.lastModified(), zipEntry.getTime()) < l && set.contains((Object)file.toString())) continue;
            try {
                System.out.println("Loading from " + file.getPath() + " >> " + zipEntry.getName());
                MechFileParser mechFileParser = new MechFileParser(zipFile.getInputStream(zipEntry), zipEntry.getName());
                Entity entity = mechFileParser.getEntity();
                MechSummary mechSummary = new MechSummary();
                mechSummary.setName(entity.getShortName());
                mechSummary.setChassis(entity.getChassis());
                mechSummary.setModel(entity.getModel());
                mechSummary.setSourceFile(file);
                mechSummary.setEntryName(zipEntry.getName());
                mechSummary.setYear(entity.getYear());
                mechSummary.setType(entity.getTechLevel());
                mechSummary.setTons((int)entity.getWeight());
                mechSummary.setBV(entity.calculateBattleValue());
                vector.addElement((Object)mechSummary);
                set.add((Object)zipEntry.getName());
                bl = true;
            }
            catch (Exception exception) {
                System.err.println("couldn't load file " + zipEntry.getName() + " : " + exception.getMessage());
            }
        }
        try {
            zipFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }
}

