/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.awt.Color;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.StreamTokenizer;
import java.io.Writer;

public class Settings {
    public static String cfgFileName = "MegaMek.cfg";
    public static int windowPosX = 0;
    public static int windowPosY = 0;
    public static int windowSizeWidth = 800;
    public static int windowSizeHeight = 600;
    public static boolean minimapEnabled = true;
    public static int minimapPosX = 0;
    public static int minimapPosY = 0;
    public static int minimapSizeWidth = 168;
    public static int minimapSizeHeight = 204;
    public static String lastPlayerName = "";
    public static int lastPlayerColor;
    public static String lastServerPass;
    public static int lastServerPort;
    public static String lastConnectAddr;
    public static int lastConnectPort;
    public static Color mapTextColor;
    public static Color moveDefaultColor;
    public static Color moveRunColor;
    public static Color moveJumpColor;
    public static Color moveIllegalColor;
    public static String mapTileset;
    public static String mechDirectory;
    private static String[] m_sColorNames;
    private static Color[] m_colorValues;

    /*
     * Unable to fully structure code
     */
    public static void load() {
        try {
            var0 = new File(Settings.cfgFileName);
            if (!var0.exists()) {
                return;
            }
            var1_2 = new FileReader(var0);
            var2_3 = new StreamTokenizer(var1_2);
            var2_3.lowerCaseMode(true);
            var2_3.quoteChar(34);
            var2_3.commentChar(35);
            block7: while (true) {
                switch (var2_3.nextToken()) {
                    case -1: {
                        break block7;
                    }
                    case 10: {
                        break block7;
                    }
                    case -3: {
                        var3_4 = var2_3.sval;
                        if (!var3_4.equals("windowpos")) ** GOTO lbl26
                        var2_3.nextToken();
                        Settings.windowPosX = (int)var2_3.nval;
                        var2_3.nextToken();
                        Settings.windowPosY = (int)var2_3.nval;
                        ** GOTO lbl95
lbl26:
                        // 1 sources

                        if (!var3_4.equals("windowsize")) ** GOTO lbl34
                        var2_3.nextToken();
                        Settings.windowSizeWidth = (int)var2_3.nval;
                        var2_3.nextToken();
                        Settings.windowSizeHeight = (int)var2_3.nval;
                        ** GOTO lbl95
lbl34:
                        // 1 sources

                        if (!var3_4.equals("minimapenabled")) ** GOTO lbl39
                        var2_3.nextToken();
                        Settings.minimapEnabled = Boolean.valueOf(var2_3.sval);
                        ** GOTO lbl95
lbl39:
                        // 1 sources

                        if (!var3_4.equals("minimappos")) ** GOTO lbl47
                        var2_3.nextToken();
                        Settings.minimapPosX = (int)var2_3.nval;
                        var2_3.nextToken();
                        Settings.minimapPosY = (int)var2_3.nval;
                        ** GOTO lbl95
lbl47:
                        // 1 sources

                        if (!var3_4.equals("minimapsize")) ** GOTO lbl55
                        var2_3.nextToken();
                        Settings.minimapSizeWidth = (int)var2_3.nval;
                        var2_3.nextToken();
                        Settings.minimapSizeHeight = (int)var2_3.nval;
                        ** GOTO lbl95
lbl55:
                        // 1 sources

                        if (!var3_4.equals("playername")) ** GOTO lbl60
                        var2_3.nextToken();
                        Settings.lastPlayerName = var2_3.sval;
                        ** GOTO lbl95
lbl60:
                        // 1 sources

                        if (!var3_4.equals("server")) ** GOTO lbl68
                        var2_3.nextToken();
                        Settings.lastServerPass = var2_3.sval;
                        var2_3.nextToken();
                        Settings.lastServerPort = (int)var2_3.nval;
                        ** GOTO lbl95
lbl68:
                        // 1 sources

                        if (!var3_4.equals("connect")) ** GOTO lbl76
                        var2_3.nextToken();
                        Settings.lastConnectAddr = var2_3.sval;
                        var2_3.nextToken();
                        Settings.lastConnectPort = (int)var2_3.nval;
                        ** GOTO lbl95
lbl76:
                        // 1 sources

                        if (!var3_4.equals("maptext")) ** GOTO lbl79
                        Settings.mapTextColor = Settings.loadColor(var2_3, Settings.mapTextColor);
                        ** GOTO lbl95
lbl79:
                        // 1 sources

                        if (!var3_4.equals("movedefault")) ** GOTO lbl82
                        Settings.moveDefaultColor = Settings.loadColor(var2_3, Settings.moveDefaultColor);
                        ** GOTO lbl95
lbl82:
                        // 1 sources

                        if (!var3_4.equals("moverun")) ** GOTO lbl85
                        Settings.moveRunColor = Settings.loadColor(var2_3, Settings.moveRunColor);
                        ** GOTO lbl95
lbl85:
                        // 1 sources

                        if (!var3_4.equals("movejump")) ** GOTO lbl88
                        Settings.moveJumpColor = Settings.loadColor(var2_3, Settings.moveJumpColor);
                        ** GOTO lbl95
lbl88:
                        // 1 sources

                        if (!var3_4.equals("moveillegal")) ** GOTO lbl91
                        Settings.moveIllegalColor = Settings.loadColor(var2_3, Settings.moveIllegalColor);
                        ** GOTO lbl95
lbl91:
                        // 1 sources

                        if (var3_4.equals("maptileset")) {
                            var2_3.nextToken();
                            Settings.mapTileset = var2_3.sval;
                        }
                    }
lbl95:
                    // 17 sources

                    default: {
                        continue block7;
                    }
                }
                break;
            }
            var1_2.close();
        }
        catch (Exception var0_1) {
            System.err.println("error reading settings file:");
            System.err.println(var0_1.getMessage());
        }
    }

    private static Color loadColor(StreamTokenizer streamTokenizer, Color color) {
        try {
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == -2) {
                int n = (int)streamTokenizer.nval;
                streamTokenizer.nextToken();
                int n2 = (int)streamTokenizer.nval;
                streamTokenizer.nextToken();
                int n3 = (int)streamTokenizer.nval;
                return new Color(n, n2, n3);
            }
            if (streamTokenizer.ttype == -3) {
                String string = streamTokenizer.sval;
                int n = 0;
                while (n < m_sColorNames.length) {
                    if (m_sColorNames[n].equalsIgnoreCase(string)) {
                        return m_colorValues[n];
                    }
                    ++n;
                }
                System.out.println("Unrecognized color: " + string);
            }
        }
        catch (Exception exception) {
            System.err.println("Unable to load color data");
        }
        return color;
    }

    public static void save() {
        try {
            File file = new File(cfgFileName);
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write("# MegaMek config file\r\n");
            fileWriter.write("# Edit at your own risk\r\n");
            fileWriter.write("\r\n");
            fileWriter.write("windowpos " + windowPosX + " " + windowPosY + "\r\n");
            fileWriter.write("windowsize " + windowSizeWidth + " " + windowSizeHeight + "\r\n");
            fileWriter.write("minimapenabled " + minimapEnabled + "\r\n");
            fileWriter.write("minimappos " + minimapPosX + " " + minimapPosY + "\r\n");
            fileWriter.write("minimapsize " + minimapSizeWidth + " " + minimapSizeHeight + "\r\n");
            fileWriter.write("playername \"" + lastPlayerName + "\"" + "\r\n");
            fileWriter.write("server \"" + lastServerPass + "\" " + lastServerPort + "\r\n");
            fileWriter.write("connect \"" + lastConnectAddr + "\" " + lastConnectPort + "\r\n");
            fileWriter.write("maptext " + Settings.writeColor(mapTextColor) + "\r\n");
            fileWriter.write("movedefault " + Settings.writeColor(moveDefaultColor) + "\r\n");
            fileWriter.write("moverun " + Settings.writeColor(moveRunColor) + "\r\n");
            fileWriter.write("movejump " + Settings.writeColor(moveJumpColor) + "\r\n");
            fileWriter.write("moveillegal " + Settings.writeColor(moveIllegalColor) + "\r\n");
            fileWriter.write("maptileset \"" + mapTileset + "\"\r\n");
            ((Writer)fileWriter).close();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    private static String writeColor(Color color) {
        int n = 0;
        while (n < m_colorValues.length) {
            if (color == m_colorValues[n]) {
                return m_sColorNames[n];
            }
            ++n;
        }
        return color.getRed() + " " + color.getGreen() + " " + color.getBlue();
    }

    static {
        lastServerPass = "";
        lastServerPort = 2346;
        lastConnectAddr = "localhost";
        lastConnectPort = 2346;
        mapTextColor = Color.black;
        moveDefaultColor = Color.cyan;
        moveRunColor = Color.yellow;
        moveJumpColor = Color.red;
        moveIllegalColor = Color.darkGray;
        mapTileset = "defaulthexset.txt";
        mechDirectory = "data" + File.separator + "mechfiles";
        m_sColorNames = new String[]{"black", "blue", "cyan", "darkgray", "gray", "green", "lightgray", "magenta", "orange", "pink", "red", "white", "yellow"};
        m_colorValues = new Color[]{Color.black, Color.blue, Color.cyan, Color.darkGray, Color.gray, Color.green, Color.lightGray, Color.magenta, Color.orange, Color.pink, Color.red, Color.white, Color.yellow};
    }
}

