/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import megamek.common.EquipmentType;

public class WeaponType
extends EquipmentType {
    public static final int DAMAGE_MISSILE = -2;
    public static final int DAMAGE_VARIABLE = -3;
    public static final int WEAPON_NA = Integer.MIN_VALUE;
    public static final int F_DIRECT_FIRE = 1;
    public static final int F_FLAMER = 2;
    public static final int F_LASER = 4;
    public static final int F_PPC = 8;
    public static final int F_AUTO_TARGET = 16;
    public static final int F_NO_FIRES = 32;
    public static final int F_INFANTRY = 3840;
    private int heat;
    private int damage;
    private int rackSize;
    private int ammoType;
    private int minimumRange;
    private int shortRange;
    private int mediumRange;
    private int longRange;

    private WeaponType() {
    }

    public int getHeat() {
        return this.heat;
    }

    public int getFireTN() {
        if (this.hasFlag(32)) {
            return Integer.MAX_VALUE;
        }
        if (this.hasFlag(2)) {
            return 4;
        }
        if (this.hasFlag(8) || this.hasFlag(4)) {
            return 7;
        }
        return 9;
    }

    public int getDamage() {
        return this.damage;
    }

    public int getRackSize() {
        return this.rackSize;
    }

    public int getAmmoType() {
        return this.ammoType;
    }

    public int getMinimumRange() {
        return this.minimumRange;
    }

    public int getShortRange() {
        return this.shortRange;
    }

    public int getMediumRange() {
        return this.mediumRange;
    }

    public int getLongRange() {
        return this.longRange;
    }

    public static void initializeTypes() {
        EquipmentType.addType(WeaponType.createFlamer());
        EquipmentType.addType(WeaponType.createSmallLaser());
        EquipmentType.addType(WeaponType.createMediumLaser());
        EquipmentType.addType(WeaponType.createLargeLaser());
        EquipmentType.addType(WeaponType.createPPC());
        EquipmentType.addType(WeaponType.createAC2());
        EquipmentType.addType(WeaponType.createAC5());
        EquipmentType.addType(WeaponType.createAC10());
        EquipmentType.addType(WeaponType.createAC20());
        EquipmentType.addType(WeaponType.createMG());
        EquipmentType.addType(WeaponType.createLRM5());
        EquipmentType.addType(WeaponType.createLRM10());
        EquipmentType.addType(WeaponType.createLRM15());
        EquipmentType.addType(WeaponType.createLRM20());
        EquipmentType.addType(WeaponType.createSRM2());
        EquipmentType.addType(WeaponType.createSRM4());
        EquipmentType.addType(WeaponType.createSRM6());
        EquipmentType.addType(WeaponType.createInfRifle());
        EquipmentType.addType(WeaponType.createInfMG());
        EquipmentType.addType(WeaponType.createInfSRM());
        EquipmentType.addType(WeaponType.createInfLRM());
        EquipmentType.addType(WeaponType.createInfLaser());
        EquipmentType.addType(WeaponType.createInfFlamer());
        EquipmentType.addType(WeaponType.createISERPPC());
        EquipmentType.addType(WeaponType.createISERLargeLaser());
        EquipmentType.addType(WeaponType.createISERMediumLaser());
        EquipmentType.addType(WeaponType.createISERSmallLaser());
        EquipmentType.addType(WeaponType.createISLargePulseLaser());
        EquipmentType.addType(WeaponType.createISMediumPulseLaser());
        EquipmentType.addType(WeaponType.createISSmallPulseLaser());
        EquipmentType.addType(WeaponType.createISLBXAC2());
        EquipmentType.addType(WeaponType.createISLBXAC5());
        EquipmentType.addType(WeaponType.createISLBXAC10());
        EquipmentType.addType(WeaponType.createISLBXAC20());
        EquipmentType.addType(WeaponType.createISGaussRifle());
        EquipmentType.addType(WeaponType.createISLightGaussRifle());
        EquipmentType.addType(WeaponType.createISHeavyGaussRifle());
        EquipmentType.addType(WeaponType.createISUltraAC2());
        EquipmentType.addType(WeaponType.createISUltraAC5());
        EquipmentType.addType(WeaponType.createISUltraAC10());
        EquipmentType.addType(WeaponType.createISUltraAC20());
        EquipmentType.addType(WeaponType.createISRAC2());
        EquipmentType.addType(WeaponType.createISRAC5());
        EquipmentType.addType(WeaponType.createISStreakSRM2());
        EquipmentType.addType(WeaponType.createISStreakSRM4());
        EquipmentType.addType(WeaponType.createISStreakSRM6());
        EquipmentType.addType(WeaponType.createISMRM10());
        EquipmentType.addType(WeaponType.createISMRM20());
        EquipmentType.addType(WeaponType.createISMRM30());
        EquipmentType.addType(WeaponType.createISMRM40());
        EquipmentType.addType(WeaponType.createISAMS());
        EquipmentType.addType(WeaponType.createISNarc());
        EquipmentType.addType(WeaponType.createCLERPPC());
        EquipmentType.addType(WeaponType.createCLERLargeLaser());
        EquipmentType.addType(WeaponType.createCLERMediumLaser());
        EquipmentType.addType(WeaponType.createCLERSmallLaser());
        EquipmentType.addType(WeaponType.createCLERMicroLaser());
        EquipmentType.addType(WeaponType.createCLFlamer());
        EquipmentType.addType(WeaponType.createCLHeavyLargeLaser());
        EquipmentType.addType(WeaponType.createCLHeavyMediumLaser());
        EquipmentType.addType(WeaponType.createCLHeavySmallLaser());
        EquipmentType.addType(WeaponType.createCLLargePulseLaser());
        EquipmentType.addType(WeaponType.createCLMediumPulseLaser());
        EquipmentType.addType(WeaponType.createCLSmallPulseLaser());
        EquipmentType.addType(WeaponType.createCLMicroPulseLaser());
        EquipmentType.addType(WeaponType.createCLLBXAC2());
        EquipmentType.addType(WeaponType.createCLLBXAC5());
        EquipmentType.addType(WeaponType.createCLLBXAC10());
        EquipmentType.addType(WeaponType.createCLLBXAC20());
        EquipmentType.addType(WeaponType.createCLMG());
        EquipmentType.addType(WeaponType.createCLLightMG());
        EquipmentType.addType(WeaponType.createCLHeavyMG());
        EquipmentType.addType(WeaponType.createCLLRM5());
        EquipmentType.addType(WeaponType.createCLLRM10());
        EquipmentType.addType(WeaponType.createCLLRM15());
        EquipmentType.addType(WeaponType.createCLLRM20());
        EquipmentType.addType(WeaponType.createCLSRM2());
        EquipmentType.addType(WeaponType.createCLSRM4());
        EquipmentType.addType(WeaponType.createCLSRM6());
        EquipmentType.addType(WeaponType.createCLGaussRifle());
        EquipmentType.addType(WeaponType.createCLUltraAC2());
        EquipmentType.addType(WeaponType.createCLUltraAC5());
        EquipmentType.addType(WeaponType.createCLUltraAC10());
        EquipmentType.addType(WeaponType.createCLUltraAC20());
        EquipmentType.addType(WeaponType.createCLStreakSRM2());
        EquipmentType.addType(WeaponType.createCLStreakSRM4());
        EquipmentType.addType(WeaponType.createCLStreakSRM6());
        EquipmentType.addType(WeaponType.createCLAMS());
        EquipmentType.addType(WeaponType.createCLNarc());
    }

    public static WeaponType createFlamer() {
        WeaponType weaponType = new WeaponType();
        weaponType.internalName = weaponType.name = "Flamer";
        weaponType.mepName = "IS Flamer";
        weaponType.mtfName = "ISFlamer";
        weaponType.heat = 3;
        weaponType.damage = 2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 2;
        weaponType.bv = 6.0;
        return weaponType;
    }

    public static WeaponType createLargeLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.internalName = weaponType.name = "Large Laser";
        weaponType.mepName = "IS Large Laser";
        weaponType.mtfName = "ISLargeLaser";
        weaponType.heat = 8;
        weaponType.damage = 8;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 5;
        weaponType.mediumRange = 10;
        weaponType.longRange = 15;
        weaponType.tonnage = 5.0f;
        weaponType.criticals = 2;
        weaponType.flags |= 5;
        weaponType.bv = 124.0;
        return weaponType;
    }

    public static WeaponType createMediumLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.internalName = weaponType.name = "Medium Laser";
        weaponType.mepName = "IS Medium Laser";
        weaponType.mtfName = "ISMediumLaser";
        weaponType.heat = 3;
        weaponType.damage = 5;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 5;
        weaponType.bv = 46.0;
        return weaponType;
    }

    public static WeaponType createSmallLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.internalName = weaponType.name = "Small Laser";
        weaponType.mepName = "IS Small Laser";
        weaponType.mtfName = "ISSmallLaser";
        weaponType.heat = 1;
        weaponType.damage = 3;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x25;
        weaponType.bv = 9.0;
        return weaponType;
    }

    public static WeaponType createPPC() {
        WeaponType weaponType = new WeaponType();
        weaponType.internalName = weaponType.name = "Particle Cannon";
        weaponType.mepName = "IS PPC";
        weaponType.mtfName = "ISPPC";
        weaponType.heat = 10;
        weaponType.damage = 10;
        weaponType.ammoType = -1;
        weaponType.minimumRange = 3;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 12;
        weaponType.longRange = 18;
        weaponType.tonnage = 7.0f;
        weaponType.criticals = 3;
        weaponType.flags |= 9;
        weaponType.bv = 176.0;
        return weaponType;
    }

    public static WeaponType createMG() {
        WeaponType weaponType = new WeaponType();
        weaponType.internalName = weaponType.name = "Machine Gun";
        weaponType.mepName = "IS Machine Gun";
        weaponType.mtfName = "ISMachine Gun";
        weaponType.heat = 0;
        weaponType.damage = 2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 3;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.bv = 5.0;
        return weaponType;
    }

    public static WeaponType createAC2() {
        WeaponType weaponType = new WeaponType();
        weaponType.internalName = weaponType.name = "Auto Cannon/2";
        weaponType.mepName = "IS Auto Cannon/2";
        weaponType.mtfName = "ISAC2";
        weaponType.heat = 1;
        weaponType.damage = 2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 1;
        weaponType.minimumRange = 4;
        weaponType.shortRange = 8;
        weaponType.mediumRange = 16;
        weaponType.longRange = 24;
        weaponType.tonnage = 6.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 1;
        weaponType.bv = 37.0;
        return weaponType;
    }

    public static WeaponType createAC5() {
        WeaponType weaponType = new WeaponType();
        weaponType.internalName = weaponType.name = "Auto Cannon/5";
        weaponType.mepName = "IS Auto Cannon/5";
        weaponType.mtfName = "ISAC5";
        weaponType.heat = 1;
        weaponType.damage = 5;
        weaponType.rackSize = 5;
        weaponType.ammoType = 1;
        weaponType.minimumRange = 3;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 12;
        weaponType.longRange = 18;
        weaponType.tonnage = 8.0f;
        weaponType.criticals = 4;
        weaponType.flags |= 1;
        weaponType.bv = 70.0;
        return weaponType;
    }

    public static WeaponType createAC10() {
        WeaponType weaponType = new WeaponType();
        weaponType.internalName = weaponType.name = "Auto Cannon/10";
        weaponType.mepName = "IS Auto Cannon/10";
        weaponType.mtfName = "ISAC10";
        weaponType.heat = 3;
        weaponType.damage = 10;
        weaponType.rackSize = 10;
        weaponType.ammoType = 1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 5;
        weaponType.mediumRange = 10;
        weaponType.longRange = 15;
        weaponType.tonnage = 12.0f;
        weaponType.criticals = 7;
        weaponType.flags |= 1;
        weaponType.bv = 124.0;
        return weaponType;
    }

    public static WeaponType createAC20() {
        WeaponType weaponType = new WeaponType();
        weaponType.internalName = weaponType.name = "Auto Cannon/20";
        weaponType.mepName = "IS Auto Cannon/20";
        weaponType.mtfName = "ISAC20";
        weaponType.heat = 7;
        weaponType.damage = 20;
        weaponType.rackSize = 20;
        weaponType.ammoType = 1;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.tonnage = 14.0f;
        weaponType.criticals = 10;
        weaponType.flags |= 1;
        weaponType.bv = 178.0;
        return weaponType;
    }

    public static WeaponType createLRM5() {
        WeaponType weaponType = new WeaponType();
        weaponType.internalName = weaponType.name = "LRM 5";
        weaponType.mepName = "IS LRM-5";
        weaponType.mtfName = "ISLRM5";
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 5;
        weaponType.ammoType = 7;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.tonnage = 2.0f;
        weaponType.criticals = 1;
        weaponType.bv = 45.0;
        return weaponType;
    }

    public static WeaponType createLRM10() {
        WeaponType weaponType = new WeaponType();
        weaponType.internalName = weaponType.name = "LRM 10";
        weaponType.mepName = "IS LRM-10";
        weaponType.mtfName = "ISLRM10";
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 10;
        weaponType.ammoType = 7;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.tonnage = 5.0f;
        weaponType.criticals = 2;
        weaponType.bv = 90.0;
        return weaponType;
    }

    public static WeaponType createLRM15() {
        WeaponType weaponType = new WeaponType();
        weaponType.internalName = weaponType.name = "LRM 15";
        weaponType.mepName = "IS LRM-15";
        weaponType.mtfName = "ISLRM15";
        weaponType.heat = 5;
        weaponType.damage = -2;
        weaponType.rackSize = 15;
        weaponType.ammoType = 7;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.tonnage = 7.0f;
        weaponType.criticals = 3;
        weaponType.bv = 136.0;
        return weaponType;
    }

    public static WeaponType createLRM20() {
        WeaponType weaponType = new WeaponType();
        weaponType.internalName = weaponType.name = "LRM 20";
        weaponType.mepName = "IS LRM-20";
        weaponType.mtfName = "ISLRM20";
        weaponType.heat = 6;
        weaponType.damage = -2;
        weaponType.rackSize = 20;
        weaponType.ammoType = 7;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.tonnage = 10.0f;
        weaponType.criticals = 5;
        weaponType.bv = 181.0;
        return weaponType;
    }

    public static WeaponType createSRM2() {
        WeaponType weaponType = new WeaponType();
        weaponType.internalName = weaponType.name = "SRM 2";
        weaponType.mepName = "IS SRM-2";
        weaponType.mtfName = "ISSRM2";
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 9;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x20;
        weaponType.bv = 21.0;
        return weaponType;
    }

    public static WeaponType createSRM4() {
        WeaponType weaponType = new WeaponType();
        weaponType.internalName = weaponType.name = "SRM 4";
        weaponType.mepName = "IS SRM-4";
        weaponType.mtfName = "ISSRM4";
        weaponType.heat = 3;
        weaponType.damage = -2;
        weaponType.rackSize = 4;
        weaponType.ammoType = 9;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.tonnage = 2.0f;
        weaponType.criticals = 1;
        weaponType.bv = 39.0;
        return weaponType;
    }

    public static WeaponType createSRM6() {
        WeaponType weaponType = new WeaponType();
        weaponType.internalName = weaponType.name = "SRM 6";
        weaponType.mepName = "IS SRM-6";
        weaponType.mtfName = "ISSRM6";
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 6;
        weaponType.ammoType = 9;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.tonnage = 3.0f;
        weaponType.criticals = 2;
        weaponType.bv = 59.0;
        return weaponType;
    }

    public static WeaponType createISERPPC() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "ER PPC";
        weaponType.internalName = "ISERPPC";
        weaponType.mepName = "IS ER PPC";
        weaponType.mtfName = "ISERPPC";
        weaponType.heat = 15;
        weaponType.damage = 10;
        weaponType.ammoType = -1;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 23;
        weaponType.tonnage = 7.0f;
        weaponType.criticals = 3;
        weaponType.flags |= 9;
        weaponType.bv = 229.0;
        return weaponType;
    }

    public static WeaponType createISERLargeLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "ER Large Laser";
        weaponType.internalName = "ISERLargeLaser";
        weaponType.mepName = "IS ER Large Laser";
        weaponType.mtfName = "ISERLargeLaser";
        weaponType.heat = 12;
        weaponType.damage = 8;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 19;
        weaponType.tonnage = 5.0f;
        weaponType.criticals = 2;
        weaponType.flags |= 5;
        weaponType.bv = 163.0;
        return weaponType;
    }

    public static WeaponType createISERMediumLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "ER Medium Laser";
        weaponType.internalName = "ISERMediumLaser";
        weaponType.mepName = "N/A";
        weaponType.mtfName = "ISERMediumLaser";
        weaponType.heat = 5;
        weaponType.damage = 5;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 5;
        weaponType.bv = 62.0;
        return weaponType;
    }

    public static WeaponType createISERSmallLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "ER Small Laser";
        weaponType.internalName = "ISERSmallLaser";
        weaponType.mepName = "N/A";
        weaponType.mtfName = "ISERSmallLaser";
        weaponType.heat = 2;
        weaponType.damage = 3;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 5;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x25;
        weaponType.bv = 17.0;
        return weaponType;
    }

    public static WeaponType createISLargePulseLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Large Pulse Laser";
        weaponType.internalName = "ISLargePulseLaser";
        weaponType.mepName = "IS Pulse Large Laser";
        weaponType.mtfName = "ISLargePulseLaser";
        weaponType.heat = 10;
        weaponType.damage = 9;
        weaponType.toHitModifier = -2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 7;
        weaponType.longRange = 10;
        weaponType.tonnage = 7.0f;
        weaponType.criticals = 2;
        weaponType.flags |= 5;
        weaponType.bv = 119.0;
        return weaponType;
    }

    public static WeaponType createISMediumPulseLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Medium Pulse Laser";
        weaponType.internalName = "ISMediumPulseLaser";
        weaponType.mepName = "IS Pulse Med Laser";
        weaponType.mtfName = "ISMediumPulseLaser";
        weaponType.heat = 4;
        weaponType.damage = 6;
        weaponType.toHitModifier = -2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 6;
        weaponType.tonnage = 2.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 5;
        weaponType.bv = 48.0;
        return weaponType;
    }

    public static WeaponType createISSmallPulseLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Small Pulse Laser";
        weaponType.internalName = "ISSmallPulseLaser";
        weaponType.mepName = "IS Pulse Small Laser";
        weaponType.mtfName = "ISSmallPulseLaser";
        weaponType.heat = 2;
        weaponType.damage = 3;
        weaponType.toHitModifier = -2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 5;
        weaponType.bv = 12.0;
        return weaponType;
    }

    public static WeaponType createISLBXAC2() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "LB 2-X AC";
        weaponType.internalName = "ISLBXAC2";
        weaponType.mepName = "IS LB 2-X AC";
        weaponType.mtfName = "ISLBXAC2";
        weaponType.heat = 1;
        weaponType.damage = 2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 19;
        weaponType.minimumRange = 4;
        weaponType.shortRange = 9;
        weaponType.mediumRange = 18;
        weaponType.longRange = 27;
        weaponType.tonnage = 6.0f;
        weaponType.criticals = 4;
        weaponType.flags |= 1;
        weaponType.bv = 42.0;
        return weaponType;
    }

    public static WeaponType createISLBXAC5() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "LB 5-X AC";
        weaponType.internalName = "ISLBXAC5";
        weaponType.mepName = "IS LB 5-X AC";
        weaponType.mtfName = "ISLBXAC5";
        weaponType.heat = 1;
        weaponType.damage = 5;
        weaponType.rackSize = 5;
        weaponType.ammoType = 19;
        weaponType.minimumRange = 3;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.tonnage = 8.0f;
        weaponType.criticals = 5;
        weaponType.flags |= 1;
        weaponType.bv = 83.0;
        return weaponType;
    }

    public static WeaponType createISLBXAC10() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "LB 10-X AC";
        weaponType.internalName = "ISLBXAC10";
        weaponType.mepName = "IS LB 10-X AC";
        weaponType.mtfName = "ISLBXAC10";
        weaponType.heat = 2;
        weaponType.damage = 10;
        weaponType.rackSize = 10;
        weaponType.ammoType = 19;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 12;
        weaponType.longRange = 18;
        weaponType.tonnage = 11.0f;
        weaponType.criticals = 6;
        weaponType.flags |= 1;
        weaponType.bv = 148.0;
        return weaponType;
    }

    public static WeaponType createISLBXAC20() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "LB 20-X AC";
        weaponType.internalName = "ISLBXAC20";
        weaponType.mepName = "IS LB 20-X AC";
        weaponType.mtfName = "ISLBXAC20";
        weaponType.heat = 6;
        weaponType.damage = 20;
        weaponType.rackSize = 20;
        weaponType.ammoType = 19;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.tonnage = 14.0f;
        weaponType.criticals = 11;
        weaponType.flags |= 1;
        weaponType.bv = 237.0;
        return weaponType;
    }

    public static WeaponType createISGaussRifle() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Gauss Rifle";
        weaponType.internalName = "ISGaussRifle";
        weaponType.mepName = "IS Gauss Rifle";
        weaponType.mtfName = "ISGaussRifle";
        weaponType.heat = 1;
        weaponType.damage = 15;
        weaponType.ammoType = 6;
        weaponType.minimumRange = 2;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 15;
        weaponType.longRange = 22;
        weaponType.tonnage = 15.0f;
        weaponType.criticals = 7;
        weaponType.flags |= 0x21;
        weaponType.explosive = true;
        weaponType.bv = 321.0;
        return weaponType;
    }

    public static WeaponType createISLightGaussRifle() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Light Gauss Rifle";
        weaponType.internalName = "ISLightGaussRifle";
        weaponType.mepName = "N/A";
        weaponType.mtfName = "ISLightGaussRifle";
        weaponType.heat = 1;
        weaponType.damage = 8;
        weaponType.ammoType = 21;
        weaponType.minimumRange = 3;
        weaponType.shortRange = 8;
        weaponType.mediumRange = 17;
        weaponType.longRange = 25;
        weaponType.tonnage = 12.0f;
        weaponType.criticals = 5;
        weaponType.flags |= 0x21;
        weaponType.explosive = true;
        weaponType.bv = 159.0;
        return weaponType;
    }

    public static WeaponType createISHeavyGaussRifle() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Heavy Gauss Rifle";
        weaponType.mepName = weaponType.internalName = "ISHeavyGaussRifle";
        weaponType.mtfName = weaponType.internalName;
        weaponType.heat = 2;
        weaponType.damage = -3;
        weaponType.ammoType = 22;
        weaponType.minimumRange = 4;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 13;
        weaponType.longRange = 20;
        weaponType.tonnage = 18.0f;
        weaponType.criticals = 11;
        weaponType.flags |= 0x21;
        weaponType.explosive = true;
        weaponType.bv = 346.0;
        return weaponType;
    }

    public static WeaponType createISUltraAC2() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Ultra AC/2";
        weaponType.internalName = "ISUltraAC2";
        weaponType.mepName = "IS Ultra AC/2";
        weaponType.mtfName = "ISUltraAC2";
        weaponType.heat = 1;
        weaponType.damage = 2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 20;
        weaponType.minimumRange = 3;
        weaponType.shortRange = 8;
        weaponType.mediumRange = 17;
        weaponType.longRange = 25;
        weaponType.tonnage = 7.0f;
        weaponType.criticals = 3;
        weaponType.flags |= 1;
        weaponType.bv = 56.0;
        String[] stringArray = new String[]{"Single", "Ultra"};
        weaponType.setModes(stringArray);
        return weaponType;
    }

    public static WeaponType createISUltraAC5() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Ultra AC/5";
        weaponType.internalName = "ISUltraAC5";
        weaponType.mepName = "IS Ultra AC/5";
        weaponType.mtfName = "ISUltraAC5";
        weaponType.heat = 1;
        weaponType.damage = 5;
        weaponType.rackSize = 5;
        weaponType.ammoType = 20;
        weaponType.minimumRange = 2;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 13;
        weaponType.longRange = 20;
        weaponType.tonnage = 9.0f;
        weaponType.criticals = 5;
        weaponType.flags |= 1;
        weaponType.bv = 113.0;
        String[] stringArray = new String[]{"Single", "Ultra"};
        weaponType.setModes(stringArray);
        return weaponType;
    }

    public static WeaponType createISUltraAC10() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Ultra AC/10";
        weaponType.internalName = "ISUltraAC10";
        weaponType.mepName = "IS Ultra AC/10";
        weaponType.mtfName = "ISUltraAC10";
        weaponType.heat = 4;
        weaponType.damage = 10;
        weaponType.rackSize = 10;
        weaponType.ammoType = 20;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 12;
        weaponType.longRange = 18;
        weaponType.tonnage = 13.0f;
        weaponType.criticals = 7;
        weaponType.flags |= 1;
        weaponType.bv = 253.0;
        String[] stringArray = new String[]{"Single", "Ultra"};
        weaponType.setModes(stringArray);
        return weaponType;
    }

    public static WeaponType createISUltraAC20() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Ultra AC/20";
        weaponType.internalName = "ISUltraAC20";
        weaponType.mepName = "IS Ultra AC/20";
        weaponType.mtfName = "ISUltraAC20";
        weaponType.heat = 8;
        weaponType.damage = 20;
        weaponType.rackSize = 20;
        weaponType.ammoType = 20;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 7;
        weaponType.longRange = 10;
        weaponType.tonnage = 15.0f;
        weaponType.criticals = 10;
        weaponType.flags |= 1;
        weaponType.bv = 282.0;
        String[] stringArray = new String[]{"Single", "Ultra"};
        weaponType.setModes(stringArray);
        return weaponType;
    }

    public static WeaponType createISRAC2() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Rotary AC/2";
        weaponType.mepName = weaponType.internalName = "ISRotaryAC2";
        weaponType.mtfName = weaponType.internalName;
        weaponType.heat = 1;
        weaponType.damage = 2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 23;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 12;
        weaponType.longRange = 18;
        weaponType.tonnage = 8.0f;
        weaponType.criticals = 3;
        weaponType.flags |= 1;
        weaponType.bv = 118.0;
        String[] stringArray = new String[]{"Single", "2-shot", "4-shot", "6-shot"};
        weaponType.setModes(stringArray);
        weaponType.explosive = true;
        return weaponType;
    }

    public static WeaponType createISRAC5() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Rotary AC/5";
        weaponType.mepName = weaponType.internalName = "ISRotaryAC5";
        weaponType.mtfName = weaponType.internalName;
        weaponType.heat = 1;
        weaponType.damage = 5;
        weaponType.rackSize = 5;
        weaponType.ammoType = 23;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 5;
        weaponType.mediumRange = 10;
        weaponType.longRange = 15;
        weaponType.tonnage = 10.0f;
        weaponType.criticals = 6;
        weaponType.flags |= 1;
        weaponType.bv = 247.0;
        String[] stringArray = new String[]{"Single", "2-shot", "4-shot", "6-shot"};
        weaponType.setModes(stringArray);
        weaponType.explosive = true;
        return weaponType;
    }

    public static WeaponType createISStreakSRM2() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Streak SRM 2";
        weaponType.internalName = "ISStreakSRM2";
        weaponType.mepName = "IS Streak SRM-2";
        weaponType.mtfName = "ISStreakSRM2";
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 11;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.tonnage = 1.5f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x20;
        weaponType.bv = 30.0;
        return weaponType;
    }

    public static WeaponType createISStreakSRM4() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Streak SRM 4";
        weaponType.internalName = "ISStreakSRM4";
        weaponType.mepName = "IS Streak SRM-4";
        weaponType.mtfName = "ISStreakSRM4";
        weaponType.heat = 3;
        weaponType.damage = -2;
        weaponType.rackSize = 4;
        weaponType.ammoType = 11;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.tonnage = 3.0f;
        weaponType.criticals = 1;
        weaponType.bv = 59.0;
        return weaponType;
    }

    public static WeaponType createISStreakSRM6() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Streak SRM 6";
        weaponType.internalName = "ISStreakSRM6";
        weaponType.mepName = "IS Streak SRM-6";
        weaponType.mtfName = "ISStreakSRM6";
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 6;
        weaponType.ammoType = 11;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.tonnage = 4.5f;
        weaponType.criticals = 2;
        weaponType.bv = 89.0;
        return weaponType;
    }

    public static WeaponType createISMRM10() {
        WeaponType weaponType = new WeaponType();
        weaponType.internalName = weaponType.name = "MRM 10";
        weaponType.mepName = "MRM-10";
        weaponType.mtfName = "ISMRM10";
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.toHitModifier = 1;
        weaponType.rackSize = 10;
        weaponType.ammoType = 12;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 8;
        weaponType.longRange = 15;
        weaponType.tonnage = 3.0f;
        weaponType.criticals = 2;
        weaponType.bv = 56.0;
        return weaponType;
    }

    public static WeaponType createISMRM20() {
        WeaponType weaponType = new WeaponType();
        weaponType.internalName = weaponType.name = "MRM 20";
        weaponType.mepName = "MRM-20";
        weaponType.mtfName = "ISMRM20";
        weaponType.heat = 6;
        weaponType.damage = -2;
        weaponType.toHitModifier = 1;
        weaponType.rackSize = 20;
        weaponType.ammoType = 12;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 8;
        weaponType.longRange = 15;
        weaponType.tonnage = 7.0f;
        weaponType.criticals = 3;
        weaponType.bv = 112.0;
        return weaponType;
    }

    public static WeaponType createISMRM30() {
        WeaponType weaponType = new WeaponType();
        weaponType.internalName = weaponType.name = "MRM 30";
        weaponType.mepName = "MRM-30";
        weaponType.mtfName = "ISMRM30";
        weaponType.heat = 10;
        weaponType.damage = -2;
        weaponType.toHitModifier = 1;
        weaponType.rackSize = 30;
        weaponType.ammoType = 12;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 8;
        weaponType.longRange = 15;
        weaponType.tonnage = 10.0f;
        weaponType.criticals = 5;
        weaponType.bv = 168.0;
        return weaponType;
    }

    public static WeaponType createISMRM40() {
        WeaponType weaponType = new WeaponType();
        weaponType.internalName = weaponType.name = "MRM 40";
        weaponType.mepName = "MRM-40";
        weaponType.mtfName = "ISMRM40";
        weaponType.heat = 12;
        weaponType.damage = -2;
        weaponType.toHitModifier = 1;
        weaponType.rackSize = 40;
        weaponType.ammoType = 12;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 8;
        weaponType.longRange = 15;
        weaponType.tonnage = 12.0f;
        weaponType.criticals = 7;
        weaponType.bv = 224.0;
        return weaponType;
    }

    public static WeaponType createISAMS() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "AMS";
        weaponType.internalName = "ISAntiMissileSystem";
        weaponType.mepName = "IS Anti-Missile System";
        weaponType.mtfName = weaponType.internalName;
        weaponType.heat = 1;
        weaponType.rackSize = 2;
        weaponType.damage = 1;
        weaponType.ammoType = 14;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.bv = 32.0;
        weaponType.flags |= 0x10;
        String[] stringArray = new String[]{"On", "Off"};
        weaponType.setModes(stringArray);
        weaponType.setInstantModeSwitch(false);
        return weaponType;
    }

    public static WeaponType createISNarc() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Narc";
        weaponType.internalName = "ISNarcBeacon";
        weaponType.mepName = "IS Narc Beacon";
        weaponType.mtfName = weaponType.internalName;
        weaponType.heat = 0;
        weaponType.rackSize = 1;
        weaponType.ammoType = 13;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.tonnage = 3.0f;
        weaponType.criticals = 2;
        weaponType.bv = 30.0;
        weaponType.flags |= 0x20;
        return weaponType;
    }

    public static WeaponType createCLERPPC() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "ER PPC";
        weaponType.internalName = "CLERPPC";
        weaponType.mepName = "Clan ER PPC";
        weaponType.mtfName = "CLERPPC";
        weaponType.heat = 15;
        weaponType.damage = 15;
        weaponType.ammoType = -1;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 23;
        weaponType.tonnage = 6.0f;
        weaponType.criticals = 2;
        weaponType.flags |= 9;
        weaponType.bv = 412.0;
        return weaponType;
    }

    public static WeaponType createCLERLargeLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "ER Large Laser";
        weaponType.internalName = "CLERLargeLaser";
        weaponType.mepName = "Clan ER Large Laser";
        weaponType.mtfName = "CLERLargeLaser";
        weaponType.heat = 12;
        weaponType.damage = 10;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 8;
        weaponType.mediumRange = 15;
        weaponType.longRange = 25;
        weaponType.tonnage = 4.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 5;
        weaponType.bv = 249.0;
        return weaponType;
    }

    public static WeaponType createCLERMediumLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "ER Medium Laser";
        weaponType.internalName = "CLERMediumLaser";
        weaponType.mepName = "Clan ER Medium Laser";
        weaponType.mtfName = "CLERMediumLaser";
        weaponType.heat = 5;
        weaponType.damage = 7;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 5;
        weaponType.mediumRange = 10;
        weaponType.longRange = 15;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 5;
        weaponType.bv = 108.0;
        return weaponType;
    }

    public static WeaponType createCLERSmallLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "ER Small Laser";
        weaponType.internalName = "CLERSmallLaser";
        weaponType.mepName = "Clan ER Small Laser";
        weaponType.mtfName = "CLERSmallLaser";
        weaponType.heat = 2;
        weaponType.damage = 5;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 6;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x25;
        weaponType.bv = 31.0;
        return weaponType;
    }

    public static WeaponType createCLERMicroLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "ER Micro Laser";
        weaponType.internalName = "CLERMicroLaser";
        weaponType.mepName = "N/A";
        weaponType.mtfName = "CLERMicroLaser";
        weaponType.heat = 1;
        weaponType.damage = 2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 4;
        weaponType.tonnage = 0.25f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x25;
        weaponType.bv = 7.0;
        return weaponType;
    }

    public static WeaponType createCLFlamer() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Flamer";
        weaponType.internalName = "CLFlamer";
        weaponType.mepName = "Clan Flamer";
        weaponType.mtfName = "CLFlamer";
        weaponType.heat = 3;
        weaponType.damage = 2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.flags |= 2;
        weaponType.bv = 6.0;
        return weaponType;
    }

    public static WeaponType createCLHeavyLargeLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Heavy Large Laser";
        weaponType.internalName = "CLHeavyLargeLaser";
        weaponType.mepName = "N/A";
        weaponType.mtfName = "CLHeavyLargeLaser";
        weaponType.heat = 18;
        weaponType.damage = 16;
        weaponType.toHitModifier = 1;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 5;
        weaponType.mediumRange = 10;
        weaponType.longRange = 15;
        weaponType.tonnage = 4.0f;
        weaponType.criticals = 3;
        weaponType.flags |= 5;
        weaponType.bv = 243.0;
        return weaponType;
    }

    public static WeaponType createCLHeavyMediumLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Heavy Medium Laser";
        weaponType.internalName = "CLHeavyMediumLaser";
        weaponType.mepName = "N/A";
        weaponType.mtfName = "CLHeavyMediumLaser";
        weaponType.heat = 7;
        weaponType.damage = 10;
        weaponType.toHitModifier = 1;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 2;
        weaponType.flags |= 5;
        weaponType.bv = 76.0;
        return weaponType;
    }

    public static WeaponType createCLHeavySmallLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Heavy Small Laser";
        weaponType.internalName = "CLHeavySmallLaser";
        weaponType.mepName = "N/A";
        weaponType.mtfName = "CLHeavySmallLaser";
        weaponType.heat = 3;
        weaponType.damage = 6;
        weaponType.toHitModifier = 1;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.flags |= 5;
        weaponType.bv = 15.0;
        return weaponType;
    }

    public static WeaponType createCLMG() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Machine Gun";
        weaponType.internalName = "CLMG";
        weaponType.mepName = "Clan Machine Gun";
        weaponType.mtfName = "CLMG";
        weaponType.heat = 0;
        weaponType.damage = 2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 3;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.tonnage = 0.25f;
        weaponType.criticals = 1;
        weaponType.bv = 5.0;
        return weaponType;
    }

    public static WeaponType createCLLightMG() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Light Machine Gun";
        weaponType.internalName = "CLLightMG";
        weaponType.mepName = "N/A";
        weaponType.mtfName = "CLLightMG";
        weaponType.heat = 0;
        weaponType.damage = 1;
        weaponType.rackSize = 2;
        weaponType.ammoType = 5;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 6;
        weaponType.tonnage = 0.25f;
        weaponType.criticals = 1;
        weaponType.bv = 5.0;
        return weaponType;
    }

    public static WeaponType createCLHeavyMG() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Heavy Machine Gun";
        weaponType.internalName = "CLHeavyMG";
        weaponType.mepName = "N/A";
        weaponType.mtfName = "CLHeavyMG";
        weaponType.heat = 0;
        weaponType.damage = 3;
        weaponType.rackSize = 2;
        weaponType.ammoType = 4;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.bv = 6.0;
        return weaponType;
    }

    public static WeaponType createCLLRM5() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "LRM 5";
        weaponType.internalName = "CLLRM5";
        weaponType.mepName = "Clan LRM-5";
        weaponType.mtfName = "CLLRM5";
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 5;
        weaponType.ammoType = 7;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.bv = 55.0;
        return weaponType;
    }

    public static WeaponType createCLLRM10() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "LRM 10";
        weaponType.internalName = "CLLRM10";
        weaponType.mepName = "Clan LRM-10";
        weaponType.mtfName = "CLLRM10";
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 10;
        weaponType.ammoType = 7;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.tonnage = 2.5f;
        weaponType.criticals = 1;
        weaponType.bv = 109.0;
        return weaponType;
    }

    public static WeaponType createCLLRM15() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "LRM 15";
        weaponType.internalName = "CLLRM15";
        weaponType.mepName = "Clan LRM-15";
        weaponType.mtfName = "CLLRM15";
        weaponType.heat = 5;
        weaponType.damage = -2;
        weaponType.rackSize = 15;
        weaponType.ammoType = 7;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.tonnage = 3.5f;
        weaponType.criticals = 2;
        weaponType.bv = 164.0;
        return weaponType;
    }

    public static WeaponType createCLLRM20() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "LRM 20";
        weaponType.internalName = "CLLRM20";
        weaponType.mepName = "Clan LRM-20";
        weaponType.mtfName = "CLLRM20";
        weaponType.heat = 6;
        weaponType.damage = -2;
        weaponType.rackSize = 20;
        weaponType.ammoType = 7;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.tonnage = 5.0f;
        weaponType.criticals = 4;
        weaponType.bv = 220.0;
        return weaponType;
    }

    public static WeaponType createCLSRM2() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "SRM 2";
        weaponType.internalName = "CLSRM2";
        weaponType.mepName = "Clan SRM-2";
        weaponType.mtfName = "CLSRM2";
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 9;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x20;
        weaponType.bv = 21.0;
        return weaponType;
    }

    public static WeaponType createCLSRM4() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "SRM 4";
        weaponType.internalName = "CLSRM4";
        weaponType.mepName = "Clan SRM-4";
        weaponType.mtfName = "CLSRM4";
        weaponType.heat = 3;
        weaponType.damage = -2;
        weaponType.rackSize = 4;
        weaponType.ammoType = 9;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.bv = 39.0;
        return weaponType;
    }

    public static WeaponType createCLSRM6() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "SRM 6";
        weaponType.internalName = "CLSRM6";
        weaponType.mepName = "Clan SRM-6";
        weaponType.mtfName = "CLSRM6";
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 6;
        weaponType.ammoType = 9;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.tonnage = 1.5f;
        weaponType.criticals = 1;
        weaponType.bv = 59.0;
        return weaponType;
    }

    public static WeaponType createCLLargePulseLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Large Pulse Laser";
        weaponType.internalName = "CLLargePulseLaser";
        weaponType.mepName = "Clan Pulse Large Laser";
        weaponType.mtfName = "CLLargePulseLaser";
        weaponType.heat = 10;
        weaponType.damage = 10;
        weaponType.toHitModifier = -2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 14;
        weaponType.longRange = 20;
        weaponType.tonnage = 6.0f;
        weaponType.criticals = 2;
        weaponType.flags |= 5;
        weaponType.bv = 265.0;
        return weaponType;
    }

    public static WeaponType createCLMediumPulseLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Medium Pulse Laser";
        weaponType.internalName = "CLMediumPulseLaser";
        weaponType.mepName = "Clan Pulse Med Laser";
        weaponType.mtfName = "CLMediumPulseLaser";
        weaponType.heat = 4;
        weaponType.damage = 7;
        weaponType.toHitModifier = -2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.tonnage = 2.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 5;
        weaponType.bv = 111.0;
        return weaponType;
    }

    public static WeaponType createCLSmallPulseLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Small Pulse Laser";
        weaponType.internalName = "CLSmallPulseLaser";
        weaponType.mepName = "Clan Pulse Small Laser";
        weaponType.mtfName = "CLSmallPulseLaser";
        weaponType.heat = 2;
        weaponType.damage = 3;
        weaponType.toHitModifier = -2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 6;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 5;
        weaponType.bv = 24.0;
        return weaponType;
    }

    public static WeaponType createCLMicroPulseLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Micro Pulse Laser";
        weaponType.internalName = "CLMicroPulseLaser";
        weaponType.mepName = "N/A";
        weaponType.mtfName = "CLMicroPulseLaser";
        weaponType.heat = 1;
        weaponType.damage = 3;
        weaponType.toHitModifier = -2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x25;
        weaponType.bv = 12.0;
        return weaponType;
    }

    public static WeaponType createCLLBXAC2() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "LB 2-X AC";
        weaponType.internalName = "CLLBXAC2";
        weaponType.mepName = "Clan LB 2-X AC";
        weaponType.mtfName = "CLLBXAC2";
        weaponType.heat = 1;
        weaponType.damage = 2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 19;
        weaponType.minimumRange = 4;
        weaponType.shortRange = 10;
        weaponType.mediumRange = 20;
        weaponType.longRange = 30;
        weaponType.tonnage = 5.0f;
        weaponType.criticals = 3;
        weaponType.flags |= 1;
        weaponType.bv = 47.0;
        return weaponType;
    }

    public static WeaponType createCLLBXAC5() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "LB 5-X AC";
        weaponType.internalName = "CLLBXAC5";
        weaponType.mepName = "Clan LB 5-X AC";
        weaponType.mtfName = "CLLBXAC5";
        weaponType.heat = 1;
        weaponType.damage = 5;
        weaponType.rackSize = 5;
        weaponType.ammoType = 19;
        weaponType.minimumRange = 3;
        weaponType.shortRange = 8;
        weaponType.mediumRange = 15;
        weaponType.longRange = 24;
        weaponType.tonnage = 7.0f;
        weaponType.criticals = 4;
        weaponType.flags |= 1;
        weaponType.bv = 93.0;
        return weaponType;
    }

    public static WeaponType createCLLBXAC10() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "LB 10-X AC";
        weaponType.internalName = "CLLBXAC10";
        weaponType.mepName = "Clan LB 10-X AC";
        weaponType.mtfName = "CLLBXAC10";
        weaponType.heat = 2;
        weaponType.damage = 10;
        weaponType.rackSize = 10;
        weaponType.ammoType = 19;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 12;
        weaponType.longRange = 18;
        weaponType.tonnage = 10.0f;
        weaponType.criticals = 5;
        weaponType.flags |= 1;
        weaponType.bv = 148.0;
        return weaponType;
    }

    public static WeaponType createCLLBXAC20() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "LB 20-X AC";
        weaponType.internalName = "CLLBXAC20";
        weaponType.mepName = "Clan LB 20-X AC";
        weaponType.mtfName = "CLLBXAC20";
        weaponType.heat = 6;
        weaponType.damage = 20;
        weaponType.rackSize = 20;
        weaponType.ammoType = 19;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.tonnage = 12.0f;
        weaponType.criticals = 9;
        weaponType.flags |= 1;
        weaponType.bv = 237.0;
        return weaponType;
    }

    public static WeaponType createCLGaussRifle() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Gauss Rifle";
        weaponType.internalName = "CLGaussRifle";
        weaponType.mepName = "Clan Gauss Rifle";
        weaponType.mtfName = "CLGaussRifle";
        weaponType.heat = 1;
        weaponType.damage = 15;
        weaponType.ammoType = 6;
        weaponType.minimumRange = 2;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 15;
        weaponType.longRange = 22;
        weaponType.tonnage = 12.0f;
        weaponType.criticals = 6;
        weaponType.flags |= 0x21;
        weaponType.explosive = true;
        weaponType.bv = 321.0;
        return weaponType;
    }

    public static WeaponType createCLUltraAC2() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Ultra AC/2";
        weaponType.internalName = "CLUltraAC2";
        weaponType.mepName = "Clan Ultra AC/2";
        weaponType.mtfName = "CLUltraAC2";
        weaponType.heat = 1;
        weaponType.damage = 2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 20;
        weaponType.minimumRange = 2;
        weaponType.shortRange = 9;
        weaponType.mediumRange = 18;
        weaponType.longRange = 27;
        weaponType.tonnage = 5.0f;
        weaponType.criticals = 2;
        weaponType.flags |= 1;
        weaponType.bv = 62.0;
        String[] stringArray = new String[]{"Single", "Ultra"};
        weaponType.setModes(stringArray);
        return weaponType;
    }

    public static WeaponType createCLUltraAC5() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Ultra AC/5";
        weaponType.internalName = "CLUltraAC5";
        weaponType.mepName = "Clan Ultra AC/5";
        weaponType.mtfName = "CLUltraAC5";
        weaponType.heat = 1;
        weaponType.damage = 5;
        weaponType.rackSize = 5;
        weaponType.ammoType = 20;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.tonnage = 7.0f;
        weaponType.criticals = 3;
        weaponType.flags |= 1;
        weaponType.bv = 123.0;
        String[] stringArray = new String[]{"Single", "Ultra"};
        weaponType.setModes(stringArray);
        return weaponType;
    }

    public static WeaponType createCLUltraAC10() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Ultra AC/10";
        weaponType.internalName = "CLUltraAC10";
        weaponType.mepName = "Clan Ultra AC/10";
        weaponType.mtfName = "CLUltraAC10";
        weaponType.heat = 3;
        weaponType.damage = 10;
        weaponType.rackSize = 10;
        weaponType.ammoType = 20;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 12;
        weaponType.longRange = 18;
        weaponType.tonnage = 10.0f;
        weaponType.criticals = 4;
        weaponType.flags |= 1;
        weaponType.bv = 211.0;
        String[] stringArray = new String[]{"Single", "Ultra"};
        weaponType.setModes(stringArray);
        return weaponType;
    }

    public static WeaponType createCLUltraAC20() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Ultra AC/20";
        weaponType.internalName = "CLUltraAC20";
        weaponType.mepName = "Clan Ultra AC/20";
        weaponType.mtfName = "CLUltraAC20";
        weaponType.heat = 7;
        weaponType.damage = 20;
        weaponType.rackSize = 20;
        weaponType.ammoType = 20;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.tonnage = 12.0f;
        weaponType.criticals = 8;
        weaponType.flags |= 1;
        weaponType.bv = 337.0;
        String[] stringArray = new String[]{"Single", "Ultra"};
        weaponType.setModes(stringArray);
        return weaponType;
    }

    public static WeaponType createCLStreakSRM2() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Streak SRM 2";
        weaponType.internalName = "CLStreakSRM2";
        weaponType.mepName = "Clan Streak SRM-2";
        weaponType.mtfName = "CLStreakSRM2";
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 11;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x20;
        weaponType.bv = 40.0;
        return weaponType;
    }

    public static WeaponType createCLStreakSRM4() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Streak SRM 4";
        weaponType.internalName = "CLStreakSRM4";
        weaponType.mepName = "Clan Streak SRM-4";
        weaponType.mtfName = "CLStreakSRM4";
        weaponType.heat = 3;
        weaponType.damage = -2;
        weaponType.rackSize = 4;
        weaponType.ammoType = 11;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.tonnage = 2.0f;
        weaponType.criticals = 1;
        weaponType.bv = 79.0;
        return weaponType;
    }

    public static WeaponType createCLStreakSRM6() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Streak SRM 6";
        weaponType.internalName = "CLStreakSRM6";
        weaponType.mepName = "Clan Streak SRM-6";
        weaponType.mtfName = "CLStreakSRM6";
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 6;
        weaponType.ammoType = 11;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.tonnage = 3.0f;
        weaponType.criticals = 2;
        weaponType.bv = 119.0;
        return weaponType;
    }

    public static WeaponType createInfRifle() {
        WeaponType weaponType = new WeaponType();
        weaponType.internalName = weaponType.name = "Infantry Rifle";
        weaponType.mepName = "IS Infantry Rifle";
        weaponType.mtfName = "ISInfantryRifle";
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.ammoType = 1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 2;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0xF01;
        weaponType.bv = 4.0;
        return weaponType;
    }

    public static WeaponType createInfMG() {
        WeaponType weaponType = new WeaponType();
        weaponType.internalName = weaponType.name = "Infantry MG";
        weaponType.mepName = "IS Infantry MG";
        weaponType.mtfName = "ISInfantryMG";
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.ammoType = 3;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0xF01;
        weaponType.bv = 4.0;
        return weaponType;
    }

    public static WeaponType createInfSRM() {
        WeaponType weaponType = new WeaponType();
        weaponType.internalName = weaponType.name = "Infantry SRM";
        weaponType.mepName = "IS Infantry SRM";
        weaponType.mtfName = "ISInfantrySRM";
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.ammoType = 9;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 6;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0xF01;
        weaponType.bv = 4.0;
        return weaponType;
    }

    public static WeaponType createInfLRM() {
        WeaponType weaponType = new WeaponType();
        weaponType.internalName = weaponType.name = "Infantry LRM";
        weaponType.mepName = "IS Infantry LRM";
        weaponType.mtfName = "ISInfantryLRM";
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.ammoType = 7;
        weaponType.minimumRange = 3;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 9;
        weaponType.longRange = 12;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0xF01;
        weaponType.bv = 4.0;
        return weaponType;
    }

    public static WeaponType createInfLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.internalName = weaponType.name = "Infantry Laser";
        weaponType.mepName = "IS Infantry Laser";
        weaponType.mtfName = "ISInfantryLaser";
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0xF05;
        weaponType.bv = 4.0;
        return weaponType;
    }

    public static WeaponType createInfFlamer() {
        WeaponType weaponType = new WeaponType();
        weaponType.internalName = weaponType.name = "Infantry Flamer";
        weaponType.mepName = "IS Infantry Flamer";
        weaponType.mtfName = "ISInfantryFlamer";
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 2;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0xF03;
        weaponType.bv = 4.0;
        return weaponType;
    }

    public static WeaponType createCLAMS() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "AMS";
        weaponType.internalName = "CLAntiMissileSystem";
        weaponType.mepName = "Clan Anti-Missile Sys";
        weaponType.mtfName = weaponType.internalName;
        weaponType.heat = 1;
        weaponType.rackSize = 2;
        weaponType.damage = 2;
        weaponType.ammoType = 14;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.bv = 63.0;
        weaponType.flags |= 0x10;
        String[] stringArray = new String[]{"On", "Off"};
        weaponType.setModes(stringArray);
        weaponType.setInstantModeSwitch(false);
        return weaponType;
    }

    public static WeaponType createCLNarc() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Narc";
        weaponType.internalName = "CLNarcBeacon";
        weaponType.mepName = "Clan Narc Beacon";
        weaponType.mtfName = weaponType.internalName;
        weaponType.heat = 0;
        weaponType.rackSize = 1;
        weaponType.ammoType = 13;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.tonnage = 2.0f;
        weaponType.criticals = 1;
        weaponType.bv = 30.0;
        weaponType.flags |= 0x20;
        return weaponType;
    }

    public String toString() {
        return "WeaponType: " + this.name;
    }
}

