/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.AbstractPlayer;
import game.Link;
import game.Move;
import game.Node;
import game.TestBoard;
import i18n.I18n;
import java.util.TreeSet;

public class Detective
extends AbstractPlayer {
    private int taxiTickets;
    private int busTickets;
    private int ugTickets;

    Detective(Node n) {
        super(n);
        this.taxiTickets = 10;
        this.busTickets = 8;
        this.ugTickets = 4;
    }

    Detective(Detective d) {
        this.taxiTickets = d.taxiTickets;
        this.busTickets = d.busTickets;
        this.ugTickets = d.ugTickets;
        this.position = d.position;
    }

    public void changePosition(Node n, int ticket) {
        boolean canMove = false;
        Link[] links = this.getPosition().getLinks();
        int i = 0;
        while (i < links.length) {
            Node temp = links[i].getToNode();
            int type = links[i].getType();
            if (temp.equals(n) && ticket == type) {
                canMove = true;
            }
            ++i;
        }
        if (canMove) {
            switch (ticket) {
                case 1: {
                    if (this.taxiTickets == 0) {
                        canMove = false;
                        break;
                    }
                    --this.taxiTickets;
                    break;
                }
                case 2: {
                    if (this.busTickets == 0) {
                        canMove = false;
                        break;
                    }
                    --this.busTickets;
                    break;
                }
                case 3: {
                    if (this.ugTickets == 0) {
                        canMove = false;
                        break;
                    }
                    --this.ugTickets;
                }
            }
        }
        if (canMove) {
            this.prevPositions.add(new Move(n.getPosition(), ticket));
            this.position = n;
        }
    }

    public void setStaticState() {
        Move m = (Move)this.prevPositions.getLast();
        this.prevPositions.add(new Move(m.getNode(), 0));
    }

    public boolean canMove(TestBoard board) {
        Node n = this.getPosition();
        Link[] lk = n.getLinks();
        boolean canMove = false;
        int i = 0;
        while (i < lk.length) {
            boolean canGoToThisNode = true;
            Node toNode = lk[i].getToNode();
            Detective[] det = board.getDetectives();
            int j = 0;
            while (j < det.length) {
                if (toNode.equals(det[j].getPosition())) {
                    canGoToThisNode = false;
                }
                ++j;
            }
            int t = lk[i].getType();
            switch (t) {
                case 1: {
                    if (this.taxiTickets > 0 || !canGoToThisNode) break;
                    canGoToThisNode = false;
                    break;
                }
                case 2: {
                    if (this.busTickets > 0 || !canGoToThisNode) break;
                    canGoToThisNode = false;
                    break;
                }
                case 3: {
                    if (this.ugTickets > 0 || !canGoToThisNode) break;
                    canGoToThisNode = false;
                    break;
                }
                case 50: {
                    canGoToThisNode = false;
                }
            }
            if (canGoToThisNode) {
                canMove = true;
            }
            ++i;
        }
        return canMove;
    }

    public TreeSet<Move> getPossibleMoves(TestBoard board) {
        if (!this.canMove(board)) {
            return null;
        }
        Node n = this.getPosition();
        Link[] lk = n.getLinks();
        TreeSet<Move> possibleMoves = new TreeSet<Move>();
        int i = 0;
        while (i < lk.length) {
            if (lk[i].getType() != 50) {
                boolean canGoToThisNode = true;
                Node toNode = lk[i].getToNode();
                Detective[] det = board.getDetectives();
                int j = 0;
                while (j < det.length) {
                    if (toNode.equals(det[j].getPosition())) {
                        canGoToThisNode = false;
                    }
                    ++j;
                }
                int t = lk[i].getType();
                switch (t) {
                    case 1: {
                        if (this.taxiTickets > 0 || !canGoToThisNode) break;
                        canGoToThisNode = false;
                        break;
                    }
                    case 2: {
                        if (this.busTickets > 0 || !canGoToThisNode) break;
                        canGoToThisNode = false;
                        break;
                    }
                    case 3: {
                        if (this.ugTickets > 0 || !canGoToThisNode) break;
                        canGoToThisNode = false;
                    }
                }
                if (canGoToThisNode) {
                    possibleMoves.add(new Move(toNode.getPosition(), t));
                }
            }
            ++i;
        }
        return possibleMoves;
    }

    public String toString() {
        return I18n.tr("DetectiveStatus", this.getPosition().getPosition(), this.taxiTickets, this.busTickets, this.ugTickets);
    }

    public int mobility() {
        int mobility = 0;
        int i = 0;
        while (i < this.position.getLinks().length) {
            mobility += this.position.getLinks()[i].getType();
            ++i;
        }
        return mobility;
    }

    public void change(Node n, int ticket) {
        this.position = n;
        if (ticket == 1) {
            --this.taxiTickets;
        } else if (ticket == 2) {
            --this.busTickets;
        } else if (ticket == 3) {
            --this.ugTickets;
        }
    }
}

