/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Fugitive;
import game.TestBoard;
import i18n.I18n;
import javax.swing.table.AbstractTableModel;

class PreviousMoves
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    protected TestBoard board;
    protected int numDetectives;
    boolean revealAll;

    public PreviousMoves(TestBoard b, boolean all) {
        this.board = b;
        this.numDetectives = this.board.getDetectives().length;
        this.revealAll = all;
    }

    @Override
    public int getRowCount() {
        return this.board.getCurrentMoves();
    }

    @Override
    public int getColumnCount() {
        return this.numDetectives + 1;
    }

    @Override
    public Object getValueAt(int r, int c) {
        String pos = "";
        if (c > 0) {
            int ln = this.board.getDetectives()[c - 1].getPrevPos().size();
            if (r + 1 < ln) {
                pos = this.board.getDetectives()[c - 1].getPrevPos().get(r + 1).toString();
            }
        } else {
            Fugitive fg = this.board.getMrX();
            pos = !this.board.isCheckPoint(r + 1) && !this.revealAll ? String.valueOf(pos) + fg.getPrevPos().get(r + 1).toStringTicket() : String.valueOf(pos) + fg.getPrevPos().get(r + 1).toString();
        }
        return pos;
    }

    @Override
    public String getColumnName(int c) {
        if (c > 0) {
            return I18n.tr("DetectiveColumnHeader", c);
        }
        return I18n.tr("MrXColumnHeader");
    }
}

