/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.Player;
import edu.xtec.jclic.PlayerSettings;
import edu.xtec.jclic.accessibility.FressaFunctions;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.media.CheckMediaSystem;
import edu.xtec.jclic.media.EventSounds;
import edu.xtec.jclic.media.MediaContent;
import edu.xtec.jclic.project.ProjectInstallerDlg;
import edu.xtec.jclic.project.ProjectLibrary;
import edu.xtec.util.KJMenuItem;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;

public class ExtendedPlayer
extends Player {
    JFrame debugFrame = null;
    public static final String MESSAGES_BUNDLE = "messages.PlayerMessages";
    protected int recentFilesOffset;
    protected JMenuBar menuBar;
    protected JMenu fileMenu;
    protected JMenu recentFilesMenu;
    protected JMenu activityMenu;
    protected JMenu toolsMenu;
    protected JMenu helpMenu;
    protected PlayerSettings settings;
    protected FressaFunctions fressa;
    public static final int ACTION_OPEN_FILE = 8;
    public static final int ACTION_OPEN_URL = 9;
    public static final int ACTION_EXIT = 10;
    public static final int ACTION_SETTINGS = 11;
    public static final int ACTION_LIBRARIES = 12;
    public static final int ACTION_ABOUT = 13;
    public static final int NUM_ACTIONS_EXT = 14;
    public static final String[] ACTION_NAME_EXT = new String[]{"openFile", "openUrl", "exit", "settings", "libraries", "helpAbout"};
    public static final String[] ACTION_ICONS_EXT = new String[]{"icons/file_open.gif", "icons/world.gif", "icons/exit_small.gif", "icons/settings.gif", "icons/database.gif", "icons/help.gif"};

    public ExtendedPlayer(Options options) {
        super(options);
    }

    @Override
    protected void init() {
        this.settings = PlayerSettings.loadPlayerSettings(this);
        super.init();
        this.settings.checkLibrary();
        if (this.settings.fressaEnabled) {
            this.fressa = new FressaFunctions(this.options);
        }
    }

    protected void doInstall(String fileName) {
        if (this.settings.promptPassword(this, new String[]{"install_info_description", "settings_passwordRequired"})) {
            try {
                ProjectInstallerDlg pi = ProjectInstallerDlg.getProjectInstallerDlg(this, this.settings.libraryManager, fileName);
                if (pi != null) {
                    pi.setVisible(true);
                    if (pi.result != null && !pi.cancel) {
                        if (pi.launchNow && pi.pathToMainProject != null) {
                            this.load(pi.pathToMainProject, null);
                        } else {
                            this.launchProjectLibrary(pi.result);
                        }
                    }
                }
            }
            catch (Exception ex) {
                System.err.println("Error installing: " + ex.getMessage());
            }
        }
    }

    @Override
    public boolean start(String fullPath, String sequence) {
        boolean result = super.start(fullPath, sequence);
        if (!result) {
            try {
                ProjectLibrary pl = this.settings.libraryManager.getAutoStartProjectLibrary();
                if (pl != null) {
                    this.launchProjectLibrary(pl);
                }
            }
            catch (Exception ex) {
                System.err.println("Error loading autoStart project library!\n" + ex);
            }
        }
        return result;
    }

    @Override
    public boolean load(String fullPath, String sequence) {
        boolean result = false;
        if (fullPath != null && sequence == null && fullPath.endsWith(".jclic.inst")) {
            this.doInstall(fullPath);
        } else {
            result = super.load(fullPath, sequence);
        }
        return result;
    }

    @Override
    public Messages setMessages() {
        super.setMessages();
        this.messages.addBundle(MESSAGES_BUNDLE);
        return this.messages;
    }

    @Override
    protected FileSystem createFileSystem() {
        return this.settings.fileSystem;
    }

    protected void createMenu() {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu(this.messages.get("m_File"));
        this.fileMenu.setMnemonic(this.messages.get("m_File_Mnemonic").charAt(0));
        this.fileMenu.add(new KJMenuItem(this.getAction(8)));
        this.fileMenu.add(new KJMenuItem(this.getAction(9)));
        this.menuBar.add(this.fileMenu);
        this.activityMenu = new JMenu(this.messages.get("m_Activity"));
        this.activityMenu.setMnemonic(this.messages.get("m_Activity_Mnemonic").charAt(0));
        this.activityMenu.add(new KJMenuItem(this.getAction(1)));
        this.activityMenu.add(new KJMenuItem(this.getAction(0)));
        this.activityMenu.add(new KJMenuItem(this.getAction(2)));
        this.activityMenu.add(new KJMenuItem(this.getAction(3)));
        this.activityMenu.addSeparator();
        this.activityMenu.add(new KJMenuItem(this.getAction(4)));
        this.activityMenu.add(new KJMenuItem(this.getAction(5)));
        this.activityMenu.add(new KJMenuItem(this.getAction(7)));
        this.activityMenu.addSeparator();
        this.activityMenu.add(new KJMenuItem(this.getAction(6)));
        this.menuBar.add(this.activityMenu);
        this.toolsMenu = new JMenu(this.messages.get("m_Tools"));
        this.toolsMenu.setMnemonic(this.messages.get("m_Tools_Mnemonic").charAt(0));
        this.toolsMenu.add(new KJMenuItem(this.getAction(12)));
        this.toolsMenu.add(new KJMenuItem(this.getAction(11)));
        this.menuBar.add(this.toolsMenu);
        this.helpMenu = new JMenu(this.messages.get("m_Help"));
        this.helpMenu.setMnemonic(this.messages.get("m_Help_Mnemonic").charAt(0));
        this.helpMenu.add(new KJMenuItem(this.getAction(13)));
        this.menuBar.add(this.helpMenu);
    }

    protected void postCreateMenu() {
        this.fileMenu.addSeparator();
        this.fileMenu.add(new KJMenuItem(this.getAction(10)));
        this.fileMenu.addSeparator();
        this.recentFilesMenu = this.fileMenu;
        this.recentFilesOffset = this.fileMenu.getItemCount();
        this.updateRecentFilesMenu();
    }

    @Override
    public void addTo(RootPaneContainer cont, Object constraints) {
        super.addTo(cont, constraints);
        this.checkMenu(false);
    }

    protected void checkMenu(boolean recreate) {
        JRootPane rp = this.getRootPane();
        if (rp == null) {
            return;
        }
        if (recreate || rp.getJMenuBar() == null) {
            if (recreate || this.menuBar == null) {
                this.createMenu();
                this.postCreateMenu();
            }
            rp.setJMenuBar(this.menuBar);
            rp.revalidate();
        }
    }

    protected void updateRecentFilesMenu() {
        if (this.recentFilesMenu != null && this.recentFilesOffset >= 0) {
            int i;
            int itemsToRemove = this.recentFilesMenu.getItemCount() - this.recentFilesOffset;
            for (i = 0; i < itemsToRemove; ++i) {
                this.recentFilesMenu.remove(this.recentFilesOffset);
            }
            for (i = 0; i < PlayerSettings.MAX_RECENT; ++i) {
                if (this.settings.recentFiles[i] == null) continue;
                String s = this.settings.recentFiles[i];
                int k = s.lastIndexOf(92);
                if (k < 0) {
                    k = s.lastIndexOf(47);
                }
                if (k >= 0) {
                    s = s.substring(k + 1);
                }
                this.createMenuItem(this.recentFilesMenu, Integer.toString(i + 1) + ". " + s, "recent" + i, true, KeyStroke.getKeyStroke(49 + i, 8));
            }
        }
    }

    JMenuItem createMenuItem(JComponent parent, String text, String actionCommand, boolean mnemonic, KeyStroke accelerator) {
        JMenuItem jmi = new JMenuItem(text);
        if (actionCommand != null) {
            jmi.setActionCommand(actionCommand);
            jmi.addActionListener(this);
        }
        if (mnemonic) {
            jmi.setMnemonic(jmi.getText().charAt(0));
        }
        if (accelerator != null) {
            jmi.setAccelerator(accelerator);
        }
        parent.add(jmi);
        return jmi;
    }

    @Override
    protected int getNumActions() {
        return 14;
    }

    @Override
    protected void buildActions() {
        super.buildActions();
        this.actions[8] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String fileName;
                int[] filters;
                String result;
                FileSystem fs = ExtendedPlayer.this.project.getFileSystem();
                if (fs.isUrlBased()) {
                    fs = ExtendedPlayer.this.settings.fileSystem;
                }
                if ((result = fs.chooseFile(null, false, filters = new int[]{5, 7, 4}, ExtendedPlayer.this.options, null, ExtendedPlayer.this, false)) != null && ExtendedPlayer.this.load(fileName = fs.getFullFileNamePath(result), null)) {
                    ExtendedPlayer.this.addRecentFile(fileName);
                }
            }
        };
        this.actions[9] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String url = ExtendedPlayer.this.messages.showInputDlg((Component)ExtendedPlayer.this, "URL_OPEN", "URL", "http://", "URL_OPEN", false);
                if (url != null) {
                    if ((url = url.trim()).indexOf("://", 7) >= 0) {
                        url = url.substring(7);
                    }
                    if (url.length() > 0 && !url.equals("http://") && ExtendedPlayer.this.load(url, null)) {
                        ExtendedPlayer.this.addRecentFile(url);
                    }
                }
            }
        };
        this.actions[10] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ExtendedPlayer.this.exit();
            }
        };
        this.actions[11] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String currentLook = ExtendedPlayer.this.options.getString("lookAndFeel");
                String currentLanguage = ExtendedPlayer.this.options.getString("language");
                String currentCountry = ExtendedPlayer.this.options.getString("country");
                String currentVariant = ExtendedPlayer.this.options.getString("variant");
                String currentSkin = ExtendedPlayer.this.options.getString("skin");
                String currentReporterClass = ExtendedPlayer.this.settings.reporterClass;
                String currentReporterParams = ExtendedPlayer.this.settings.reporterParams;
                boolean currentReporterEnabled = ExtendedPlayer.this.settings.reporterEnabled;
                String currentMediaSystem = ExtendedPlayer.this.settings.mediaSystem;
                if (ExtendedPlayer.this.settings.edit(ExtendedPlayer.this)) {
                    AbstractButton bt;
                    ExtendedPlayer.this.settings.save();
                    ExtendedPlayer.this.options.syncProperties(ExtendedPlayer.this.settings.getProperties(), false);
                    if (!ExtendedPlayer.this.settings.skin.equals(currentSkin)) {
                        ExtendedPlayer.this.initSkin();
                        ExtendedPlayer.this.setSkin(null);
                    } else if (ExtendedPlayer.this.getSkin() != null && (bt = ExtendedPlayer.this.getSkin().getButton(6)) != null) {
                        bt.setSelected(!ExtendedPlayer.this.audioEnabled);
                    }
                    boolean recreateMenu = false;
                    if (!ExtendedPlayer.this.settings.lookAndFeel.equals(currentLook)) {
                        ExtendedPlayer.this.options.setLookAndFeel();
                        recreateMenu = true;
                    }
                    if (!(ExtendedPlayer.this.settings.language == null || StrUtils.compareObjects(ExtendedPlayer.this.settings.language, currentLanguage) && StrUtils.compareObjects(ExtendedPlayer.this.settings.country, currentCountry) && StrUtils.compareObjects(ExtendedPlayer.this.settings.variant, currentVariant))) {
                        ExtendedPlayer.this.setMessages();
                        recreateMenu = true;
                    }
                    if (recreateMenu) {
                        ExtendedPlayer.this.checkMenu(true);
                    }
                    if (!(!ExtendedPlayer.this.settings.reporterEnabled || ExtendedPlayer.this.settings.reporterClass.equals(currentReporterClass) && ExtendedPlayer.this.settings.reporterParams.equals(currentReporterParams))) {
                        ExtendedPlayer.this.initReporter();
                    }
                    ExtendedPlayer.this.audioEnabled = ExtendedPlayer.this.settings.soundEnabled;
                    EventSounds.globalEnabled = ExtendedPlayer.this.settings.systemSounds;
                    if (!currentMediaSystem.equals(ExtendedPlayer.this.settings.mediaSystem)) {
                        ExtendedPlayer.this.options.put("mediaSystem", ExtendedPlayer.this.settings.mediaSystem);
                        CheckMediaSystem.check(ExtendedPlayer.this.options, false);
                        ExtendedPlayer.this.createEventSounds();
                    }
                }
            }
        };
        this.actions[12] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                try {
                    ProjectLibrary pl = ExtendedPlayer.this.settings.libraryManager.selectProjectLibrary(true, false);
                    if (pl != null) {
                        ExtendedPlayer.this.launchProjectLibrary(pl);
                    }
                }
                catch (Exception ex) {
                    ExtendedPlayer.this.messages.showErrorWarning(ExtendedPlayer.this, "error_launchLibrary", ex);
                }
            }
        };
        this.actions[13] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ExtendedPlayer.this.showAbout(false);
            }
        };
    }

    @Override
    protected String getActionName(int actionId) {
        if (actionId >= 8 && actionId < 14) {
            return ACTION_NAME_EXT[actionId - 8];
        }
        return super.getActionName(actionId);
    }

    @Override
    protected Icon getActionIcon(int actionId) {
        if (actionId >= 8 && actionId < 14) {
            return ResourceManager.getImageIcon(ACTION_ICONS_EXT[actionId - 8]);
        }
        return super.getActionIcon(actionId);
    }

    @Override
    protected boolean processActionEvent(String ac) {
        if (ac.startsWith("recent") && ac.length() > 6) {
            try {
                int i = Integer.parseInt(ac.substring(6));
                if (i >= 0 && i < PlayerSettings.MAX_RECENT && this.settings.recentFiles[i] != null) {
                    this.load(this.settings.recentFiles[i], null);
                }
            }
            catch (Exception ex) {
                System.err.println("invalid command: " + ac);
            }
        } else {
            return super.processActionEvent(ac);
        }
        return true;
    }

    protected void launchProjectLibrary(ProjectLibrary pl) {
        if (pl != null) {
            this.setProject(null);
            MediaContent mc = new MediaContent();
            mc.externalParam = pl.getFullPath();
            mc.mediaFileName = pl.activitySequence.getElement(0, false).getTag();
            mc.mediaType = 8;
            this.playMedia(mc, null);
        }
    }

    protected void addRecentFile(String fName) {
        this.settings.addRecentFile(fName);
        this.updateRecentFilesMenu();
        this.settings.save();
    }

    @Override
    public FressaFunctions getFressa() {
        return this.fressa;
    }
}

