/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.Constants;
import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.ActiveBox;
import java.awt.AWTEvent;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class HelpActivityComponent
extends JPanel
implements ListSelectionListener {
    public static final String PREFERRED_LOCATION = "prefLoc";
    public Activity.Panel ap;
    public AbstractBox markedBox;
    public boolean markedBoxWasVisible;

    public HelpActivityComponent(Activity.Panel setAct) {
        this.ap = setAct;
        this.markedBox = null;
        this.enableEvents(16L);
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.putClientProperty(PREFERRED_LOCATION, new Point(this.ap.getLocationOnScreen()));
    }

    public void init() {
    }

    public void end() {
        this.unmarkBox();
    }

    public abstract void render(Graphics2D var1, Rectangle var2);

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints rh = g2.getRenderingHints();
        g2.setRenderingHints(Constants.DEFAULT_RENDERING_HINTS);
        super.paintComponent(g2);
        this.render(g2, g2.getClipBounds());
        g2.setRenderingHints(rh);
    }

    public void unmarkBox() {
        this.ap.ps.stopMedia(1);
        if (this.markedBox != null) {
            this.markedBox.setMarked(!this.markedBox.isMarked());
            this.markedBox.setInverted(!this.markedBox.isInverted());
            this.markedBox.setVisible(this.markedBoxWasVisible);
            this.markedBox = null;
        }
    }

    public void markBox(AbstractBox bx, boolean play) {
        this.unmarkBox();
        this.markedBox = bx;
        if (bx != null) {
            this.markedBoxWasVisible = bx.isVisible();
            if (play && bx instanceof ActiveBox) {
                ((ActiveBox)bx).playMedia(this.ap.ps);
            }
            bx.setMarked(!bx.isMarked());
            bx.setInverted(!bx.isInverted());
            bx.setVisible(true);
        }
    }

    public void processMouse(MouseEvent p1) {
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof MouseEvent) {
            this.processMouse((MouseEvent)e);
        }
        super.processEvent(e);
    }

    @Override
    public void valueChanged(ListSelectionEvent ev) {
    }

    @Override
    public void doLayout() {
    }
}

