/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.accessibility;

import edu.xtec.jclic.accessibility.FressaFunctions;
import edu.xtec.util.Options;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TFormKeyboard
extends JFrame {
    JPanel panelPlaphoons;
    public static final int CELLS_X = 15;
    public static final int CELLS_Y = 5;
    public static final int DEFAULT_POS_X = 100;
    public static final int DEFAULT_POS_Y = 100;
    public static final int DEFAULT_WIDTH = 445;
    public static final int DEFAULT_HEIGHT = 160;
    public static final float FONT_SIZE_INCREMENT = 4.0f;
    int cellWidth;
    int cellHeight;
    JLabel[][] keys = new JLabel[15][5];
    boolean[][] full = new boolean[15][5];
    int frameBorder = 1;
    int frameSpan;
    int span = this.frameSpan = 2;
    boolean isShiftLock = false;
    boolean isShift = false;
    int iIsShift;
    int nIsShift;
    boolean isHorizontalScanning = false;
    int xPos = 0;
    int yPos = 0;
    FressaFunctions fressa;
    Font font;
    Font boldFont;

    public TFormKeyboard(Options options, FressaFunctions fressa) {
        this.fressa = fressa;
        this.setResizable(true);
        this.setLocation(100, 100);
        this.setTitle(options.getMsg("acc_keyboardTitle"));
        this.setDefaultCloseOperation(2);
        this.panelPlaphoons = new JPanel();
        this.panelPlaphoons.setBackground(Color.white);
        this.panelPlaphoons.setBorder(BorderFactory.createBevelBorder(1));
        this.add((Component)this.panelPlaphoons, "Center");
        this.panelPlaphoons.setLayout(null);
        this.setSize(445, 160);
        this.font = new JLabel().getFont();
        this.font = this.font.deriveFont(this.font.getSize2D() + 4.0f);
        this.boldFont = this.font.deriveFont(1);
        MouseAdapter mAdapter = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                if (me.getButton() == 1) {
                    TFormKeyboard.this.plafonsOnClick(me);
                }
            }
        };
        for (int i = 0; i < 15; ++i) {
            for (int n = 0; n < 5; ++n) {
                this.full[i][n] = false;
                this.keys[i][n] = new JLabel();
                if (i > 0) {
                    this.keys[i][n].setBorder(BorderFactory.createLineBorder(Color.black, this.frameBorder));
                }
                this.keys[i][n].setHorizontalAlignment(0);
                this.keys[i][n].setFont(this.font);
                this.panelPlaphoons.add(this.keys[i][n]);
                this.keys[i][n].addMouseListener(mAdapter);
            }
        }
        this.lowercase();
        this.setAlwaysOnTop(true);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, screenSize.height - frameSize.height);
        this.calcFrameSize();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                TFormKeyboard.this.calcFrameSize();
            }
        });
    }

    void sendKey(int t) {
        if (this.fressa.robot != null) {
            this.fressa.robot.keyPress(t);
            this.fressa.robot.keyRelease(t);
        }
        this.isShiftFalse();
    }

    void sendShiftKey(int t) {
        if (this.fressa.robot != null) {
            this.fressa.robot.keyPress(16);
            this.fressa.robot.keyPress(t);
            this.fressa.robot.keyRelease(t);
            this.fressa.robot.keyRelease(16);
        }
        this.isShiftFalse();
    }

    void isShiftFalse() {
        if (this.isShift) {
            this.isShift = false;
            this.keys[this.iIsShift][this.nIsShift].setForeground(Color.black);
            if (this.isShiftLock) {
                this.uppercase();
            } else {
                this.lowercase();
            }
        }
    }

    public void changeScanningPosition() {
        if (this.isHorizontalScanning) {
            ++this.xPos;
            if (this.xPos >= 15) {
                this.isHorizontalScanning = false;
                this.xPos = 0;
                this.yPos = 0;
            } else {
                while (this.keys[this.xPos][this.yPos].getText().equals("") && !this.full[this.xPos][this.yPos]) {
                    ++this.xPos;
                    if (this.xPos < 15) continue;
                    this.isHorizontalScanning = false;
                    this.xPos = 0;
                    this.yPos = 0;
                    break;
                }
            }
        } else {
            this.yPos = (this.yPos + 1) % 5;
        }
        int x = this.keys[this.xPos][this.yPos].getLocationOnScreen().x + this.cellWidth / 2;
        int y = this.keys[this.xPos][this.yPos].getLocationOnScreen().y + this.cellHeight / 2;
        this.mouseMove(x, y);
        if (this.fressa.readLabels && !this.keys[this.xPos][this.yPos].getText().equals("")) {
            this.fressa.readText(this.keys[this.xPos][this.yPos].getText());
        }
    }

    public void doClick() {
        if (this.fressa.robot != null) {
            this.fressa.robot.mousePress(16);
            this.fressa.robot.mouseRelease(16);
        }
    }

    public void mouseMove(int x, int y) {
        if (this.fressa.robot != null) {
            this.fressa.robot.mouseMove(x, y);
        }
    }

    public void plafonsOnClick(MouseEvent evt) {
        int ic = -1;
        int nc = -1;
        if (this.fressa.actPanel == null) {
            return;
        }
        this.fressa.actPanel.requestFocus();
        int wait = 0;
        int maxWait = 10;
        while (!this.fressa.actPanel.hasFocus() && ++wait <= maxWait) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                System.err.println("Error while waiting to transfer focus. " + ex.getMessage());
                break;
            }
        }
        if (!this.fressa.actPanel.hasFocus()) {
            System.err.println("Accessible keyboard: Error transferring focus!");
            return;
        }
        block3: for (int i = 0; i < 15; ++i) {
            for (int n = 0; n < 5; ++n) {
                if (!evt.getComponent().equals(this.keys[i][n])) continue;
                ic = i;
                nc = n;
                continue block3;
            }
        }
        if (ic == -1 && nc == -1) {
            return;
        }
        this.fressa.mustDisableScanTimer = true;
        if (ic == 0) {
            this.isHorizontalScanning = true;
            this.xPos = 0;
            this.changeScanningPosition();
            return;
        }
        this.isHorizontalScanning = false;
        this.xPos = 0;
        this.yPos = -1;
        if (nc == 0 && ic == 14) {
            this.sendKey(8);
        } else if (this.keys[ic][nc].getText().equals("tab")) {
            if (this.isShift) {
                this.sendShiftKey(9);
            } else {
                this.sendKey(9);
            }
        } else if ((nc == 1 || nc == 2) && ic == 14 || nc == 0 && ic == 1) {
            this.sendKey(10);
        } else if (nc == 4 && ic == 1) {
            this.sendKey(32);
        } else if (nc == 4 && ic == 2) {
            this.sendKey(127);
        } else if (nc == 4 && ic == 3) {
            this.sendKey(37);
        } else if (nc == 4 && ic == 4) {
            this.sendKey(39);
        } else if (nc == 4 && ic == 5) {
            this.sendKey(40);
        } else if (nc == 4 && ic == 6) {
            this.sendKey(38);
        } else if (!this.keys[ic][nc].getText().equals("\u00ba")) {
            if (this.keys[ic][nc].getText().equals("1")) {
                this.sendKey(49);
            } else if (this.keys[ic][nc].getText().equals("2")) {
                this.sendKey(50);
            } else if (this.keys[ic][nc].getText().equals("3")) {
                this.sendKey(51);
            } else if (this.keys[ic][nc].getText().equals("4")) {
                this.sendKey(52);
            } else if (this.keys[ic][nc].getText().equals("5")) {
                this.sendKey(53);
            } else if (this.keys[ic][nc].getText().equals("6")) {
                this.sendKey(54);
            } else if (this.keys[ic][nc].getText().equals("7")) {
                this.sendKey(55);
            } else if (this.keys[ic][nc].getText().equals("8")) {
                this.sendKey(56);
            } else if (this.keys[ic][nc].getText().equals("9")) {
                this.sendKey(57);
            } else if (this.keys[ic][nc].getText().equals("0")) {
                this.sendKey(48);
            } else if (this.keys[ic][nc].getText().equals("'")) {
                this.sendKey(222);
            } else if (this.keys[ic][nc].getText().equals("\u00a1")) {
                this.sendKey(518);
            } else if (this.keys[ic][nc].getText().equals("`")) {
                this.sendKey(128);
            } else if (this.keys[ic][nc].getText().equals("+")) {
                this.sendKey(521);
            } else if (this.keys[ic][nc].getText().equals("\u00f1")) {
                if (this.fressa.robot != null) {
                    this.fressa.robot.keyPress(18);
                    this.fressa.robot.keyPress(97);
                    this.fressa.robot.keyRelease(97);
                    this.fressa.robot.keyPress(102);
                    this.fressa.robot.keyRelease(102);
                    this.fressa.robot.keyPress(100);
                    this.fressa.robot.keyRelease(100);
                    this.fressa.robot.keyRelease(18);
                }
                this.isShiftFalse();
            } else if (this.keys[ic][nc].getText().equals("\u00b4")) {
                this.sendKey(129);
            } else if (this.keys[ic][nc].getText().equals("\u00e7")) {
                if (this.fressa.robot != null) {
                    this.fressa.robot.keyPress(18);
                    this.fressa.robot.keyPress(97);
                    this.fressa.robot.keyRelease(97);
                    this.fressa.robot.keyPress(99);
                    this.fressa.robot.keyRelease(99);
                    this.fressa.robot.keyPress(101);
                    this.fressa.robot.keyRelease(101);
                    this.fressa.robot.keyRelease(18);
                }
                this.isShiftFalse();
            } else if (this.keys[ic][nc].getText().equals(",")) {
                this.sendKey(44);
            } else if (this.keys[ic][nc].getText().equals(".")) {
                this.sendKey(this.keys[ic][nc].getText().codePointAt(0));
            } else if (this.keys[ic][nc].getText().equals("-")) {
                this.sendKey(45);
            } else if (this.keys[ic][nc].getText().equals("<")) {
                this.sendKey(153);
            } else if (!this.keys[ic][nc].getText().equals("\u00aa")) {
                if (this.keys[ic][nc].getText().equals("!")) {
                    this.sendShiftKey(49);
                } else if (this.keys[ic][nc].getText().equals("\"")) {
                    this.sendShiftKey(50);
                } else if (this.keys[ic][nc].getText().equals("\u00b7")) {
                    this.sendShiftKey(51);
                } else if (this.keys[ic][nc].getText().equals("$")) {
                    this.sendShiftKey(52);
                } else if (this.keys[ic][nc].getText().equals("%")) {
                    this.sendShiftKey(53);
                } else if (this.keys[ic][nc].getText().equals("&")) {
                    this.sendShiftKey(54);
                } else if (this.keys[ic][nc].getText().equals("/")) {
                    this.sendKey(111);
                } else if (this.keys[ic][nc].getText().equals("(")) {
                    this.sendShiftKey(56);
                } else if (this.keys[ic][nc].getText().equals(")")) {
                    this.sendShiftKey(57);
                } else if (this.keys[ic][nc].getText().equals("=")) {
                    this.sendShiftKey(48);
                } else if (this.keys[ic][nc].getText().equals("?")) {
                    this.sendShiftKey(222);
                } else if (this.keys[ic][nc].getText().equals("\u00bf")) {
                    this.sendShiftKey(518);
                } else if (this.keys[ic][nc].getText().equals("^")) {
                    this.sendShiftKey(128);
                } else if (this.keys[ic][nc].getText().equals("*")) {
                    this.sendShiftKey(521);
                } else if (this.keys[ic][nc].getText().equals("\u00a8")) {
                    this.sendShiftKey(129);
                } else if (this.keys[ic][nc].getText().equals("\u00c7")) {
                    if (this.fressa.robot != null) {
                        this.fressa.robot.keyPress(18);
                        this.fressa.robot.keyPress(97);
                        this.fressa.robot.keyRelease(97);
                        this.fressa.robot.keyPress(98);
                        this.fressa.robot.keyRelease(98);
                        this.fressa.robot.keyPress(104);
                        this.fressa.robot.keyRelease(104);
                        this.fressa.robot.keyRelease(18);
                    }
                    this.isShiftFalse();
                } else if (this.keys[ic][nc].getText().equals("\u00d1")) {
                    if (this.fressa.robot != null) {
                        this.fressa.robot.keyPress(18);
                        this.fressa.robot.keyPress(97);
                        this.fressa.robot.keyRelease(97);
                        this.fressa.robot.keyPress(102);
                        this.fressa.robot.keyRelease(102);
                        this.fressa.robot.keyPress(101);
                        this.fressa.robot.keyRelease(101);
                        this.fressa.robot.keyRelease(18);
                    }
                    this.isShiftFalse();
                } else if (this.keys[ic][nc].getText().equals(">")) {
                    this.sendShiftKey(153);
                } else if (this.keys[ic][nc].getText().equals(";")) {
                    this.sendShiftKey(44);
                } else if (this.keys[ic][nc].getText().equals(":")) {
                    this.sendShiftKey(".".codePointAt(0));
                } else if (this.keys[ic][nc].getText().equals("_")) {
                    this.sendShiftKey(45);
                } else if (this.keys[ic][nc].getText().equals("co")) {
                    if (this.fressa.robot != null && this.fressa.actPanelRectangleMiddleBottom != null) {
                        this.mouseMove(this.fressa.actPanelRectangleMiddleBottom.x, this.fressa.actPanelRectangleMiddleBottom.y);
                        this.doClick();
                    }
                } else if (this.keys[ic][nc].getText().equals("<>")) {
                    this.fressa.currentZone = 0;
                    this.fressa.place = 0;
                } else if (this.keys[ic][nc].getText().equals("BM")) {
                    boolean bl = this.isShiftLock = !this.isShiftLock;
                    if (this.isShift) {
                        this.isShift = false;
                        this.keys[this.iIsShift][this.nIsShift].setForeground(new Color(0, 0, 0));
                    }
                    if (this.isShiftLock) {
                        this.uppercase();
                        this.keys[ic][nc].setForeground(new Color(127, 127, 127));
                    } else {
                        this.lowercase();
                        this.keys[ic][nc].setForeground(new Color(0, 0, 0));
                    }
                } else if (this.keys[ic][nc].getText().equals("shi")) {
                    this.isShift = !this.isShift;
                    this.iIsShift = ic;
                    this.nIsShift = nc;
                    if (this.isShift) {
                        if (this.isShiftLock) {
                            this.lowercase();
                        } else {
                            this.uppercase();
                        }
                        this.keys[ic][nc].setForeground(new Color(127, 127, 127));
                    } else {
                        if (this.isShiftLock) {
                            this.uppercase();
                        } else {
                            this.lowercase();
                        }
                        this.keys[ic][nc].setForeground(new Color(0, 0, 0));
                    }
                } else if (!this.keys[ic][nc].getText().equals("")) {
                    if (!this.keys[ic][nc].getText().equals(this.keys[ic][nc].getText().toUpperCase())) {
                        this.sendKey(this.keys[ic][nc].getText().toUpperCase().codePointAt(0));
                    } else {
                        this.sendShiftKey(this.keys[ic][nc].getText().toUpperCase().codePointAt(0));
                    }
                }
            }
        }
        this.fressa.mustDisableScanTimer = false;
    }

    public void calcFrameSize() {
        this.cellWidth = this.panelPlaphoons.getWidth() / 15;
        this.cellHeight = this.panelPlaphoons.getHeight() / 5;
        this.span = this.frameBorder + this.frameSpan;
        for (int i = 0; i < 15; ++i) {
            for (int n = 0; n < 5; ++n) {
                this.keys[i][n].setVisible(false);
                this.keys[i][n].setBounds(this.frameSpan + this.cellWidth * i, this.frameSpan + this.cellHeight * n, this.cellWidth - this.frameSpan, this.cellHeight - this.frameSpan);
                this.keys[i][n].setVisible(true);
            }
        }
    }

    void lowercase() {
        int i = 1;
        int n = 0;
        this.keys[i][n].setIcon(new ImageIcon(this.getClass().getResource("return.gif")));
        this.full[i][n] = true;
        this.keys[++i][n].setText("1");
        this.full[i][n] = true;
        this.keys[++i][n].setText("2");
        this.full[i][n] = true;
        this.keys[++i][n].setText("3");
        this.full[i][n] = true;
        this.keys[++i][n].setText("4");
        this.full[i][n] = true;
        this.keys[++i][n].setText("5");
        this.full[i][n] = true;
        this.keys[++i][n].setText("6");
        this.full[i][n] = true;
        this.keys[++i][n].setText("7");
        this.full[i][n] = true;
        this.keys[++i][n].setText("8");
        this.full[i][n] = true;
        this.keys[++i][n].setText("9");
        this.full[i][n] = true;
        this.keys[++i][n].setText("0");
        this.full[i][n] = true;
        this.keys[++i][n].setText("'");
        this.full[i][n] = true;
        this.keys[++i][n].setText("\u00a1");
        this.full[i][n] = true;
        this.keys[++i][n].setIcon(new ImageIcon(this.getClass().getResource("bacspace.gif")));
        this.full[i][n] = true;
        ++i;
        i = 1;
        this.keys[i][++n].setText("tab");
        this.full[i][n] = true;
        this.keys[++i][n].setText("q");
        this.full[i][n] = true;
        this.keys[++i][n].setText("w");
        this.full[i][n] = true;
        this.keys[++i][n].setText("e");
        this.full[i][n] = true;
        this.keys[++i][n].setText("r");
        this.full[i][n] = true;
        this.keys[++i][n].setText("t");
        this.full[i][n] = true;
        this.keys[++i][n].setText("y");
        this.full[i][n] = true;
        this.keys[++i][n].setText("u");
        this.full[i][n] = true;
        this.keys[++i][n].setText("i");
        this.full[i][n] = true;
        this.keys[++i][n].setText("o");
        this.full[i][n] = true;
        this.keys[++i][n].setText("p");
        this.full[i][n] = true;
        this.keys[++i][n].setText("`");
        this.full[i][n] = true;
        this.keys[++i][n].setText("+");
        this.full[i][n] = true;
        this.keys[++i][n].setIcon(new ImageIcon(this.getClass().getResource("return.gif")));
        this.full[i][n] = true;
        ++i;
        i = 1;
        this.keys[i][++n].setText("BM");
        this.full[i][n] = true;
        this.keys[++i][n].setText("a");
        this.full[i][n] = true;
        this.keys[++i][n].setText("s");
        this.full[i][n] = true;
        this.keys[++i][n].setText("d");
        this.full[i][n] = true;
        this.keys[++i][n].setText("f");
        this.full[i][n] = true;
        this.keys[++i][n].setText("g");
        this.full[i][n] = true;
        this.keys[++i][n].setText("h");
        this.full[i][n] = true;
        this.keys[++i][n].setText("j");
        this.full[i][n] = true;
        this.keys[++i][n].setText("k");
        this.full[i][n] = true;
        this.keys[++i][n].setText("l");
        this.full[i][n] = true;
        this.keys[++i][n].setText("\u00f1");
        this.full[i][n] = true;
        this.keys[++i][n].setText("\u00b4");
        this.full[i][n] = true;
        this.keys[++i][n].setText("\u00e7");
        this.full[i][n] = true;
        this.keys[++i][n].setIcon(new ImageIcon(this.getClass().getResource("return.gif")));
        this.full[i][n] = true;
        ++i;
        i = 1;
        this.keys[i][++n].setText("shi");
        this.full[i][n] = true;
        this.keys[++i][n].setText("<");
        this.full[i][n] = true;
        this.keys[++i][n].setText("z");
        this.full[i][n] = true;
        this.keys[++i][n].setText("x");
        this.full[i][n] = true;
        this.keys[++i][n].setText("c");
        this.full[i][n] = true;
        this.keys[++i][n].setText("v");
        this.full[i][n] = true;
        this.keys[++i][n].setText("b");
        this.full[i][n] = true;
        this.keys[++i][n].setText("n");
        this.full[i][n] = true;
        this.keys[++i][n].setText("m");
        this.full[i][n] = true;
        this.keys[++i][n].setText(",");
        this.full[i][n] = true;
        this.keys[++i][n].setText(".");
        this.full[i][n] = true;
        this.keys[++i][n].setText("-");
        this.full[i][n] = true;
        ++i;
        ++i;
        i = 1;
        this.keys[i][++n].setIcon(new ImageIcon(this.getClass().getResource("espai.gif")));
        this.full[i][n] = true;
        this.keys[++i][n].setIcon(new ImageIcon(this.getClass().getResource("delete.gif")));
        this.full[i][n] = true;
        this.keys[++i][n].setIcon(new ImageIcon(this.getClass().getResource("esquerra.gif")));
        this.full[i][n] = true;
        this.keys[++i][n].setIcon(new ImageIcon(this.getClass().getResource("dreta.gif")));
        this.full[i][n] = true;
        this.keys[++i][n].setIcon(new ImageIcon(this.getClass().getResource("baixa.gif")));
        this.full[i][n] = true;
        this.keys[++i][n].setIcon(new ImageIcon(this.getClass().getResource("puja.gif")));
        this.full[i][n] = true;
        this.keys[++i][n].setText("<>");
        this.full[i][n] = true;
        Font f = this.keys[i][n].getFont();
        this.keys[i][n].setFont(new Font(f.getFontName(), 1, f.getSize()));
        this.keys[++i][n].setText("co");
        this.full[i][n] = true;
        f = this.keys[i][n].getFont();
        this.keys[i][n].setFont(new Font(f.getFontName(), 1, f.getSize()));
        this.keys[++i][n].setText("");
        f = this.keys[i][n].getFont();
        this.keys[i][n].setFont(new Font(f.getFontName(), 1, f.getSize()));
        ++i;
    }

    void uppercase() {
        int i = 1;
        int n = 0;
        this.keys[i][n].setIcon(new ImageIcon(this.getClass().getResource("return.gif")));
        this.full[i][n] = true;
        this.keys[++i][n].setText("!");
        this.full[i][n] = true;
        this.keys[++i][n].setText("\"");
        this.full[i][n] = true;
        this.keys[++i][n].setText("\u00b7");
        this.full[i][n] = true;
        this.keys[++i][n].setText("$");
        this.full[i][n] = true;
        this.keys[++i][n].setText("%");
        this.full[i][n] = true;
        this.keys[++i][n].setText("&");
        this.full[i][n] = true;
        this.keys[++i][n].setText("/");
        this.full[i][n] = true;
        this.keys[++i][n].setText("(");
        this.full[i][n] = true;
        this.keys[++i][n].setText(")");
        this.full[i][n] = true;
        this.keys[++i][n].setText("=");
        this.full[i][n] = true;
        this.keys[++i][n].setText("?");
        this.full[i][n] = true;
        this.keys[++i][n].setText("\u00bf");
        this.full[i][n] = true;
        this.keys[++i][n].setIcon(new ImageIcon(this.getClass().getResource("bacspace.gif")));
        this.full[i][n] = true;
        ++i;
        i = 1;
        this.keys[i][++n].setText("tab");
        this.full[i][n] = true;
        this.keys[++i][n].setText("Q");
        this.full[i][n] = true;
        this.keys[++i][n].setText("W");
        this.full[i][n] = true;
        this.keys[++i][n].setText("E");
        this.full[i][n] = true;
        this.keys[++i][n].setText("R");
        this.full[i][n] = true;
        this.keys[++i][n].setText("T");
        this.full[i][n] = true;
        this.keys[++i][n].setText("Y");
        this.full[i][n] = true;
        this.keys[++i][n].setText("U");
        this.full[i][n] = true;
        this.keys[++i][n].setText("I");
        this.full[i][n] = true;
        this.keys[++i][n].setText("O");
        this.full[i][n] = true;
        this.keys[++i][n].setText("P");
        this.full[i][n] = true;
        this.keys[++i][n].setText("^");
        this.full[i][n] = true;
        this.keys[++i][n].setText("*");
        this.full[i][n] = true;
        this.keys[++i][n].setIcon(new ImageIcon(this.getClass().getResource("return.gif")));
        this.full[i][n] = true;
        ++i;
        i = 1;
        this.keys[i][++n].setText("BM");
        this.full[i][n] = true;
        this.keys[++i][n].setText("A");
        this.full[i][n] = true;
        this.keys[++i][n].setText("S");
        this.full[i][n] = true;
        this.keys[++i][n].setText("D");
        this.full[i][n] = true;
        this.keys[++i][n].setText("F");
        this.full[i][n] = true;
        this.keys[++i][n].setText("G");
        this.full[i][n] = true;
        this.keys[++i][n].setText("H");
        this.full[i][n] = true;
        this.keys[++i][n].setText("J");
        this.full[i][n] = true;
        this.keys[++i][n].setText("K");
        this.full[i][n] = true;
        this.keys[++i][n].setText("L");
        this.full[i][n] = true;
        this.keys[++i][n].setText("\u00d1");
        this.full[i][n] = true;
        this.keys[++i][n].setText("\u00a8");
        this.full[i][n] = true;
        this.keys[++i][n].setText("\u00c7");
        this.full[i][n] = true;
        this.keys[++i][n].setIcon(new ImageIcon(this.getClass().getResource("return.gif")));
        this.full[i][n] = true;
        ++i;
        i = 1;
        this.keys[i][++n].setText("shi");
        this.full[i][n] = true;
        this.keys[++i][n].setText(">");
        this.full[i][n] = true;
        this.keys[++i][n].setText("Z");
        this.full[i][n] = true;
        this.keys[++i][n].setText("X");
        this.full[i][n] = true;
        this.keys[++i][n].setText("C");
        this.full[i][n] = true;
        this.keys[++i][n].setText("V");
        this.full[i][n] = true;
        this.keys[++i][n].setText("B");
        this.full[i][n] = true;
        this.keys[++i][n].setText("N");
        this.full[i][n] = true;
        this.keys[++i][n].setText("M");
        this.full[i][n] = true;
        this.keys[++i][n].setText(";");
        this.full[i][n] = true;
        this.keys[++i][n].setText(":");
        this.full[i][n] = true;
        this.keys[++i][n].setText("_");
        this.full[i][n] = true;
        ++i;
        ++i;
        i = 1;
        this.keys[i][++n].setIcon(new ImageIcon(this.getClass().getResource("espai.gif")));
        this.full[i][n] = true;
        this.keys[++i][n].setIcon(new ImageIcon(this.getClass().getResource("delete.gif")));
        this.full[i][n] = true;
        this.keys[++i][n].setIcon(new ImageIcon(this.getClass().getResource("esquerra.gif")));
        this.full[i][n] = true;
        this.keys[++i][n].setIcon(new ImageIcon(this.getClass().getResource("dreta.gif")));
        this.full[i][n] = true;
        this.keys[++i][n].setIcon(new ImageIcon(this.getClass().getResource("baixa.gif")));
        this.full[i][n] = true;
        this.keys[++i][n].setIcon(new ImageIcon(this.getClass().getResource("puja.gif")));
        this.full[i][n] = true;
        this.keys[++i][n].setText("<>");
        this.full[i][n] = true;
        Font f = this.keys[i][n].getFont();
        this.keys[i][n].setFont(this.boldFont);
        this.keys[++i][n].setText("co");
        this.full[i][n] = true;
        f = this.keys[i][n].getFont();
        this.keys[i][n].setFont(this.boldFont);
        this.keys[++i][n].setText("");
        f = this.keys[i][n].getFont();
        this.keys[i][n].setFont(this.boldFont);
        ++i;
    }
}

