/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.panels;

import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.edit.Editable;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.ResourceManager;
import javax.swing.ImageIcon;
import org.jdom.Element;

public class MenuElement
implements Editable,
Cloneable,
Domable {
    public String caption;
    public String icon = "@ico00.png";
    public String projectPath;
    public String sequence;
    public String description;
    public static final String ELEMENT_NAME = "menuElement";
    public static final String CAPTION = "caption";
    public static final String ICON = "icon";
    public static final String PATH = "path";
    public static final String SEQUENCE = "sequence";
    public static final String DESCRIPTION = "description";
    public static final String RETURN_TAG = "@RETURN";
    public static final String DEFAULT_ICON = "@ico00.png";
    public static final String DEFAULT_FOLDER_ICON = "@icofolder.png";
    public static final int MAX_ICON_WIDTH = 32;
    public static final int MAX_ICON_HEIGHT = 32;

    @Override
    public Element getJDomElement() {
        Element e = new Element(ELEMENT_NAME);
        if (this.caption != null) {
            e.setAttribute(CAPTION, this.caption);
        }
        if (this.icon != null && !this.icon.equals(DEFAULT_ICON)) {
            e.setAttribute(ICON, this.icon);
        }
        if (this.projectPath != null) {
            e.setAttribute(PATH, this.projectPath);
        }
        if (this.sequence != null) {
            e.setAttribute(SEQUENCE, this.sequence);
        }
        if (this.description != null) {
            e.setAttribute(DESCRIPTION, this.description);
        }
        return e;
    }

    public ImageIcon getIcon(MediaBag mb) {
        ImageIcon result = null;
        if (this.icon.startsWith("@")) {
            String fn = this.icon.substring(1);
            if (fn.endsWith(".gif") && fn.startsWith("ico")) {
                fn = fn.substring(0, fn.length() - 4) + ".png";
            }
            result = ResourceManager.getImageIcon("icons/" + fn);
        } else {
            try {
                result = new ImageIcon(mb.getImageElement(this.icon).getImage());
                result.setDescription(this.icon);
            }
            catch (Exception ex) {
                System.err.println("Error reading image " + this.icon + "\n" + ex);
            }
        }
        if (result == null) {
            result = ResourceManager.getImageIcon("icons/ico00.png");
        }
        return result;
    }

    public static MenuElement getMenuElement(Element e) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        MenuElement me = new MenuElement();
        me.setProperties(e, null);
        return me;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        this.caption = JDomUtility.getStringAttr(e, CAPTION, this.caption, false);
        this.sequence = JDomUtility.getStringAttr(e, SEQUENCE, this.sequence, false);
        this.description = JDomUtility.getStringAttr(e, DESCRIPTION, this.description, false);
        this.projectPath = FileSystem.stdFn(JDomUtility.getStringAttr(e, PATH, this.projectPath, false));
        this.icon = this.projectPath == null ? DEFAULT_FOLDER_ICON : DEFAULT_ICON;
        this.icon = FileSystem.stdFn(JDomUtility.getStringAttr(e, ICON, this.icon, false));
    }

    @Override
    public Editor getEditor(Editor parent) {
        return Editor.createEditor(this.getClass().getName() + "Editor", this, parent);
    }
}

