/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.activities.text.TargetMarker;
import edu.xtec.jclic.activities.text.TargetMarkerBag;
import edu.xtec.jclic.activities.text.TextActivityBase;
import edu.xtec.jclic.activities.text.TextActivityDocument;
import edu.xtec.jclic.activities.text.TextActivityPane;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.Actions;
import edu.xtec.util.JDomUtility;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.ActionMap;
import javax.swing.text.BadLocationException;
import org.jdom.Element;

public class Identify
extends TextActivityBase {
    public static final int IDENTIFY_WORDS = 0;
    public static final int IDENTIFY_CHARS = 1;
    protected int type;
    public static final String[] TYPES = new String[]{"identifyWords", "identifyChars"};

    public Identify(JClicProject project) {
        super(project);
        this.setType(0);
        this.hasCheckButton = true;
        this.checkButtonText = "";
    }

    @Override
    public Element getJDomElement() {
        Element e = super.getJDomElement();
        e.setAttribute("type", TYPES[this.type]);
        return e;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        super.setProperties(e, aux);
        this.setType(JDomUtility.getStrIndexAttr(e, "type", TYPES, this.type));
    }

    @Override
    public void setProperties(Clic3Activity c3a) throws Exception {
        super.setProperties(c3a);
        this.setType(c3a.puzMode == 3 ? 0 : 1);
    }

    @Override
    public Activity.Panel getActivityPanel(PlayStation ps) {
        return new Panel(ps);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type == 1 ? 1 : 0;
        this.tad.setTargetType(type == 1 ? 1 : 2);
    }

    class Panel
    extends TextActivityBase.Panel {
        TextActivityDocument playDoc;
        int nActions;
        int score;
        boolean[] validChars;
        boolean[] marks;
        boolean[] targets;

        protected Panel(PlayStation ps) {
            super(Identify.this, ps);
            this.playDoc = null;
            this.nActions = 0;
            this.score = 0;
            this.validChars = null;
            this.marks = null;
            this.targets = null;
        }

        @Override
        protected void initDocument() throws Exception {
            if (Identify.this.tad != null) {
                this.playing = false;
                this.playDoc = new TextActivityDocument(Identify.this.styleContext);
                Identify.this.tad.cloneDoc(this.playDoc, false, false, true);
                if (!this.buildCheckArrays()) {
                    return;
                }
                this.pane.setStyledDocument(this.playDoc);
                this.playDoc.attachTo(this.pane, this);
                this.pane.setEditable(false);
                this.pane.requestFocus();
                this.nActions = 0;
                this.score = 0;
            }
        }

        private boolean buildCheckArrays() {
            if (this.playDoc == null) {
                return false;
            }
            int l = this.playDoc.getLength();
            if (l > 0) {
                int i;
                char[] chars;
                try {
                    chars = this.playDoc.getText(0, l).toCharArray();
                }
                catch (BadLocationException ex) {
                    this.playDoc = null;
                    return false;
                }
                this.validChars = new boolean[l];
                this.marks = new boolean[l];
                this.targets = new boolean[l];
                for (i = 0; i < l; ++i) {
                    this.marks[i] = false;
                    this.targets[i] = false;
                    this.validChars[i] = Character.isLetterOrDigit(chars[i]);
                }
                for (i = 0; i < this.playDoc.tmb.size(); ++i) {
                    TargetMarker tm = this.playDoc.tmb.getElement(i);
                    for (int j = tm.begOffset; j < tm.endOffset; ++j) {
                        this.targets[j] = true;
                    }
                }
            } else {
                this.validChars = new boolean[1];
                this.marks = new boolean[1];
                this.targets = new boolean[1];
            }
            return true;
        }

        @Override
        protected TextActivityPane buildPane() {
            IdentifyPane p = new IdentifyPane();
            p.setActions();
            return p;
        }

        protected boolean checkScore() {
            int i;
            this.score = 0;
            for (i = 0; i < this.playDoc.tmb.size(); ++i) {
                if (!this.marks[this.playDoc.tmb.getElement((int)i).begOffset]) continue;
                ++this.score;
            }
            for (i = 0; i < this.targets.length; ++i) {
                if (!this.marks[i] || this.targets[i]) continue;
                return false;
            }
            return this.score == this.playDoc.tmb.size();
        }

        @Override
        protected void doCheck(boolean fromButton) {
            int i;
            if (this.playDoc == null || this.playDoc.tmb.size() == 0) {
                return;
            }
            TargetMarkerBag tmb = this.playDoc.tmb;
            this.playDoc.setCharacterAttributes(0, this.marks.length, Identify.this.styleContext.getStyle("default"), true);
            for (i = 0; i < this.marks.length; ++i) {
                int j;
                if (!this.marks[i]) continue;
                for (j = i; j < this.marks.length && this.marks[j]; ++j) {
                }
                this.playDoc.setCharacterAttributes(i, j - i, Identify.this.styleContext.getStyle("targetError"), true);
                i = j;
            }
            for (i = 0; i < tmb.size(); ++i) {
                TargetMarker tm = tmb.getElement(i);
                this.playDoc.applyStyleToTarget(tm, this.marks[tm.begOffset] ? "target" : "default", false, true);
            }
            boolean finishedOk = this.checkScore();
            this.ps.setCounterValue(0, this.score);
            this.ps.setCounterValue(1, this.nActions);
            if (!finishedOk) {
                if (fromButton) {
                    this.playEvent(4);
                    this.pane.requestFocus();
                }
            } else {
                this.finishActivity(true);
            }
        }

        @Override
        public void finishActivity(boolean result) {
            this.pane.setEnabled(false);
            super.finishActivity(result);
        }

        class IdentifyPane
        extends TextActivityPane {
            protected IdentifyPane() {
                super(Panel.this);
                this.enableEvents(16L);
            }

            @Override
            public boolean processMouse(MouseEvent e) {
                if (!super.processMouse(e) || !Panel.this.playing || Panel.this.playDoc == null) {
                    return false;
                }
                if (e.getID() == 501) {
                    this.select(this.viewToModel(e.getPoint()));
                }
                return false;
            }

            protected void select(int p) {
                if (p < 0 || p >= Panel.this.marks.length) {
                    Panel.this.playEvent(2);
                    return;
                }
                ++Panel.this.nActions;
                boolean marked = Panel.this.marks[p];
                int l = 1;
                TargetMarker tm = Panel.this.playDoc.tmb.getElementByOffset(p, false);
                if (tm != null) {
                    p = tm.begOffset;
                    l = tm.getLength();
                } else {
                    if (!Panel.this.validChars[p]) {
                        Panel.this.playEvent(2);
                        return;
                    }
                    if (Identify.this.type == 0) {
                        int it;
                        for (it = p; it > 0 && Panel.this.validChars[it]; --it) {
                        }
                        int p0 = it + 1;
                        it = p;
                        p = p0;
                        while (it < Panel.this.validChars.length && Panel.this.validChars[it]) {
                            ++it;
                        }
                        l = it - p0;
                    }
                }
                Panel.this.playDoc.setCharacterAttributes(p, l, Identify.this.styleContext.getStyle(marked ? "default" : "target"), true);
                for (int i = 0; i < l; ++i) {
                    Panel.this.marks[p + i] = !marked;
                }
                if (!Identify.this.hasCheckButton) {
                    TargetMarkerBag tmb = Panel.this.playDoc.tmb;
                    boolean ok = tm != null && Panel.this.marks[p];
                    boolean finishedOk = Panel.this.checkScore();
                    try {
                        this.tabp.ps.reportNewAction(Identify.this, "SELECT", Panel.this.playDoc.getText(p, l), marked ? "true" : "false", ok, Panel.this.score);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (finishedOk) {
                        Panel.this.finishActivity(true);
                        return;
                    }
                }
                Panel.this.playEvent(1);
            }

            protected void setActions() {
                Map<String, Object[]> actionKeys = Actions.getActionKeys(this);
                ActionMap am = new ActionMap();
                am.setParent(this.getActionMap());
                this.setActionMap(am);
                Actions.mapTraceAction(this, actionKeys, "beep");
                Actions.mapTraceAction(this, actionKeys, "requestFocus");
                Actions.mapTraceAction(this, actionKeys, "toggle-componentOrientation");
                am.setParent(null);
            }
        }
    }
}

