/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.activities.text.BasicEvaluator;
import edu.xtec.jclic.activities.text.Evaluator;
import edu.xtec.jclic.activities.text.TargetMarker;
import edu.xtec.jclic.activities.text.TargetMarkerBag;
import edu.xtec.jclic.activities.text.TextActivityBase;
import edu.xtec.jclic.activities.text.TextActivityDocument;
import edu.xtec.jclic.activities.text.TextActivityPane;
import edu.xtec.jclic.activities.text.TextTarget;
import edu.xtec.jclic.boxes.BoxConnector;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.Actions;
import edu.xtec.util.JDomUtility;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Map;
import java.util.Random;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.KeyStroke;
import org.jdom.Element;

public class Order
extends TextActivityBase {
    public static final int ORDER_WORDS = 0;
    public static final int ORDER_PARAGRAPHS = 1;
    protected boolean amongParagraphs = false;
    protected int type;
    protected Evaluator ev;
    public static final String[] TYPES = new String[]{"orderWords", "orderParagraphs"};
    public static final String AMONG_PARAGRAPHS = "amongParagraphs";

    public Order(JClicProject project) {
        super(project);
        this.setType(0);
        this.hasCheckButton = true;
        this.checkButtonText = "";
        this.ev = new BasicEvaluator(project);
    }

    @Override
    public Element getJDomElement() {
        Element e = super.getJDomElement();
        e.setAttribute("type", TYPES[this.type]);
        if (this.amongParagraphs) {
            e.setAttribute(AMONG_PARAGRAPHS, JDomUtility.boolString(this.amongParagraphs));
        }
        e.addContent(this.ev.getJDomElement());
        return e;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        super.setProperties(e, aux);
        this.setType(JDomUtility.getStrIndexAttr(e, "type", TYPES, this.type));
        if (this.type == 0) {
            this.amongParagraphs = JDomUtility.getBoolAttr(e, AMONG_PARAGRAPHS, this.amongParagraphs);
        }
        this.ev = Evaluator.getEvaluator(e.getChild("evaluator"), this.project);
    }

    @Override
    public void setProperties(Clic3Activity c3a) throws Exception {
        super.setProperties(c3a);
        ((BasicEvaluator)this.ev).setProperties(c3a);
        this.setType(c3a.puzMode == 5 ? 1 : 0);
        this.amongParagraphs = c3a.brPar;
    }

    @Override
    public Activity.Panel getActivityPanel(PlayStation ps) {
        return new Panel(ps);
    }

    public int getType() {
        return this.type;
    }

    @Override
    public boolean hasRandom() {
        return true;
    }

    @Override
    public boolean shuffleAlways() {
        return true;
    }

    public void setType(int type) {
        this.type = type == 0 ? 0 : 1;
        this.tad.setTargetType(type == 0 ? 2 : 3);
    }

    class Panel
    extends TextActivityBase.Panel {
        TextActivityDocument playDoc;
        int nActions;
        TargetMarker anchor;
        TargetMarker cursor;

        protected Panel(PlayStation ps) {
            super(Order.this, ps);
            this.playDoc = null;
            this.nActions = 0;
        }

        @Override
        protected void initDocument() throws Exception {
            if (Order.this.tad != null) {
                int i;
                this.playing = false;
                this.playDoc = new TextActivityDocument(Order.this.styleContext);
                Order.this.tad.cloneDoc(this.playDoc, false, false, false);
                for (i = 0; i < this.playDoc.tmb.size(); ++i) {
                    this.playDoc.tmb.getElement((int)i).target = new TextTarget();
                    this.playDoc.tmb.getElement((int)i).target.answer = new String[]{this.playDoc.tmb.getElement(i).getCurrentText()};
                }
                if (this.playDoc.tmb.size() > 1) {
                    for (i = 0; i < 5 && this.shuffle() == this.playDoc.tmb.size(); ++i) {
                    }
                }
                this.pane.setStyledDocument(this.playDoc);
                this.playDoc.attachTo(this.pane, this);
                this.pane.setEditable(false);
                this.pane.requestFocus();
                this.bc = new BoxConnector(this.pane);
                this.nActions = 0;
            }
        }

        private int shuffle() {
            int k2;
            if (this.playDoc == null || this.playDoc.tmb.size() < 2) {
                return 0;
            }
            TargetMarkerBag tmb = this.playDoc.tmb;
            int k = tmb.size();
            int[] p = tmb.getParagragraphOffsets();
            int[] p2 = new int[k];
            for (k2 = 0; k2 < k; ++k2) {
                p2[k2] = k2;
            }
            int t2 = 0;
            Random rnd = new Random();
            for (int i = 0; i < Order.this.shuffles; ++i) {
                int t1 = rnd.nextInt(k);
                if (Order.this.type == 0 && !Order.this.amongParagraphs) {
                    k2 = 0;
                    for (int j = 0; j < k; ++j) {
                        if (j == t1 || p[j] != p[t1]) continue;
                        p2[k2++] = j;
                    }
                }
                if (k2 <= 0) continue;
                for (int c = 0; c < 300 && (t2 = p2[rnd.nextInt(k2)]) == t1; ++c) {
                }
                if (t1 == t2) continue;
                tmb.swapTargets(tmb.getElement(t1), tmb.getElement(t2));
            }
            return tmb.checkTargets(Order.this.ev);
        }

        @Override
        protected TextActivityPane buildPane() {
            OrderPane p = new OrderPane();
            p.setActions();
            return p;
        }

        protected void setTargetAnchor(TargetMarker tm) {
            if (this.anchor != null) {
                this.playDoc.applyStyleToTarget(this.anchor, "target", false, true);
            }
            this.anchor = tm;
            if (this.anchor != null) {
                this.playDoc.applyStyleToTarget(this.anchor, "target", true, true);
            }
        }

        protected void setTargetCursor(TargetMarker tm) {
            if (tm != null && tm == this.anchor) {
                this.cursor = tm;
                return;
            }
            if (this.cursor != null && this.cursor != this.anchor) {
                this.playDoc.applyStyleToTarget(this.cursor, "target", false, true);
            }
            this.cursor = tm;
            if (this.cursor != null) {
                this.playDoc.applyStyleToTarget(this.cursor, null, true, true);
            }
        }

        protected void swapTargets(TargetMarker src, TargetMarker dest) {
            if (src == dest || !this.playing || this.playDoc == null) {
                return;
            }
            this.setTargetAnchor(null);
            TargetMarkerBag tmb = this.playDoc.tmb;
            tmb.swapTargets(src, dest);
            src.checkText(Order.this.ev);
            boolean ok = dest.checkText(Order.this.ev);
            ++this.nActions;
            if (!Order.this.hasCheckButton) {
                int solvedTargets = tmb.countSolvedTargets();
                this.ps.reportNewAction(this.getActivity(), "PLACE", src.getCurrentText(), Integer.toString(tmb.indexOf(dest)), ok, solvedTargets);
                if (ok && solvedTargets == tmb.size()) {
                    this.finishActivity(true);
                } else {
                    this.playEvent(ok ? 3 : 2);
                }
            }
            this.setTargetCursor(dest);
        }

        @Override
        protected void doCheck(boolean fromButton) {
            if (this.playDoc == null || this.playDoc.tmb.size() == 0) {
                return;
            }
            TargetMarkerBag tmb = this.playDoc.tmb;
            if (this.bc.active) {
                this.bc.end();
            }
            for (int i = 0; i < tmb.size(); ++i) {
                TargetMarker tm = tmb.getElement(i);
                this.playDoc.applyStyleToTarget(tm, tm.target.targetStatus == 2 ? "target" : "targetError", false, true);
            }
            int tagsSolved = tmb.countSolvedTargets();
            this.ps.setCounterValue(0, tagsSolved);
            this.ps.setCounterValue(1, this.nActions);
            if (tagsSolved != tmb.size()) {
                if (fromButton) {
                    this.playEvent(4);
                    this.pane.requestFocus();
                }
            } else {
                this.finishActivity(true);
            }
        }

        @Override
        public void finishActivity(boolean result) {
            if (this.bc.active) {
                this.bc.end();
            }
            this.pane.setEnabled(false);
            super.finishActivity(result);
        }

        class OrderPane
        extends TextActivityPane {
            AbstractAction forwardAction;
            AbstractAction backwardAction;
            AbstractAction nextTargetAction;
            AbstractAction prevTargetAction;
            AbstractAction insertBreakAction;
            AbstractAction insertTabAction;
            AbstractAction beginAction;
            AbstractAction endAction;
            AbstractAction upAction;
            AbstractAction downAction;

            protected OrderPane() {
                super(Panel.this);
                this.forwardAction = new AbstractAction("caret-forward"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        OrderPane.this.nextTargetAction.actionPerformed(e);
                    }
                };
                this.backwardAction = new AbstractAction("caret-backward"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        OrderPane.this.prevTargetAction.actionPerformed(e);
                    }
                };
                this.nextTargetAction = new AbstractAction("next-target"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (OrderPane.this.initKeyAction()) {
                            Panel.this.setTargetCursor(Panel.this.playDoc.tmb.getNextTarget(Panel.this.cursor));
                        }
                    }
                };
                this.prevTargetAction = new AbstractAction("prev-target"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (OrderPane.this.initKeyAction()) {
                            Panel.this.setTargetCursor(Panel.this.playDoc.tmb.getPrevTarget(Panel.this.cursor));
                        }
                    }
                };
                this.insertBreakAction = new AbstractAction("insert-break"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (OrderPane.this.initKeyAction()) {
                            if (Panel.this.anchor == null) {
                                Panel.this.setTargetAnchor(Panel.this.cursor);
                            } else {
                                Panel.this.swapTargets(Panel.this.anchor, Panel.this.cursor);
                            }
                        }
                    }
                };
                this.insertTabAction = new AbstractAction("insert-tab"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if ((e.getModifiers() & 1) != 0) {
                            OrderPane.this.prevTargetAction.actionPerformed(e);
                        } else {
                            OrderPane.this.nextTargetAction.actionPerformed(e);
                        }
                    }
                };
                this.beginAction = new AbstractAction("caret-begin"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (OrderPane.this.initKeyAction()) {
                            Panel.this.setTargetCursor(Panel.this.playDoc.tmb.getElement(0));
                        }
                    }
                };
                this.endAction = new AbstractAction("caret-end"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (OrderPane.this.initKeyAction()) {
                            Panel.this.setTargetCursor(Panel.this.playDoc.tmb.getElement(Panel.this.playDoc.tmb.size() - 1));
                        }
                    }
                };
                this.upAction = new AbstractAction("caret-up"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        OrderPane.this.prevTargetAction.actionPerformed(e);
                    }
                };
                this.downAction = new AbstractAction("caret-down"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        OrderPane.this.nextTargetAction.actionPerformed(e);
                    }
                };
                this.enableEvents(48L);
            }

            @Override
            public boolean processMouse(MouseEvent e) {
                if (!super.processMouse(e) || Panel.this.bc == null || !Panel.this.playing) {
                    return false;
                }
                switch (e.getID()) {
                    case 501: {
                        int p = this.viewToModel(e.getPoint());
                        if (p < 0) break;
                        Panel.this.playEvent(1);
                        TargetMarker tm = Panel.this.playDoc.tmb.getElementByOffset(p, false);
                        if (tm != null) {
                            Panel.this.setTargetCursor(tm);
                            if (((Panel)Panel.this).bc.active) {
                                Panel.this.bc.end();
                                if (Panel.this.cursor == Panel.this.anchor) {
                                    Panel.this.setTargetAnchor(null);
                                    Panel.this.setTargetCursor(tm);
                                    break;
                                }
                                Panel.this.swapTargets(Panel.this.anchor, Panel.this.cursor);
                                break;
                            }
                            Panel.this.setTargetAnchor(tm);
                            Panel.this.bc.begin(e.getPoint());
                            break;
                        }
                        Panel.this.bc.end();
                        Panel.this.setTargetAnchor(null);
                        break;
                    }
                    case 503: 
                    case 506: {
                        if (!((Panel)Panel.this).bc.active) break;
                        Panel.this.bc.moveTo(e.getPoint());
                    }
                }
                return false;
            }

            public boolean initKeyAction() {
                if (!Panel.this.playing) {
                    return false;
                }
                if (((Panel)Panel.this).bc.active) {
                    Panel.this.bc.end();
                }
                if (Panel.this.cursor == null) {
                    Panel.this.setTargetCursor(Panel.this.playDoc.tmb.getElement(0));
                    return false;
                }
                return true;
            }

            protected void setActions() {
                Map<String, Object[]> actionKeys = Actions.getActionKeys(this);
                ActionMap am = new ActionMap();
                am.setParent(this.getActionMap());
                this.setActionMap(am);
                Actions.mapTraceAction(this, actionKeys, "beep");
                Actions.mapTraceAction(this, actionKeys, "requestFocus");
                Actions.mapTraceAction(this, actionKeys, "toggle-componentOrientation");
                Actions.mapAction(this, actionKeys, this.insertBreakAction);
                Actions.mapAction(this, actionKeys, this.insertTabAction);
                Actions.mapAction(this, actionKeys, this.forwardAction);
                Actions.mapAction(this, actionKeys, this.backwardAction);
                Actions.mapAction(this, actionKeys, this.beginAction);
                Actions.mapAction(this, actionKeys, this.endAction);
                Actions.mapAction(this, actionKeys, this.upAction);
                Actions.mapAction(this, actionKeys, this.downAction);
                Actions.mapAction(this, actionKeys, this.nextTargetAction);
                Actions.mapAction(this, actionKeys, this.prevTargetAction);
                am.setParent(null);
                this.getInputMap().put(KeyStroke.getKeyStroke(9, 1), this.insertTabAction.getValue("Name"));
            }
        }
    }
}

