/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.Constants;
import edu.xtec.jclic.activities.text.TextActivityBase;
import edu.xtec.jclic.activities.text.TextTarget;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.BoxBase;
import java.awt.AWTEvent;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.rtf.RTFEditorKit;

public class TextActivityPane
extends JTextPane {
    TextActivityBase.Panel tabp;
    TextActivityBase tab;
    ActiveBox bx;

    public TextActivityPane(TextActivityBase.Panel tabp) {
        this.tabp = tabp;
        this.tab = (TextActivityBase)tabp.getActivity();
        this.bx = new ActiveBox(null, tabp, null);
        this.bx.setVisible(false);
        this.setEditorKit(new RTFEditorKit());
        this.enableEvents(16L);
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof MouseEvent && !this.processMouse((MouseEvent)e)) {
            ((MouseEvent)e).consume();
            return;
        }
        super.processEvent(e);
    }

    public boolean processMouse(MouseEvent e) {
        boolean result = true;
        if (e.getID() == 501) {
            if (this.tabp.showingPrevScreen) {
                this.tabp.ps.startActivity(this.tabp);
                result = false;
            } else if (this.tabp.isPlaying() && this.bx.isVisible() && this.bx.contains(e.getPoint())) {
                if (this.bx.getContent().mediaContent != null) {
                    this.bx.playMedia(this.tabp.ps);
                }
                result = false;
            }
        }
        return result;
    }

    public void enableActiveBox(ActiveBoxContent abc, Point location) {
        if (abc.dimension != null) {
            this.bx.setContent(abc);
            this.bx.setBounds(new Rectangle(location, abc.dimension));
            this.bx.setVisible(true);
            this.bx.repaint();
        }
    }

    public void disableActiveBox() {
        this.bx.setVisible(false);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        super.paint(g2);
        if (this.bx.isVisible()) {
            RenderingHints rh = g2.getRenderingHints();
            g2.setRenderingHints(Constants.DEFAULT_RENDERING_HINTS);
            do {
                BoxBase.flagFontReduced = false;
                this.bx.update(g2, g2.getClipBounds(), this);
            } while (BoxBase.flagFontReduced);
            g2.setRenderingHints(rh);
        }
    }

    @Override
    public void setStyledDocument(StyledDocument doc) {
        this.transferFocus();
        Style defaultStyle = doc.getStyle("default");
        AttributeSet as = defaultStyle.copyAttributes();
        super.setStyledDocument(doc);
        defaultStyle.addAttributes(as);
        this.setBackground(StyleConstants.getBackground(defaultStyle));
        Style st = this.tab.styleContext.getStyle("target");
        if (st != null) {
            this.setCaretColor(StyleConstants.getForeground(st));
        }
        this.requestFocus();
    }

    protected void targetChanged(TextTarget tt) {
    }
}

