/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.activities.text.Evaluator;
import edu.xtec.jclic.activities.text.TargetMarker;
import edu.xtec.jclic.activities.text.TextActivityBase;
import edu.xtec.jclic.activities.text.TextActivityDocument;
import edu.xtec.jclic.activities.text.TextActivityPane;
import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.media.MediaContent;
import edu.xtec.util.JDomUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyleConstants;
import org.jdom.Element;

public class TextTarget {
    public static final int NO_INFO = 0;
    public static final int INFO_ALWAYS = 1;
    public static final int INFO_ON_ERROR = 2;
    public static final int INFO_ON_DEMAND = 3;
    public static final String[] infoTypes = new String[]{"no_info", "always", "onError", "onDemand"};
    public static final int NOT_EDITED = 0;
    public static final int EDITED = 1;
    public static final int SOLVED = 2;
    public static final int WITH_ERROR = 3;
    public static final int INFO_LEFTALIGN = 1;
    public static final int INFO_ONLYPLAY = 2;
    public boolean isList = false;
    public int numIniChars = 1;
    public char iniChar = (char)95;
    public int maxLenResp = 0;
    public String[] answer = null;
    public String[] options = null;
    public String iniText = null;
    public int infoMode = 0;
    public ActiveBoxContent popupContent = null;
    public int popupDelay = 0;
    public int popupMaxTime = 0;
    public boolean onlyPlay = false;
    protected TargetCombo comboList = null;
    public int targetStatus = 0;
    private boolean flagModified = false;
    TextActivityPane parentPane;
    public static final String ELEMENT_NAME = "target";
    public static final String ANSWER = "answer";
    public static final String OPTION_LIST = "optionList";
    public static final String OPTION = "option";
    public static final String RESPONSE = "response";
    public static final String FILL = "fill";
    public static final String INI_LEN = "length";
    public static final String MAX_LEN = "maxLength";
    public static final String INI_TEXT = "show";
    public static final String INFO = "info";
    public static final String MODE = "mode";
    public static final String DELAY = "delay";
    public static final String MAX_TIME = "maxTime";

    public TextTarget() {
    }

    public TextTarget(Document doc, int x0, int x1) {
        this();
        String s;
        if (x1 < x0) {
            int v = x0;
            x0 = x1;
            x1 = v;
        }
        try {
            s = doc.getText(x0, x1 - x0);
        }
        catch (BadLocationException ex) {
            s = "";
        }
        this.numIniChars = s.length();
        this.answer = new String[]{s};
        this.maxLenResp = this.numIniChars;
    }

    public void reset() {
        this.targetStatus = 0;
        this.flagModified = false;
        if (this.comboList != null) {
            this.comboList.checkColors();
        }
    }

    public Element getJDomElement() {
        Element child;
        Element e = new Element(ELEMENT_NAME);
        if (this.answer != null) {
            for (String ans : this.answer) {
                e.addContent(new Element(ANSWER).addContent(ans));
            }
        }
        if (this.isList) {
            child = new Element(OPTION_LIST);
            if (this.options != null) {
                for (String opt : this.options) {
                    child.addContent(new Element(OPTION).addContent(opt));
                }
            }
            e.addContent(child);
        } else {
            child = new Element(RESPONSE);
            child.setAttribute(FILL, new String(new char[]{this.iniChar}));
            child.setAttribute(INI_LEN, Integer.toString(this.numIniChars));
            child.setAttribute(MAX_LEN, Integer.toString(this.maxLenResp));
            if (this.iniText != null && this.iniText.length() > 0) {
                child.setAttribute(INI_TEXT, this.iniText);
            }
            e.addContent(child);
        }
        if (this.popupContent != null && this.infoMode != 0) {
            child = new Element(INFO);
            if (this.infoMode != 1) {
                child.setAttribute(MODE, infoTypes[this.infoMode]);
            }
            if (this.popupDelay > 0) {
                child.setAttribute(DELAY, Integer.toString(this.popupDelay));
            }
            if (this.popupMaxTime > 0) {
                child.setAttribute(MAX_TIME, Integer.toString(this.popupMaxTime));
            }
            if (this.onlyPlay && this.popupContent.mediaContent != null) {
                child.addContent(this.popupContent.mediaContent.getJDomElement());
            } else {
                child.addContent(this.popupContent.getJDomElement());
            }
            e.addContent(child);
        }
        return e;
    }

    public static TextTarget getTextTarget(Element e, MediaBag mediaBag) throws Exception {
        TextTarget tt = new TextTarget();
        tt.setProperties(e, mediaBag);
        return tt;
    }

    public void setProperties(Element e, Object aux) throws Exception {
        List optionLst;
        Element child;
        JDomUtility.checkName(e, ELEMENT_NAME);
        MediaBag mediaBag = (MediaBag)aux;
        List answerLst = e.getChildren(ANSWER);
        if (!answerLst.isEmpty()) {
            this.answer = new String[answerLst.size()];
            for (int i = 0; i < this.answer.length; ++i) {
                this.answer[i] = ((Element)answerLst.get(i)).getText();
            }
        }
        if ((child = e.getChild(OPTION_LIST)) != null && !(optionLst = child.getChildren(OPTION)).isEmpty()) {
            this.isList = true;
            this.options = new String[optionLst.size()];
            for (int i = 0; i < this.options.length; ++i) {
                this.options[i] = ((Element)optionLst.get(i)).getText();
            }
        }
        if ((child = e.getChild(RESPONSE)) != null) {
            String s = new String(new char[]{this.iniChar});
            if ((s = JDomUtility.getStringAttr(child, FILL, s, true)).length() > 0) {
                this.iniChar = s.charAt(0);
            }
            this.numIniChars = JDomUtility.getIntAttr(child, INI_LEN, this.numIniChars);
            this.maxLenResp = JDomUtility.getIntAttr(child, MAX_LEN, this.maxLenResp);
            this.iniText = child.getAttributeValue(INI_TEXT);
        }
        if ((child = e.getChild(INFO)) != null) {
            this.infoMode = JDomUtility.getStrIndexAttr(child, MODE, infoTypes, 1);
            this.popupDelay = JDomUtility.getIntAttr(child, DELAY, this.popupDelay);
            this.popupMaxTime = JDomUtility.getIntAttr(child, MAX_TIME, this.popupMaxTime);
            Element child2 = child.getChild("media");
            if (child2 != null) {
                this.onlyPlay = true;
                this.popupContent = new ActiveBoxContent();
                this.popupContent.mediaContent = MediaContent.getMediaContent(child2);
            } else {
                child2 = child.getChild("cell");
                if (child2 != null) {
                    this.popupContent = ActiveBoxContent.getActiveBoxContent(child2, mediaBag);
                }
            }
        }
    }

    protected void setParentPane(TextActivityPane pane) {
        this.parentPane = pane;
    }

    public void setAnswer(String text) {
        StringTokenizer st = new StringTokenizer(text, "|");
        int numItems = st.countTokens();
        if (numItems <= 0) {
            this.answer = null;
        } else {
            this.answer = new String[numItems];
            for (int i = 0; i < numItems; ++i) {
                this.answer[i] = st.nextToken();
            }
        }
    }

    public String getAnswers() {
        StringBuilder sb = new StringBuilder();
        if (this.answer != null) {
            for (int i = 0; i < this.answer.length; ++i) {
                if (i > 0) {
                    sb.append("|");
                }
                sb.append(this.answer[i]);
            }
        }
        return sb.substring(0);
    }

    public boolean checkText(String txt, Evaluator ev) {
        if (this.answer == null || txt == null) {
            return false;
        }
        boolean ok = ev.checkText(txt, this.answer);
        this.targetStatus = ok ? 2 : 3;
        return ok;
    }

    public JComboBox buildCombo(AttributeSet targetAttr, AttributeSet errorAttr) {
        if (!this.isList || this.options == null) {
            return null;
        }
        this.comboList = new TargetCombo(this.options, targetAttr, errorAttr);
        if (this.iniText != null) {
            this.comboList.setSelectedItem(this.iniText);
        }
        return this.comboList;
    }

    public String getFillString() {
        return this.getFillString(this.numIniChars);
    }

    public String getFillString(int length) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            s.append(this.iniChar);
        }
        return s.substring(0);
    }

    public void requestFocus(TextActivityBase.Panel tabp, TargetMarker tm) {
        if (this.comboList != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TextTarget.this.comboList.requestFocus();
                }
            });
        } else {
            tabp.requestFocus();
        }
        if (this.popupContent != null && (this.infoMode == 1 || this.infoMode == 2 && this.targetStatus == 3)) {
            tabp.popupTimer.setUp(this, tm);
        }
    }

    public void checkPopup(TextActivityBase.Panel tabp, TargetMarker tm, boolean f1Key) {
        if (this.popupContent != null) {
            boolean show = false;
            if (this.infoMode == 2) {
                show = this.targetStatus == 3;
            } else if (this.infoMode == 3) {
                show = f1Key;
            }
            if (show) {
                tabp.popupTimer.setUp(this, tm);
            } else {
                tabp.popupTimer.stopPopup();
            }
        }
    }

    protected Point getPopupLocation(TextActivityBase.Panel tabp, TargetMarker tm) {
        if (this.popupContent == null || this.onlyPlay) {
            return null;
        }
        Rectangle r = tm.getBegRect(tabp.pane);
        if (r == null) {
            return null;
        }
        Point pt = r.getLocation();
        pt.y -= this.popupContent.dimension.height;
        if (pt.y < 0) {
            pt.y = r.y + r.height;
        }
        if (pt.x + this.popupContent.dimension.width > tabp.pane.getWidth()) {
            pt.x -= tabp.pane.getWidth() - pt.x + this.popupContent.dimension.width;
            if (pt.x < 0) {
                pt.x = 0;
            }
        }
        return pt;
    }

    public void adjustPopupLocation(TextActivityBase.Panel tabp, TargetMarker tm) {
        Point pt = this.getPopupLocation(tabp, tm);
        if (pt != null) {
            tabp.pane.bx.setLocation(pt);
        }
    }

    public void lostFocus(TextActivityBase.Panel tabp, TargetMarker tm) {
        if (this.comboList != null && this.parentPane != null) {
            this.parentPane.repaint();
        }
        if (this.popupContent != null) {
            tabp.popupTimer.stopPopup();
        }
    }

    public void setModified(boolean value) {
        this.flagModified = value;
        if (value && this.targetStatus == 0) {
            this.targetStatus = 1;
        }
    }

    public boolean isModified() {
        return this.flagModified;
    }

    public static class PopupTimer
    extends Timer {
        TextTarget target;
        boolean action;
        TextActivityBase.Panel tabp;
        TargetMarker tm;

        public PopupTimer(TextActivityBase.Panel tabp) {
            super(1000, null);
            this.tabp = tabp;
            this.setRepeats(false);
            this.target = null;
        }

        public void setUp(TextTarget setTarget, TargetMarker setTm) {
            this.stop();
            this.target = setTarget;
            this.tm = setTm;
            this.action = true;
            if (this.target != null && this.target.popupContent != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (PopupTimer.this.target.popupDelay > 0) {
                            PopupTimer.this.setInitialDelay(PopupTimer.this.target.popupDelay * 1000);
                            PopupTimer.this.setRepeats(false);
                            PopupTimer.this.start();
                        } else {
                            PopupTimer.this.startPopup();
                        }
                    }
                });
            }
        }

        public void startPopup() {
            this.stop();
            if (this.target != null && this.target.popupContent != null) {
                Point pt;
                if (!this.target.onlyPlay && (pt = this.target.getPopupLocation(this.tabp, this.tm)) != null) {
                    this.tabp.pane.enableActiveBox(this.target.popupContent, pt);
                }
                if (this.target.popupContent.mediaContent != null) {
                    this.tabp.ps.playMedia(this.target.popupContent.mediaContent, this.tabp.pane.bx);
                }
                if (this.target.popupMaxTime > 0) {
                    this.action = false;
                    this.setInitialDelay(this.target.popupMaxTime * 1000);
                    this.setRepeats(false);
                    this.start();
                }
            }
        }

        public void stopPopup() {
            this.stop();
            if (this.target != null && this.target.popupContent != null) {
                this.tabp.ps.stopMedia(1);
                this.tabp.pane.disableActiveBox();
            }
        }

        @Override
        protected void fireActionPerformed(ActionEvent e) {
            if (this.action) {
                this.startPopup();
            } else {
                this.stopPopup();
            }
        }
    }

    public class TargetCombo
    extends JComboBox {
        Color bgColor;
        Color foreColor;
        Color errBgColor;
        Color errForeColor;
        Font rFont;
        TargetComboCellRenderer cellRenderer;
        JTextField txEditor;
        AbstractAction showListAction;
        AbstractAction fwdAction;
        AbstractAction bkAction;

        public TargetCombo(String[] items, AttributeSet targetAttr, AttributeSet errorAttr) {
            super(items);
            this.setSelectedIndex(-1);
            this.showListAction = new AbstractAction("showList"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TargetCombo.this.setPopupVisible(true);
                }
            };
            this.fwdAction = new AbstractAction("forward"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Action act;
                    if (TextTarget.this.parentPane != null && (act = TextTarget.this.parentPane.getActionMap().get("next-target")) != null) {
                        act.actionPerformed(e);
                    }
                }
            };
            this.bkAction = new AbstractAction("backwards"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Action act;
                    if (TextTarget.this.parentPane != null && (act = TextTarget.this.parentPane.getActionMap().get("prev-target")) != null) {
                        act.actionPerformed(e);
                    }
                }
            };
            this.rFont = TextActivityDocument.attributesToFont(targetAttr);
            this.setFont(this.rFont);
            this.bgColor = StyleConstants.getBackground(targetAttr);
            this.foreColor = StyleConstants.getForeground(targetAttr);
            this.errBgColor = StyleConstants.getBackground(errorAttr);
            this.errForeColor = StyleConstants.getForeground(errorAttr);
            this.setCursor(Cursor.getDefaultCursor());
            this.cellRenderer = new TargetComboCellRenderer();
            this.setRenderer(this.cellRenderer);
            Dimension d = this.getPreferredSize();
            this.setPreferredSize(new Dimension((int)d.getWidth() + this.rFont.getSize() / 2, (int)d.getHeight()));
            this.setMaximumSize(this.getPreferredSize());
            this.setEditable(true);
            Component c = this.getEditor().getEditorComponent();
            this.txEditor = c instanceof JTextField ? (JTextField)c : new JTextField();
            this.txEditor.setEnabled(false);
            this.checkColors();
            this.setAlignmentY(0.8f);
            this.setKActions();
        }

        protected void setKActions() {
            this.registerKeyboardAction(this.showListAction, KeyStroke.getKeyStroke(40, 0), 0);
            this.registerKeyboardAction(this.showListAction, KeyStroke.getKeyStroke(10, 0), 0);
            this.txEditor.registerKeyboardAction(this.showListAction, KeyStroke.getKeyStroke(40, 0), 0);
            this.txEditor.registerKeyboardAction(this.showListAction, KeyStroke.getKeyStroke(10, 0), 0);
            this.registerKeyboardAction(this.fwdAction, KeyStroke.getKeyStroke(39, 0), 1);
            this.registerKeyboardAction(this.fwdAction, KeyStroke.getKeyStroke(9, 0), 1);
            this.registerKeyboardAction(this.fwdAction, KeyStroke.getKeyStroke(10, 0), 1);
            this.registerKeyboardAction(this.bkAction, KeyStroke.getKeyStroke(37, 0), 1);
            this.registerKeyboardAction(this.bkAction, KeyStroke.getKeyStroke(9, 1), 1);
        }

        public void checkColors() {
            if (TextTarget.this.targetStatus == 3) {
                this.txEditor.setBackground(this.errBgColor);
                this.txEditor.setForeground(this.errForeColor);
                this.txEditor.setDisabledTextColor(this.errForeColor);
            } else {
                this.txEditor.setBackground(this.bgColor);
                this.txEditor.setForeground(this.foreColor);
                this.txEditor.setDisabledTextColor(this.foreColor);
            }
        }

        @Override
        public void setSelectedItem(Object o) {
            super.setSelectedItem(o);
            if (o != null && TextTarget.this.parentPane != null) {
                TextTarget.this.setModified(true);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!TargetCombo.this.isPopupVisible()) {
                            TextTarget.this.parentPane.targetChanged(TextTarget.this);
                        }
                    }
                });
            }
        }

        class TargetComboCellRenderer
        extends JLabel
        implements ListCellRenderer {
            public TargetComboCellRenderer() {
                this.setOpaque(true);
                this.setFont(TargetCombo.this.rFont);
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setBackground(isSelected ? TargetCombo.this.foreColor : TargetCombo.this.bgColor);
                this.setForeground(isSelected ? TargetCombo.this.bgColor : TargetCombo.this.foreColor);
                this.setText(value == null ? "" : value.toString());
                return this;
            }
        }
    }
}

