/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.HelpActivityComponent;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.automation.ActiveBagContentKit;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.ActiveBoxBag;
import edu.xtec.jclic.boxes.ActiveBoxGrid;
import edu.xtec.jclic.boxes.BoxBag;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.shapers.Rectangular;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.StrUtils;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import javax.swing.JTextField;
import org.jdom.Element;

public class WrittenAnswer
extends Activity
implements ActiveBagContentKit.Compatible {
    int nonAssignedCells;
    boolean useIdAss;
    protected static final String ANSWERS = "answers";
    protected static final String INVERSE = "inverse";

    public WrittenAnswer(JClicProject project) {
        super(project);
        this.boxGridPos = 0;
        this.abc = new ActiveBagContent[3];
        this.scramble[0] = false;
        this.nonAssignedCells = 0;
        this.invAss = false;
        this.useIdAss = true;
    }

    @Override
    public void initNew() {
        super.initNew();
        this.abc[0] = ActiveBagContent.initNew(3, 2, 65);
        this.abc[1] = ActiveBagContent.initNew(3, 2, 65);
    }

    @Override
    public Element getJDomElement() {
        if (this.abc[0] == null || this.abc[1] == null) {
            return null;
        }
        Element e = super.getJDomElement();
        e.addContent(this.abc[0].getJDomElement().setAttribute("id", "primary"));
        e.addContent(this.abc[1].getJDomElement().setAttribute("id", ANSWERS));
        if (this.abc[2] != null) {
            e.addContent(this.abc[2].getJDomElement().setAttribute("id", "solvedPrimary"));
        }
        Element ex = new Element("scramble");
        ex.setAttribute("times", Integer.toString(this.shuffles));
        ex.setAttribute("primary", JDomUtility.boolString(this.scramble[0]));
        e.addContent(ex);
        ex = new Element("layout");
        ex.setAttribute("position", LAYOUT_NAMES[this.boxGridPos]);
        e.addContent(ex);
        if (this.invAss) {
            e.setAttribute(INVERSE, JDomUtility.boolString(this.invAss));
        }
        return e;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        Element child2;
        super.setProperties(e, aux);
        this.abc[2] = null;
        for (Element child2 : e.getChildren("cells")) {
            ActiveBagContent bag = ActiveBagContent.getActiveBagContent(child2, this.project.mediaBag);
            String id = JDomUtility.getStringAttr(child2, "id", "primary", false);
            if ("primary".equals(id)) {
                this.abc[0] = bag;
                continue;
            }
            if (ANSWERS.equals(id)) {
                this.abc[1] = bag;
                continue;
            }
            if (!"solvedPrimary".equals(id)) continue;
            this.abc[2] = bag;
        }
        if (this.abc[0] == null || this.abc[1] == null) {
            throw new IllegalArgumentException("WrittenAnswer without content!");
        }
        child2 = e.getChild("scramble");
        if (child2 != null) {
            this.shuffles = JDomUtility.getIntAttr(child2, "times", this.shuffles);
            this.scramble[0] = JDomUtility.getBoolAttr(child2, "primary", this.scramble[0]);
        }
        if ((child2 = e.getChild("layout")) != null) {
            this.boxGridPos = JDomUtility.getStrIndexAttr(child2, "position", LAYOUT_NAMES, this.boxGridPos);
        }
        this.invAss = JDomUtility.getBoolAttr(e, INVERSE, this.invAss);
        this.abc[0].avoidAllIdsNull(this.abc[1].getNumCells());
    }

    @Override
    public void setProperties(Clic3Activity c3a) throws Exception {
        super.setProperties(c3a);
        c3a.nctxw = c3a.ncw;
        c3a.nctxh = c3a.nch;
        this.boxGridPos = c3a.graPos;
        for (int i = 0; i < 2; ++i) {
            this.abc[i] = c3a.createActiveBagContent(i);
            this.abc[i].setBoxBase(c3a.getBoxBase(i));
        }
        this.scramble[0] = c3a.bar[0];
        this.abc[2] = c3a.sol ? c3a.createActiveBagContent(2) : null;
        this.abc[0].avoidAllIdsNull(this.abc[1].getNumCells());
    }

    @Override
    public int getMinNumActions() {
        if (this.abc[0] == null || this.abc[1] == null) {
            return 0;
        }
        if (this.invAss) {
            return this.abc[1].getNumCells();
        }
        return this.abc[0].getNumCells() - this.nonAssignedCells;
    }

    @Override
    public boolean helpSolutionAllowed() {
        return true;
    }

    @Override
    public boolean hasRandom() {
        return true;
    }

    @Override
    public boolean needsKeyboard() {
        return true;
    }

    @Override
    public Activity.Panel getActivityPanel(PlayStation ps) {
        return new Panel(ps);
    }

    class Panel
    extends Activity.Panel
    implements ActionListener {
        JTextField textField;
        ActiveBoxBag[] bg;
        int currentCell;
        boolean[] invAssCheck;

        protected Panel(PlayStation ps) {
            super(ps);
            this.bg = new ActiveBoxBag[2];
            for (int i = 0; i < 2; ++i) {
                this.bg[i] = null;
            }
            this.currentCell = -1;
            this.textField = null;
            this.invAssCheck = null;
        }

        @Override
        public void clear() {
            for (int i = 0; i < 2; ++i) {
                if (this.bg[i] == null) continue;
                this.bg[i].end();
                this.bg[i] = null;
            }
            this.textField = null;
        }

        @Override
        public void buildVisualComponents() throws Exception {
            if (this.firstRun) {
                super.buildVisualComponents();
            }
            this.currentCell = -1;
            this.clear();
            if (WrittenAnswer.this.abc[0] != null && WrittenAnswer.this.abc[1] != null) {
                if (WrittenAnswer.this.acp != null) {
                    WrittenAnswer.this.acp.generateContent(new ActiveBagContentKit(WrittenAnswer.this.abc[0].nch, WrittenAnswer.this.abc[0].ncw, WrittenAnswer.this.abc, true), this.ps);
                }
                if (WrittenAnswer.this.invAss) {
                    this.invAssCheck = new boolean[WrittenAnswer.this.abc[1].getNumCells()];
                    for (int i = 0; i < this.invAssCheck.length; ++i) {
                        this.invAssCheck[i] = false;
                    }
                }
                this.bg[0] = ActiveBoxGrid.createEmptyGrid(null, this, WrittenAnswer.this.margin, WrittenAnswer.this.margin, WrittenAnswer.this.abc[0]);
                double w = WrittenAnswer.this.abc[1].w;
                if (WrittenAnswer.this.boxGridPos == 2 || WrittenAnswer.this.boxGridPos == 3) {
                    w = WrittenAnswer.this.abc[0].getTotalWidth();
                }
                this.bg[1] = new ActiveBoxGrid(null, this, WrittenAnswer.this.margin, WrittenAnswer.this.margin, w, WrittenAnswer.this.abc[1].h, new Rectangular(1, 1), WrittenAnswer.this.abc[1].bb);
                this.textField = new JTextField(200);
                this.textField.setHorizontalAlignment(0);
                ActiveBox bx = this.bg[1].getActiveBox(0);
                bx.setInactive(false);
                bx.hasHostedComponent = true;
                bx.setHostedComponent(this.textField);
                this.textField.addActionListener(this);
                this.bg[0].setContent(WrittenAnswer.this.abc[0], WrittenAnswer.this.abc[2]);
                this.currentCell = 0;
                this.bg[0].setDefaultIdAss();
                WrittenAnswer.this.nonAssignedCells = 0;
                for (int i = 0; i < this.bg[0].getNumCells(); ++i) {
                    bx = this.bg[0].getActiveBox(i);
                    if (bx.idAss != -1) continue;
                    ++WrittenAnswer.this.nonAssignedCells;
                    bx.switchToAlt(this.ps);
                }
                this.bg[0].setVisible(true);
                this.bg[1].setVisible(true);
                this.invalidate();
            }
        }

        @Override
        public void initActivity() throws Exception {
            super.initActivity();
            if (!this.firstRun) {
                this.buildVisualComponents();
            } else {
                this.firstRun = false;
            }
            this.setAndPlayMsg(1, 0);
            if (this.bg[0] != null && this.bg[1] != null) {
                if (WrittenAnswer.this.scramble[0]) {
                    this.shuffle(new ActiveBoxBag[]{this.bg[0]}, true, true);
                }
                if (WrittenAnswer.this.useOrder) {
                    this.currentItem = this.bg[0].getNextItem(-1);
                }
                this.playing = true;
                this.setCurrentCell(0);
            }
        }

        @Override
        public void render(Graphics2D g2, Rectangle dirtyRegion) {
            for (int i = 0; i < 2; ++i) {
                if (this.bg[i] == null) continue;
                this.bg[i].update(g2, dirtyRegion, this);
            }
        }

        @Override
        public Dimension setDimension(Dimension preferredMaxSize) {
            return this.bg[0] == null || this.bg[1] == null || this.getSize().equals(preferredMaxSize) ? preferredMaxSize : BoxBag.layoutDouble(preferredMaxSize, this.bg[0], this.bg[1], WrittenAnswer.this.boxGridPos, WrittenAnswer.this.margin);
        }

        private boolean checkInvAss() {
            if (!WrittenAnswer.this.invAss || this.invAssCheck == null) {
                return false;
            }
            for (boolean b : this.invAssCheck) {
                if (b) continue;
                return false;
            }
            return true;
        }

        private void setCurrentCell(int i) {
            ActiveBox bx;
            boolean m = false;
            if (!this.playing) {
                return;
            }
            if (this.currentCell != -1) {
                boolean ok = false;
                bx = this.bg[0].getActiveBoxWithIdLoc(this.currentCell);
                String src = bx.getDescription();
                bx.setMarked(false);
                int id = bx.idAss;
                String txCheck = id >= 0 ? WrittenAnswer.this.abc[1].getActiveBoxContent((int)id).text : "";
                String txAnswer = this.textField.getText().trim();
                if (StrUtils.compareMultipleOptions(txAnswer, txCheck, false)) {
                    ok = true;
                    bx.idAss = -1;
                    if (txCheck.indexOf(124) >= 0) {
                        this.textField.setText(new StringTokenizer(txCheck, "|").nextToken());
                    }
                    if (WrittenAnswer.this.abc[2] != null) {
                        bx.switchToAlt(this.ps);
                        m = bx.playMedia(this.ps);
                    } else {
                        bx.clear();
                    }
                    if (WrittenAnswer.this.invAss && id >= 0 && id < this.invAssCheck.length) {
                        this.invAssCheck[id] = true;
                    }
                    if (WrittenAnswer.this.useOrder) {
                        this.currentItem = this.bg[0].getNextItem(this.currentItem);
                    }
                }
                int cellsPlaced = this.bg[0].countCellsWithIdAss(-1);
                if (txAnswer.length() > 0) {
                    this.ps.reportNewAction(this.getActivity(), "WRITE", src, txAnswer, ok, cellsPlaced);
                }
                if (ok && (this.checkInvAss() || cellsPlaced == this.bg[0].getNumCells())) {
                    this.finishActivity(true);
                    this.textField.setEnabled(false);
                    return;
                }
                if (!m && txAnswer.length() > 0) {
                    this.playEvent(ok ? 3 : 2);
                }
            }
            if ((bx = WrittenAnswer.this.useOrder ? (ActiveBox)this.bg[0].getBox(this.currentItem) : this.bg[0].getActiveBoxWithIdLoc(i)) == null || bx.idAss == -1) {
                for (int j = 0; j < this.bg[0].getNumCells(); ++j) {
                    bx = this.bg[0].getActiveBoxWithIdLoc(j);
                    if (bx.idAss != -1) break;
                }
                if (bx != null && bx.idAss == -1) {
                    this.finishActivity(false);
                    this.textField.setEnabled(false);
                    return;
                }
            }
            if (this.bg[0].getNumCells() > 1 && bx != null) {
                bx.setMarked(true);
            }
            if (bx != null) {
                this.currentCell = bx.idLoc;
            }
            this.textField.setText("");
            this.textField.requestFocus();
            if (bx != null) {
                bx.playMedia(this.ps);
            }
        }

        @Override
        public void requestFocus() {
            if (this.playing && this.textField != null) {
                this.textField.requestFocus();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.playing && e.getSource() == this.textField && this.currentCell != -1) {
                this.setCurrentCell(this.currentCell);
            }
        }

        @Override
        public void processMouse(MouseEvent e) {
            boolean m = false;
            if (this.playing) {
                switch (e.getID()) {
                    case 501: {
                        this.ps.stopMedia(1);
                        ActiveBox bx = this.bg[0].findActiveBox(e.getPoint());
                        if (bx == null) break;
                        if (bx.getContent() != null && bx.getContent().mediaContent == null) {
                            this.playEvent(1);
                        }
                        this.setCurrentCell(bx.idLoc);
                    }
                }
            }
        }

        @Override
        public void showHelp() {
            if (!WrittenAnswer.this.helpWindowAllowed() || this.bg[0] == null) {
                return;
            }
            HelpActivityComponent hac = null;
            if (WrittenAnswer.this.showSolution) {
                hac = new HelpActivityComponent(this){
                    ActiveBoxBag abb;
                    String currentResponse;
                    int cellsPlaced;
                    {
                        this.abb = null;
                        this.currentResponse = "";
                        this.cellsPlaced = Panel.this.bg[0].countCellsWithIdAss(-1);
                    }

                    @Override
                    public void render(Graphics2D g2, Rectangle dirtyRegion) {
                        if (this.abb != null) {
                            this.abb.update(g2, dirtyRegion, this);
                        }
                    }

                    @Override
                    public void init() {
                        this.currentResponse = Panel.this.textField.getText();
                        this.abb = (ActiveBoxBag)Panel.this.bg[0].clone();
                        this.abb.setContainer(this);
                        Dimension size = this.abb.getBounds().getSize();
                        this.abb.setBounds(8.0, 8.0, size.width, size.height);
                        size.width += 16;
                        size.height += 16;
                        this.setPreferredSize(size);
                        this.setMaximumSize(size);
                        this.setMinimumSize(size);
                        Point p = (Point)this.getClientProperty("prefLoc");
                        if (p != null) {
                            p.translate((int)Panel.this.bg[0].x - 8, (int)Panel.this.bg[0].y - 8);
                        }
                    }

                    @Override
                    public void end() {
                        super.end();
                        Panel.this.textField.setText(this.currentResponse);
                    }

                    @Override
                    public void processMouse(MouseEvent e) {
                        if (this.abb != null) {
                            switch (e.getID()) {
                                case 501: {
                                    ActiveBox bx = this.abb.findActiveBox(e.getPoint());
                                    if (bx == null) break;
                                    boolean m = bx.playMedia(Panel.this.ps);
                                    String s = WrittenAnswer.this.abc[1].getActiveBoxContent((int)bx.idOrder).text;
                                    if (s != null) {
                                        Panel.this.textField.setText(s.replace('|', ' '));
                                    }
                                    Panel.this.ps.reportNewAction(Panel.this.getActivity(), "HELP", bx.getDescription(), null, false, this.cellsPlaced);
                                    if (m) break;
                                    Panel.this.playEvent(1);
                                    break;
                                }
                                case 502: {
                                    this.unmarkBox();
                                    Panel.this.textField.setText("");
                                }
                            }
                        }
                    }
                };
                hac.init();
            }
            if (this.ps.showHelp(hac, WrittenAnswer.this.helpMsg)) {
                this.ps.reportNewAction(this.getActivity(), "HELP", null, null, false, this.bg[0].countCellsWithIdAss(-1));
            }
            if (hac != null) {
                hac.end();
            }
        }
    }
}

