/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.automation.arith;

import edu.xtec.jclic.automation.ActiveBagContentKit;
import edu.xtec.jclic.automation.AutoContentProvider;
import edu.xtec.jclic.automation.arith.Operator;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.ResourceBridge;
import java.text.DecimalFormat;
import java.util.Random;
import org.jdom.Element;

public class Arith
extends AutoContentProvider {
    private static final String DLL_TITLE = "ARITH2.DLL";
    private static final int ARITHVER = 2;
    protected static final int NMAXLOOPS = 60;
    protected static final int NOSORT = 0;
    protected static final int SORTASC = 1;
    protected static final int SORTDESC = 2;
    protected static final int SUM = 1;
    protected static final int REST = 2;
    protected static final int MULT = 4;
    protected static final int DIV = 8;
    protected static final int NOPERACIONS = 4;
    protected static final String[] OPSTR = new String[]{"+", "-", "\u00d7", ":"};
    protected static final int ABX = 1;
    protected static final int AXC = 2;
    protected static final int XBC = 4;
    protected static final int AXBC = 8;
    protected static final int CAXB = 16;
    protected static final int NTIPUSEX = 5;
    protected static final int INDIF = 0;
    protected static final int AGB = 1;
    protected static final int BGA = 2;
    private static final int RES = -12345;
    private static final int MAX_STR_LEN = 100;
    private static String S = "\u00a0";
    protected static final String ID = "id";
    protected static final String A = "A";
    protected static final String B = "B";
    protected static final String OPERATIONS = "operations";
    protected static final String PLUS = "plus";
    protected static final String MINUS = "minus";
    protected static final String MULTIPLY = "multiply";
    protected static final String DIVIDE = "divide";
    protected static final String UNKNOWN = "unknown";
    protected static final String RESULT = "result";
    protected static final String FIRST = "first";
    protected static final String LAST = "last";
    protected static final String OPERAND = "operand";
    protected static final String INVERSE = "inverse";
    protected static final String FROM = "from";
    protected static final String TO = "to";
    protected static final String NOT_CARRY = "notCarry";
    protected static final String DUPLICATES = "duplicates";
    protected static final String ORDER = "order";
    protected static final String ASCENDING = "ascending";
    protected static final String DESCENDING = "descending";
    protected static final String CONDITION = "condition";
    protected static final String FIRST_BIG = "firstBig";
    protected static final String LAST_BIG = "lastBig";
    protected static DecimalFormat[] DF;
    protected static final int WILDCARD_DF = 5;
    Operator opA;
    Operator opB;
    boolean use_add = true;
    boolean use_subst;
    boolean use_mult;
    boolean use_div;
    boolean exp_abx = true;
    boolean exp_axc;
    boolean exp_xbc;
    boolean exp_axbc;
    boolean exp_caxb;
    int resultLimInf = 13;
    int resultLimSup = 25;
    boolean resultCarry;
    boolean resultNoDup;
    int resultOrder = 0;
    int opCond = 0;
    private Random random = new Random();

    public Arith() {
        this.opA = new Operator();
        this.opB = new Operator();
        if (DF == null) {
            DF = new DecimalFormat[6];
            Arith.DF[0] = new DecimalFormat("0");
            Arith.DF[1] = new DecimalFormat("0.0");
            Arith.DF[2] = new DecimalFormat("0.00");
            Arith.DF[3] = new DecimalFormat("0.000");
            Arith.DF[4] = new DecimalFormat("0.0000");
            Arith.DF[5] = new DecimalFormat("0000000000");
        }
    }

    public DecimalFormat getDF(int index) {
        return DF[index <= 5 ? index : 4];
    }

    @Override
    public Element getJDomElement() {
        Element e = super.getJDomElement();
        Element op = this.opA.getJDomElement();
        op.setAttribute(ID, A);
        e.addContent(op);
        op = this.opB.getJDomElement();
        op.setAttribute(ID, B);
        e.addContent(op);
        Element eop = new Element(OPERATIONS);
        eop.setAttribute(PLUS, JDomUtility.boolString(this.use_add));
        eop.setAttribute(MINUS, JDomUtility.boolString(this.use_subst));
        eop.setAttribute(MULTIPLY, JDomUtility.boolString(this.use_mult));
        eop.setAttribute(DIVIDE, JDomUtility.boolString(this.use_div));
        e.addContent(eop);
        Element eu = new Element(UNKNOWN);
        eu.setAttribute(RESULT, JDomUtility.boolString(this.exp_abx));
        eu.setAttribute(FIRST, JDomUtility.boolString(this.exp_xbc));
        eu.setAttribute(LAST, JDomUtility.boolString(this.exp_axc));
        eu.setAttribute(OPERAND, JDomUtility.boolString(this.exp_axbc));
        eu.setAttribute(INVERSE, JDomUtility.boolString(this.exp_caxb));
        e.addContent(eu);
        Element er = new Element(RESULT);
        er.setAttribute(FROM, Operator.LIM_CH[this.resultLimInf]);
        er.setAttribute(TO, Operator.LIM_CH[this.resultLimSup]);
        if (this.resultCarry) {
            er.setAttribute(NOT_CARRY, JDomUtility.boolString(this.resultCarry));
        }
        er.setAttribute(DUPLICATES, JDomUtility.boolString(!this.resultNoDup));
        if (this.resultOrder != 0) {
            er.setAttribute(ORDER, this.resultOrder == 1 ? ASCENDING : DESCENDING);
        }
        if (this.opCond != 0) {
            er.setAttribute(CONDITION, this.opCond == 1 ? FIRST_BIG : LAST_BIG);
        }
        e.addContent(er);
        return e;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        String s;
        Element child2;
        for (Element child2 : e.getChildren(OPERAND)) {
            s = child2.getAttributeValue(ID);
            if (A.equals(s)) {
                this.opA.setProperties(child2, aux);
                continue;
            }
            if (B.equals(s)) {
                this.opB.setProperties(child2, aux);
                continue;
            }
            throw new IllegalArgumentException("Unknown operator: " + s);
        }
        child2 = e.getChild(OPERATIONS);
        if (child2 != null) {
            this.use_add = JDomUtility.getBoolAttr(child2, PLUS, this.use_add);
            this.use_subst = JDomUtility.getBoolAttr(child2, MINUS, this.use_subst);
            this.use_mult = JDomUtility.getBoolAttr(child2, MULTIPLY, this.use_mult);
            this.use_div = JDomUtility.getBoolAttr(child2, DIVIDE, this.use_div);
        }
        if ((child2 = e.getChild(UNKNOWN)) != null) {
            this.exp_abx = JDomUtility.getBoolAttr(child2, RESULT, this.exp_abx);
            this.exp_xbc = JDomUtility.getBoolAttr(child2, FIRST, this.exp_xbc);
            this.exp_axc = JDomUtility.getBoolAttr(child2, LAST, this.exp_axc);
            this.exp_axbc = JDomUtility.getBoolAttr(child2, OPERAND, this.exp_axbc);
            this.exp_caxb = JDomUtility.getBoolAttr(child2, INVERSE, this.exp_caxb);
        }
        if ((child2 = e.getChild(RESULT)) != null) {
            this.resultLimInf = JDomUtility.getStrIndexAttr(child2, FROM, Operator.LIM_CH, this.resultLimInf);
            this.resultLimSup = JDomUtility.getStrIndexAttr(child2, TO, Operator.LIM_CH, this.resultLimSup);
            this.resultCarry = JDomUtility.getBoolAttr(child2, NOT_CARRY, this.resultCarry);
            this.resultNoDup = !JDomUtility.getBoolAttr(child2, DUPLICATES, !this.resultNoDup);
            s = child2.getAttributeValue(ORDER);
            this.resultOrder = s == null ? 0 : (s.equals(ASCENDING) ? 1 : 2);
            s = child2.getAttributeValue(CONDITION);
            this.opCond = s == null ? 0 : (s.equals(FIRST_BIG) ? 1 : 2);
        }
    }

    @Override
    public boolean setClic3Properties(byte[] ops) {
        int v;
        boolean fromBlank = false;
        int p = 0;
        p = this.opA.setClic3Properties(ops, p);
        p = this.opB.setClic3Properties(ops, p);
        if ((v = ops[p++] & 0x7F) == 0) {
            v = 1;
        }
        this.use_add = (v & 1) != 0;
        this.use_subst = (v & 2) != 0;
        this.use_mult = (v & 4) != 0;
        this.use_div = (v & 8) != 0;
        if ((v = ops[p++] & 0x7F) == 0) {
            v = 1;
        }
        this.exp_abx = (v & 1) != 0;
        this.exp_axc = (v & 2) != 0;
        this.exp_xbc = (v & 4) != 0;
        this.exp_axbc = (v & 8) != 0;
        this.exp_caxb = (v & 0x10) != 0;
        int i = ops[p++] & 0x7F;
        this.resultLimInf = i == 0 ? 13 : i;
        i = ops[p++] & 0x7F;
        this.resultLimSup = i == 0 ? 25 : i;
        this.resultCarry = (ops[p++] & 1) == 1;
        this.resultNoDup = (ops[p++] & 1) == 1;
        this.resultOrder = ops[p++] & 3;
        this.opCond = ops[p++] & 3;
        int arithVer = p < ops.length ? ops[p++] & 0x7F : 0;
        if (arithVer == 0) {
            arithVer = 2;
            if (!this.opA.fromBlank) {
                this.opA.limInf = Operator.adjustLimVer(this.opA.limInf);
                this.opA.limSup = Operator.adjustLimVer(this.opA.limSup);
                this.opB.limInf = Operator.adjustLimVer(this.opB.limInf);
                this.opB.limSup = Operator.adjustLimVer(this.opB.limSup);
                this.resultLimInf = Operator.adjustLimVer(this.resultLimInf);
                this.resultLimSup = Operator.adjustLimVer(this.resultLimSup);
            }
        }
        return arithVer <= 2;
    }

    boolean genNum(Num n, Operator op, long limInf2, long limSup2) {
        n.c = op.numDec;
        int exp = n.c == 0 ? 1 : (n.c == 1 ? 10 : 100);
        long ls = Operator.LIMITS[op.limSup];
        if (limSup2 != -12345L && limSup2 < ls) {
            ls = limSup2;
        }
        long li = Operator.LIMITS[op.limInf];
        if (limInf2 != -12345L && limInf2 > li) {
            li = limInf2;
        }
        boolean resolt = false;
        if (op.fromList > 0) {
            n.vf = op.lst[this.random.nextInt(op.fromList)];
            resolt = true;
        }
        if (!resolt) {
            int r = this.random.nextInt(100);
            if (op.wZero && r <= 10) {
                n.vf = 0.0f;
                resolt = true;
            } else if (op.wOne && r > 10 && r <= 20) {
                n.vf = 1.0f;
                resolt = true;
            } else if (op.wMinusOne && r > 20 && r <= 30) {
                n.vf = -1.0f;
                resolt = true;
            }
        }
        if (!resolt) {
            int rang;
            if (li > ls) {
                long k = li;
                li = ls;
                ls = k;
            }
            if ((rang = (int)(ls - li + 1L)) < 0) {
                rang = 1;
            }
            long v = ((long)this.random.nextInt(rang) + li) * (long)exp;
            if (exp > 1) {
                v += (long)this.random.nextInt(exp);
            }
            n.vf = (float)v / (float)exp;
        }
        return true;
    }

    boolean genOp(Operacio o) {
        int[] ops = new int[4];
        long rlinf = Operator.LIMITS[this.resultLimInf];
        long rlsup = Operator.LIMITS[this.resultLimSup];
        int nops = 0;
        if (this.use_add) {
            ops[nops++] = 1;
        }
        if (this.use_subst) {
            ops[nops++] = 2;
        }
        if (this.use_mult) {
            ops[nops++] = 4;
        }
        if (this.use_div) {
            ops[nops++] = 8;
        }
        int op = ops[this.random.nextInt(nops)];
        switch (op) {
            case 1: {
                int i;
                for (i = 0; i < 60; ++i) {
                    this.genNum(o.numA, this.opA, -12345L, rlsup);
                    long ri2 = o.numA.vf < (float)rlinf ? rlinf - (long)o.numA.vf : -12345L;
                    long rs2 = rlsup - (long)o.numA.vf;
                    switch (this.opCond) {
                        case 1: {
                            if (rs2 != -12345L && !((float)rs2 > o.numA.vf)) break;
                            rs2 = (long)o.numA.vf;
                            break;
                        }
                        case 2: {
                            if (ri2 != -12345L && !((float)ri2 < o.numA.vf)) break;
                            ri2 = (long)o.numA.vf;
                        }
                    }
                    this.genNum(o.numB, this.opB, ri2, rs2);
                    o.numR.vf = o.numA.vf + o.numB.vf;
                    if (o.numR.vf >= (float)rlinf && o.numR.vf <= (float)rlsup) break;
                }
                o.numR.c = o.numA.c > o.numB.c ? o.numA.c : o.numB.c;
                o.op = 0;
                if (!this.resultCarry || !(o.numA.vf > 0.0f) || !(o.numB.vf > 0.0f)) break;
                float q = o.numR.c == 2 ? 100.0f : (o.numR.c == 1 ? 10.0f : 1.0f);
                char[] bufa = this.getDF(5).format((long)((double)(o.numA.vf * q) + 0.5)).toCharArray();
                char[] bufb = this.getDF(5).format((long)((double)(o.numB.vf * q) + 0.5)).toCharArray();
                for (i = 0; i < 10 && bufa[i] == '0' && bufb[i] == '0'; ++i) {
                }
                while (i < 10) {
                    int va = bufa[i] - 48;
                    int vb = bufb[i] - 48;
                    if (va + vb >= 10) {
                        int x;
                        while (va + vb > 9) {
                            if (va > vb) {
                                va = va > 0 ? this.random.nextInt(va) : 0;
                                continue;
                            }
                            vb = vb > 0 ? this.random.nextInt(vb) : 0;
                        }
                        bufa[i] = 48;
                        for (x = 0; x < va; ++x) {
                            int n = i;
                            bufa[n] = (char)(bufa[n] + '\u0001');
                        }
                        bufb[i] = 48;
                        for (x = 0; x < vb; ++x) {
                            int n = i;
                            bufb[n] = (char)(bufb[n] + '\u0001');
                        }
                    }
                    ++i;
                }
                o.numA.vf = Long.parseLong(new String(bufa));
                o.numB.vf = Long.parseLong(new String(bufb));
                o.numR.vf = (long)((double)(o.numA.vf + o.numB.vf) + 0.5);
                o.numA.vf /= q;
                o.numB.vf /= q;
                o.numR.vf /= q;
                break;
            }
            case 2: {
                int i;
                for (i = 0; i < 60; ++i) {
                    this.genNum(o.numA, this.opA, rlinf, -12345L);
                    long ri2 = o.numA.vf > (float)rlsup ? (long)(o.numA.vf - (float)rlsup) : -12345L;
                    long rs2 = (long)(o.numA.vf - (float)rlinf);
                    switch (this.opCond) {
                        case 1: {
                            if (rs2 != -12345L && !((float)rs2 > o.numA.vf)) break;
                            rs2 = (long)o.numA.vf;
                            break;
                        }
                        case 2: {
                            if (ri2 != -12345L && !((float)ri2 < o.numA.vf)) break;
                            ri2 = (long)o.numA.vf;
                        }
                    }
                    this.genNum(o.numB, this.opB, ri2, rs2);
                    o.numR.vf = o.numA.vf - o.numB.vf;
                    if (o.numR.vf >= (float)rlinf && o.numR.vf <= (float)rlsup) break;
                }
                o.numR.c = o.numA.c > o.numB.c ? o.numA.c : o.numB.c;
                o.op = 1;
                if (!this.resultCarry || !(o.numA.vf > 0.0f) || !(o.numB.vf > 0.0f) || !(o.numA.vf >= o.numB.vf)) break;
                float q = o.numR.c == 2 ? 100 : (o.numR.c == 1 ? 10 : 1);
                char[] bufa = this.getDF(5).format((long)((double)(o.numA.vf * q) + 0.5)).toCharArray();
                char[] bufb = this.getDF(5).format((long)((double)(o.numB.vf * q) + 0.5)).toCharArray();
                for (i = 0; i < 10 && bufb[i] == '0'; ++i) {
                }
                while (i < 10) {
                    int va = bufa[i] - 48;
                    int vb = bufb[i] - 48;
                    if (va < vb) {
                        vb = va > 0 ? this.random.nextInt(va) : 0;
                        bufb[i] = 48;
                        for (int x = 0; x < vb; ++x) {
                            int n = i;
                            bufb[n] = (char)(bufb[n] + '\u0001');
                        }
                    }
                    ++i;
                }
                o.numA.vf = Long.parseLong(new String(bufa));
                o.numB.vf = Long.parseLong(new String(bufb));
                o.numR.vf = (long)((double)(o.numA.vf - o.numB.vf) + 0.5);
                o.numA.vf /= q;
                o.numB.vf /= q;
                o.numR.vf /= q;
                break;
            }
            case 4: {
                for (int i = 0; i < 60; ++i) {
                    this.genNum(o.numA, this.opA, -12345L, -12345L);
                    long ri2 = Operator.LIMITS[this.opB.limInf];
                    long rs2 = Operator.LIMITS[this.opB.limSup];
                    switch (this.opCond) {
                        case 1: {
                            if (!((float)rs2 > o.numA.vf)) break;
                            rs2 = (long)o.numA.vf;
                            break;
                        }
                        case 2: {
                            if (!((float)ri2 < o.numA.vf)) break;
                            ri2 = (long)o.numA.vf;
                        }
                    }
                    this.genNum(o.numB, this.opB, ri2, rs2);
                    o.numR.vf = o.numA.vf * o.numB.vf;
                    if (o.numR.vf >= (float)rlinf && o.numR.vf <= (float)rlsup) break;
                }
                o.numR.c = o.numA.c + o.numB.c;
                o.op = 2;
                break;
            }
            case 8: {
                int i;
                for (i = 0; i < 60; ++i) {
                    float f;
                    this.genNum(o.numA, this.opA, -12345L, -12345L);
                    long ri2 = Operator.LIMITS[this.opB.limInf];
                    long rs2 = Operator.LIMITS[this.opB.limSup];
                    switch (this.opCond) {
                        case 1: {
                            if (!((float)rs2 > o.numA.vf)) break;
                            rs2 = (long)o.numA.vf;
                            break;
                        }
                        case 2: {
                            if (!((float)ri2 < o.numA.vf)) break;
                            ri2 = (long)o.numA.vf;
                        }
                    }
                    this.genNum(o.numB, this.opB, ri2, rs2);
                    if (o.numB.vf == 0.0f || !(Math.abs(o.numA.vf) >= Math.abs(o.numB.vf))) continue;
                    o.numR.vf = o.numA.vf / o.numB.vf;
                    if (f >= (float)rlinf && o.numR.vf <= (float)rlsup) break;
                }
                if (o.numB.vf == 0.0f) {
                    o.numB.vf = 1.0f;
                }
                o.numR.vf = o.numA.vf / o.numB.vf;
                i = o.numA.c - o.numB.c;
                float q = (float)Math.pow(10.0, i);
                o.numA.vf *= q;
                o.numR.vf *= q;
                o.numR.vf = (long)o.numR.vf;
                o.numA.vf = o.numR.vf * o.numB.vf;
                o.numA.vf /= q;
                o.numR.vf /= q;
                o.numR.c = i > 0 ? i : 0;
                o.op = 3;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean generateContent(Object kit, ResourceBridge rb) {
        boolean result = false;
        if (kit instanceof ActiveBagContentKit) {
            ActiveBagContentKit k = (ActiveBagContentKit)kit;
            result = this.generateContent(k.nRows, k.nCols, k.content, k.useIds, rb);
        }
        return result;
    }

    protected boolean generateContent(int nRows, int nCols, ActiveBagContent[] content, boolean useIds, ResourceBridge rb) {
        int k;
        int j;
        Operacio o;
        int i;
        if (nRows <= 0 || nCols <= 0 || content == null || content.length < 1 || content[0] == null || rb == null) {
            return false;
        }
        int[] tipus = new int[5];
        int nColsB = nCols;
        int nRowsB = nRows;
        int nCells = nRows * nCols;
        if (nCells < 2) {
            return false;
        }
        int[] ass = null;
        int numTipus = 0;
        if (this.exp_abx) {
            tipus[numTipus++] = 1;
        }
        if (this.exp_axc) {
            tipus[numTipus++] = 2;
        }
        if (this.exp_xbc) {
            tipus[numTipus++] = 4;
        }
        if (this.exp_axbc) {
            tipus[numTipus++] = 8;
        }
        if (numTipus == 0) {
            return false;
        }
        boolean tipInv = this.exp_caxb;
        Operacio[] op = new Operacio[nCells];
        String[] stra = new String[nCells];
        String[] strb = new String[nCells];
        String[] strc = new String[nCells];
        for (i = 0; i < nCells; ++i) {
            o = new Operacio();
            for (j = 0; j < 60; ++j) {
                this.genOp(o);
                if (!this.resultNoDup) break;
                for (k = 0; k < i && o.numR.vf != op[k].numR.vf; ++k) {
                }
                if (k == i) break;
            }
            op[i] = o;
        }
        if (this.resultOrder != 0) {
            for (i = nCells - 1; i > 0; --i) {
                for (j = 0; j < i; ++j) {
                    if (!(this.resultOrder == 1 && op[j].numR.vf > op[j + 1].numR.vf) && (this.resultOrder != 2 || !(op[j].numR.vf < op[j + 1].numR.vf))) continue;
                    o = op[j];
                    op[j] = op[j + 1];
                    op[j + 1] = o;
                }
            }
        }
        block22: for (i = 0; i < nCells; ++i) {
            int tipX = tipus[this.random.nextInt(numTipus)];
            String va = this.getDF(op[0].numA.c).format(op[i].numA.vf);
            String vb = this.getDF(op[0].numB.c).format(op[i].numB.vf);
            String vc = this.getDF(op[0].numR.c).format(op[i].numR.vf);
            String operator = OPSTR[op[i].op];
            strc[i] = tipInv ? vc + S + "=" + S + va + S + operator + S + vb : va + S + operator + S + vb + S + "=" + S + vc;
            switch (tipX) {
                case 2: {
                    strb[i] = vb;
                    if (tipInv) {
                        stra[i] = vc + S + "=" + S + va + S + operator + S + "?";
                        continue block22;
                    }
                    stra[i] = va + S + operator + S + "?" + S + "=" + S + vc;
                    continue block22;
                }
                case 4: {
                    strb[i] = va;
                    if (tipInv) {
                        stra[i] = vc + S + "=" + S + "?" + S + operator + S + vb;
                        continue block22;
                    }
                    stra[i] = "?" + S + operator + S + vb + S + "=" + S + vc;
                    continue block22;
                }
                case 8: {
                    strb[i] = operator;
                    if (tipInv) {
                        stra[i] = vc + S + "=" + S + va + S + "?" + S + vb;
                        continue block22;
                    }
                    stra[i] = va + S + "?" + S + vb + S + "=" + S + vc;
                    continue block22;
                }
                default: {
                    strb[i] = vc;
                    stra[i] = tipInv ? "?" + S + "=" + S + va + S + operator + S + vb : va + S + operator + S + vb + S + "=";
                }
            }
        }
        if (useIds) {
            ass = new int[nCells];
            String[] strbx = new String[nCells];
            k = 0;
            for (i = 0; i < nCells; ++i) {
                for (j = 0; j < k && !strb[i].equals(strbx[j]); ++j) {
                }
                if (j == k) {
                    strbx[k] = strb[i];
                    ass[i] = k++;
                    continue;
                }
                ass[i] = j;
            }
            strb = new String[k];
            for (i = 0; i < k; ++i) {
                strb[i] = strbx[i];
            }
            if (nRowsB * nColsB != k) {
                boolean distH = false;
                switch (k) {
                    case 6: {
                        nRowsB = distH ? 2 : 3;
                        nColsB = distH ? 3 : 2;
                        break;
                    }
                    case 8: {
                        nRowsB = distH ? 2 : 4;
                        nColsB = distH ? 4 : 2;
                        break;
                    }
                    case 9: {
                        nRowsB = 3;
                        nColsB = 3;
                        break;
                    }
                    case 10: {
                        nRowsB = distH ? 2 : 5;
                        nColsB = distH ? 5 : 2;
                        break;
                    }
                    case 12: {
                        nRowsB = distH ? 3 : 4;
                        nColsB = distH ? 4 : 3;
                        break;
                    }
                    case 14: {
                        nRowsB = distH ? 2 : 7;
                        nColsB = distH ? 7 : 2;
                        break;
                    }
                    case 15: {
                        nRowsB = distH ? 3 : 5;
                        nColsB = distH ? 3 : 5;
                        break;
                    }
                    case 16: {
                        nRowsB = 4;
                        nColsB = 4;
                        break;
                    }
                    case 18: {
                        nRowsB = distH ? 6 : 3;
                        nColsB = distH ? 3 : 6;
                        break;
                    }
                    case 20: {
                        nRowsB = distH ? 4 : 5;
                        nColsB = distH ? 5 : 4;
                        break;
                    }
                    default: {
                        nRowsB = distH ? 1 : k;
                        nColsB = distH ? k : 1;
                    }
                }
            }
        }
        content[0].setTextContent(stra, nCols, nRows);
        if (ass != null) {
            content[0].setIds(ass);
        }
        if (content.length > 1 && content[1] != null) {
            content[1].setTextContent(strb, nColsB, nRowsB);
            content[1].getShaper().reset(nColsB, nRowsB);
        }
        if (content.length > 2 && content[2] != null) {
            content[2].setTextContent(strc, nCols, nRows);
        }
        return true;
    }

    public static boolean checkClient(Class cl) {
        return ActiveBagContentKit.Compatible.class.isAssignableFrom(cl);
    }

    protected class Operacio {
        Num numA;
        Num numB;
        Num numR;
        int op;

        protected Operacio() {
            this.numA = new Num();
            this.numB = new Num();
            this.numR = new Num();
        }
    }

    protected class Num {
        float vf;
        int c;

        protected Num() {
        }
    }
}

