/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.bags.MediaBagElement;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.media.ActiveMediaPlayer;
import edu.xtec.jclic.media.MediaContent;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Map;
import org.jdom.Element;

public class ActiveBoxContent
implements Cloneable,
Domable {
    public BoxBase bb = null;
    public Dimension dimension = null;
    public Boolean border = null;
    public String text = null;
    public String imgName = null;
    public Shape imgClip = null;
    public MediaContent mediaContent = null;
    public int[] imgAlign = new int[]{1, 1};
    public int[] txtAlign = new int[]{1, 1};
    public boolean avoidOverlapping = false;
    public int id = -1;
    public int item = -1;
    public Image img = null;
    protected static ActiveBoxContent EMPTY_CONTENT;
    public Object userData = null;
    public String rawText = null;
    public String htmlText = null;
    public String innerHtmlText = null;
    public boolean animated = false;
    public ActiveMediaPlayer amp = null;
    public static final String ELEMENT_NAME = "cell";
    protected static final String ID = "id";
    protected static final String ITEM = "item";
    protected static final String WIDTH = "width";
    protected static final String HEIGHT = "height";
    protected static final String BORDER = "border";
    protected static final String IMAGE = "image";
    protected static final String TXTALIGN = "txtAlign";
    protected static final String IMGALIGN = "imgAlign";
    protected static final String AVOID_OVERLAPPING = "avoidOverlapping";
    public static final int EMPTY_CELL = 0;
    public static final int ONLY_ID = 1;
    public static final int HAS_CONTENT = 2;

    protected void copyRawDataFrom(ActiveBoxContent src) {
        this.bb = src.bb;
        this.dimension = src.dimension;
        this.border = src.border;
        this.text = src.text;
        this.imgName = src.imgName;
        this.imgClip = src.imgClip;
        this.mediaContent = src.mediaContent;
        this.imgAlign = src.imgAlign;
        this.txtAlign = src.txtAlign;
        this.avoidOverlapping = src.avoidOverlapping;
        this.id = src.id;
        this.item = src.item;
        this.img = src.img;
        this.userData = src.userData;
        this.rawText = src.rawText;
        this.htmlText = src.htmlText;
        this.innerHtmlText = src.innerHtmlText;
        this.animated = src.animated;
        this.amp = src.amp;
    }

    public static ActiveBoxContent getEmptyContent() {
        if (EMPTY_CONTENT == null) {
            EMPTY_CONTENT = new ActiveBoxContent();
        }
        return EMPTY_CONTENT;
    }

    @Override
    public Element getJDomElement() {
        Element e = new Element(ELEMENT_NAME);
        if (this.id != -1) {
            e.setAttribute(ID, Integer.toString(this.id));
        }
        if (this.item != -1) {
            e.setAttribute(ITEM, Integer.toString(this.item));
        }
        JDomUtility.setAlignProp(e, TXTALIGN, this.txtAlign, true);
        JDomUtility.setAlignProp(e, IMGALIGN, this.imgAlign, true);
        if (this.avoidOverlapping) {
            e.setAttribute(AVOID_OVERLAPPING, JDomUtility.boolString(this.avoidOverlapping));
        }
        if (this.dimension != null) {
            e.setAttribute(WIDTH, Integer.toString(this.dimension.width));
            e.setAttribute(HEIGHT, Integer.toString(this.dimension.height));
        }
        if (this.border != null) {
            e.setAttribute(BORDER, JDomUtility.boolString(this.border));
        }
        if (this.imgName != null) {
            e.setAttribute(IMAGE, this.imgName);
        }
        if (this.bb != null) {
            e.addContent(this.bb.getJDomElement());
        }
        if (this.mediaContent != null) {
            e.addContent(this.mediaContent.getJDomElement());
        }
        if (this.text != null) {
            JDomUtility.setParagraphs(e, this.text);
        }
        return e;
    }

    public int testCellContents() {
        if (JDomUtility.isDefaultAlign(this.txtAlign) && JDomUtility.isDefaultAlign(this.imgAlign) && !this.avoidOverlapping && this.dimension == null && this.border == null && this.imgName == null && this.bb == null && this.mediaContent == null && (this.text == null || this.text.length() == 0)) {
            return this.id == -1 && this.item == -1 ? 0 : 1;
        }
        return 2;
    }

    public static ActiveBoxContent getActiveBoxContent(Element e, MediaBag mediaBag) throws Exception {
        ActiveBoxContent abc = new ActiveBoxContent();
        abc.setProperties(e, mediaBag);
        return abc;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        MediaBag mediaBag = (MediaBag)aux;
        this.id = JDomUtility.getIntAttr(e, ID, this.id);
        this.item = JDomUtility.getIntAttr(e, ITEM, this.item);
        if (e.getAttribute("hAlign") != null || e.getAttribute("vAlign") != null) {
            this.txtAlign[0] = JDomUtility.getHAlign(e, this.txtAlign[0]);
            this.txtAlign[1] = JDomUtility.getVAlign(e, this.txtAlign[1]);
            this.imgAlign[0] = this.txtAlign[0];
            this.imgAlign[1] = this.txtAlign[1];
        } else {
            this.txtAlign = JDomUtility.getAlignProp(e, TXTALIGN, this.txtAlign);
            this.imgAlign = JDomUtility.getAlignProp(e, IMGALIGN, this.imgAlign);
        }
        this.avoidOverlapping = JDomUtility.getBoolAttr(e, AVOID_OVERLAPPING, this.avoidOverlapping);
        this.dimension = JDomUtility.getDimensionAttr(e, WIDTH, HEIGHT, this.dimension);
        this.border = JDomUtility.getBooleanAttr(e, BORDER, this.border);
        this.imgName = FileSystem.stdFn(e.getAttributeValue(IMAGE));
        Element child = e.getChild("style");
        if (child != null) {
            this.setBoxBase(BoxBase.getBoxBase(child));
        }
        if ((child = e.getChild("media")) != null) {
            this.mediaContent = MediaContent.getMediaContent(child);
        }
        this.setTextContent(JDomUtility.getParagraphs(e));
        if (mediaBag != null) {
            this.realizeContent(mediaBag);
        }
    }

    public static void listReferences(Element e, Map<String, String> map) {
        if (e != null) {
            Element child;
            String s = e.getAttributeValue(IMAGE);
            if (s != null && s.length() > 0) {
                map.put(s, "media");
            }
            if ((child = e.getChild("media")) != null) {
                MediaContent.listReferences(child, map);
            }
        }
    }

    public Object clone() {
        ActiveBoxContent abc = null;
        try {
            abc = (ActiveBoxContent)super.clone();
            abc.txtAlign = new int[]{this.txtAlign[0], this.txtAlign[1]};
            abc.imgAlign = new int[]{this.imgAlign[0], this.imgAlign[1]};
        }
        catch (Exception ex) {
            System.err.println("Unexpected error cloning ActiveBoxContent!");
        }
        return abc;
    }

    public void realizeContent(MediaBag mediaBag) throws Exception {
        MediaBagElement mbe;
        if (this.imgName != null && (mbe = mediaBag.getImageElement(this.imgName)) != null) {
            this.img = mbe.getImage();
            this.animated = mbe.animated;
        }
        if (this.mediaContent != null) {
            this.mediaContent.registerContentTo(mediaBag);
            if (this.img == null && (this.text == null || this.text.length() == 0)) {
                String s = this.mediaContent.getIconName();
                this.img = ResourceManager.getImageIcon("icons/" + s).getImage();
            }
        }
        this.checkHtmlText(mediaBag);
    }

    public boolean isEmpty() {
        return this.text == null && this.img == null;
    }

    public boolean isEquivalent(ActiveBoxContent abc, boolean checkCase) {
        if (abc == this) {
            return true;
        }
        boolean result = false;
        if (abc != null) {
            result = this.isEmpty() && abc.isEmpty() ? this.id == abc.id : (this.text == null ? abc.text == null : (checkCase ? this.text.equals(abc.text) : this.text.equalsIgnoreCase(abc.text))) && (this.mediaContent == null ? abc.mediaContent == null : this.mediaContent.isEquivalent(abc.mediaContent)) && this.img == abc.img && (this.imgClip == null ? abc.imgClip == null : this.imgClip.equals(abc.imgClip));
        }
        return result;
    }

    public boolean equals(Object o) {
        boolean result;
        boolean bl = result = o == this;
        if (!result && o != null && o instanceof ActiveBoxContent) {
            ActiveBoxContent abc = (ActiveBoxContent)o;
            result = this.isEquivalent(abc, true) && (this.bb == null && abc.bb == null || this.bb != null && this.bb.equals(abc.bb)) && this.txtAlign[0] == abc.txtAlign[0] && this.txtAlign[1] == abc.txtAlign[1] && this.imgAlign[0] == abc.imgAlign[0] && this.imgAlign[1] == abc.imgAlign[1] && this.avoidOverlapping == abc.avoidOverlapping;
        }
        return result;
    }

    public void setTextContent(String tx) {
        if (tx != null) {
            this.rawText = tx;
            this.text = tx;
            this.checkHtmlText(null);
        } else {
            this.rawText = null;
            this.text = null;
            this.htmlText = null;
            this.innerHtmlText = null;
        }
    }

    protected void checkHtmlText(MediaBag mediaBag) {
        this.htmlText = null;
        this.innerHtmlText = null;
        if (this.text != null && this.text.substring(0).toLowerCase().startsWith("<html>")) {
            int s2;
            String s;
            this.htmlText = this.text;
            if (mediaBag != null) {
                FileSystem fs = mediaBag.getProject().getFileSystem();
                String path = fs.root;
                if (!fs.isUrlBased()) {
                    path = "file:" + FileSystem.sysFn(path);
                }
                this.htmlText = StrUtils.replace(this.htmlText, "SRC=\"", "SRC=\"" + path);
                this.htmlText = StrUtils.replace(this.htmlText, "src=\"", "src=\"" + path);
            }
            if ((s = this.htmlText.substring(0).toLowerCase()).indexOf("<body") == -1 && (s2 = s.indexOf("</html>")) >= 0) {
                this.innerHtmlText = this.htmlText.substring(6, s2);
            }
        }
    }

    public void setImgContent(Image setImg, Shape setImgClip) {
        this.img = setImg;
        this.imgName = null;
        this.imgClip = setImgClip;
    }

    public void setImgAlign(int[] align) {
        this.imgAlign[0] = align[0];
        this.imgAlign[1] = align[1];
    }

    public void setImgAlign(int h, int v) {
        this.imgAlign[0] = h;
        this.imgAlign[1] = v;
    }

    public void setTxtAlign(int[] align) {
        this.txtAlign[0] = align[0];
        this.txtAlign[1] = align[1];
    }

    public void setTxtAlign(int h, int v) {
        this.txtAlign[0] = h;
        this.txtAlign[1] = v;
    }

    public void prepareMedia(PlayStation ps) {
        this.amp = this.mediaContent != null ? ps.getActiveMediaPlayer(this.mediaContent) : null;
    }

    public void setBoxBase(BoxBase boxBase) {
        this.bb = boxBase;
    }

    public void setDimension(Dimension d) {
        this.dimension = d;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public void setBorder(boolean b) {
        this.border = b;
    }

    public void copyStyleTo(ActiveBoxContent abc) {
        if (abc != null) {
            abc.setBoxBase(this.bb);
            if (this.border != null) {
                abc.setBorder(this.border);
            }
        }
    }

    public String getDescription() {
        StringBuilder result = new StringBuilder();
        if (this.text != null && this.text.length() > 0) {
            result.append(this.text);
        } else if (this.imgName != null) {
            result.append("IMG:").append(this.imgName);
        } else if (this.imgClip != null) {
            Rectangle r = this.imgClip.getBounds();
            result.append("[").append(r.x).append(",").append(r.y).append(",");
            result.append(r.width).append(",").append(r.height).append("]");
        }
        if (this.mediaContent != null) {
            if (result.length() > 0) {
                result.append(' ');
            }
            result.append(this.mediaContent.getDescription());
        }
        return result.substring(0);
    }
}

