/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.util.LFUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ThumbsExplorerPanel
extends JPanel {
    public static final int DEFAULT_THUMB_WIDTH = 90;
    public static final int DEFAULT_THUMB_HEIGHT = 90;
    public static final int DEFAULT_THUMB_MARGIN = 14;
    public static final int DEFAULT_TEXT_HEIGHT = 14;
    public static final int DEFAULT_THUMB_INTERNAL_MARGIN = 2;
    protected static BasicStroke BORDER_STROKE = new BasicStroke(0.2f);
    protected int th_width;
    protected int th_height;
    protected int th_margin;
    protected int th_textHeight;
    protected int th_int_margin;
    protected Font font;
    private List<ThumbElement> elements;
    private ThumbElement current;
    private int elementsPerRow;
    private EventListenerList listenersList;
    public Dimension maxThumbSize;
    public Dimension boxSize;

    public ThumbsExplorerPanel() {
        this.setLayout(null);
        this.elements = new ArrayList<ThumbElement>();
        this.listenersList = new EventListenerList();
        this.setSizes(90, 90, 14, 14, 2);
        this.setPreferredSize(new Dimension(3 * this.boxSize.width, this.boxSize.height));
        this.setFont(new Font("Dialog", 0, 12));
        this.setBackground(LFUtil.getColor("Table.background", Color.lightGray));
        this.elementsPerRow = 1;
        this.enableEvents(24L);
    }

    public void setSizes(int th_width, int th_height, int th_margin, int th_textHeight, int th_int_margin) {
        this.th_width = Math.max(10, th_width);
        this.th_height = Math.max(10, th_height);
        this.th_margin = Math.max(5, th_margin);
        this.th_textHeight = Math.max(10, th_textHeight);
        this.th_int_margin = Math.max(0, th_int_margin);
        this.boxSize = new Dimension(th_width + 2 * th_margin, th_height + th_textHeight + 2 * th_margin);
        this.maxThumbSize = new Dimension(th_width - 2 * th_int_margin, th_height - 2 * th_int_margin);
        for (int i = 0; i < this.elements.size(); ++i) {
            this.getThumbElement(i).sizeImage();
        }
        this.invalidate();
    }

    public void resizeTo(int desiredWidth) {
        int numElements = this.elements.size();
        int w = Math.max(this.boxSize.width, desiredWidth);
        int bpr = w / this.boxSize.width;
        int numRows = numElements / bpr + 1;
        int h = numRows * this.boxSize.height;
        this.setPreferredSize(new Dimension(w, h));
        this.revalidate();
        this.repaint();
    }

    public ThumbElement getThumbElement(int p) {
        return this.elements.get(p);
    }

    public ThumbElement[] getThumbElements() {
        return this.elements.toArray(new ThumbElement[this.elements.size()]);
    }

    public ThumbElement getElementFor(Object object) {
        ThumbElement result = null;
        for (int i = 0; i < this.elements.size(); ++i) {
            if (this.getThumbElement(i).getUserObject() != object) continue;
            result = this.getThumbElement(i);
            break;
        }
        return result;
    }

    public int getThumbElementCount() {
        return this.elements.size();
    }

    public void removeThumbElementAt(int p) {
        ThumbElement o;
        if (this.elements != null && (o = this.elements.get(p)) != null) {
            if (o == this.current) {
                this.current = null;
            }
            this.elements.remove(p);
            this.invalidate();
        }
    }

    public void removeAllThumbElements() {
        this.elements.clear();
        this.current = null;
        this.invalidate();
        this.repaint();
    }

    public ThumbElement addThumbElement(int p, Object userObject, ImageIcon img, String text) {
        ThumbElement th = new ThumbElement(userObject, img, text);
        if (p >= 0) {
            this.elements.add(p, th);
        } else {
            this.elements.add(th);
        }
        this.invalidate();
        return th;
    }

    public ThumbElement addThumbElement(Object userObject, ImageIcon img, String text) {
        return this.addThumbElement(-1, userObject, img, text);
    }

    public ThumbElement getCurrent() {
        return this.current;
    }

    public Object getCurrentObject() {
        return this.current == null ? null : this.current.getUserObject();
    }

    public void setCurrent(ThumbElement th) {
        Rectangle r;
        if (this.current != null && (r = this.getRectFor(this.getIndexOf(this.current))) != null) {
            this.repaint(r);
        }
        if (th != null && this.elements.contains(th)) {
            this.current = th;
            r = this.getRectFor(this.getIndexOf(this.current));
            if (r != null) {
                this.repaint(r);
            }
            this.scrollRectToVisible(r);
        } else {
            this.current = null;
        }
    }

    public void checkCurrentVisibility() {
        Rectangle r;
        if (this.current != null && (r = this.getRectFor(this.getIndexOf(this.current))) != null) {
            this.scrollRectToVisible(r);
        }
    }

    public void setCurrentObject(Object o) {
        ThumbElement th = null;
        for (int i = 0; i < this.elements.size(); ++i) {
            if (this.getThumbElement(i).getUserObject() != o) continue;
            th = this.getThumbElement(i);
            break;
        }
        this.setCurrent(th);
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
        this.repaint();
    }

    public int getIndexOf(ThumbElement th) {
        return th == null ? -1 : this.elements.indexOf(th);
    }

    public Rectangle getRectFor(int p) {
        Rectangle r = null;
        if (p >= 0 && p < this.elements.size()) {
            r = new Rectangle(this.boxSize);
            r.x = p % this.elementsPerRow * r.width;
            r.y = p / this.elementsPerRow * r.height;
        }
        return r;
    }

    @Override
    public void doLayout() {
        Dimension d = this.getPreferredSize();
        int w = Math.max(d.width, this.boxSize.width);
        this.elementsPerRow = w / this.boxSize.width;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Rectangle clip = g2.getClipBounds();
        Rectangle r = new Rectangle(this.boxSize);
        for (int i = 0; i < this.elements.size(); ++i) {
            r.x = i % this.elementsPerRow * r.width;
            r.y = i / this.elementsPerRow * r.height;
            if (!r.intersects(clip)) continue;
            this.getThumbElement(i).paint(g2, r);
        }
    }

    public void addActionListener(ActionListener l) {
        this.listenersList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenersList.remove(ActionListener.class, l);
    }

    protected void fireActionPerformed() {
        EventListener[] listeners;
        ActionEvent actionEvent = new ActionEvent(this.current, 1001, "");
        for (EventListener lst : listeners = this.listenersList.getListeners(ActionListener.class)) {
            ((ActionListener)lst).actionPerformed(actionEvent);
        }
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.listenersList.add(ListSelectionListener.class, l);
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.listenersList.remove(ListSelectionListener.class, l);
    }

    protected void fireSelectionChanged(int index) {
        EventListener[] listeners;
        ListSelectionEvent listEvent = new ListSelectionEvent(this.current, index, index, false);
        for (EventListener lst : listeners = this.listenersList.getListeners(ListSelectionListener.class)) {
            ((ListSelectionListener)lst).valueChanged(listEvent);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent ev) {
        int p;
        if (this.isEnabled() && ev.getID() == 502 && (p = ev.getX() / this.boxSize.width + this.elementsPerRow * (ev.getY() / this.boxSize.height)) < this.elements.size()) {
            if (ev.getClickCount() == 1) {
                this.setCurrent(this.getThumbElement(p));
                this.fireSelectionChanged(p);
            } else if (ev.getClickCount() == 2) {
                this.fireActionPerformed();
            }
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
    }

    public class ThumbElement {
        ImageIcon image;
        String text;
        Object userObject;

        ThumbElement(Object userObject, ImageIcon image, String text) {
            this.setUserObject(userObject);
            this.setImage(image);
            this.setText(text);
        }

        public Object getUserObject() {
            return this.userObject;
        }

        public void setUserObject(Object userObject) {
            this.userObject = userObject;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public ImageIcon getImage() {
            return this.image;
        }

        public void setImage(ImageIcon image) {
            this.image = image;
            if (image != null) {
                this.sizeImage();
            }
        }

        protected void sizeImage() {
            if (this.image != null) {
                int w = this.image.getIconWidth();
                int h = this.image.getIconHeight();
                if (w > ThumbsExplorerPanel.this.maxThumbSize.width || h > ThumbsExplorerPanel.this.maxThumbSize.height) {
                    double f = Math.min((double)ThumbsExplorerPanel.this.maxThumbSize.width / (double)w, (double)ThumbsExplorerPanel.this.maxThumbSize.height / (double)h);
                    this.image = new ImageIcon(this.image.getImage().getScaledInstance((int)(f * (double)w), (int)(f * (double)h), 4));
                }
            }
        }

        protected void paint(Graphics2D g2, Rectangle r) {
            g2.setBackground(LFUtil.getColor("Table.background", Color.white));
            g2.clearRect(r.x, r.y, r.width, r.height);
            if (ThumbsExplorerPanel.this.current == this) {
                Rectangle r2 = new Rectangle(r.x + ThumbsExplorerPanel.this.th_margin / 2, r.y + ThumbsExplorerPanel.this.th_margin / 2, r.width - ThumbsExplorerPanel.this.th_margin, r.height - ThumbsExplorerPanel.this.th_margin);
                g2.setColor(LFUtil.getSysColor("activeCaption", Color.orange));
                g2.fill(r2);
                g2.setColor(LFUtil.getSysColor("activeCaptionBorder", Color.red));
                g2.draw(r2);
            }
            if (this.image != null) {
                this.image.paintIcon(ThumbsExplorerPanel.this, g2, r.x + (ThumbsExplorerPanel.this.th_width + 2 * ThumbsExplorerPanel.this.th_margin - this.image.getIconWidth()) / 2, r.y + (ThumbsExplorerPanel.this.th_height + 2 * ThumbsExplorerPanel.this.th_margin - this.image.getIconHeight()) / 2);
            }
            g2.setColor(LFUtil.getColor("Table.gridColor", Color.gray));
            g2.setStroke(BORDER_STROKE);
            g2.drawRect(r.x + ThumbsExplorerPanel.this.th_margin, r.y + ThumbsExplorerPanel.this.th_margin, ThumbsExplorerPanel.this.th_width, ThumbsExplorerPanel.this.th_height);
            if (this.text != null && this.text.length() > 0) {
                TextHitInfo hitInfo;
                int insPoint;
                if (ThumbsExplorerPanel.this.current == this) {
                    g2.setColor(LFUtil.getSysColor("activeCaptionText", Color.black));
                } else {
                    g2.setColor(LFUtil.getColor("Table.foreground", Color.black));
                }
                FontRenderContext frc = g2.getFontRenderContext();
                Font f2 = LFUtil.getFont("Table.font", ThumbsExplorerPanel.this.font);
                TextLayout layout = new TextLayout(this.text, f2, frc);
                Rectangle2D txRect = layout.getBounds();
                if (layout.getBounds().getWidth() > (double)ThumbsExplorerPanel.this.th_width && (insPoint = (hitInfo = layout.hitTestChar(ThumbsExplorerPanel.this.th_width - 20, 0.0f)).getInsertionIndex()) > 0) {
                    layout = new TextLayout(this.text.substring(0, insPoint) + "...", f2, frc);
                    txRect = layout.getBounds();
                }
                layout.draw(g2, (float)r.x + (float)ThumbsExplorerPanel.this.th_margin + ((float)ThumbsExplorerPanel.this.th_width - (float)txRect.getWidth()) / 2.0f, (float)r.y + (float)(2 * ThumbsExplorerPanel.this.th_margin) + (float)ThumbsExplorerPanel.this.th_height);
            }
        }
    }
}

