/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.edit;

import edu.xtec.jclic.edit.EditDialog;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.util.CtrlPanel;
import edu.xtec.util.Options;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public abstract class EditorPanel
extends CtrlPanel
implements FocusListener,
Editor.EditorListener {
    protected Editor editor;
    protected Options options;
    public static final Color titleBgColor = Color.orange;
    public static final Color titleForeColor = Color.blue;
    public static final Color panelBgColor = new Color(255, 255, 204);
    public static final Border titleBorder = new EmptyBorder(new Insets(6, 4, 6, 4));
    public static final Border panelBorder = new EmptyBorder(0, 0, 0, 0);
    public JLabel northComponent;
    public Component southComponent;

    public EditorPanel(Options options) {
        this.options = options;
    }

    public Options getOptions() {
        return this.options;
    }

    protected void postInit(int preferredLabelWidth, boolean withTitleBar, boolean withToolBar) {
        this.setBorder(panelBorder);
        if (withTitleBar || withToolBar) {
            JPanel northPanel = new JPanel(new BorderLayout());
            if (withTitleBar) {
                this.northComponent = this.createTitleLabel(preferredLabelWidth);
                northPanel.add((Component)this.northComponent, "North");
            }
            if (withToolBar) {
                this.southComponent = this.createToolBar();
                northPanel.add(this.southComponent, "South");
            }
            this.add((Component)northPanel, "North");
        }
    }

    public abstract boolean checkIfEditorValid(Editor var1);

    public final void clear() {
        this.setModified(false);
    }

    public final void fill() {
        this.setInitializing(true);
        this.fillData();
        this.setInitializing(false);
        this.setModified(false);
        this.setEnabled(this.editor != null);
    }

    protected abstract void fillData();

    public final void save() {
        if (this.editor != null && this.isModified()) {
            this.saveData();
            this.editor.fireEditorDataChanged(this);
            this.setModified(false);
        }
    }

    protected abstract void saveData();

    public void attachEditor(Editor e, boolean saveChanges) {
        if (e == this.editor) {
            if (this.editor != null && saveChanges && this.isModified()) {
                this.editor.setModified(true);
            }
            this.fill();
        } else {
            if (this.editor != null) {
                this.removeEditor(saveChanges);
            }
            if (this.checkIfEditorValid(e)) {
                this.setEditor(e);
                this.editor.addEditorListener(this);
                this.fill();
            }
        }
    }

    public Editor getEditor() {
        return this.editor;
    }

    protected synchronized void setEditor(Editor e) {
        if (this.editor != null) {
            this.editor.clearActionsOwner();
        }
        this.editor = e;
        if (e != null) {
            e.setActionsOwner();
        }
    }

    public void removeEditor(boolean saveChanges) {
        if (this.editor != null) {
            this.editor.removeEditorListener(this);
            if (saveChanges) {
                this.save();
            }
            this.setEditor(null);
            this.fill();
        }
    }

    @Override
    public void editorDataChanged(Editor e) {
        if (e != null && e.equals(this.getEditor())) {
            this.fillData();
        }
    }

    protected Icon getIcon() {
        return null;
    }

    protected String getTitle() {
        return "";
    }

    protected JLabel createTitleLabel(int preferredWidth) {
        JLabel result = new JLabel(this.getTitle());
        result.setHorizontalAlignment(0);
        if (this.getIcon() != null) {
            result.setIcon(this.getIcon());
            result.setIconTextGap(10);
        }
        result.setBackground(titleBgColor);
        result.setForeground(titleForeColor);
        result.setOpaque(true);
        result.setBorder(titleBorder);
        result.validate();
        Dimension d = result.getPreferredSize();
        result.setPreferredSize(new Dimension(Math.max(d.width, preferredWidth), d.height));
        result.setMinimumSize(result.getPreferredSize());
        return result;
    }

    protected void addActionsTo(Container cnt) {
    }

    protected JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.setOpaque(false);
        this.addActionsTo(toolBar);
        return toolBar;
    }

    protected String checkEmptyString(String src, boolean trim, String msgCodeDefault) {
        String result = src;
        if (result != null && trim) {
            result = result.trim();
        }
        if (result == null || result.length() == 0) {
            result = this.options.getMsg(msgCodeDefault);
        }
        return result;
    }

    public boolean showDialog(Editor e, String titleKey, Component cmp, boolean removeActionButtons) {
        if (removeActionButtons && this.southComponent != null) {
            this.remove(this.southComponent);
        }
        this.attachEditor(e, false);
        EditDialog dlg = new EditDialog(this.options, titleKey, JOptionPane.getFrameForComponent(cmp));
        dlg.getContentPane().add((Component)this, "Center");
        if (this.northComponent != null) {
            Dimension d = dlg.getContentPane().getPreferredSize();
            d.width = this.northComponent.getPreferredSize().width;
            this.setPreferredSize(d);
        }
        dlg.showDialog();
        this.removeEditor(dlg.result);
        return dlg.result;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.getEditor() != null) {
            this.getEditor().setActionsOwner();
        } else {
            Editor.clearBasicActionsOwner();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }
}

