/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.media.AudioPlayer;
import edu.xtec.jclic.media.EventSounds;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Options;
import org.jdom.Element;

public class EventSoundsElement
implements Domable,
Cloneable {
    protected String fileName;
    protected int enabled;
    protected AudioPlayer player;
    protected String id;
    public static final String ELEMENT_NAME = "sound";
    public static final String ID = "id";
    public static final String FILE = "file";

    public EventSoundsElement(String id) {
        this.id = id;
        this.enabled = 2;
        this.fileName = null;
        this.player = null;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public Element getJDomElement() {
        if (this.id == null || this.enabled == 2 && this.fileName == null) {
            return null;
        }
        Element e = new Element(ELEMENT_NAME);
        e.setAttribute(ID, this.id);
        if (this.enabled != 2) {
            e.setAttribute("enabled", JDomUtility.triStateString(this.enabled));
        }
        if (this.fileName != null) {
            e.setAttribute(FILE, this.fileName);
        }
        return e;
    }

    public static EventSoundsElement getEventSoundsElement(Element e) throws Exception {
        String id = JDomUtility.getStringAttr(e, ID, e.getName(), false);
        if (id == null || id.length() < 1 || ELEMENT_NAME.equals(id)) {
            throw new Exception("Invalid event sound element id: " + id);
        }
        EventSoundsElement ev = new EventSoundsElement(id);
        ev.setProperties(e, null);
        return ev;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        this.enabled = JDomUtility.getTriStateAttr(e, "enabled", this.enabled);
        this.fileName = JDomUtility.getStringAttr(e, FILE, this.fileName, false);
    }

    public void setFileName(String fName) {
        if (this.player != null) {
            this.player.close();
        }
        this.fileName = fName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setEnabled(int v) {
        if (JDomUtility.checkTriState(v)) {
            this.enabled = v;
            if (this.player != null) {
                this.player.stop();
            }
        }
    }

    public int getEnabled() {
        return this.enabled;
    }

    private void buildPlayer(Options options) {
        this.close();
        String s = options.getString("mediaSystem");
        try {
            Class<?> c = Class.forName("edu.xtec.jclic.media.JavaSoundAudioPlayer");
            this.player = (AudioPlayer)c.newInstance();
        }
        catch (Exception ex) {
            System.err.println("Error building audio player:\n" + ex);
        }
    }

    public boolean setDataSource(Object source, Options options) throws Exception {
        this.buildPlayer(options);
        return this.player == null ? false : this.player.setDataSource(source);
    }

    public void realize(Options options, MediaBag mediaBag) throws Exception {
        if (this.player == null) {
            this.buildPlayer(options);
        }
        this.player.realize(this.fileName, mediaBag);
    }

    public void close() {
        if (this.player != null) {
            this.player.close();
            this.player = null;
        }
    }

    public void play() {
        if (this.player != null && this.enabled != 0 && EventSounds.globalEnabled) {
            this.player.play();
        }
    }

    public void stop() {
        if (this.player != null) {
            this.player.stop();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public Object clone() {
        EventSoundsElement evs = new EventSoundsElement(this.id);
        evs.fileName = this.fileName;
        evs.enabled = this.enabled;
        evs.player = this.player;
        return evs;
    }
}

