/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.media.ActiveMediaPlayer;
import edu.xtec.jclic.media.AudioBuffer;
import edu.xtec.jclic.media.ClipWrapper;
import edu.xtec.jclic.media.FalseClip;
import edu.xtec.jclic.media.JavaSoundAudioBuffer;
import edu.xtec.jclic.media.MediaContent;
import edu.xtec.jclic.media.PseudoClip;
import edu.xtec.util.ExtendedByteArrayInputStream;
import edu.xtec.util.StreamIO;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequencer;
import javax.swing.Timer;

public class JavaSoundActiveMediaPlayer
extends ActiveMediaPlayer {
    PseudoClip clip;
    Timer timer;
    boolean midi = false;
    ByteArrayInputStream midiIs = null;
    public static Sequencer sequencer = null;

    public JavaSoundActiveMediaPlayer(MediaContent mc, MediaBag mb, PlayStation ps) {
        super(mc, mb, ps);
        if (!this.useAudioBuffer) {
            try {
                switch (mc.mediaType) {
                    case 3: {
                        this.midi = true;
                        InputStream is = mb.getInputStream(mc.mediaFileName);
                        if (is instanceof ByteArrayInputStream) {
                            this.midiIs = (ByteArrayInputStream)is;
                            break;
                        }
                        this.midiIs = new ExtendedByteArrayInputStream(StreamIO.readInputStream(is), mc.mediaFileName);
                        break;
                    }
                    case 1: {
                        this.clip = mc.to > 0 || mc.from > 0 ? ClipWrapper.getClipWrapper(mb, mc.mediaFileName) : FalseClip.getFalseClip(mb, mc.mediaFileName);
                        if (this.clip == null || mc.loop || mc.to <= Math.max(0, mc.from)) break;
                        this.timer = new Timer(mc.to - Math.max(0, mc.from), new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent ev) {
                                if (JavaSoundActiveMediaPlayer.this.clip != null && JavaSoundActiveMediaPlayer.this.clip.isRunning()) {
                                    JavaSoundActiveMediaPlayer.this.clip.stop();
                                }
                            }
                        });
                        this.timer.setCoalesce(false);
                        this.timer.setRepeats(false);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                System.err.println("Error reading media \"" + mc.mediaFileName + "\":\n" + ex);
            }
        }
    }

    @Override
    public AudioBuffer createAudioBuffer(int seconds) throws Exception {
        return new JavaSoundAudioBuffer(this.mc.length);
    }

    public static void closeMidiSequencer() {
        if (sequencer != null) {
            if (sequencer.isRunning()) {
                sequencer.stop();
            }
            if (sequencer.isOpen()) {
                sequencer.close();
            }
        }
    }

    @Override
    public void realize() {
        if (!this.useAudioBuffer) {
            try {
                if (this.midi) {
                    if (sequencer == null) {
                        sequencer = MidiSystem.getSequencer();
                    }
                } else if (this.clip != null && !this.clip.isOpen()) {
                    this.clip.open();
                }
            }
            catch (Exception e) {
                System.err.println("Error realizing media \"" + this.mc.mediaFileName + "\"\n" + e);
            }
        }
    }

    @Override
    protected void playNow(ActiveBox setBx) {
        if (this.useAudioBuffer) {
            super.playNow(setBx);
        } else {
            try {
                if (this.midi) {
                    if (sequencer == null) {
                        this.realize();
                    }
                    if (sequencer != null && this.midiIs != null) {
                        if (sequencer.isRunning()) {
                            sequencer.stop();
                        }
                        if (!sequencer.isOpen()) {
                            sequencer.open();
                        }
                        this.midiIs.reset();
                        sequencer.setSequence(this.midiIs);
                        sequencer.stop();
                        this.setTimeRanges();
                        sequencer.start();
                    }
                } else if (this.clip != null) {
                    if (!this.clip.isOpen()) {
                        this.realize();
                    }
                    this.setTimeRanges();
                    this.attachVisualComponent();
                    if (this.mc.loop) {
                        this.clip.loop(-1);
                    } else {
                        this.clip.start();
                        if (this.timer != null) {
                            this.timer.start();
                        }
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Error playing media \"" + this.mc.mediaFileName + "\":\n" + e);
            }
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (!this.useAudioBuffer) {
            try {
                if (this.midi && sequencer != null) {
                    JavaSoundActiveMediaPlayer.closeMidiSequencer();
                } else if (this.clip != null && this.clip.isActive()) {
                    if (this.timer != null && this.timer.isRunning()) {
                        this.timer.stop();
                    }
                    this.clip.stop();
                }
            }
            catch (Exception e) {
                System.err.println("Error stopping media \"" + this.mc.mediaFileName + "\":\n" + e);
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        if (!this.useAudioBuffer) {
            try {
                if (this.midi) {
                    if (sequencer != null) {
                        sequencer.close();
                        sequencer = null;
                    }
                    if (this.midiIs != null) {
                        this.midiIs.close();
                        this.midiIs = null;
                    }
                } else if (this.clip != null) {
                    this.stop();
                    this.clip.close();
                    this.destroyVisualComponent();
                    this.clip = null;
                    this.timer = null;
                }
            }
            catch (Exception e) {
                System.err.println("Error closing media \"" + this.mc.mediaFileName + "\":\n" + e);
            }
        }
    }

    @Override
    protected void setTimeRanges() {
        if (this.useAudioBuffer) {
            return;
        }
        try {
            if (this.midi && sequencer != null) {
                sequencer.setTickPosition(0L);
            } else if (this.clip != null && this.clip.isOpen()) {
                if (this.mc.from >= 0 || this.mc.to >= 0) {
                    int to;
                    int from = this.mc.from > 0 ? (int)(this.clip.getFormat().getFrameRate() * (float)this.mc.from / 1000.0f) : 0;
                    int n = to = this.mc.to >= 0 ? (int)(this.clip.getFormat().getFrameRate() * (float)this.mc.to / 1000.0f) : -1;
                    if (this.mc.loop) {
                        this.clip.setLoopPoints(from, to);
                    }
                    this.clip.setFramePosition(from);
                } else {
                    this.clip.setFramePosition(0);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error setting time ranges for \"" + this.mc.mediaFileName + "\":\n" + e);
        }
    }

    @Override
    protected Component getVisualComponent() {
        return null;
    }
}

