/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.Icon;
import org.jdom.Element;

public class LibraryManagerElement
implements Domable {
    protected String name;
    protected String path;
    protected Options options;
    protected boolean exists;
    protected boolean editable;
    protected boolean isUrl;
    protected boolean systemLib;
    public static final String ELEMENT_NAME = "library";
    public static final String NAME = "name";
    public static final String PATH = "path";

    public LibraryManagerElement(Options options) {
        this.options = options;
        this.name = options.getMsg("UNNAMED");
        this.path = null;
        this.exists = false;
        this.editable = false;
        this.isUrl = false;
        this.systemLib = false;
    }

    public LibraryManagerElement(String name, String path, Options options) {
        this.name = name;
        this.path = path;
        this.options = options;
        this.checkAttributes();
    }

    public static LibraryManagerElement getLibraryManagerElement(Element e, Options options) throws Exception {
        LibraryManagerElement lme = new LibraryManagerElement(options);
        lme.setProperties(e, null);
        return lme;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        this.name = JDomUtility.getStringAttr(e, NAME, this.name, false);
        this.path = JDomUtility.getStringAttr(e, PATH, this.path, false);
        this.checkAttributes();
    }

    @Override
    public Element getJDomElement() {
        Element e = new Element(ELEMENT_NAME);
        e.setAttribute(NAME, this.name);
        e.setAttribute(PATH, this.path);
        return e;
    }

    public Icon getIcon() {
        String base = "icons/database";
        if (this.exists) {
            if (!this.editable) {
                base = base + "_locked";
            }
        } else {
            base = base + "_unavailable";
        }
        return ResourceManager.getImageIcon(base + ".gif");
    }

    protected void checkAttributes() {
        this.exists = false;
        this.editable = false;
        this.isUrl = false;
        if (this.path != null) {
            if (this.path.startsWith("http:") || this.path.startsWith("https:")) {
                this.isUrl = true;
                try {
                    URL url = new URL(this.path.replace(" ", "%20"));
                    URLConnection con = url.openConnection();
                    this.exists = con != null;
                }
                catch (Exception url) {}
            } else {
                File file = new File(this.path);
                boolean bl = this.exists = file.exists() && !file.isDirectory() && file.canRead();
                if (this.exists) {
                    this.editable = file.canWrite();
                }
            }
        }
    }

    public void setSystemLib(boolean setting) {
        this.systemLib = setting;
    }

    public boolean isSystemLib() {
        return this.systemLib;
    }

    public String toString() {
        return this.name;
    }
}

