/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.activities.panels.Menu;
import edu.xtec.jclic.activities.panels.MenuEditor;
import edu.xtec.jclic.activities.panels.MenuElement;
import edu.xtec.jclic.edit.EditorTreePanel;
import edu.xtec.jclic.fileSystem.FileBackup;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.misc.Gradient;
import edu.xtec.jclic.project.LibraryManager;
import edu.xtec.jclic.project.LibraryManagerElement;
import edu.xtec.jclic.project.ProjectInstaller;
import edu.xtec.jclic.project.ProjectLibrary;
import edu.xtec.util.ExtendedJDialog;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ProgressInputStream;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StreamIO;
import edu.xtec.util.SwingWorker;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ProjectInstallerDlg
extends ExtendedJDialog
implements ProgressInputStream.ProgressInputStreamListener,
ListSelectionListener {
    public ProjectLibrary result;
    public boolean cancel;
    public boolean launchNow;
    public String pathToMainProject;
    Messages msg;
    LibraryManager lm;
    FileSystem storeFileSystem;
    ProjectInstaller pi;
    ProjectLibrary pl;
    LibraryManager.LibraryPane libraryPane;
    EditorTreePanel etp;
    File installDir;
    Options options;
    boolean workerRunning;
    SwingWorker worker;
    boolean copyComplete;
    private Font titleFont;
    private Font mainFont;
    private Font itemFont;
    private Image logo;
    private Gradient logoGp;
    private int currentStage = 0;
    private static final int STAGE_INFO = 0;
    private static final int STAGE_SELECT_LIB = 1;
    private static final int STAGE_COPY_FILES = 2;
    private static final int STAGE_SELECT_FOLDER = 3;
    private static final int STAGE_END = 4;
    private static final int NUM_STAGES = 5;
    private static final String[] STAGE_TITLES = new String[]{"install_title", "install_step_1", "install_step_2", "install_step_3", "install_step_4"};
    private static final String LOGO = "icons/install.png";
    private JButton cancelBtn;
    private JPanel card00;
    private JPanel card01;
    private JPanel card02;
    private JPanel card03;
    private JPanel card04;
    private JLabel cardTitleLb;
    private JLabel destLb;
    private JProgressBar itemProgressBar;
    private JCheckBox launchProjectChk;
    private JPanel libFolderPanel;
    private JPanel logoPanel;
    private JPanel mainPane;
    private JButton nextBtn;
    private JButton prevBtn;
    private JPanel selectLibPanel;
    private JLabel statusLb;

    private ProjectInstallerDlg(Component parent, LibraryManager lm, ProjectInstaller pi) throws Exception {
        super(parent, null, true);
        this.lm = lm;
        this.options = lm.settings.rb.getOptions();
        this.msg = this.options.getMessages();
        this.setTitle(this.msg.get("install_title"));
        this.result = null;
        this.launchNow = true;
        this.pathToMainProject = null;
        this.cancel = false;
        this.titleFont = new Font("Dialog", 1, 18);
        this.mainFont = new Font("Dialog", 1, 12);
        this.itemFont = new Font("Dialog", 0, 12);
        this.pi = pi;
        if (pi.from == null) {
            throw new Exception("Path to installer data store not specified!");
        }
        this.storeFileSystem = FileSystem.createFileSystem(pi.from, null, lm.settings.rb);
        this.logo = ResourceManager.getImageIcon(LOGO).getImage();
        this.logoGp = new Gradient(Color.white, Color.blue, 90, 1);
        this.initComponents();
        this.centerOver(parent);
        this.getRootPane().setDefaultButton(this.nextBtn);
    }

    public static ProjectInstallerDlg getProjectInstallerDlg(Component parent, LibraryManager lm, String installerScriptFile) throws Exception {
        return new ProjectInstallerDlg(parent, lm, ProjectInstaller.getProjectInstaller(installerScriptFile));
    }

    private void initComponents() {
        JPanel btPane = new JPanel();
        this.cancelBtn = new JButton();
        this.prevBtn = new JButton();
        this.nextBtn = new JButton();
        JPanel basicPane = new JPanel();
        this.mainPane = new JPanel();
        this.card00 = new JPanel();
        JLabel infoTitleLb = new JLabel();
        JTextArea titleLb2 = new JTextArea();
        JTextArea authorLb = new JTextArea();
        JLabel sourceLbHeader = new JLabel();
        JLabel sourceLb = new JLabel();
        JLabel wizardInfoLb = new JLabel();
        this.card01 = new JPanel();
        JLabel libLb = new JLabel();
        this.selectLibPanel = this.lm.getLibraryPane(true, true);
        this.libraryPane = (LibraryManager.LibraryPane)this.selectLibPanel;
        this.libraryPane.addListSelectionListener(this);
        this.card02 = new JPanel();
        JLabel sourcePathLbHeader = new JLabel();
        JLabel sourcePathLb = new JLabel();
        JLabel destLbHeader = new JLabel();
        this.destLb = new JLabel();
        JLabel statusLbHeader = new JLabel();
        this.statusLb = new JLabel();
        this.itemProgressBar = new JProgressBar();
        this.card03 = new JPanel();
        JLabel libFolderLb = new JLabel();
        this.libFolderPanel = new JPanel();
        this.card04 = new JPanel();
        JLabel finishLb = new JLabel();
        JLabel finishLb2 = new JLabel();
        JLabel finishLb3 = new JLabel();
        this.launchProjectChk = new JCheckBox();
        this.cardTitleLb = new JLabel();
        this.logoPanel = new JPanel(){

            @Override
            public void paintComponent(Graphics g) {
                Rectangle r = new Rectangle(0, 0, this.getBounds().width, this.getBounds().height);
                if (ProjectInstallerDlg.this.logoGp != null) {
                    ProjectInstallerDlg.this.logoGp.paint((Graphics2D)g, r);
                }
                if (ProjectInstallerDlg.this.logo != null) {
                    int x = (r.width - ProjectInstallerDlg.this.logo.getWidth(this)) / 2;
                    int y = (r.height - ProjectInstallerDlg.this.logo.getHeight(this)) / 2;
                    g.drawImage(ProjectInstallerDlg.this.logo, x, y, this);
                }
            }
        };
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ProjectInstallerDlg.this.closeDialog(evt);
            }
        });
        btPane.setLayout(new GridBagLayout());
        this.cancelBtn.setToolTipText(this.msg.get("wizard_cancel_tooltip"));
        this.cancelBtn.setText(this.msg.get("wizard_cancel"));
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectInstallerDlg.this.cancelBtnActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        btPane.add((Component)this.cancelBtn, gridBagConstraints);
        this.prevBtn.setToolTipText(this.msg.get("wizard_prev_tooltip"));
        this.prevBtn.setText(this.msg.get("wizard_prev"));
        this.prevBtn.setEnabled(false);
        this.prevBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectInstallerDlg.this.prevBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        btPane.add((Component)this.prevBtn, gridBagConstraints);
        this.nextBtn.setToolTipText(this.msg.get("wizard_next_tooltip"));
        this.nextBtn.setText(this.msg.get("wizard_next"));
        this.nextBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectInstallerDlg.this.nextBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        btPane.add((Component)this.nextBtn, gridBagConstraints);
        this.getContentPane().add((Component)btPane, "South");
        basicPane.setLayout(new BorderLayout());
        basicPane.setPreferredSize(new Dimension(500, 300));
        this.mainPane.setLayout(new CardLayout());
        this.mainPane.setBackground(new Color(255, 255, 204));
        this.card00.setLayout(new GridBagLayout());
        this.card00.setOpaque(false);
        infoTitleLb.setFont(this.mainFont);
        infoTitleLb.setText(this.msg.get("install_info_info"));
        infoTitleLb.setPreferredSize(new Dimension(300, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.card00.add((Component)infoTitleLb, gridBagConstraints);
        titleLb2.setEditable(false);
        titleLb2.setFont(this.mainFont);
        titleLb2.setLineWrap(true);
        titleLb2.setText("\"" + this.pi.projectTitle + "\"");
        titleLb2.setWrapStyleWord(true);
        titleLb2.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.card00.add((Component)titleLb2, gridBagConstraints);
        authorLb.setEditable(false);
        authorLb.setFont(this.itemFont);
        authorLb.setLineWrap(true);
        authorLb.setText(this.pi.authors != null ? this.pi.authors : "");
        authorLb.setWrapStyleWord(true);
        authorLb.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.card00.add((Component)authorLb, gridBagConstraints);
        sourceLbHeader.setText(this.msg.get("install_info_from"));
        sourceLbHeader.setFont(this.mainFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(12, 3, 3, 3);
        this.card00.add((Component)sourceLbHeader, gridBagConstraints);
        sourceLb.setText(this.storeFileSystem.getFullRoot());
        sourceLb.setFont(this.itemFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.card00.add((Component)sourceLb, gridBagConstraints);
        wizardInfoLb.setText(this.msg.get("wizard_info"));
        wizardInfoLb.setFont(this.mainFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 3, 3, 3);
        this.card00.add((Component)wizardInfoLb, gridBagConstraints);
        this.mainPane.add((Component)this.card00, "card00");
        this.card01.setLayout(new GridBagLayout());
        this.card01.setOpaque(false);
        libLb.setText(this.msg.get("install_select_library"));
        libLb.setFont(this.mainFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.card01.add((Component)libLb, gridBagConstraints);
        this.selectLibPanel.setBorder(new TitledBorder(this.msg.get("library_caption")));
        this.selectLibPanel.setPreferredSize(new Dimension(300, 200));
        this.selectLibPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.card01.add((Component)this.selectLibPanel, gridBagConstraints);
        this.mainPane.add((Component)this.card01, "card01");
        this.card02.setLayout(new GridBagLayout());
        this.card02.setPreferredSize(new Dimension(400, 300));
        this.card02.setOpaque(false);
        sourcePathLbHeader.setText(this.msg.get("install_source"));
        sourcePathLbHeader.setFont(this.mainFont);
        sourcePathLbHeader.setLabelFor(sourcePathLb);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.card02.add((Component)sourcePathLbHeader, gridBagConstraints);
        sourcePathLb.setText(this.storeFileSystem.getFullRoot());
        sourcePathLb.setFont(this.itemFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.card02.add((Component)sourcePathLb, gridBagConstraints);
        destLbHeader.setText(this.msg.get("install_dest"));
        destLbHeader.setFont(this.mainFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.card02.add((Component)destLbHeader, gridBagConstraints);
        this.destLb.setText(this.pi.baseFolder);
        this.destLb.setFont(this.itemFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.card02.add((Component)this.destLb, gridBagConstraints);
        statusLbHeader.setText(this.msg.get("install_status"));
        statusLbHeader.setFont(this.mainFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 3, 6, 3);
        this.card02.add((Component)statusLbHeader, gridBagConstraints);
        this.statusLb.setText(this.msg.get("install_msg_waiting"));
        this.statusLb.setFont(this.itemFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 3, 6, 3);
        this.card02.add((Component)this.statusLb, gridBagConstraints);
        this.itemProgressBar.setToolTipText(this.msg.get("install_progress_tooltip"));
        this.itemProgressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.card02.add((Component)this.itemProgressBar, gridBagConstraints);
        this.mainPane.add((Component)this.card02, "card02");
        this.card03.setLayout(new GridBagLayout());
        this.card03.setOpaque(false);
        libFolderLb.setText(this.msg.get("install_select_folder"));
        libFolderLb.setFont(this.mainFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.card03.add((Component)libFolderLb, gridBagConstraints);
        this.libFolderPanel.setLayout(new BorderLayout());
        this.libFolderPanel.setBorder(new TitledBorder(this.msg.get("install_library_folders")));
        this.libFolderPanel.setPreferredSize(new Dimension(300, 200));
        this.libFolderPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.card03.add((Component)this.libFolderPanel, gridBagConstraints);
        this.mainPane.add((Component)this.card03, "card03");
        this.card04.setLayout(new GridBagLayout());
        this.card04.setOpaque(false);
        finishLb.setText(this.msg.get("install_success_1"));
        finishLb.setFont(this.mainFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 13, 3);
        this.card04.add((Component)finishLb, gridBagConstraints);
        finishLb2.setText(this.msg.get("install_success_2"));
        finishLb2.setFont(this.mainFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.card04.add((Component)finishLb2, gridBagConstraints);
        finishLb3.setText(this.msg.get("install_success_3"));
        finishLb3.setFont(this.mainFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.card04.add((Component)finishLb3, gridBagConstraints);
        this.launchProjectChk.setSelected(true);
        this.launchProjectChk.setText(this.msg.get("install_launchProject"));
        this.launchProjectChk.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(13, 3, 3, 3);
        this.card04.add((Component)this.launchProjectChk, gridBagConstraints);
        this.mainPane.add((Component)this.card04, "card04");
        basicPane.add((Component)this.mainPane, "Center");
        this.cardTitleLb.setText(this.msg.get("install_title"));
        this.cardTitleLb.setForeground(new Color(255, 255, 255));
        this.cardTitleLb.setBackground(new Color(255, 153, 51));
        this.cardTitleLb.setFont(new Font("SansSerif", 1, 18));
        this.cardTitleLb.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        this.cardTitleLb.setOpaque(true);
        basicPane.add((Component)this.cardTitleLb, "North");
        this.getContentPane().add((Component)basicPane, "Center");
        this.logoPanel.setPreferredSize(new Dimension(75, 230));
        this.getContentPane().add((Component)this.logoPanel, "West");
        this.pack();
    }

    private void nextBtnActionPerformed(ActionEvent evt) {
        if (this.currentStage != 2 || this.copyComplete) {
            this.goToStage(this.currentStage + 1);
        }
    }

    private void goToStage(int stage) {
        if (stage >= 0 && stage <= 5) {
            boolean bNext = false;
            boolean bPrev = false;
            boolean bCancel = false;
            this.currentStage = stage;
            switch (this.currentStage) {
                case 0: {
                    bNext = true;
                    bPrev = false;
                    bCancel = true;
                    break;
                }
                case 1: {
                    bNext = this.libraryPane.getCurrentSelected() != null;
                    bPrev = true;
                    bCancel = true;
                    break;
                }
                case 2: {
                    this.initCopyStage();
                    this.copyFiles();
                    bPrev = false;
                    bNext = false;
                    bCancel = true;
                    break;
                }
                case 3: {
                    bNext = this.etp != null && this.etp.currentItem != null && this.etp.currentItem instanceof MenuEditor;
                    bPrev = false;
                    bCancel = true;
                    break;
                }
                case 4: {
                    this.initEndStage();
                    bNext = true;
                    bPrev = false;
                    bCancel = false;
                    break;
                }
                case 5: {
                    this.result = this.pl;
                    this.launchNow = this.launchProjectChk.isSelected();
                    this.closeDialog(null);
                    return;
                }
            }
            StringBuilder nbs = new StringBuilder("wizard_").append(this.currentStage < 4 ? "next" : "finish");
            this.nextBtn.setText(this.msg.get(nbs.substring(0)));
            this.nextBtn.setToolTipText(this.msg.get(nbs.append("_tooltip").substring(0)));
            this.nextBtn.setEnabled(bNext);
            this.prevBtn.setEnabled(bPrev);
            this.cancelBtn.setEnabled(bCancel);
            if (this.currentStage < 5) {
                CardLayout cl = (CardLayout)this.mainPane.getLayout();
                String s = Integer.toString(stage);
                if (s.length() == 1) {
                    s = "0" + s;
                }
                cl.show(this.mainPane, "card" + s);
                this.cardTitleLb.setText(this.msg.get(STAGE_TITLES[stage]));
            }
        }
    }

    private void initCopyStage() {
        LibraryManagerElement lme = this.libraryPane.getCurrentSelected();
        if (this.pl == null || !this.pl.getFullPath().equals(lme.path)) {
            try {
                this.pl = ProjectLibrary.loadProjectLibrary(lme.path, this.lm.settings.rb);
                if (this.etp != null) {
                    this.libFolderPanel.remove(this.etp);
                }
                this.etp = new EditorTreePanel(this.pl.getEditor(null), this.options, true, Menu.class){

                    @Override
                    protected void currentItemChanged() {
                        if (ProjectInstallerDlg.this.currentStage == 3) {
                            ProjectInstallerDlg.this.nextBtn.setEnabled(this.currentItem != null && this.currentItem instanceof MenuEditor);
                        }
                        super.currentItemChanged();
                    }
                };
                this.etp.getTree().setSelectionRow(1);
                this.libFolderPanel.add((Component)this.etp, "Center");
                this.card03.revalidate();
                File root = new File(this.pl.getFileSystem().getFullRoot());
                this.installDir = new File(root, this.pi.baseFolder);
                this.destLb.setText(this.installDir.getAbsolutePath());
            }
            catch (Exception ex) {
                this.msg.showErrorWarning(this, "library_error_reading", ex);
                this.closeDialog(null);
            }
        }
    }

    private void initEndStage() {
        try {
            Menu menu = ((MenuEditor)this.etp.currentItem).getMenu();
            for (int i = 0; i < this.pi.iconItems.size() && !this.cancel; ++i) {
                ProjectInstaller.IconItem ii = this.pi.iconItems.get(i);
                MenuElement me = new MenuElement();
                me.caption = ii.text;
                me.projectPath = this.pi.baseFolder + File.separator + ii.project;
                me.icon = ii.icon != null ? (!ii.icon.startsWith("@") ? this.pi.baseFolder + File.separator + ii.icon : ii.icon) : "@ico00.png";
                if (ii.description != null) {
                    me.description = ii.description;
                }
                menu.addMenuElement(me);
                if (this.pathToMainProject != null) continue;
                this.pathToMainProject = this.pl.getFileSystem().getFullFileNamePath(me.projectPath);
            }
            this.pl.activityBag.addActivity(menu);
            this.pl.save(null);
            this.launchProjectChk.setEnabled(this.pathToMainProject != null);
        }
        catch (Exception ex) {
            this.msg.showErrorWarning(this, "library_error_creating_icons", ex);
            this.closeDialog(null);
        }
    }

    private void prevBtnActionPerformed(ActionEvent evt) {
        this.goToStage(this.currentStage - 1);
    }

    @Override
    public void valueChanged(ListSelectionEvent ev) {
        if (ev != null && !ev.getValueIsAdjusting() && this.currentStage == 1) {
            this.nextBtn.setEnabled(this.libraryPane.getCurrentSelected() != null);
        }
    }

    private void copyFiles() {
        String PAUSED = "PAUSED";
        String ERR = "ERROR";
        String OK = "OK";
        String CANCEL = "CANCEL";
        final ProjectInstallerDlg cmp = this;
        this.prevBtn.setEnabled(false);
        this.nextBtn.setEnabled(false);
        this.statusLb.setText(this.msg.get("install_msg_waiting"));
        this.worker = new SwingWorker(){

            @Override
            public Object construct() {
                String destFolder;
                ProjectInstallerDlg.this.workerRunning = true;
                ArrayList<FileBackup> fileBackups = new ArrayList<FileBackup>();
                Exception ex = null;
                String srcFolder = FileSystem.stdFn(ProjectInstallerDlg.this.storeFileSystem.getFullFileNamePath(null));
                if (srcFolder.equalsIgnoreCase(destFolder = FileSystem.stdFn(ProjectInstallerDlg.this.installDir.getAbsolutePath()))) {
                    ProjectInstallerDlg.this.itemProgressBar.setValue(ProjectInstallerDlg.this.itemProgressBar.getMaximum());
                    ProjectInstallerDlg.this.statusLb.setText(ProjectInstallerDlg.this.msg.get("install_toSourceFolder"));
                } else {
                    try {
                        if (ProjectInstallerDlg.this.msg.confirmOverwriteFile(cmp, ProjectInstallerDlg.this.installDir, "yn") != 1) {
                            return "PAUSED";
                        }
                        boolean overwriteAll = false;
                        boolean overwriteNone = false;
                        for (int i = 0; i < ProjectInstallerDlg.this.pi.files.size() && !ProjectInstallerDlg.this.cancel; ++i) {
                            InputStream is;
                            String file = ProjectInstallerDlg.this.pi.getFile(i).replace('/', File.separatorChar);
                            File f = new File(ProjectInstallerDlg.this.installDir, file);
                            ProjectInstallerDlg.this.statusLb.setText(ProjectInstallerDlg.this.msg.get("install_msg_copying") + " " + file);
                            if (f.exists()) {
                                if (overwriteNone) continue;
                                if (!overwriteAll) {
                                    boolean next = false;
                                    switch (ProjectInstallerDlg.this.msg.confirmOverwriteFile(cmp, f, "yYnNc")) {
                                        case 6: {
                                            overwriteAll = true;
                                        }
                                        case 1: {
                                            break;
                                        }
                                        case 7: {
                                            overwriteNone = true;
                                        }
                                        case 3: {
                                            next = true;
                                            break;
                                        }
                                        default: {
                                            ProjectInstallerDlg.this.cancel = true;
                                        }
                                    }
                                    if (next) continue;
                                    if (ProjectInstallerDlg.this.cancel) break;
                                }
                            }
                            ProgressInputStream pis = (is = ProjectInstallerDlg.this.storeFileSystem.getInputStream(ProjectInstallerDlg.this.pi.getFile(i))) instanceof ProgressInputStream ? (ProgressInputStream)is : new ProgressInputStream(is, -1, file);
                            pis.addProgressInputStreamListener(cmp);
                            fileBackups.add(new FileBackup(f));
                            StreamIO.writeStreamTo(pis, new FileOutputStream(f));
                        }
                    }
                    catch (Exception e) {
                        ex = e;
                    }
                    if (!fileBackups.isEmpty()) {
                        ProjectInstallerDlg.this.statusLb.setText(ProjectInstallerDlg.this.msg.get("install_msg_cleanup"));
                        for (int i = fileBackups.size() - 1; i >= 0; --i) {
                            FileBackup fb = (FileBackup)fileBackups.get(i);
                            if (ProjectInstallerDlg.this.cancel || ex != null) {
                                try {
                                    fb.rollback();
                                }
                                catch (Exception e) {
                                    ProjectInstallerDlg.this.msg.showErrorWarning((Component)cmp, "FILE_ERR_RESTORING", fb.getFile().getAbsolutePath(), e, null);
                                }
                                continue;
                            }
                            try {
                                fb.cleanup();
                                continue;
                            }
                            catch (Exception e) {
                                ProjectInstallerDlg.this.msg.showErrorWarning((Component)cmp, "FILE_ERR_DELETING", fb.getBackup().getAbsolutePath(), e, null);
                            }
                        }
                    }
                }
                ProjectInstallerDlg.this.statusLb.setText(ProjectInstallerDlg.this.msg.get("install_msg_end"));
                if (ex != null) {
                    return ex;
                }
                return ProjectInstallerDlg.this.cancel ? "CANCEL" : "OK";
            }

            @Override
            public void finished() {
                Object result = this.get();
                ProjectInstallerDlg.this.workerRunning = false;
                ProjectInstallerDlg.this.worker = null;
                if (result != null) {
                    if (ProjectInstallerDlg.this.cancel) {
                        ProjectInstallerDlg.this.msg.showAlert((Component)cmp, "install_msg_cancel");
                        ProjectInstallerDlg.this.closeDialog(null);
                    } else if (result instanceof Exception) {
                        ProjectInstallerDlg.this.msg.showErrorWarning(cmp, "install_error", (Exception)result);
                        ProjectInstallerDlg.this.closeDialog(null);
                    } else if (result.equals("PAUSED")) {
                        ProjectInstallerDlg.this.statusLb.setText(ProjectInstallerDlg.this.msg.get("install_msg_waiting"));
                        ProjectInstallerDlg.this.prevBtn.setEnabled(true);
                        ProjectInstallerDlg.this.nextBtn.setEnabled(true);
                    } else if (result.equals("OK")) {
                        ProjectInstallerDlg.this.nextBtn.setEnabled(true);
                        ProjectInstallerDlg.this.copyComplete = true;
                        ProjectInstallerDlg.this.nextBtnActionPerformed(null);
                    }
                }
            }
        };
        this.worker.start();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.cancel = true;
        StreamIO.setCancel(true);
        if (!this.workerRunning) {
            this.msg.showAlert((Component)this, "install_msg_cancel");
            this.closeDialog(null);
        } else {
            this.worker.interrupt();
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void setProgressMax(int max) {
        this.itemProgressBar.setMaximum(max);
    }

    @Override
    public void setProgressValue(int value) {
        this.itemProgressBar.setValue(value);
    }

    @Override
    public void startProgress(String name) {
        this.itemProgressBar.setValue(0);
    }

    @Override
    public void endProgress() {
    }
}

