/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.project.Author;
import edu.xtec.util.Domable;
import edu.xtec.util.Html;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Messages;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.jdom.Element;

public class Revision
implements Domable {
    public Date date;
    public Author[] authors;
    public String description;
    public String comments;
    public static final String ELEMENT_NAME = "revision";
    public static final String DATE = "date";
    public static final String DESCRIPTION = "description";
    public static final String COMMENTS = "comments";

    public Revision() {
        this.date = new Date();
        this.description = new String();
        this.comments = null;
    }

    public Revision(Date setDate, String setDescription) {
        this.date = setDate;
        this.description = setDescription;
        this.authors = null;
        this.comments = null;
    }

    @Override
    public Element getJDomElement() {
        Element e = new Element(ELEMENT_NAME);
        e.setAttribute(DESCRIPTION, this.description);
        e.setAttribute(DATE, JDomUtility.dateToStringShortUS(this.date));
        if (this.comments != null) {
            JDomUtility.addParagraphs(e, COMMENTS, this.comments);
        }
        if (this.authors != null) {
            for (Author author : this.authors) {
                e.addContent(author.getJDomElement());
            }
        }
        return e;
    }

    public static Revision getRevision(Element e) throws Exception {
        Revision r = new Revision();
        r.setProperties(e, null);
        return r;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        this.description = JDomUtility.getStringAttr(e, DESCRIPTION, this.description, true);
        this.date = JDomUtility.getDateAttrShortUS(e, DATE, this.date);
        this.comments = JDomUtility.getParagraphs(e.getChild(COMMENTS));
        ArrayList<Author> al = new ArrayList<Author>();
        Iterator itr = e.getChildren("author").iterator();
        while (itr.hasNext()) {
            al.add(Author.getAuthor((Element)itr.next()));
        }
        if (!al.isEmpty()) {
            this.authors = al.toArray(new Author[al.size()]);
        }
    }

    public String toHtmlString(Messages msg) {
        Html html = new Html(300);
        html.bold(msg.getShortDateStr(this.date));
        if (this.description != null) {
            html.append("<B>: ").appendParagraphs(this.description).append("</B>");
        }
        if (this.authors != null) {
            for (Author author : this.authors) {
                html.br().append(author.toHtmlString(msg));
            }
        }
        if (this.comments != null && this.comments.length() > 0) {
            html.br().appendParagraphs(this.comments);
        }
        return html.toString();
    }

    public String toString() {
        DateFormat df = DateFormat.getDateInstance(3);
        StringBuilder sb = new StringBuilder();
        sb.append(df.format(this.date)).append(" - ");
        if (this.description != null && this.description.length() > 0) {
            sb.append(this.description);
        }
        return sb.substring(0);
    }
}

