/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.shapers;

import edu.xtec.jclic.shapers.Holes;
import edu.xtec.jclic.shapers.ShapeData;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;

public class HolesMaker {
    Holes h;
    int nx;
    int ny;
    boolean[][] flagDone;
    int nIds;
    int[][] ids;
    int[] newIds;
    Rectangle2D.Double r;
    boolean skipOnes;
    boolean singleCells;

    public HolesMaker(int setNx, int setNy, int[] setIds, boolean useIds, boolean skipOnes, boolean singleCells) {
        this.skipOnes = skipOnes;
        this.singleCells = singleCells;
        this.nx = setNx;
        this.ny = setNy;
        this.h = new Holes(this.nx, this.ny);
        this.flagDone = new boolean[this.nx][this.ny];
        this.ids = new int[this.nx][this.ny];
        for (int y = 0; y < this.ny; ++y) {
            for (int x = 0; x < this.nx; ++x) {
                this.flagDone[x][y] = false;
                this.ids[x][y] = setIds[y * this.nx + x];
            }
        }
        this.nIds = 0;
        this.newIds = new int[this.nx * this.ny];
        this.h.scaleW = this.nx;
        this.h.scaleH = this.ny;
        this.r = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
        ShapeData[] shapeDataX = new ShapeData[this.nx * this.ny];
        int j = 0;
        for (int y = 0; y < this.ny; ++y) {
            for (int x = 0; x < this.nx; ++x) {
                Area a;
                if (this.flagDone[x][y] || this.ids[x][y] < 0) continue;
                Shape sh = a = this.scan(null, x, y);
                if (a.isRectangular()) {
                    sh = a.getBounds2D();
                }
                shapeDataX[j] = ShapeData.getShapeData(sh, null);
                shapeDataX[j].scaleTo(this.nx, this.ny);
                ++j;
            }
        }
        if (!useIds) {
            int nCells;
            int maxId = 0;
            for (int i = 0; i < j; ++i) {
                if (this.newIds[i] <= maxId) continue;
                maxId = this.newIds[i];
            }
            this.h.nCells = nCells = maxId + 1;
            this.h.shapeData = new ShapeData[nCells];
            for (int i = 0; i < nCells; ++i) {
                int k;
                for (k = 0; k < j && this.newIds[k] != i; ++k) {
                }
                if (k == j) {
                    this.h.shapeData[i] = shapeDataX[0];
                    System.err.println("HolesMaker error buliding shape for cell: " + i);
                    continue;
                }
                this.h.shapeData[i] = shapeDataX[k];
            }
        } else {
            this.h.nCells = j;
            this.h.shapeData = new ShapeData[j];
            System.arraycopy(shapeDataX, 0, this.h.shapeData, 0, j);
        }
        this.h.nCols = this.nx;
        this.h.nRows = this.ny;
        this.h.enclosingShapeData = ShapeData.getShapeData(new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0), null);
    }

    public Holes getShaper() {
        return this.h;
    }

    public int[] getIds() {
        int[] result = new int[this.nIds];
        System.arraycopy(this.newIds, 0, result, 0, this.nIds);
        return result;
    }

    protected Area scan(Area a, int xx, int y) {
        int id = this.ids[xx][y];
        for (int x = xx; x < this.nx && !this.flagDone[x][y] && this.ids[x][y] == id; ++x) {
            this.flagDone[x][y] = true;
            this.r.x = x;
            this.r.y = y;
            if (a == null) {
                a = new Area(this.r);
                this.newIds[this.nIds++] = id;
            } else {
                a.add(new Area(this.r));
            }
            if (this.singleCells || this.skipOnes && id == 1) break;
            if (x > 0 && !this.flagDone[x - 1][y] && this.ids[x - 1][y] == id) {
                this.scan(a, x - 1, y);
            }
            if (y > 0 && !this.flagDone[x][y - 1] && this.ids[x][y - 1] == id) {
                this.scan(a, x, y - 1);
            }
            if (y >= this.ny - 1 || this.flagDone[x][y + 1] || this.ids[x][y + 1] != id) continue;
            this.scan(a, x, y + 1);
        }
        return a;
    }
}

